/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate;

import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.fileTypes.PlainTextLikeFileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.fileTypes.ex.FileTypeIdentifiableByVirtualFile;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.io.ByteSequence;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.TextMateBundle;
import org.jetbrains.plugins.textmate.TextMateLanguage;
import org.jetbrains.plugins.textmate.TextMateService;

public final class TextMateFileType
extends LanguageFileType
implements FileTypeIdentifiableByVirtualFile,
PlainTextLikeFileType {
    public static final TextMateFileType INSTANCE = new TextMateFileType();

    private TextMateFileType() {
        super((Language)TextMateLanguage.LANGUAGE);
    }

    @NotNull
    public String getName() {
        return "textmate";
    }

    @NotNull
    public String getDescription() {
        return TextMateBundle.message("filetype.textmate.description", new Object[0]);
    }

    @NotNull
    public String getDefaultExtension() {
        return "";
    }

    public Icon getIcon() {
        return AllIcons.FileTypes.Text;
    }

    public boolean isMyFileType(@NotNull VirtualFile file) {
        if (file.isDirectory() || !(file instanceof LightVirtualFile)) {
            return false;
        }
        CharSequence fileName = file.getNameSequence();
        FileType originalFileType = FileTypeManager.getInstance().getFileTypeByFileName(fileName);
        return TextMateFileType.isTypeShouldBeReplacedByTextMateType(originalFileType) && TextMateService.getInstance().getLanguageDescriptorByFileName(fileName) != null;
    }

    private static boolean isTypeShouldBeReplacedByTextMateType(@Nullable FileType registeredType) {
        return registeredType == UnknownFileType.INSTANCE || registeredType == INSTANCE || registeredType == PlainTextFileType.INSTANCE;
    }

    public boolean isReadOnly() {
        return true;
    }

    private static class TextMateFileDetector
    implements FileTypeRegistry.FileTypeDetector {
        private TextMateFileDetector() {
        }

        @Nullable
        public FileType detect(@NotNull VirtualFile file, @NotNull ByteSequence firstBytes, @Nullable CharSequence firstCharsIfText) {
            if (file.isDirectory()) {
                return null;
            }
            if (firstCharsIfText == null) {
                return null;
            }
            CharSequence fileName = file.getNameSequence();
            FileType originalFileType = FileTypeManager.getInstance().getFileTypeByFileName(fileName);
            if (!TextMateFileType.isTypeShouldBeReplacedByTextMateType(originalFileType)) {
                return null;
            }
            boolean textMateRecognizesMe = false;
            try {
                textMateRecognizesMe = TextMateService.getInstance().getLanguageDescriptorByFileName(fileName) != null;
            }
            catch (ProcessCanceledException processCanceledException) {
                // empty catch block
            }
            if (!textMateRecognizesMe) {
                return null;
            }
            return INSTANCE;
        }

        public int getDesiredContentPrefixLength() {
            return 0;
        }
    }
}

