/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.pattern;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.RefactoringQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.JavaRefactoringActionHandlerFactory;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.util.SmartList;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.IntelliLangBundle;
import org.intellij.plugins.intelliLang.util.AnnotateFix;
import org.intellij.plugins.intelliLang.util.AnnotationUtilEx;
import org.intellij.plugins.intelliLang.util.PsiUtilEx;
import org.intellij.plugins.intelliLang.util.SubstitutedExpressionEvaluationHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PatternValidator
extends LocalInspectionTool {
    private static final Key<CachedValue<Pattern>> COMPLIED_PATTERN = Key.create((String)"COMPILED_PATTERN");
    public boolean CHECK_NON_CONSTANT_VALUES = true;

    @Nullable
    public JComponent createOptionsPanel() {
        final JCheckBox jCheckBox = new JCheckBox(IntelliLangBundle.message((String)"flag.non.compile.time.constant.expressions", (Object[])new Object[0]));
        jCheckBox.setToolTipText(IntelliLangBundle.message((String)"the.inspection.will.flag.expressions.with.unknown.values", (Object[])new Object[0]));
        jCheckBox.setSelected(this.CHECK_NON_CONSTANT_VALUES);
        jCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PatternValidator.this.CHECK_NON_CONSTANT_VALUES = jCheckBox.isSelected();
            }
        });
        return JBUI.Panels.simplePanel().addToTop((Component)jCheckBox);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new JavaElementVisitor(){

            public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
                this.visitExpression((PsiExpression)expression);
            }

            public void visitExpression(@NotNull PsiExpression expression) {
                PsiElement element = expression.getParent();
                if (element instanceof PsiExpressionList) {
                    this.check(expression, holder, false);
                } else if (element instanceof PsiNameValuePair) {
                    PsiNameValuePair valuePair = (PsiNameValuePair)element;
                    String name = valuePair.getName();
                    if (name == null || name.equals("value")) {
                        this.check(expression, holder, true);
                    }
                    this.check(expression, holder, false);
                }
            }

            public void visitReturnStatement(@NotNull PsiReturnStatement statement) {
                PsiExpression returnValue = statement.getReturnValue();
                if (returnValue != null) {
                    this.check(returnValue, holder, false);
                }
            }

            public void visitVariable(@NotNull PsiVariable var) {
                PsiExpression initializer = var.getInitializer();
                if (initializer != null) {
                    this.check(initializer, holder, false);
                }
            }

            public void visitAssignmentExpression(@NotNull PsiAssignmentExpression expression) {
                PsiExpression e = expression.getRExpression();
                if (e != null) {
                    this.check(e, holder, false);
                }
                this.visitExpression((PsiExpression)expression);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private void check(@NotNull PsiExpression expression, ProblemsHolder holder2, boolean isAnnotationValue) {
                if (expression instanceof PsiConditionalExpression) {
                    PsiConditionalExpression expr = (PsiConditionalExpression)expression;
                    PsiExpression e = expr.getThenExpression();
                    if (e != null) {
                        this.check(e, holder2, isAnnotationValue);
                    }
                    if ((e = expr.getElseExpression()) == null) return;
                    this.check(e, holder2, isAnnotationValue);
                    return;
                } else {
                    PsiModifierListOwner element;
                    PsiType type = expression.getType();
                    if (type == null || !PsiUtilEx.isString(type)) return;
                    if (isAnnotationValue) {
                        PsiAnnotation psiAnnotation = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiAnnotation.class);
                        if (psiAnnotation == null || !Configuration.getInstance().getAdvancedConfiguration().getSubstAnnotationClass().equals(psiAnnotation.getQualifiedName())) return;
                        element = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiModifierListOwner.class);
                    } else {
                        element = AnnotationUtilEx.getAnnotatedElementFor((PsiElement)expression, AnnotationUtilEx.LookupType.PREFER_CONTEXT);
                    }
                    if (element == null || !PsiUtilEx.isLanguageAnnotationTarget(element)) return;
                    PsiAnnotation[] annotations = AnnotationUtilEx.getAnnotationFrom(element, (Pair<String, ? extends Set<String>>)Configuration.getInstance().getAdvancedConfiguration().getPatternAnnotationPair(), true);
                    PatternValidator.this.checkExpression(expression, annotations, holder2);
                }
            }
        };
    }

    private void checkExpression(PsiExpression expression, PsiAnnotation[] annotations, ProblemsHolder holder) {
        String o;
        Pattern pattern;
        if (annotations.length == 0) {
            return;
        }
        PsiAnnotation psiAnnotation = annotations[0];
        CachedValue p = (CachedValue)psiAnnotation.getUserData(COMPLIED_PATTERN);
        if (p == null) {
            CachedValueProvider provider = () -> {
                String pattern = AnnotationUtilEx.calcAnnotationValue(psiAnnotation, "value");
                Pattern p1 = null;
                if (pattern != null) {
                    try {
                        p1 = Pattern.compile(pattern);
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                        // empty catch block
                    }
                }
                return CachedValueProvider.Result.create((Object)p1, (Object[])annotations);
            };
            p = CachedValuesManager.getManager((Project)expression.getProject()).createCachedValue(provider, false);
            psiAnnotation.putUserData(COMPLIED_PATTERN, (Object)p);
        }
        if ((pattern = (Pattern)p.getValue()) == null) {
            return;
        }
        SmartList nonConstantElements = new SmartList();
        Configuration configuration = Configuration.getInstance();
        Object result = new SubstitutedExpressionEvaluationHelper(expression.getProject()).computeExpression(expression, configuration.getAdvancedConfiguration().getDfaOption(), false, (List<? super PsiExpression>)nonConstantElements);
        String string = o = result == null ? null : String.valueOf(result);
        if (o != null) {
            if (!pattern.matcher(o).matches()) {
                if (annotations.length > 1) {
                    String fqn = annotations[annotations.length - 1].getQualifiedName();
                    assert (fqn != null);
                    String name = StringUtil.getShortName((String)fqn);
                    holder.registerProblem((PsiElement)expression, IntelliLangBundle.message((String)"inspection.message.expression.does.not.match.pattern", (Object[])new Object[]{o, name, pattern.pattern()}), new LocalQuickFix[0]);
                } else {
                    holder.registerProblem((PsiElement)expression, IntelliLangBundle.message((String)"inspection.message.expression.does.not.match.pattern2", (Object[])new Object[]{o, pattern.pattern()}), new LocalQuickFix[0]);
                }
            }
        } else if (this.CHECK_NON_CONSTANT_VALUES) {
            for (PsiExpression expr : nonConstantElements) {
                Object quickFix;
                PsiModifierListOwner owner;
                Object e = expr instanceof PsiReferenceExpression ? ((PsiReferenceExpression)expr).resolve() : (expr instanceof PsiMethodCallExpression ? ((PsiMethodCallExpression)expr).getMethodExpression().resolve() : expr);
                PsiModifierListOwner psiModifierListOwner = owner = e instanceof PsiModifierListOwner ? (PsiModifierListOwner)e : null;
                if (owner != null && PsiUtilEx.isLanguageAnnotationTarget(owner)) {
                    PsiAnnotation[] resolvedAnnos = AnnotationUtilEx.getAnnotationFrom(owner, (Pair<String, ? extends Set<String>>)configuration.getAdvancedConfiguration().getPatternAnnotationPair(), true);
                    if (resolvedAnnos.length == 2 && annotations.length == 2 && Comparing.strEqual((String)resolvedAnnos[1].getQualifiedName(), (String)annotations[1].getQualifiedName())) {
                        return;
                    }
                    String classname = (String)configuration.getAdvancedConfiguration().getSubstAnnotationPair().first;
                    quickFix = AnnotateFix.canApplyOn(owner) ? new AnnotateFix(classname) : new IntroduceVariableFix();
                } else {
                    quickFix = new IntroduceVariableFix();
                }
                holder.registerProblem((PsiElement)expr, IntelliLangBundle.message((String)"inspection.pattern.validator.description", (Object[])new Object[0]), new LocalQuickFix[]{quickFix});
            }
        }
    }

    private static class IntroduceVariableFix
    implements RefactoringQuickFix {
        IntroduceVariableFix() {
        }

        @NotNull
        public String getFamilyName() {
            return IntelliLangBundle.message((String)"introduce.variable.fix.family.name", (Object[])new Object[0]);
        }

        @NotNull
        public RefactoringActionHandler getHandler() {
            return JavaRefactoringActionHandlerFactory.getInstance().createIntroduceVariableHandler();
        }
    }
}

