/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject.java;

import com.intellij.openapi.util.Pair;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.uast.UastPatterns;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.UastInjectionHostReferenceProvider;
import com.intellij.psi.UastReferenceProvider;
import com.intellij.psi.UastReferenceRegistrar;
import com.intellij.util.ProcessingContext;
import java.util.Objects;
import java.util.Set;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.inject.java.RegExpEnumReference;
import org.intellij.plugins.intelliLang.inject.java.ULiteralLanguageReference;
import org.intellij.plugins.intelliLang.util.AnnotationUtilEx;
import org.intellij.plugins.intelliLang.util.PsiUtilEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UExpression;

public final class LanguageReferenceProvider
extends PsiReferenceContributor {
    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        final Configuration configuration = Configuration.getInstance();
        UastReferenceRegistrar.registerUastReferenceProvider((PsiReferenceRegistrar)registrar, (ElementPattern)UastPatterns.injectionHostUExpression().annotationParam((ElementPattern)StandardPatterns.string().with((PatternCondition)new PatternCondition<String>("isLanguageAnnotation"){

            public boolean accepts(@NotNull String s, ProcessingContext context) {
                return Objects.equals(configuration.getAdvancedConfiguration().getLanguageAnnotationClass(), s);
            }
        }), "value"), (UastReferenceProvider)new UastInjectionHostReferenceProvider(){

            public boolean acceptsTarget(@NotNull PsiElement target) {
                return false;
            }

            public PsiReference @NotNull [] getReferencesForInjectionHost(@NotNull UExpression uExpression, @NotNull PsiLanguageInjectionHost host, @NotNull ProcessingContext context) {
                return new PsiReference[]{new ULiteralLanguageReference(uExpression, host)};
            }
        }, (double)0.0);
        registrar.registerReferenceProvider((ElementPattern)PsiJavaPatterns.literalExpression().with((PatternCondition)new PatternCondition<PsiLiteralExpression>("isStringLiteral"){

            public boolean accepts(@NotNull PsiLiteralExpression expression, ProcessingContext context) {
                return PsiUtilEx.isStringOrCharacterLiteral((PsiElement)expression);
            }
        }), new PsiReferenceProvider(){

            public boolean acceptsTarget(@NotNull PsiElement target) {
                return target instanceof PsiLiteral;
            }

            public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement psiElement, @NotNull ProcessingContext context) {
                String pattern;
                PsiAnnotation[] annotations;
                PsiLiteralExpression expression = (PsiLiteralExpression)psiElement;
                PsiModifierListOwner owner = AnnotationUtilEx.getAnnotatedElementFor((PsiElement)expression, AnnotationUtilEx.LookupType.PREFER_DECLARATION);
                if (owner != null && PsiUtilEx.isLanguageAnnotationTarget(owner) && (annotations = AnnotationUtilEx.getAnnotationFrom(owner, (Pair<String, ? extends Set<String>>)configuration.getAdvancedConfiguration().getPatternAnnotationPair(), true)).length > 0 && (pattern = AnnotationUtilEx.calcAnnotationValue(annotations, "value")) != null) {
                    return new PsiReference[]{new RegExpEnumReference(expression, pattern)};
                }
                return PsiReference.EMPTY_ARRAY;
            }
        });
    }
}

