/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject.config;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMExternalizableStringList;
import com.intellij.openapi.util.JDOMExternalizer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.compiler.PatternCompiler;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.intellij.plugins.intelliLang.IntelliLangBundle;
import org.intellij.plugins.intelliLang.inject.config.BaseInjection;
import org.intellij.plugins.intelliLang.inject.config.InjectionPlace;
import org.jdom.Element;
import org.jdom.IllegalDataException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MethodParameterInjection
extends BaseInjection {
    @NotNull
    private String myClassName = "";
    @NotNull
    private final Map<String, MethodInfo> myParameterMap = new HashMap<String, MethodInfo>();

    public MethodParameterInjection() {
        super("java");
    }

    @NotNull
    public String getClassName() {
        return this.myClassName;
    }

    public void setClassName(@NotNull String className) {
        this.myClassName = className;
    }

    public void setMethodInfos(Collection<? extends MethodInfo> newInfos) {
        this.myParameterMap.clear();
        for (MethodInfo methodInfo : newInfos) {
            this.myParameterMap.put(methodInfo.getMethodSignature(), methodInfo);
        }
    }

    public Collection<MethodInfo> getMethodInfos() {
        return this.myParameterMap.values();
    }

    public MethodParameterInjection copyFrom(@NotNull BaseInjection o) {
        super.copyFrom(o);
        if (o instanceof MethodParameterInjection) {
            MethodParameterInjection other = (MethodParameterInjection)o;
            this.myClassName = other.getClassName();
            this.myParameterMap.clear();
            for (MethodInfo info : other.myParameterMap.values()) {
                this.myParameterMap.put(info.methodSignature, info.copy());
            }
        }
        return this;
    }

    protected void readExternalImpl(Element e) {
        if (e.getAttribute("injector-id") == null) {
            this.setClassName(JDOMExternalizer.readString((Element)e, (String)"CLASS"));
            this.readOldFormat(e);
            HashMap map = new HashMap();
            JDOMExternalizer.readMap((Element)e, map, null, (String)"SIGNATURES");
            for (String s : map.keySet()) {
                String fixedSignature = MethodParameterInjection.fixSignature(s, false);
                this.myParameterMap.put(fixedSignature, new MethodInfo(fixedSignature, (String)map.get(s)));
            }
        }
    }

    private void readOldFormat(Element e) {
        JDOMExternalizableStringList list = new JDOMExternalizableStringList();
        try {
            list.readExternal(e);
        }
        catch (IllegalDataException illegalDataException) {
            // empty catch block
        }
        if (list.isEmpty()) {
            return;
        }
        boolean[] selection = new boolean[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            selection[i] = Boolean.parseBoolean((String)list.get(i));
        }
        String methodSignature = MethodParameterInjection.fixSignature(JDOMExternalizer.readString((Element)e, (String)"METHOD"), false);
        this.myParameterMap.put(methodSignature, new MethodInfo(methodSignature, selection, false));
    }

    public MethodParameterInjection copy() {
        return new MethodParameterInjection().copyFrom(this);
    }

    public void generatePlaces() {
        PatternCompiler compiler = this.getCompiler();
        List<String> patternString = MethodParameterInjection.getPatternString(this);
        InjectionPlace[] places = (InjectionPlace[])InjectionPlace.ARRAY_FACTORY.create(patternString.size());
        int patternStringSize = patternString.size();
        for (int i = 0; i < patternStringSize; ++i) {
            String text = patternString.get(i);
            places[i] = new InjectionPlace(compiler.createElementPattern(text, this.getDisplayName()), true);
        }
        this.setInjectionPlaces(places);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MethodParameterInjection that = (MethodParameterInjection)((Object)o);
        if (!this.myClassName.equals(that.myClassName)) {
            return false;
        }
        return this.myParameterMap.equals(that.myParameterMap);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.myClassName.hashCode();
        result = 31 * result + this.myParameterMap.hashCode();
        return result;
    }

    @NotNull
    public String getDisplayName() {
        String className = this.getClassName();
        if (StringUtil.isEmpty((String)className)) {
            return IntelliLangBundle.message((String)"method.param.injection.unnamed.placeholder", (Object[])new Object[0]);
        }
        MethodInfo singleInfo = null;
        for (MethodInfo info : this.myParameterMap.values()) {
            if (!info.isEnabled()) continue;
            if (singleInfo == null) {
                singleInfo = info;
                continue;
            }
            singleInfo = null;
            break;
        }
        String name = singleInfo != null ? StringUtil.getShortName((String)className) + "." + singleInfo.methodName : StringUtil.getShortName((String)className);
        return name + " (" + StringUtil.getPackageName((String)className) + ")";
    }

    public static String fixSignature(String signature, boolean parameterNames) {
        @NonNls StringBuilder sb = new StringBuilder();
        StringTokenizer st = new StringTokenizer(signature, "(,)");
        int i = 0;
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            if (i > 1) {
                sb.append(", ");
            }
            if (i == 0) {
                sb.append(token).append("(");
            } else {
                int idx = token.indexOf(32);
                if (idx > -1) {
                    if (parameterNames) {
                        sb.append(token);
                    } else {
                        sb.append(token, 0, idx);
                    }
                } else {
                    sb.append(token);
                    if (parameterNames) {
                        sb.append(' ').append('p').append(i);
                    }
                }
            }
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }

    @NotNull
    private static String buildSignature(@NotNull PsiMethod method) {
        return PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)257, (int)73730);
    }

    public static MethodInfo createMethodInfo(PsiMethod method) {
        String signature = MethodParameterInjection.buildSignature(method);
        return new MethodInfo(signature, new boolean[method.getParameterList().getParametersCount()], false);
    }

    public static boolean isInjectable(@Nullable PsiType type, Project project) {
        if (type == null) {
            return false;
        }
        if (type instanceof PsiPrimitiveType) {
            return false;
        }
        if (project.isDefault()) {
            @NonNls String text = type.getPresentableText();
            return text.equals("java.lang.String") || text.equals("java.lang.String...") || text.equals("java.lang.String[]");
        }
        return type.equalsToText("java.lang.String") || type.equalsToText("java.lang.String...") || type.equalsToText("java.lang.String[]");
    }

    @Nullable
    public static PsiMethod makeMethod(Project project, String signature) {
        if (StringUtil.isEmpty((String)signature)) {
            return null;
        }
        try {
            return JavaPsiFacade.getInstance((Project)project).getElementFactory().createMethodFromText("void " + MethodParameterInjection.fixSignature(signature, true) + "{}", null);
        }
        catch (IncorrectOperationException incorrectOperationException) {
            return null;
        }
    }

    public static String getParameterTypesString(String signature) {
        @NonNls StringBuilder sb = new StringBuilder();
        StringTokenizer st = new StringTokenizer(signature, "(,)");
        int i = 0;
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            if (i > 1) {
                sb.append(", ");
            }
            if (i != 0) {
                sb.append('\"');
                int idx = token.indexOf(32);
                if (idx > -1) {
                    sb.append(token, 0, idx);
                } else {
                    sb.append(token);
                }
                sb.append('\"');
            }
            ++i;
        }
        return sb.toString();
    }

    public static String getPatternStringForJavaPlace(String methodName, String parametersStrings, int parameterIndex, String className) {
        StringBuilder sb = new StringBuilder();
        if (parameterIndex >= 0) {
            sb.append("psiParameter().ofMethod(").append(parameterIndex).append(", ");
        }
        sb.append("psiMethod().withName(\"").append(methodName).append("\").withParameters(").append(parametersStrings).append(").definedInClass(\"").append(className).append("\")");
        if (parameterIndex >= 0) {
            sb.append(")");
        }
        return sb.toString();
    }

    public static List<String> getPatternString(MethodParameterInjection injection) {
        ArrayList<String> list = new ArrayList<String>();
        String className = injection.getClassName();
        for (MethodInfo info : injection.getMethodInfos()) {
            boolean[] paramFlags = info.getParamFlags();
            int paramFlagsLength = paramFlags.length;
            String methodName = info.getMethodName();
            String typesString = MethodParameterInjection.getParameterTypesString(info.getMethodSignature());
            if (info.isReturnFlag()) {
                list.add(MethodParameterInjection.getPatternStringForJavaPlace(methodName, typesString, -1, className));
            }
            for (int i = 0; i < paramFlagsLength; ++i) {
                if (!paramFlags[i]) continue;
                list.add(MethodParameterInjection.getPatternStringForJavaPlace(methodName, typesString, i, className));
            }
        }
        return list;
    }

    public static class MethodInfo {
        @NotNull
        final String methodSignature;
        @NotNull
        @NlsSafe
        final String methodName;
        final boolean @NotNull [] paramFlags;
        boolean returnFlag;

        public MethodInfo(@NotNull String methodSignature, boolean @NotNull [] paramFlags, boolean returnFlag) {
            this.methodSignature = methodSignature;
            this.paramFlags = paramFlags;
            this.returnFlag = returnFlag;
            this.methodName = MethodInfo.calcMethodName(methodSignature);
        }

        public MethodInfo(@NotNull String methodSignature, @NotNull String paramFlags) {
            this.methodSignature = methodSignature;
            Pair<boolean[], Boolean> flags = MethodInfo.parseFlags(paramFlags);
            this.returnFlag = (Boolean)flags.second;
            this.paramFlags = (boolean[])flags.first;
            this.methodName = MethodInfo.calcMethodName(methodSignature);
        }

        @NotNull
        public String getMethodSignature() {
            return this.methodSignature;
        }

        @NotNull
        public String getMethodName() {
            return this.methodName;
        }

        public boolean @NotNull [] getParamFlags() {
            return this.paramFlags;
        }

        public boolean isReturnFlag() {
            return this.returnFlag;
        }

        public void setReturnFlag(boolean returnFlag) {
            this.returnFlag = returnFlag;
        }

        public boolean isEnabled() {
            if (this.returnFlag) {
                return true;
            }
            for (boolean b : this.paramFlags) {
                if (!b) continue;
                return true;
            }
            return false;
        }

        private static Pair<boolean[], Boolean> parseFlags(String string) {
            int returnIdx = string.indexOf(58);
            boolean returnFlag = returnIdx != -1 && Boolean.parseBoolean(string.substring(0, returnIdx));
            StringTokenizer st = new StringTokenizer(string.substring(returnIdx + 1), ",");
            boolean[] result = new boolean[st.countTokens()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = Boolean.parseBoolean(st.nextToken());
            }
            return Pair.create((Object)result, (Object)returnFlag);
        }

        @NonNls
        private static String calcMethodName(String methodSignature) {
            String s = (String)StringUtil.split((String)methodSignature, (String)"(").get(0);
            return s.length() == 0 ? "<none>" : s;
        }

        public String getFlagsString() {
            StringBuilder result = new StringBuilder();
            result.append(this.returnFlag).append(':');
            boolean first = true;
            for (boolean b : this.paramFlags) {
                if (first) {
                    first = false;
                } else {
                    result.append(',');
                }
                result.append(b);
            }
            return result.toString();
        }

        public MethodInfo copy() {
            return new MethodInfo(this.methodSignature, (boolean[])this.paramFlags.clone(), this.returnFlag);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MethodInfo that = (MethodInfo)o;
            if (this.returnFlag != that.returnFlag) {
                return false;
            }
            if (!this.methodName.equals(that.methodName)) {
                return false;
            }
            if (!this.methodSignature.equals(that.methodSignature)) {
                return false;
            }
            return Arrays.equals(this.paramFlags, that.paramFlags);
        }

        public int hashCode() {
            int result = this.methodSignature.hashCode();
            result = 31 * result + this.methodName.hashCode();
            result = 31 * result + Arrays.hashCode(this.paramFlags);
            result = 31 * result + (this.returnFlag ? 1 : 0);
            return result;
        }
    }
}

