/*
 * Decompiled with CFR 0.152.
 */
package trebuchet.task;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import trebuchet.extractors.Extractor;
import trebuchet.extractors.ExtractorRegistry;
import trebuchet.importers.ImportFeedback;
import trebuchet.importers.Importer;
import trebuchet.importers.ImporterRegistry;
import trebuchet.io.BufferProducer;
import trebuchet.io.StreamingReader;
import trebuchet.model.Model;
import trebuchet.model.fragments.ModelFragment;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u000e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u000eJ\u000e\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u000eR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Ltrebuchet/task/ImportTask;", "", "importFeedback", "Ltrebuchet/importers/ImportFeedback;", "(Ltrebuchet/importers/ImportFeedback;)V", "fragments", "", "Ltrebuchet/model/fragments/ModelFragment;", "addImporterSource", "", "reader", "Ltrebuchet/io/StreamingReader;", "extractOrImport", "stream", "Ltrebuchet/io/BufferProducer;", "finish", "Ltrebuchet/model/Model;", "import", "source", "importBuffer", "intellij.android.profilers.atrace"})
@SourceDebugExtension(value={"SMAP\nImportTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImportTask.kt\ntrebuchet/task/ImportTask\n+ 2 Timing.kt\nkotlin/system/TimingKt\n*L\n1#1,77:1\n17#2,6:78\n*S KotlinDebug\n*F\n+ 1 ImportTask.kt\ntrebuchet/task/ImportTask\n*L\n37#1:78,6\n*E\n"})
public final class ImportTask {
    @NotNull
    private final ImportFeedback importFeedback;
    @NotNull
    private final List<ModelFragment> fragments;

    public ImportTask(@NotNull ImportFeedback importFeedback) {
        Intrinsics.checkNotNullParameter((Object)importFeedback, (String)"importFeedback");
        this.importFeedback = importFeedback;
        this.fragments = new ArrayList();
    }

    @NotNull
    public final Model importBuffer(@NotNull BufferProducer source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return this.import(source);
    }

    @NotNull
    public final Model import(@NotNull BufferProducer source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Model model = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        this.extractOrImport(source);
        model = this.finish();
        long duration = System.currentTimeMillis() - start$iv;
        System.out.println((Object)("Took " + duration + "ms to import"));
        Model model2 = model;
        Intrinsics.checkNotNull((Object)model2);
        return model2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void extractOrImport(BufferProducer stream) {
        try {
            StreamingReader reader = new StreamingReader(stream, 0, 2, null);
            reader.loadIndex(reader.getKeepLoadedSize());
            Extractor extractor = ExtractorRegistry.INSTANCE.extractorFor(reader, this.importFeedback);
            if (extractor != null) {
                extractor.extract(reader, (Function1<? super BufferProducer, Unit>)((Function1)new Function1<BufferProducer, Unit>((Object)this){

                    public final void invoke(@NotNull BufferProducer p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        ImportTask.access$extractOrImport((ImportTask)this.receiver, p0);
                    }
                }));
            } else {
                this.addImporterSource(reader);
            }
        }
        catch (Throwable ex) {
            this.importFeedback.reportImportException(ex);
        }
        finally {
            stream.close();
        }
    }

    private final void addImporterSource(StreamingReader reader) {
        ModelFragment result;
        Importer importer = ImporterRegistry.INSTANCE.importerFor(reader, this.importFeedback);
        if (importer != null && (result = importer.import(reader)) != null) {
            this.fragments.add(result);
        }
    }

    private final Model finish() {
        Model model = new Model((Iterable<ModelFragment>)this.fragments);
        this.fragments.clear();
        return model;
    }

    public static final /* synthetic */ void access$extractOrImport(ImportTask $this, BufferProducer stream) {
        $this.extractOrImport(stream);
    }
}

