/*
 * Decompiled with CFR 0.152.
 */
package trebuchet.importers.ftrace;

import java.util.regex.Matcher;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import trebuchet.importers.ftrace.FtraceImporterState;
import trebuchet.importers.ftrace.FunctionHandlerRegistry;
import trebuchet.importers.ftrace.ImportData;
import trebuchet.importers.ftrace.SchedParser;
import trebuchet.model.SchedulingState;
import trebuchet.model.fragments.CpuModelFragment;
import trebuchet.model.fragments.ThreadModelFragment;
import trebuchet.util.BufferReader;
import trebuchet.util.BufferReaderState;
import trebuchet.util.MatchResult;
import trebuchet.util.PreviewReader;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\f\u0010\r\u001a\u00020\u000e*\u00020\u000fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Ltrebuchet/importers/ftrace/SchedParser;", "Ltrebuchet/importers/ftrace/FunctionHandlerRegistry;", "()V", "schedSwitchMatcher", "Ljava/util/regex/Matcher;", "schedWakeupMatcher", "sched_blocked_reason", "", "data", "Ltrebuchet/importers/ftrace/ImportData;", "sched_cpu_hotplug", "sched_switch", "sched_wakeup", "readSchedulingState", "Ltrebuchet/model/SchedulingState;", "Ltrebuchet/util/PreviewReader;", "intellij.android.profilers.atrace"})
@SourceDebugExtension(value={"SMAP\nSchedParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SchedParser.kt\ntrebuchet/importers/ftrace/SchedParser\n+ 2 ImportData.kt\ntrebuchet/importers/ftrace/ImportData\n+ 3 BufferReader.kt\ntrebuchet/util/BufferReaderState\n*L\n1#1,111:1\n34#2:112\n34#2:113\n34#2:114\n34#2:115\n60#3:116\n29#3:117\n34#3,2:118\n60#3:120\n*S KotlinDebug\n*F\n+ 1 SchedParser.kt\ntrebuchet/importers/ftrace/SchedParser\n*L\n36#1:112\n66#1:113\n77#1:114\n81#1:115\n86#1:116\n91#1:117\n92#1:118,2\n93#1:120\n*E\n"})
public final class SchedParser
extends FunctionHandlerRegistry {
    @NotNull
    public static final SchedParser INSTANCE = new SchedParser();
    @NotNull
    private static final Matcher schedSwitchMatcher;
    @NotNull
    private static final Matcher schedWakeupMatcher;

    private SchedParser() {
        super(null, 1, null);
    }

    private final void sched_switch(ImportData data) {
        ImportData this_$iv = data;
        boolean $i$f$readDetails = false;
        BufferReader $this$sched_switch_u24lambda_u240 = this_$iv.getLine().getFunctionDetailsReader();
        boolean bl = false;
        $this$sched_switch_u24lambda_u240.match(schedSwitchMatcher, (Function1<? super MatchResult, Unit>)((Function1)new Function1<MatchResult, Unit>(data){
            final /* synthetic */ ImportData $data;
            {
                this.$data = $data;
                super(1);
            }

            public final void invoke(@NotNull MatchResult $this$match) {
                ThreadModelFragment nextThread;
                Intrinsics.checkNotNullParameter((Object)$this$match, (String)"$this$match");
                int prevPid = $this$match.int(2);
                int prevPrio = $this$match.int(3);
                SchedulingState prevState2 = (SchedulingState)((Object)$this$match.read(4, sched_switch.1.prevState.1.INSTANCE));
                int nextPid = $this$match.int(6);
                int nextPrio = $this$match.int(7);
                ThreadModelFragment prevThread = FtraceImporterState.threadFor$default(this.$data.getImporter(), prevPid, 0, null, 6, null);
                if (prevThread.getName() == null) {
                    ThreadModelFragment.hint$default(prevThread, 0, $this$match.string(1), 0, null, 13, null);
                }
                if ((nextThread = FtraceImporterState.threadFor$default(this.$data.getImporter(), nextPid, 0, null, 6, null)).getName() == null) {
                    ThreadModelFragment.hint$default(nextThread, 0, $this$match.string(5), 0, null, 13, null);
                }
                CpuModelFragment cpu = this.$data.getImporter().cpuFor(this.$data.getLine().getCpu());
                prevThread.getSchedulingStateBuilder().switchState(prevState2, this.$data.getLine().getTimestamp());
                nextThread.getSchedulingStateBuilder().switchState(SchedulingState.RUNNING, this.$data.getLine().getTimestamp());
                cpu.getSchedulingProcessBuilder().switchProcess(nextThread.getProcess(), nextThread, this.$data.getLine().getTimestamp());
            }
        }));
    }

    private final void sched_wakeup(ImportData data) {
        ImportData this_$iv = data;
        boolean $i$f$readDetails = false;
        BufferReader $this$sched_wakeup_u24lambda_u241 = this_$iv.getLine().getFunctionDetailsReader();
        boolean bl = false;
        $this$sched_wakeup_u24lambda_u241.match(schedWakeupMatcher, (Function1<? super MatchResult, Unit>)((Function1)new Function1<MatchResult, Unit>(data){
            final /* synthetic */ ImportData $data;
            {
                this.$data = $data;
                super(1);
            }

            public final void invoke(@NotNull MatchResult $this$match) {
                Intrinsics.checkNotNullParameter((Object)$this$match, (String)"$this$match");
                int pid = $this$match.int(2);
                ThreadModelFragment thread2 = FtraceImporterState.threadFor$default(this.$data.getImporter(), pid, 0, null, 6, null);
                if (thread2.getName() == null) {
                    ThreadModelFragment.hint$default(thread2, 0, $this$match.string(1), 0, null, 13, null);
                }
                thread2.getSchedulingStateBuilder().switchState(SchedulingState.WAKING, this.$data.getLine().getTimestamp());
            }
        }));
    }

    private final void sched_blocked_reason(ImportData data) {
        ImportData this_$iv = data;
        boolean $i$f$readDetails = false;
        BufferReader $this$sched_blocked_reason_u24lambda_u242 = this_$iv.getLine().getFunctionDetailsReader();
        boolean bl = false;
    }

    private final void sched_cpu_hotplug(ImportData data) {
        ImportData this_$iv = data;
        boolean $i$f$readDetails = false;
        BufferReader $this$sched_cpu_hotplug_u24lambda_u243 = this_$iv.getLine().getFunctionDetailsReader();
        boolean bl = false;
    }

    private final SchedulingState readSchedulingState(PreviewReader $this$readSchedulingState) {
        SchedulingState schedulingState;
        byte by;
        BufferReaderState this_$iv = $this$readSchedulingState;
        boolean $i$f$readByte = false;
        byte[] byArray = this_$iv.getBuffer();
        int n = this_$iv.getIndex();
        this_$iv.setIndex(n + 1);
        byte by2 = by = byArray[n];
        if (by2 == 83) {
            schedulingState = SchedulingState.SLEEPING;
        } else if (by2 == 82) {
            schedulingState = SchedulingState.RUNNABLE;
        } else if (by2 == 68) {
            BufferReaderState this_$iv2 = $this$readSchedulingState;
            boolean $i$f$peek = false;
            if (this_$iv2.getBuffer()[this_$iv2.getIndex()] == 124) {
                this_$iv2 = $this$readSchedulingState;
                boolean $i$f$skip = false;
                int n2 = this_$iv2.getIndex();
                this_$iv2.setIndex(n2 + 1);
                BufferReaderState this_$iv3 = $this$readSchedulingState;
                boolean $i$f$readByte2 = false;
                byte[] byArray2 = this_$iv3.getBuffer();
                int n3 = this_$iv3.getIndex();
                this_$iv3.setIndex(n3 + 1);
                byte by3 = byArray2[n3];
                return by3 == 75 ? SchedulingState.UNINTR_SLEEP_WAKE_KILL : (by3 == 87 ? SchedulingState.UNINTR_SLEEP_WAKING : SchedulingState.UNINTR_SLEEP);
            }
            schedulingState = SchedulingState.UNINTR_SLEEP;
        } else {
            schedulingState = by2 == 84 ? SchedulingState.STOPPED : (by2 == 116 ? SchedulingState.DEBUG : (by2 == 90 ? SchedulingState.ZOMBIE : (by2 == 88 ? SchedulingState.EXIT_DEAD : (by2 == 120 ? SchedulingState.TASK_DEAD : (by2 == 75 ? SchedulingState.WAKE_KILL : (by2 == 87 ? SchedulingState.WAKING : SchedulingState.UNKNOWN))))));
        }
        return schedulingState;
    }

    public static final /* synthetic */ SchedulingState access$readSchedulingState(SchedParser $this, PreviewReader $receiver) {
        return $this.readSchedulingState($receiver);
    }

    static {
        INSTANCE.handleWith("sched_switch", (Function1<? super ImportData, Unit>)((Function1)new Function1<ImportData, Unit>((Object)INSTANCE){

            public final void invoke(@NotNull ImportData p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((SchedParser)this.receiver).sched_switch(p0);
            }
        }));
        INSTANCE.handleWith("sched_waking", (Function1<? super ImportData, Unit>)((Function1)new Function1<ImportData, Unit>((Object)INSTANCE){

            public final void invoke(@NotNull ImportData p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((SchedParser)this.receiver).sched_wakeup(p0);
            }
        }));
        INSTANCE.handleWith("sched_wakeup", (Function1<? super ImportData, Unit>)((Function1)new Function1<ImportData, Unit>((Object)INSTANCE){

            public final void invoke(@NotNull ImportData p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((SchedParser)this.receiver).sched_wakeup(p0);
            }
        }));
        INSTANCE.handleWith("sched_blocked_reason", (Function1<? super ImportData, Unit>)((Function1)new Function1<ImportData, Unit>((Object)INSTANCE){

            public final void invoke(@NotNull ImportData p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((SchedParser)this.receiver).sched_blocked_reason(p0);
            }
        }));
        INSTANCE.handleWith("sched_cpu_hotplug", (Function1<? super ImportData, Unit>)((Function1)new Function1<ImportData, Unit>((Object)INSTANCE){

            public final void invoke(@NotNull ImportData p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((SchedParser)this.receiver).sched_cpu_hotplug(p0);
            }
        }));
        schedSwitchMatcher = INSTANCE.matcher("prev_comm=(.*) prev_pid=(\\d+) prev_prio=(\\d+) prev_state=([^\\s]+) ==> next_comm=(.*) next_pid=(\\d+) next_prio=(\\d+)");
        schedWakeupMatcher = INSTANCE.matcher("comm=(.+) pid=(\\d+) prio=(\\d+)(?: success=\\d+)? target_cpu=(\\d+)");
    }
}

