/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.sessions;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.updater.Updatable;
import com.android.tools.idea.protobuf.ByteString;
import com.android.tools.idea.protobuf.GeneratedMessageV3;
import com.android.tools.idea.transport.EventStreamServer;
import com.android.tools.idea.transport.TransportService;
import com.android.tools.profiler.proto.Commands;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profilers.LogUtils;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.cpu.CpuCaptureSessionArtifact;
import com.android.tools.profilers.memory.AllocationSessionArtifact;
import com.android.tools.profilers.memory.HeapProfdSessionArtifact;
import com.android.tools.profilers.memory.HprofSessionArtifact;
import com.android.tools.profilers.sessions.SessionArtifact;
import com.android.tools.profilers.sessions.SessionAspect;
import com.android.tools.profilers.sessions.SessionItem;
import com.google.common.collect.Lists;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class SessionsManager
extends AspectModel<SessionAspect> {
    private static final SessionArtifactComparator ARTIFACT_COMPARATOR = new SessionArtifactComparator();
    @NotNull
    private final StudioProfilers myProfilers;
    @NotNull
    private Map<Long, SessionItem> mySessionItems;
    @NotNull
    private Map<Long, Common.SessionMetaData> mySessionMetaDatas;
    @NotNull
    private List<SessionArtifact> mySessionArtifacts;
    @NotNull
    private Common.Session mySelectedSession;
    private GeneratedMessageV3 mySelectedArtifactProto;
    @NotNull
    private Common.Session myProfilingSession;
    private final Map<Long, Range> mySessionViewRangeMap;
    private final Map<String, Consumer<File>> myImportHandlers = new HashMap<String, Consumer<File>>();
    @NotNull
    private final List<ArtifactFetcher> myArtifactsFetchers;
    @NotNull
    private final Map<Long, EventStreamServer> myStreamIdToStreamServerMap = new HashMap<Long, EventStreamServer>();

    private static Logger getLogger() {
        return Logger.getInstance(SessionsManager.class);
    }

    public SessionsManager(@NotNull StudioProfilers profilers) {
        this.myProfilers = profilers;
        this.mySelectedSession = this.myProfilingSession = Common.Session.getDefaultInstance();
        this.mySessionItems = new HashMap<Long, SessionItem>();
        this.mySessionMetaDatas = new HashMap<Long, Common.SessionMetaData>();
        this.mySessionMetaDatas.put(Common.Session.getDefaultInstance().getSessionId(), Common.SessionMetaData.getDefaultInstance());
        this.mySessionArtifacts = new ArrayList<SessionArtifact>();
        this.mySessionViewRangeMap = new HashMap<Long, Range>();
        this.myArtifactsFetchers = new ArrayList<ArtifactFetcher>();
        this.myArtifactsFetchers.add(HprofSessionArtifact::getSessionArtifacts);
        this.myArtifactsFetchers.add(CpuCaptureSessionArtifact::getSessionArtifacts);
        this.myArtifactsFetchers.add(HeapProfdSessionArtifact::getSessionArtifacts);
        this.myArtifactsFetchers.add(AllocationSessionArtifact::getSessionArtifacts);
    }

    @NotNull
    public Common.Session getSelectedSession() {
        return this.mySelectedSession;
    }

    @NotNull
    public Common.Session getProfilingSession() {
        return this.myProfilingSession;
    }

    @VisibleForTesting
    public GeneratedMessageV3 getSelectedArtifactProto() {
        return this.mySelectedArtifactProto;
    }

    @NotNull
    public Common.SessionMetaData getSelectedSessionMetaData() {
        return this.mySessionMetaDatas.get(this.mySelectedSession.getSessionId());
    }

    @NotNull
    public List<SessionArtifact> getSessionArtifacts() {
        return this.mySessionArtifacts;
    }

    public boolean isSessionAlive() {
        return SessionsManager.isSessionAlive(this.mySelectedSession);
    }

    public static boolean isSessionAlive(@NotNull Common.Session session) {
        return session.getEndTimestamp() == Long.MAX_VALUE;
    }

    @NotNull
    public Range getSessionPreferredViewRange(@NotNull Common.Session session) {
        double viewRangeMin = TimeUnit.NANOSECONDS.toMicros(session.getStartTimestamp());
        double viewRangeMax = TimeUnit.NANOSECONDS.toMicros(session.getEndTimestamp());
        if (this.mySessionViewRangeMap.containsKey(session.getSessionId())) {
            Range cachedRange = this.mySessionViewRangeMap.get(session.getSessionId());
            viewRangeMin = Math.max(viewRangeMin, cachedRange.getMin());
            viewRangeMax = Math.min(viewRangeMax, cachedRange.getMax());
        }
        return new Range(viewRangeMin, viewRangeMax);
    }

    public void update() {
        Transport.GetEventGroupsRequest request = Transport.GetEventGroupsRequest.newBuilder().setKind(Common.Event.Kind.SESSION).build();
        Transport.GetEventGroupsResponse response = this.myProfilers.getClient().getTransportClient().getEventGroups(request);
        this.updateSessionItemsByGroup(response.getGroupsList());
    }

    private void updateSessionItemsByGroup(List<Transport.EventGroup> groups) {
        ArrayList<SessionArtifact> sessionArtifacts = new ArrayList<SessionArtifact>();
        List previousArtifactProtos = ContainerUtil.map(this.mySessionArtifacts, artifact -> artifact.getArtifactProto());
        ArrayList sortedGroups = Lists.newArrayList(groups);
        Collections.sort(sortedGroups, Comparator.comparing(Transport.EventGroup::getEventsCount, Comparator.reverseOrder()).thenComparingLong(g -> g.getEventsCount() > 0 ? g.getEvents(0).getSession().getSessionStarted().getStartTimestampEpochMs() : 0L));
        sortedGroups.forEach(group -> {
            SessionItem sessionItem = this.mySessionItems.get(group.getGroupId());
            boolean sessionStateChanged = false;
            Common.Event startEvent = group.getEvents(0);
            if (startEvent.getSession().getSessionStarted().getType() != Common.SessionData.SessionStarted.SessionType.FULL && group.getEventsCount() < 2) {
                return;
            }
            if (sessionItem == null) {
                sessionItem = this.processSessionStarted(startEvent);
                sessionStateChanged = true;
                LogUtils.log(((Object)((Object)this)).getClass(), "Session started (" + sessionItem.getName() + "), support level =" + this.myProfilers.getSupportLevelForSession(sessionItem.getSession()));
            }
            if (group.getEventsCount() == 2 && sessionItem.isOngoing()) {
                Common.Session session = sessionItem.getSession().toBuilder().setEndTimestamp(group.getEvents(1).getTimestamp()).build();
                sessionItem.setSession(session);
                sessionStateChanged = true;
                LogUtils.log(((Object)((Object)this)).getClass(), "Session stopped (" + sessionItem.getName() + "), support level =" + this.myProfilers.getSupportLevelForSession(sessionItem.getSession()));
            }
            if (sessionStateChanged) {
                this.setSessionInternal(sessionItem.getSession());
                if (sessionItem.isOngoing()) {
                    this.setProfilingSession(sessionItem.getSession());
                }
                this.setSessionInternal(sessionItem.getSession());
            }
            SessionItem item = sessionItem;
            sessionArtifacts.add(item);
            ArrayList artifacts = new ArrayList();
            this.myArtifactsFetchers.forEach(fetcher -> artifacts.addAll(fetcher.fetch(this.myProfilers, item.getSession(), item.getSessionMetaData())));
            item.setChildArtifacts(artifacts);
            if (item.getSessionMetaData().getType() == Common.SessionMetaData.SessionType.FULL) {
                sessionArtifacts.addAll(artifacts);
            }
            Collections.sort(sessionArtifacts, ARTIFACT_COMPARATOR);
        });
        List newArtifactProtos = ContainerUtil.map(sessionArtifacts, artifact -> artifact.getArtifactProto());
        if (!previousArtifactProtos.equals(newArtifactProtos)) {
            this.mySessionArtifacts.forEach(artifact -> this.myProfilers.getUpdater().unregister((Updatable)artifact));
            this.mySessionArtifacts = sessionArtifacts;
            this.changed(SessionAspect.SESSIONS);
            this.mySessionArtifacts.forEach(artifact -> this.myProfilers.getUpdater().register((Updatable)artifact));
            this.registerImplicitlySelectedArtifactProto(this.mySessionArtifacts, previousArtifactProtos);
        }
    }

    private void registerImplicitlySelectedArtifactProto(List<SessionArtifact> sessionArtifacts, List<GeneratedMessageV3> previousArtifactProtos) {
        SessionArtifact[] newlyAddedArtifacts = (SessionArtifact[])sessionArtifacts.stream().filter(i -> !previousArtifactProtos.contains(i.getArtifactProto())).toArray(SessionArtifact[]::new);
        if (newlyAddedArtifacts.length >= 1) {
            boolean onlyOneArtifactIsNew;
            SessionArtifact artifact = newlyAddedArtifacts[0];
            boolean bl = onlyOneArtifactIsNew = newlyAddedArtifacts.length == 1;
            if (onlyOneArtifactIsNew && artifact.isTopLevelArtifact() && artifact.isOngoing() || onlyOneArtifactIsNew && !artifact.isTopLevelArtifact() && !artifact.isOngoing() && !artifact.isInitiatedByApi() || artifact.isTopLevelArtifact() && !artifact.isOngoing() && ((SessionItem)artifact).getChildArtifacts().stream().noneMatch(x -> x.getArtifactProto().equals((Object)this.getSelectedArtifactProto()))) {
                this.registerSelectedArtifactProto((GeneratedMessageV3)artifact.getArtifactProto());
            }
        }
    }

    private SessionItem processSessionStarted(Common.Event event) {
        Common.SessionData.SessionStarted sessionData = event.getSession().getSessionStarted();
        Common.Session session = Common.Session.newBuilder().setSessionId(sessionData.getSessionId()).setPid(sessionData.getPid()).setStartTimestamp(event.getTimestamp()).setEndTimestamp(Long.MAX_VALUE).setStreamId(sessionData.getStreamId()).build();
        Common.SessionMetaData metadata = Common.SessionMetaData.newBuilder().setSessionId(session.getSessionId()).setType(Common.SessionMetaData.SessionType.forNumber((int)sessionData.getType().getNumber())).setStartTimestampEpochMs(sessionData.getStartTimestampEpochMs()).setProcessAbi(sessionData.getProcessAbi()).setJvmtiEnabled(sessionData.getJvmtiEnabled()).setSessionName(sessionData.getSessionName()).build();
        SessionItem sessionItem = new SessionItem(this.myProfilers, session, metadata);
        this.mySessionItems.put(session.getSessionId(), sessionItem);
        this.mySessionMetaDatas.put(session.getSessionId(), metadata);
        return sessionItem;
    }

    public boolean setSessionById(long sessionId) {
        if (!this.mySessionItems.containsKey(sessionId)) {
            return false;
        }
        this.setSession(this.mySessionItems.get(sessionId).getSession());
        return true;
    }

    public void setSession(@NotNull Common.Session session) {
        this.myProfilers.setAutoProfilingEnabled(false);
        this.setSessionInternal(session);
    }

    private void setSessionInternal(@NotNull Common.Session session) {
        if (session.equals((Object)this.mySelectedSession)) {
            return;
        }
        assert (Common.Session.getDefaultInstance().equals((Object)session) || this.mySessionItems.containsKey(session.getSessionId()) && this.mySessionItems.get(session.getSessionId()).getSession().equals((Object)session));
        if (!Common.Session.getDefaultInstance().equals((Object)this.mySelectedSession)) {
            this.mySessionViewRangeMap.put(this.mySelectedSession.getSessionId(), new Range(this.myProfilers.getTimeline().getViewRange()));
        }
        this.mySelectedSession = session;
        this.changed(SessionAspect.SELECTED_SESSION);
    }

    private void setProfilingSession(@NotNull Common.Session session) {
        if (session.equals((Object)this.myProfilingSession)) {
            return;
        }
        this.myProfilingSession = session;
        this.changed(SessionAspect.PROFILING_SESSION);
    }

    public void registerSelectedArtifactProto(GeneratedMessageV3 selectedArtifactProto) {
        this.mySelectedArtifactProto = selectedArtifactProto;
    }

    public void resetSelectedArtifactProto() {
        this.registerSelectedArtifactProto(null);
    }

    public void beginSession(long streamId, @NotNull Common.Device device, @NotNull Common.Process process) {
        assert (Common.Session.getDefaultInstance().equals((Object)this.myProfilingSession));
        assert (device.getState() == Common.Device.State.ONLINE);
        assert (process.getState() == Common.Process.State.ALIVE);
        assert (streamId != 0L);
        Commands.BeginSession.Builder requestBuilder = Commands.BeginSession.newBuilder().setSessionName(StudioProfilers.buildSessionName(device, process)).setRequestTimeEpochMs(System.currentTimeMillis()).setProcessAbi(process.getAbiCpuArch());
        if (device.getFeatureLevel() >= 26 && process.getExposureLevel() == Common.Process.ExposureLevel.DEBUGGABLE) {
            requestBuilder.setJvmtiConfig(Commands.BeginSession.JvmtiConfig.newBuilder().setAttachAgent(true).setAgentLibFileName(String.format("libjvmtiagent_%s.so", process.getAbiCpuArch())).setAgentConfigPath("/data/local/tmp/perfd/agent.config").setPackageName(process.getPackageName()).build());
        }
        Commands.Command command = Commands.Command.newBuilder().setStreamId(streamId).setPid(process.getPid()).setBeginSession(requestBuilder).setType(Commands.Command.CommandType.BEGIN_SESSION).build();
        this.myProfilers.getClient().executeAsync(command, this.myProfilers.getIdeServices().getPoolExecutor());
    }

    public void endCurrentSession() {
        if (Common.Session.getDefaultInstance().equals((Object)this.myProfilingSession)) {
            return;
        }
        Common.Session profilingSession = this.myProfilingSession;
        this.setProfilingSession(Common.Session.getDefaultInstance());
        Commands.Command command = Commands.Command.newBuilder().setStreamId(profilingSession.getStreamId()).setPid(profilingSession.getPid()).setEndSession(Commands.EndSession.newBuilder().setSessionId(profilingSession.getSessionId())).setType(Commands.Command.CommandType.END_SESSION).build();
        this.myProfilers.getClient().executeAsync(command, this.myProfilers.getIdeServices().getPoolExecutor());
    }

    public void deleteSession(@NotNull Common.Session session) {
        assert (this.mySessionItems.containsKey(session.getSessionId()) && this.mySessionItems.get(session.getSessionId()).getSession().equals((Object)session));
        boolean sessionIsSelectedSession = this.mySelectedSession.equals((Object)session);
        if (this.myProfilingSession.equals((Object)session)) {
            this.myProfilers.setProcess(null, null);
        }
        if (sessionIsSelectedSession) {
            this.setSessionInternal(Common.Session.getDefaultInstance());
        }
        Transport.DeleteEventsRequest deleteRequest = Transport.DeleteEventsRequest.newBuilder().setStreamId(session.getStreamId()).setPid(session.getPid()).setGroupId(session.getSessionId()).setKind(Common.Event.Kind.SESSION).setFromTimestamp(session.getStartTimestamp()).setToTimestamp(session.getEndTimestamp()).build();
        Transport.DeleteEventsResponse response = this.myProfilers.getClient().getTransportClient().deleteEvents(deleteRequest);
        this.mySessionItems.remove(session.getSessionId());
        this.updateSessionItems(Collections.emptyList());
    }

    @Nullable
    public EventStreamServer getEventStreamServer(long streamId) {
        return this.myStreamIdToStreamServerMap.get(streamId);
    }

    public void createImportedSession(@NotNull String sessionName, @NotNull Common.SessionData.SessionStarted.SessionType sessionType, long startTimestampNs, long endTimestampNs, long startTimestampEpochMs, Map<String, ByteString> byteCacheMap, Common.Event ... events) {
        EventStreamServer streamServer = new EventStreamServer(Long.toString(startTimestampEpochMs));
        try {
            streamServer.start();
        }
        catch (IOException exception) {
            SessionsManager.getLogger().error(String.format("Failed to create a event server. Aborting import for session %s", sessionName));
            return;
        }
        Common.Stream stream = TransportService.getInstance().registerStreamServer(Common.Stream.Type.FILE, streamServer);
        this.myStreamIdToStreamServerMap.put(stream.getStreamId(), streamServer);
        streamServer.getByteCacheMap().putAll(byteCacheMap);
        BlockingDeque deque = streamServer.getEventDeque();
        for (Common.Event event : events) {
            deque.offer(event);
        }
        deque.offer(Common.Event.newBuilder().setKind(Common.Event.Kind.SESSION).setGroupId(startTimestampNs).setTimestamp(startTimestampNs).setSession(Common.SessionData.newBuilder().setSessionStarted(Common.SessionData.SessionStarted.newBuilder().setStreamId(stream.getStreamId()).setSessionId(startTimestampNs).setType(sessionType).setStartTimestampEpochMs(startTimestampEpochMs).setSessionName(sessionName))).build());
        deque.offer(Common.Event.newBuilder().setKind(Common.Event.Kind.SESSION).setGroupId(startTimestampNs).setTimestamp(endTimestampNs).setIsEnded(true).build());
    }

    public void registerImportHandler(@NotNull String extension, @NotNull Consumer<File> handler2) {
        this.myImportHandlers.put(extension, handler2);
    }

    public boolean importSessionFromFile(@NotNull File file) {
        int indexOfDot = file.getName().lastIndexOf(46);
        if (indexOfDot == -1) {
            return false;
        }
        String extension = StringUtil.toLowerCase((String)file.getName().substring(indexOfDot + 1));
        if (this.myImportHandlers.get(extension) == null) {
            return false;
        }
        this.myImportHandlers.get(extension).accept(file);
        return true;
    }

    private void updateSessionItems(@NotNull List<Common.Session> sessions) {
        List previousProtos = ContainerUtil.map(this.mySessionArtifacts, artifact -> artifact.getArtifactProto());
        sessions.forEach(session -> {
            SessionItem sessionItem = this.mySessionItems.get(session.getSessionId());
            if (sessionItem != null) {
                sessionItem.setSession((Common.Session)session);
            }
        });
        ArrayList<SessionArtifact> sessionArtifacts = new ArrayList<SessionArtifact>();
        for (SessionItem item : this.mySessionItems.values()) {
            sessionArtifacts.add(item);
            ArrayList artifacts = new ArrayList();
            this.myArtifactsFetchers.forEach(fetcher -> artifacts.addAll(fetcher.fetch(this.myProfilers, item.getSession(), item.getSessionMetaData())));
            item.setChildArtifacts(artifacts);
            if (item.getSessionMetaData().getType() != Common.SessionMetaData.SessionType.FULL) continue;
            sessionArtifacts.addAll(artifacts);
        }
        Collections.sort(sessionArtifacts, ARTIFACT_COMPARATOR);
        List newProtos = ContainerUtil.map(sessionArtifacts, artifact -> artifact.getArtifactProto());
        if (!previousProtos.equals(newProtos)) {
            this.mySessionArtifacts.forEach(artifact -> this.myProfilers.getUpdater().unregister((Updatable)artifact));
            this.mySessionArtifacts = sessionArtifacts;
            this.changed(SessionAspect.SESSIONS);
            this.mySessionArtifacts.forEach(artifact -> this.myProfilers.getUpdater().register((Updatable)artifact));
        }
    }

    public boolean selectArtifactProto(GeneratedMessageV3 artifactProto) {
        if (artifactProto.equals((Object)this.getSelectedArtifactProto())) {
            return false;
        }
        this.registerSelectedArtifactProto(artifactProto);
        return true;
    }

    private static interface ArtifactFetcher {
        public List<SessionArtifact<?>> fetch(@NotNull StudioProfilers var1, @NotNull Common.Session var2, @NotNull Common.SessionMetaData var3);
    }

    private static class SessionArtifactComparator
    implements Comparator<SessionArtifact> {
        private SessionArtifactComparator() {
        }

        @Override
        public int compare(SessionArtifact artifact1, SessionArtifact artifact2) {
            int result = Long.compare(artifact2.getSessionMetaData().getStartTimestampEpochMs(), artifact1.getSessionMetaData().getStartTimestampEpochMs());
            if (result != 0) {
                return result;
            }
            if (artifact1 instanceof SessionItem) {
                return -1;
            }
            if (artifact2 instanceof SessionItem) {
                return 1;
            }
            return Long.compare(artifact2.getTimestampNs(), artifact1.getTimestampNs());
        }
    }

    public static enum SessionCreationSource {
        MANUAL;

    }
}

