/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.sessions;

import com.android.tools.adtui.model.StreamingTimeline;
import com.android.tools.adtui.model.updater.Updatable;
import com.android.tools.idea.protobuf.GeneratedMessageV3;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Trace;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.cpu.CpuCaptureSessionArtifact;
import com.android.tools.profilers.sessions.SessionItem;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\bf\u0018\u0000 **\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001*J\b\u0010 \u001a\u00020!H&J\u0010\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020\bH\u0016J\b\u0010&\u001a\u00020\bH\u0016J\b\u0010'\u001a\u00020!H\u0016J\u0010\u0010(\u001a\u00020!2\u0006\u0010)\u001a\u00020\u001dH\u0016R\u0012\u0010\u0004\u001a\u00028\u0000X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\nR\u0012\u0010\f\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0010\u001a\u00020\u0011X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0012\u0010\u0014\u001a\u00020\u0015X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0012\u0010\u0018\u001a\u00020\u0019X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0012\u0010\u001c\u001a\u00020\u001dX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006+\u00c0\u0006\u0003"}, d2={"Lcom/android/tools/profilers/sessions/SessionArtifact;", "T", "Lcom/android/tools/idea/protobuf/GeneratedMessageV3;", "Lcom/android/tools/adtui/model/updater/Updatable;", "artifactProto", "getArtifactProto", "()Lcom/android/tools/idea/protobuf/GeneratedMessageV3;", "canExport", "", "getCanExport", "()Z", "isOngoing", "name", "", "getName", "()Ljava/lang/String;", "profilers", "Lcom/android/tools/profilers/StudioProfilers;", "getProfilers", "()Lcom/android/tools/profilers/StudioProfilers;", "session", "Lcom/android/tools/profiler/proto/Common$Session;", "getSession", "()Lcom/android/tools/profiler/proto/Common$Session;", "sessionMetaData", "Lcom/android/tools/profiler/proto/Common$SessionMetaData;", "getSessionMetaData", "()Lcom/android/tools/profiler/proto/Common$SessionMetaData;", "timestampNs", "", "getTimestampNs", "()J", "doSelect", "", "export", "outputStream", "Ljava/io/OutputStream;", "isInitiatedByApi", "isTopLevelArtifact", "onSelect", "update", "elapsedNs", "Companion", "intellij.android.profilers"})
public interface SessionArtifact<T extends GeneratedMessageV3>
extends Updatable {
    @NotNull
    public static final Companion Companion = com.android.tools.profilers.sessions.SessionArtifact$Companion.$$INSTANCE;
    @NotNull
    public static final String CAPTURING_SUBTITLE = "Recording...";

    @NotNull
    public StudioProfilers getProfilers();

    @NotNull
    public Common.Session getSession();

    @NotNull
    public T getArtifactProto();

    @NotNull
    public Common.SessionMetaData getSessionMetaData();

    @NotNull
    public String getName();

    public long getTimestampNs();

    public boolean isOngoing();

    public boolean getCanExport();

    default public void onSelect() {
        if (this.isTopLevelArtifact()) {
            this.getProfilers().getSessionsManager().registerSelectedArtifactProto((GeneratedMessageV3)this.getArtifactProto());
        } else if (!this.getProfilers().getSessionsManager().selectArtifactProto((GeneratedMessageV3)this.getArtifactProto())) {
            return;
        }
        this.doSelect();
    }

    public void doSelect();

    default public void export(@NotNull OutputStream outputStream) {
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
    }

    default public void update(long elapsedNs) {
    }

    default public boolean isTopLevelArtifact() {
        return this instanceof SessionItem;
    }

    default public boolean isInitiatedByApi() {
        return this instanceof CpuCaptureSessionArtifact && ((CpuCaptureSessionArtifact)this).getArtifactProto().hasConfiguration() && ((CpuCaptureSessionArtifact)this).getArtifactProto().getConfiguration().getInitiationType() == Trace.TraceInitiationType.INITIATED_BY_API;
    }

    @JvmStatic
    public static void navigateTimelineToOngoingCapture(@NotNull StreamingTimeline timeline, long startTimeUs) {
        Companion.navigateTimelineToOngoingCapture(timeline, startTimeUs);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/profilers/sessions/SessionArtifact$Companion;", "", "()V", "CAPTURING_SUBTITLE", "", "navigateTimelineToOngoingCapture", "", "timeline", "Lcom/android/tools/adtui/model/StreamingTimeline;", "startTimeUs", "", "intellij.android.profilers"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        public static final String CAPTURING_SUBTITLE = "Recording...";

        private Companion() {
        }

        @JvmStatic
        public final void navigateTimelineToOngoingCapture(@NotNull StreamingTimeline timeline, long startTimeUs) {
            Intrinsics.checkNotNullParameter((Object)timeline, (String)"timeline");
            double viewRange90PercentLength = 0.9 * timeline.getViewRange().getLength();
            double currentOngoingCaptureLength = timeline.getDataRange().getMax() - (double)startTimeUs;
            if (currentOngoingCaptureLength > viewRange90PercentLength) {
                timeline.zoom(currentOngoingCaptureLength - viewRange90PercentLength);
            }
            timeline.setStreaming(true);
            timeline.setIsPaused(false);
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @Deprecated
        public static <T extends GeneratedMessageV3> void onSelect(@NotNull SessionArtifact<T> $this) {
            ((SessionArtifact)$this).onSelect();
        }

        @Deprecated
        public static <T extends GeneratedMessageV3> void export(@NotNull SessionArtifact<T> $this, @NotNull OutputStream outputStream) {
            Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
            ((SessionArtifact)$this).export(outputStream);
        }

        @Deprecated
        public static <T extends GeneratedMessageV3> void update(@NotNull SessionArtifact<T> $this, long elapsedNs) {
            ((SessionArtifact)$this).update(elapsedNs);
        }

        @Deprecated
        public static <T extends GeneratedMessageV3> boolean isTopLevelArtifact(@NotNull SessionArtifact<T> $this) {
            return ((SessionArtifact)$this).isTopLevelArtifact();
        }

        @Deprecated
        public static <T extends GeneratedMessageV3> boolean isInitiatedByApi(@NotNull SessionArtifact<T> $this) {
            return ((SessionArtifact)$this).isInitiatedByApi();
        }

        @Deprecated
        public static <T extends GeneratedMessageV3> void postUpdate(@NotNull SessionArtifact<T> $this) {
            ((SessionArtifact)$this).postUpdate();
        }

        @Deprecated
        public static <T extends GeneratedMessageV3> void reset(@NotNull SessionArtifact<T> $this) {
            ((SessionArtifact)$this).reset();
        }
    }
}

