/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters;

import com.intellij.util.ArrayUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;

public final class ClassDb {
    public static final int INVALID_CLASS_ID = -1;
    public static final String JAVA_LANG_STRING = "java.lang.String";
    public static final String JAVA_LANG_CLASS = "java.lang.Class";
    private final Map<Long, ClassEntry> myClassEntries = new HashMap<Long, ClassEntry>();
    private boolean myResolvedSubclasses = false;

    public void clear() {
        this.myClassEntries.clear();
        this.myResolvedSubclasses = false;
    }

    @NotNull
    public ClassEntry registerClass(long classId, @NotNull String className) {
        return this.registerClass(classId, className, -1L);
    }

    @NotNull
    public ClassEntry registerClass(long classId, @NotNull String className, long retainedSize) {
        return this.registerClass(classId, -1L, className, retainedSize);
    }

    @NotNull
    public ClassEntry registerClass(long classId, long superClassId, @NotNull String className) {
        return this.registerClass(classId, superClassId, className, -1L);
    }

    @NotNull
    public ClassEntry registerClass(long classId, long superClassId, @NotNull String className, long retainedSize) {
        ClassEntry entry2 = this.myClassEntries.get(classId);
        if (entry2 == null || superClassId != entry2.mySuperClassId || !className.equals(entry2.myClassName)) {
            entry2 = new ClassEntry(classId, superClassId, className, retainedSize);
            this.myClassEntries.put(classId, entry2);
        }
        return entry2;
    }

    @NotNull
    public ClassEntry getEntry(long classId) {
        assert (this.myClassEntries.containsKey(classId));
        return this.myClassEntries.get(classId);
    }

    @NotNull
    public Set<ClassEntry> getEntriesByName(@NotNull String className) {
        HashSet<ClassEntry> entries = new HashSet<ClassEntry>();
        for (ClassEntry entry2 : this.myClassEntries.values()) {
            if (!entry2.getClassName().equals(className)) continue;
            entries.add(entry2);
        }
        return entries;
    }

    public Set<ClassEntry> getDescendantClasses(long classId) {
        this.resolveSubClasses();
        ClassEntry klass = this.getEntry(classId);
        HashSet<ClassEntry> descendants = new HashSet<ClassEntry>();
        Stack<ClassEntry> searchStack = new Stack<ClassEntry>();
        searchStack.push(klass);
        while (!searchStack.isEmpty()) {
            ClassEntry searchEntry = (ClassEntry)searchStack.pop();
            descendants.add(searchEntry);
            for (long subClassId : searchEntry.getSubClassIds()) {
                searchStack.push(this.getEntry(subClassId));
            }
        }
        return descendants;
    }

    private boolean resolveSubClasses() {
        if (this.myResolvedSubclasses) {
            return false;
        }
        for (ClassEntry entry2 : this.myClassEntries.values()) {
            long superClassId = entry2.getSuperClassId();
            if (superClassId == -1L) continue;
            this.getEntry(superClassId).getSubClassIds().add(entry2.getClassId());
        }
        this.myResolvedSubclasses = true;
        return true;
    }

    public static class ClassEntry {
        @NotNull
        private final Set<Long> mySubClassIds = new HashSet<Long>();
        @NotNull
        private final long myClassId;
        @NotNull
        private final long mySuperClassId;
        @NotNull
        private final String myClassName;
        @NotNull
        private final String[] mySplitPackageName;
        private final long myRetainedSize;

        public ClassEntry(long classId, long superClassId, @NotNull String className, long retainedSize) {
            this.myClassId = classId;
            this.mySuperClassId = superClassId;
            this.myClassName = className;
            String packageName = this.getPackageName();
            this.mySplitPackageName = packageName.isEmpty() ? ArrayUtil.EMPTY_STRING_ARRAY : packageName.split("\\.");
            this.myRetainedSize = retainedSize;
        }

        public ClassEntry(long classId, long superClassId, @NotNull String className) {
            this(classId, superClassId, className, -1L);
        }

        public long getClassId() {
            return this.myClassId;
        }

        public long getSuperClassId() {
            return this.mySuperClassId;
        }

        public Set<Long> getSubClassIds() {
            return this.mySubClassIds;
        }

        @NotNull
        public String getClassName() {
            return this.myClassName;
        }

        @NotNull
        public String getPackageName() {
            int lastIndexOfDot = this.getLastIndexOfDot();
            return lastIndexOfDot > 0 ? this.myClassName.substring(0, lastIndexOfDot) : "";
        }

        @NotNull
        public String[] getSplitPackageName() {
            return this.mySplitPackageName;
        }

        @NotNull
        public String getSimpleClassName() {
            return this.myClassName.substring(this.getLastIndexOfDot() + 1);
        }

        public long getRetainedSize() {
            return this.myRetainedSize;
        }

        public int hashCode() {
            return this.myClassName.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof ClassEntry && this.myClassName.equals(((ClassEntry)obj).myClassName);
        }

        private int getLastIndexOfDot() {
            return this.myClassName.lastIndexOf(46);
        }
    }
}

