/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.model.Interpolatable;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.adtui.model.legend.EventLegend;
import com.android.tools.adtui.model.legend.Legend;
import com.android.tools.adtui.model.legend.LegendComponentModel;
import com.android.tools.adtui.model.legend.SeriesLegend;
import com.android.tools.profilers.memory.AllocationSamplingRateDurationData;
import com.android.tools.profilers.memory.BaseStreamingMemoryProfilerStage;
import com.android.tools.profilers.memory.DetailedMemoryUsage;
import com.android.tools.profilers.memory.GcDurationData;
import com.android.tools.profilers.memory.MemoryStageLegends;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB'\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001f\u0010\u0010\u001a\u0010\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00120\u00120\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000fR\u0011\u0010\u0018\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u000fR\u0011\u0010\u001a\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u000fR\u0011\u0010\u001c\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u000fR\u0011\u0010\u001e\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u000fR\u001f\u0010 \u001a\u0010\u0012\f\u0012\n \u0013*\u0004\u0018\u00010!0!0\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0015R\u0011\u0010#\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u000fR\u0011\u0010%\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u000f\u00a8\u0006'"}, d2={"Lcom/android/tools/profilers/memory/MemoryStageLegends;", "Lcom/android/tools/adtui/model/legend/LegendComponentModel;", "stage", "Lcom/android/tools/profilers/memory/BaseStreamingMemoryProfilerStage;", "range", "Lcom/android/tools/adtui/model/Range;", "isTooltip", "", "(Lcom/android/tools/profilers/memory/BaseStreamingMemoryProfilerStage;Lcom/android/tools/adtui/model/Range;Z)V", "usage", "Lcom/android/tools/profilers/memory/DetailedMemoryUsage;", "(Lcom/android/tools/profilers/memory/BaseStreamingMemoryProfilerStage;Lcom/android/tools/adtui/model/Range;ZLcom/android/tools/profilers/memory/DetailedMemoryUsage;)V", "codeLegend", "Lcom/android/tools/adtui/model/legend/SeriesLegend;", "getCodeLegend", "()Lcom/android/tools/adtui/model/legend/SeriesLegend;", "gcDurationLegend", "Lcom/android/tools/adtui/model/legend/EventLegend;", "Lcom/android/tools/profilers/memory/GcDurationData;", "kotlin.jvm.PlatformType", "getGcDurationLegend", "()Lcom/android/tools/adtui/model/legend/EventLegend;", "graphicsLegend", "getGraphicsLegend", "javaLegend", "getJavaLegend", "nativeLegend", "getNativeLegend", "objectsLegend", "getObjectsLegend", "otherLegend", "getOtherLegend", "samplingRateDurationLegend", "Lcom/android/tools/profilers/memory/AllocationSamplingRateDurationData;", "getSamplingRateDurationLegend", "stackLegend", "getStackLegend", "totalLegend", "getTotalLegend", "intellij.android.profilers"})
@SourceDebugExtension(value={"SMAP\nMemoryStageLegends.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MemoryStageLegends.kt\ncom/android/tools/profilers/memory/MemoryStageLegends\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,69:1\n1851#2,2:70\n*S KotlinDebug\n*F\n+ 1 MemoryStageLegends.kt\ncom/android/tools/profilers/memory/MemoryStageLegends\n*L\n67#1:70,2\n*E\n"})
public final class MemoryStageLegends
extends LegendComponentModel {
    @NotNull
    private final SeriesLegend javaLegend;
    @NotNull
    private final SeriesLegend nativeLegend;
    @NotNull
    private final SeriesLegend graphicsLegend;
    @NotNull
    private final SeriesLegend stackLegend;
    @NotNull
    private final SeriesLegend codeLegend;
    @NotNull
    private final SeriesLegend otherLegend;
    @NotNull
    private final SeriesLegend totalLegend;
    @NotNull
    private final SeriesLegend objectsLegend;
    @NotNull
    private final EventLegend<GcDurationData> gcDurationLegend;
    @NotNull
    private final EventLegend<AllocationSamplingRateDurationData> samplingRateDurationLegend;

    private MemoryStageLegends(BaseStreamingMemoryProfilerStage stage, Range range, boolean isTooltip, DetailedMemoryUsage usage) {
        super(range);
        List list;
        this.javaLegend = new SeriesLegend(usage.getJavaSeries(), BaseStreamingMemoryProfilerStage.Companion.getMEMORY_AXIS_FORMATTER(), range);
        this.nativeLegend = new SeriesLegend(usage.getNativeSeries(), BaseStreamingMemoryProfilerStage.Companion.getMEMORY_AXIS_FORMATTER(), range);
        this.graphicsLegend = new SeriesLegend(usage.getGraphicsSeries(), BaseStreamingMemoryProfilerStage.Companion.getMEMORY_AXIS_FORMATTER(), range);
        this.stackLegend = new SeriesLegend(usage.getStackSeries(), BaseStreamingMemoryProfilerStage.Companion.getMEMORY_AXIS_FORMATTER(), range);
        this.codeLegend = new SeriesLegend(usage.getCodeSeries(), BaseStreamingMemoryProfilerStage.Companion.getMEMORY_AXIS_FORMATTER(), range);
        this.otherLegend = new SeriesLegend(usage.getOtherSeries(), BaseStreamingMemoryProfilerStage.Companion.getMEMORY_AXIS_FORMATTER(), range);
        this.totalLegend = new SeriesLegend(usage.getTotalMemorySeries(), BaseStreamingMemoryProfilerStage.Companion.getMEMORY_AXIS_FORMATTER(), range);
        this.objectsLegend = new SeriesLegend(usage.getObjectsSeries(), BaseStreamingMemoryProfilerStage.Companion.getOBJECT_COUNT_AXIS_FORMATTER(), range, usage.getObjectsSeries().getName(), Interpolatable.RoundedSegmentInterpolator, new Predicate(stage, usage){
            final /* synthetic */ BaseStreamingMemoryProfilerStage $stage;
            final /* synthetic */ DetailedMemoryUsage $usage;
            {
                this.$stage = $stage;
                this.$usage = $usage;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean test(Range r) {
                if (!this.$stage.isLiveAllocationTrackingReady()) return true;
                RangedSeries rangedSeries = this.$usage.getAllocationSamplingRateDurations().getSeries();
                Intrinsics.checkNotNullExpressionValue((Object)r, (String)"r");
                List data = rangedSeries.getSeriesForRange(r);
                boolean bl = false;
                if (((Collection)data).isEmpty()) return false;
                boolean bl2 = true;
                if (!bl2) return false;
                if (BaseStreamingMemoryProfilerStage.LiveAllocationSamplingMode.Companion.getModeFromFrequency(((AllocationSamplingRateDurationData)((SeriesData)CollectionsKt.last((List)data)).value).getCurrentRate().getSamplingNumInterval()) != BaseStreamingMemoryProfilerStage.LiveAllocationSamplingMode.FULL) return false;
                return true;
            }
        });
        this.gcDurationLegend = new EventLegend("GC Duration", (Function)gcDurationLegend.1.INSTANCE);
        this.samplingRateDurationLegend = new EventLegend("Tracking", (Function)samplingRateDurationLegend.1.INSTANCE);
        if (isTooltip) {
            var6_5 = new Legend[]{this.otherLegend, this.codeLegend, this.stackLegend, this.graphicsLegend, this.nativeLegend, this.javaLegend, this.objectsLegend, this.samplingRateDurationLegend, this.gcDurationLegend, this.totalLegend};
            list = CollectionsKt.listOf((Object[])var6_5);
        } else {
            var6_5 = new SeriesLegend[]{this.totalLegend, this.javaLegend, this.nativeLegend, this.graphicsLegend, this.stackLegend, this.codeLegend, this.otherLegend, this.objectsLegend};
            list = CollectionsKt.listOf((Object[])var6_5);
        }
        List legends = list;
        Iterable $this$forEach$iv = legends;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Legend p0 = (Legend)element$iv;
            boolean bl = false;
            this.add(p0);
        }
    }

    public MemoryStageLegends(@NotNull BaseStreamingMemoryProfilerStage stage, @NotNull Range range, boolean isTooltip) {
        Intrinsics.checkNotNullParameter((Object)((Object)stage), (String)"stage");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        this(stage, range, isTooltip, stage.getDetailedMemoryUsage());
    }

    @NotNull
    public final SeriesLegend getJavaLegend() {
        return this.javaLegend;
    }

    @NotNull
    public final SeriesLegend getNativeLegend() {
        return this.nativeLegend;
    }

    @NotNull
    public final SeriesLegend getGraphicsLegend() {
        return this.graphicsLegend;
    }

    @NotNull
    public final SeriesLegend getStackLegend() {
        return this.stackLegend;
    }

    @NotNull
    public final SeriesLegend getCodeLegend() {
        return this.codeLegend;
    }

    @NotNull
    public final SeriesLegend getOtherLegend() {
        return this.otherLegend;
    }

    @NotNull
    public final SeriesLegend getTotalLegend() {
        return this.totalLegend;
    }

    @NotNull
    public final SeriesLegend getObjectsLegend() {
        return this.objectsLegend;
    }

    @NotNull
    public final EventLegend<GcDurationData> getGcDurationLegend() {
        return this.gcDurationLegend;
    }

    @NotNull
    public final EventLegend<AllocationSamplingRateDurationData> getSamplingRateDurationLegend() {
        return this.samplingRateDurationLegend;
    }
}

