/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.AxisComponent;
import com.android.tools.adtui.LegendComponent;
import com.android.tools.adtui.LegendConfig;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.chart.linechart.LineChart;
import com.android.tools.adtui.chart.linechart.LineConfig;
import com.android.tools.adtui.model.LineChartModel;
import com.android.tools.adtui.model.legend.LegendComponentModel;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.ProfilerMonitor;
import com.android.tools.profilers.ProfilerMonitorView;
import com.android.tools.profilers.StudioProfilersView;
import com.android.tools.profilers.memory.MemoryMonitor;
import com.android.tools.profilers.memory.MemoryUsage;
import com.intellij.ui.components.JBPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class MemoryMonitorView
extends ProfilerMonitorView<MemoryMonitor> {
    public MemoryMonitorView(@NotNull StudioProfilersView profilersView, @NotNull MemoryMonitor monitor) {
        super(monitor);
    }

    @Override
    protected void populateUi(JPanel container) {
        container.setLayout((LayoutManager)new TabularLayout("*", "*"));
        container.setFocusable(true);
        JLabel label = new JLabel(((MemoryMonitor)((Object)this.getMonitor())).getName());
        label.setBorder(ProfilerLayout.MONITOR_LABEL_PADDING);
        label.setVerticalAlignment(1);
        label.setForeground(ProfilerColors.MONITORS_HEADER_TEXT);
        JBPanel axisPanel = new JBPanel((LayoutManager)new BorderLayout());
        axisPanel.setOpaque(false);
        AxisComponent leftAxis = new AxisComponent(((MemoryMonitor)((Object)this.getMonitor())).getMemoryAxis(), AxisComponent.AxisOrientation.RIGHT, true);
        leftAxis.setShowAxisLine(false);
        leftAxis.setShowMax(true);
        leftAxis.setOnlyShowUnitAtMax(false);
        leftAxis.setHideTickAtMin(true);
        leftAxis.setMarkerLengths(ProfilerLayout.MARKER_LENGTH, ProfilerLayout.MARKER_LENGTH);
        leftAxis.setMargins(0, ProfilerLayout.Y_AXIS_TOP_MARGIN);
        axisPanel.add((Component)leftAxis, "West");
        MemoryUsage usage = ((MemoryMonitor)((Object)this.getMonitor())).getMemoryUsage();
        LineChart lineChart = new LineChart((LineChartModel)usage);
        JBPanel lineChartPanel = new JBPanel((LayoutManager)new BorderLayout());
        lineChartPanel.setOpaque(false);
        lineChartPanel.setBorder(BorderFactory.createEmptyBorder(ProfilerLayout.Y_AXIS_TOP_MARGIN, 0, 0, 0));
        LineConfig memoryConfig = new LineConfig(ProfilerColors.MEMORY_TOTAL).setFilled(true);
        lineChart.configure(usage.getTotalMemorySeries(), memoryConfig);
        lineChartPanel.add((Component)lineChart, "Center");
        lineChart.setMaxLineColor(ProfilerColors.MONITOR_MAX_LINE);
        lineChart.setMaxLineMargin(40);
        lineChart.setRenderOffset(0, (int)LineConfig.DEFAULT_DASH_STROKE.getLineWidth() / 2);
        lineChart.setFillEndGap(true);
        ((MemoryMonitor)((Object)this.getMonitor())).addDependency(this).onChange((Enum)ProfilerMonitor.Aspect.FOCUS, () -> lineChart.setShowMaxLine(((MemoryMonitor)((Object)((Object)this.getMonitor()))).isFocused()));
        MemoryMonitor.MemoryLegend legends = ((MemoryMonitor)((Object)this.getMonitor())).getMemoryLegend();
        LegendComponent legend = new LegendComponent.Builder((LegendComponentModel)legends).setRightPadding(ProfilerLayout.MONITOR_LEGEND_RIGHT_PADDING).build();
        legend.setForeground(ProfilerColors.MONITORS_HEADER_TEXT);
        legend.configure(legends.getTotalLegend(), new LegendConfig(memoryConfig));
        JBPanel legendPanel2 = new JBPanel((LayoutManager)new BorderLayout());
        legendPanel2.setOpaque(false);
        legendPanel2.add((Component)label, "West");
        legendPanel2.add((Component)legend, "East");
        container.add((Component)legendPanel2, new TabularLayout.Constraint(0, 0));
        container.add((Component)leftAxis, new TabularLayout.Constraint(0, 0));
        container.add((Component)lineChartPanel, new TabularLayout.Constraint(0, 0));
    }
}

