/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.profilers.ProfilerCombobox;
import com.android.tools.profilers.ProfilerComboboxCellRenderer;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.memory.CaptureSelectionAspect;
import com.android.tools.profilers.memory.MemoryCaptureSelection;
import com.android.tools.profilers.memory.adapters.CaptureObject;
import com.android.tools.profilers.memory.adapters.classifiers.AllHeapSet;
import com.android.tools.profilers.memory.adapters.classifiers.HeapSet;
import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.Objects;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MemoryHeapView
extends AspectObserver {
    @NotNull
    private final MemoryCaptureSelection mySelection;
    @NotNull
    private JPanel myHeapToolbar = new JPanel(ProfilerLayout.createToolbarLayout());
    @NotNull
    private JComboBox<HeapSet> myHeapComboBox = new ProfilerCombobox();
    @Nullable
    private CaptureObject myCaptureObject = null;

    MemoryHeapView(@NotNull MemoryCaptureSelection selection2) {
        this.mySelection = selection2;
        this.mySelection.getAspect().addDependency((AspectObserver)this).onChange((Enum)CaptureSelectionAspect.CURRENT_LOADING_CAPTURE, this::setNewCapture).onChange((Enum)CaptureSelectionAspect.CURRENT_LOADED_CAPTURE, this::updateCaptureState).onChange((Enum)CaptureSelectionAspect.CURRENT_HEAP, this::refreshHeap);
        this.myHeapComboBox.addActionListener(e -> {
            Object item = this.myHeapComboBox.getSelectedItem();
            if (item instanceof HeapSet) {
                this.mySelection.selectHeapSet((HeapSet)item);
            }
        });
        this.myHeapToolbar.add(this.myHeapComboBox);
        this.setNewCapture();
        this.refreshHeap();
    }

    @NotNull
    JComponent getComponent() {
        return this.myHeapToolbar;
    }

    @VisibleForTesting
    @NotNull
    JComboBox<HeapSet> getHeapComboBox() {
        return this.myHeapComboBox;
    }

    private void setNewCapture() {
        this.myCaptureObject = this.mySelection.getSelectedCapture();
        this.myHeapComboBox.setModel(new DefaultComboBoxModel());
        this.myHeapComboBox.setRenderer((ListCellRenderer<HeapSet>)((Object)new HeapListCellRenderer()));
        this.mySelection.selectHeapSet(null);
    }

    private void updateCaptureState() {
        CaptureObject captureObject = this.mySelection.getSelectedCapture();
        if (this.myCaptureObject != captureObject) {
            return;
        }
        this.myCaptureObject = captureObject;
        if (this.myCaptureObject == null) {
            return;
        }
        Collection<HeapSet> heaps = this.myCaptureObject.getHeapSets();
        HeapSet[] heapsArray = heaps.toArray(new HeapSet[heaps.size()]);
        DefaultComboBoxModel<HeapSet> comboBoxModel = new DefaultComboBoxModel<HeapSet>(heapsArray);
        this.myHeapComboBox.setModel(comboBoxModel);
    }

    void refreshHeap() {
        Object selectedObject;
        HeapSet heapSet = this.mySelection.getSelectedHeapSet();
        if (!Objects.equals(heapSet, selectedObject = this.myHeapComboBox.getSelectedItem())) {
            this.myHeapComboBox.setSelectedItem(heapSet);
        }
    }

    private static final class HeapListCellRenderer
    extends ProfilerComboboxCellRenderer<HeapSet> {
        private HeapListCellRenderer() {
        }

        protected void customizeCellRenderer(@NotNull JList<? extends HeapSet> list, HeapSet value, int index, boolean selected, boolean hasFocus) {
            if (value != null) {
                this.append("View " + (String)(value instanceof AllHeapSet ? "all heaps" : value.getName() + " heap"));
            }
        }
    }
}

