/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.formatter.TimeFormatter;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Memory;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.memory.MainMemoryProfilerStage;
import com.android.tools.profilers.memory.MemoryProfiler;
import com.android.tools.profilers.sessions.SessionArtifact;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class LegacyAllocationsSessionArtifact
implements SessionArtifact<Memory.AllocationsInfo> {
    @NotNull
    private final StudioProfilers myProfilers;
    @NotNull
    private final Common.Session mySession;
    @NotNull
    private final Common.SessionMetaData mySessionMetaData;
    @NotNull
    private final Memory.AllocationsInfo myInfo;

    public LegacyAllocationsSessionArtifact(@NotNull StudioProfilers profilers, @NotNull Common.Session session, @NotNull Common.SessionMetaData sessionMetaData, @NotNull Memory.AllocationsInfo info) {
        this.myProfilers = profilers;
        this.mySession = session;
        this.mySessionMetaData = sessionMetaData;
        this.myInfo = info;
    }

    @Override
    @NotNull
    public Memory.AllocationsInfo getArtifactProto() {
        return this.myInfo;
    }

    @Override
    @NotNull
    public StudioProfilers getProfilers() {
        return this.myProfilers;
    }

    @Override
    @NotNull
    public Common.Session getSession() {
        return this.mySession;
    }

    @Override
    @NotNull
    public Common.SessionMetaData getSessionMetaData() {
        return this.mySessionMetaData;
    }

    @Override
    @NotNull
    public String getName() {
        return "Allocation Records";
    }

    @NotNull
    public String getSubtitle() {
        return this.isOngoing() ? "Recording..." : TimeFormatter.getFullClockString((long)TimeUnit.NANOSECONDS.toMicros(this.getTimestampNs()));
    }

    @Override
    public long getTimestampNs() {
        return this.myInfo.getStartTime() - this.mySession.getStartTimestamp();
    }

    @Override
    public boolean isOngoing() {
        return this.myInfo.getEndTime() == Long.MAX_VALUE;
    }

    @Override
    public boolean getCanExport() {
        return !this.isOngoing();
    }

    @Override
    public void doSelect() {
        boolean needsToOpenMemoryProfiler;
        boolean needsToChangeSession;
        boolean bl = needsToChangeSession = this.mySession != this.myProfilers.getSession();
        if (needsToChangeSession) {
            this.myProfilers.getSessionsManager().setSession(this.mySession);
        }
        boolean bl2 = needsToOpenMemoryProfiler = !(this.myProfilers.getStage() instanceof MainMemoryProfilerStage);
        if (needsToOpenMemoryProfiler) {
            this.myProfilers.setStage(new MainMemoryProfilerStage(this.myProfilers));
        }
        long startTimestamp = TimeUnit.NANOSECONDS.toMicros(this.myInfo.getStartTime());
        long endTimestamp = TimeUnit.NANOSECONDS.toMicros(this.myInfo.getEndTime());
        if (this.isOngoing()) {
            SessionArtifact.navigateTimelineToOngoingCapture(this.myProfilers.getTimeline(), startTimestamp);
        } else {
            assert (this.myProfilers.getStage() instanceof MainMemoryProfilerStage);
            MainMemoryProfilerStage stage = (MainMemoryProfilerStage)this.myProfilers.getStage();
            Range captureRange = new Range((double)startTimestamp, (double)endTimestamp);
            this.myProfilers.getTimeline().adjustRangeCloseToMiddleView(captureRange);
            stage.getRangeSelectionModel().set(captureRange.getMin(), captureRange.getMax());
        }
        this.myProfilers.getIdeServices().getFeatureTracker().trackSessionArtifactSelected(this, this.myProfilers.getSessionsManager().isSessionAlive());
    }

    @Override
    public void export(@NotNull OutputStream outputStream) {
        assert (this.getCanExport());
        MemoryProfiler.saveLegacyAllocationToFile(this.myProfilers.getClient(), this.mySession, this.myInfo, outputStream, this.myProfilers.getIdeServices().getFeatureTracker());
    }
}

