/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.ddmlib.AllocationInfo;
import com.android.ddmlib.AllocationsParser;
import com.android.tools.profiler.proto.Memory;
import com.intellij.util.containers.ContainerUtil;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class LegacyAllocationConverter {
    @NotNull
    private List<Allocation> myAllocations = new ArrayList<Allocation>();
    @NotNull
    private Map<String, ClassName> myAllocatedClasses = new HashMap<String, ClassName>();
    @NotNull
    private Map<List<StackTraceElement>, CallStack> myAllocationStacks = new HashMap<List<StackTraceElement>, CallStack>();

    public int addClassName(@NotNull String className) {
        int id;
        if (!this.myAllocatedClasses.containsKey(className)) {
            id = this.myAllocatedClasses.size();
            this.myAllocatedClasses.put(className, new ClassName(className, id));
        } else {
            id = this.myAllocatedClasses.get((Object)className).myClassId;
        }
        return id;
    }

    @NotNull
    public CallStack addCallStack(@NotNull List<StackTraceElement> stackTraceElements) {
        CallStack result;
        if (!this.myAllocationStacks.containsKey(stackTraceElements)) {
            result = new CallStack(stackTraceElements);
            this.myAllocationStacks.put(stackTraceElements, result);
        } else {
            result = this.myAllocationStacks.get(stackTraceElements);
        }
        return result;
    }

    public void resetAllocations() {
        this.myAllocations.clear();
    }

    public void addAllocation(@NotNull Allocation allocationInfo) {
        this.myAllocations.add(allocationInfo);
    }

    public List<Memory.AllocationEvent.Allocation> getAllocationEvents() {
        return ContainerUtil.map(this.myAllocations, allocation -> allocation.bindAllocationEventInfos());
    }

    public List<Memory.AllocationStack> getAllocationStacks() {
        return ContainerUtil.map(this.myAllocationStacks.values(), CallStack::getAllocationStack);
    }

    public List<Memory.AllocatedClass> getClassNames() {
        return ContainerUtil.map(this.myAllocatedClasses.values(), ClassName::getAllocatedClass);
    }

    public void parseDump(@NotNull byte[] dumpData) {
        AllocationInfo[] rawInfos;
        this.resetAllocations();
        for (AllocationInfo info : rawInfos = AllocationsParser.parse((ByteBuffer)ByteBuffer.wrap(dumpData))) {
            List<StackTraceElement> stackTraceElements = Arrays.asList(info.getStackTrace());
            CallStack callStack = this.addCallStack(stackTraceElements);
            int classId = this.addClassName(info.getAllocatedClass());
            this.addAllocation(new Allocation(classId, info.getSize(), info.getThreadId(), callStack.hashCode()));
        }
    }

    public static class ClassName {
        private final String myClassName;
        private final int myClassId;

        public ClassName(@NotNull String className, int classId) {
            this.myClassName = className;
            this.myClassId = classId;
        }

        @NotNull
        public Memory.AllocatedClass getAllocatedClass() {
            return Memory.AllocatedClass.newBuilder().setClassName(this.myClassName).setClassId(this.myClassId).build();
        }
    }

    public static class CallStack {
        @NotNull
        private final List<StackTraceElement> myCallStackFrames;

        public CallStack(@NotNull List<StackTraceElement> frames) {
            this.myCallStackFrames = frames;
        }

        public int hashCode() {
            return this.myCallStackFrames.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CallStack)) {
                return false;
            }
            return this.myCallStackFrames.equals(((CallStack)obj).myCallStackFrames);
        }

        @NotNull
        public Memory.AllocationStack getAllocationStack() {
            Memory.AllocationStack.Builder builder = Memory.AllocationStack.newBuilder().setStackId(this.hashCode());
            Memory.AllocationStack.StackFrameWrapper.Builder frameBuilder = Memory.AllocationStack.StackFrameWrapper.newBuilder();
            for (StackTraceElement frame : this.myCallStackFrames) {
                frameBuilder.addFrames(Memory.AllocationStack.StackFrame.newBuilder().setClassName(frame.getClassName()).setMethodName(frame.getMethodName()).setFileName(frame.getFileName()).setLineNumber(frame.getLineNumber()).build());
            }
            builder.setFullStack(frameBuilder);
            return builder.build();
        }
    }

    public static class Allocation {
        private final int myClassId;
        private final int mySize;
        private final int myThreadId;
        private final int myCallStackId;

        public Allocation(int classId, int size, int threadId, int callStackId) {
            this.myClassId = classId;
            this.mySize = size;
            this.myThreadId = threadId;
            this.myCallStackId = callStackId;
        }

        @NotNull
        public Memory.AllocationEvent.Allocation bindAllocationEventInfos() {
            return Memory.AllocationEvent.Allocation.newBuilder().setClassTag(this.myClassId).setSize((long)this.mySize).setThreadId(this.myThreadId).setStackId(this.myCallStackId).build();
        }
    }
}

