/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.model.Range;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Memory;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.memory.BaseMemoryProfilerStage;
import com.android.tools.profilers.memory.MemoryProfiler;
import com.android.tools.profilers.memory.MemorySessionArtifact;
import com.android.tools.profilers.memory.adapters.CaptureObject;
import com.android.tools.profilers.sessions.SessionArtifact;
import com.intellij.util.containers.ContainerUtil;
import java.io.OutputStream;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public final class HprofSessionArtifact
extends MemorySessionArtifact<Memory.HeapDumpInfo> {
    public HprofSessionArtifact(@NotNull StudioProfilers profilers, @NotNull Common.Session session, @NotNull Common.SessionMetaData sessionMetaData, @NotNull Memory.HeapDumpInfo info) {
        super(profilers, session, sessionMetaData, info, "Heap Dump");
    }

    @Override
    protected long getStartTime() {
        return ((Memory.HeapDumpInfo)this.getArtifactProto()).getStartTime();
    }

    @Override
    protected long getEndTime() {
        return ((Memory.HeapDumpInfo)this.getArtifactProto()).getEndTime();
    }

    @Override
    public void export(@NotNull OutputStream outputStream) {
        assert (this.getCanExport());
        MemoryProfiler.saveHeapDumpToFile(this.getProfilers().getClient(), this.getSession(), (Memory.HeapDumpInfo)this.getArtifactProto(), outputStream, this.getProfilers().getIdeServices().getFeatureTracker());
    }

    public static List<SessionArtifact<?>> getSessionArtifacts(@NotNull StudioProfilers profilers, @NotNull Common.Session session, @NotNull Common.SessionMetaData sessionMetaData) {
        Range queryRangeUs = new Range((double)TimeUnit.NANOSECONDS.toMicros(session.getStartTimestamp()), session.getEndTimestamp() == Long.MAX_VALUE ? 9.223372036854776E18 : (double)TimeUnit.NANOSECONDS.toMicros(session.getEndTimestamp()));
        List<Memory.HeapDumpInfo> infos = MemoryProfiler.getHeapDumpsForSession(profilers.getClient(), session, queryRangeUs);
        return ContainerUtil.map(infos, info -> new HprofSessionArtifact(profilers, session, sessionMetaData, (Memory.HeapDumpInfo)info));
    }

    @Override
    public void onSelect() {
        CaptureObject loaded;
        if (this.getProfilers().getStage() instanceof BaseMemoryProfilerStage && (loaded = ((BaseMemoryProfilerStage)this.getProfilers().getStage()).getCaptureSelection().getSelectedCapture()) != null && loaded.getStartTimeNs() == this.getStartTime()) {
            return;
        }
        super.onSelect();
    }
}

