/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.LegendComponent;
import com.android.tools.adtui.LegendConfig;
import com.android.tools.adtui.chart.linechart.LineChart;
import com.android.tools.adtui.model.legend.Legend;
import com.android.tools.adtui.model.legend.LegendComponentModel;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.memory.BaseStreamingMemoryProfilerStage;
import com.android.tools.profilers.memory.DetailedMemoryUsage;
import com.android.tools.profilers.memory.MemoryStageLegends;
import com.intellij.ui.components.JBPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Arrays;
import javax.swing.JLabel;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u0000 \u000e2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u000eB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/profilers/memory/FlexibleLegendPanel;", "Lcom/intellij/ui/components/JBPanel;", "stage", "Lcom/android/tools/profilers/memory/BaseStreamingMemoryProfilerStage;", "lineChart", "Lcom/android/tools/adtui/chart/linechart/LineChart;", "(Lcom/android/tools/profilers/memory/BaseStreamingMemoryProfilerStage;Lcom/android/tools/adtui/chart/linechart/LineChart;)V", "compactLegend", "Lcom/android/tools/adtui/LegendComponent;", "fullLegend", "adapt", "", "width", "", "Companion", "intellij.android.profilers.ui"})
final class FlexibleLegendPanel
extends JBPanel<FlexibleLegendPanel> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final LegendComponent fullLegend;
    @NotNull
    private final LegendComponent compactLegend;

    public FlexibleLegendPanel(@NotNull BaseStreamingMemoryProfilerStage stage, @NotNull LineChart lineChart) {
        JLabel jLabel;
        Intrinsics.checkNotNullParameter((Object)((Object)stage), (String)"stage");
        Intrinsics.checkNotNullParameter((Object)lineChart, (String)"lineChart");
        super((LayoutManager)new BorderLayout());
        this.fullLegend = FlexibleLegendPanel.Companion.makeLegendComponent(stage, lineChart, true);
        this.compactLegend = FlexibleLegendPanel.Companion.makeLegendComponent(stage, lineChart, false);
        JLabel $this$_init__u24lambda_u240 = jLabel = new JLabel("MEMORY");
        boolean bl = false;
        $this$_init__u24lambda_u240.setBorder(ProfilerLayout.MONITOR_LABEL_PADDING);
        $this$_init__u24lambda_u240.setVerticalAlignment(1);
        JLabel label = jLabel;
        this.setOpaque(false);
        this.add(label, "West");
        this.add((Component)this.fullLegend, "East");
    }

    public final void adapt(int width) {
        this.remove((Component)this.fullLegend);
        this.remove((Component)this.compactLegend);
        this.add((Component)(this.fullLegend.getPreferredSize().width + 60 < width ? this.fullLegend : this.compactLegend), "East");
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/profilers/memory/FlexibleLegendPanel$Companion;", "", "()V", "makeLegendComponent", "Lcom/android/tools/adtui/LegendComponent;", "stage", "Lcom/android/tools/profilers/memory/BaseStreamingMemoryProfilerStage;", "lineChart", "Lcom/android/tools/adtui/chart/linechart/LineChart;", "full", "", "intellij.android.profilers.ui"})
    @SourceDebugExtension(value={"SMAP\nBaseMemoryTimelineComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseMemoryTimelineComponent.kt\ncom/android/tools/profilers/memory/FlexibleLegendPanel$Companion\n+ 2 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n*L\n1#1,269:1\n26#2:270\n*S KotlinDebug\n*F\n+ 1 BaseMemoryTimelineComponent.kt\ncom/android/tools/profilers/memory/FlexibleLegendPanel$Companion\n*L\n239#1:270\n*E\n"})
    private static final class Companion {
        private Companion() {
        }

        private final LegendComponent makeLegendComponent(BaseStreamingMemoryProfilerStage stage, LineChart lineChart, boolean full) {
            LegendComponent legendComponent;
            String[] stringArray;
            MemoryStageLegends legends = stage.getLegends();
            DetailedMemoryUsage memoryUsage = stage.getDetailedMemoryUsage();
            LegendComponent.Builder builder = new LegendComponent.Builder((LegendComponentModel)legends).setRightPadding(ProfilerLayout.PROFILER_LEGEND_RIGHT_PADDING).setShowValues(full);
            if (full) {
                boolean $i$f$emptyArray = false;
                stringArray = new String[]{};
            } else {
                String[] $i$f$emptyArray = new String[]{"Total"};
                stringArray = $i$f$emptyArray;
            }
            String[] stringArray2 = stringArray;
            LegendComponent legendComponent2 = builder.setExcludedLegends(Arrays.copyOf(stringArray2, stringArray2.length)).build();
            Intrinsics.checkNotNullExpressionValue((Object)legendComponent2, (String)"Builder(legends)\n       \u2026otal\")))\n        .build()");
            LegendComponent $this$makeLegendComponent_u24lambda_u240 = legendComponent = legendComponent2;
            boolean bl = false;
            $this$makeLegendComponent_u24lambda_u240.configure((Legend)legends.getJavaLegend(), new LegendConfig(lineChart.getLineConfig(memoryUsage.getJavaSeries())));
            $this$makeLegendComponent_u24lambda_u240.configure((Legend)legends.getNativeLegend(), new LegendConfig(lineChart.getLineConfig(memoryUsage.getNativeSeries())));
            $this$makeLegendComponent_u24lambda_u240.configure((Legend)legends.getGraphicsLegend(), new LegendConfig(lineChart.getLineConfig(memoryUsage.getGraphicsSeries())));
            $this$makeLegendComponent_u24lambda_u240.configure((Legend)legends.getStackLegend(), new LegendConfig(lineChart.getLineConfig(memoryUsage.getStackSeries())));
            $this$makeLegendComponent_u24lambda_u240.configure((Legend)legends.getCodeLegend(), new LegendConfig(lineChart.getLineConfig(memoryUsage.getCodeSeries())));
            $this$makeLegendComponent_u24lambda_u240.configure((Legend)legends.getOtherLegend(), new LegendConfig(lineChart.getLineConfig(memoryUsage.getOtherSeries())));
            $this$makeLegendComponent_u24lambda_u240.configure((Legend)legends.getTotalLegend(), new LegendConfig(lineChart.getLineConfig(memoryUsage.getTotalMemorySeries())));
            $this$makeLegendComponent_u24lambda_u240.configure((Legend)legends.getObjectsLegend(), new LegendConfig(lineChart.getLineConfig(memoryUsage.getObjectsSeries())));
            return legendComponent;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

