/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.FilterComponent;
import com.android.tools.adtui.StatLabel;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.flat.FlatSeparator;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.profilers.ProfilerFonts;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.StudioProfilersView;
import com.android.tools.profilers.memory.CapturePanelTabContainer;
import com.android.tools.profilers.memory.CapturePanelUi;
import com.android.tools.profilers.memory.CaptureSelectionAspect;
import com.android.tools.profilers.memory.ClassGrouping;
import com.android.tools.profilers.memory.MemoryCaptureSelection;
import com.android.tools.profilers.memory.MemoryClassGrouping;
import com.android.tools.profilers.memory.MemoryClassifierView;
import com.android.tools.profilers.memory.MemoryHeapView;
import com.android.tools.profilers.memory.MemoryInstanceFilterMenu;
import com.android.tools.profilers.memory.ToolbarComponents;
import com.android.tools.profilers.memory.adapters.CaptureObject;
import com.android.tools.profilers.memory.adapters.HeapDumpCaptureObject;
import com.android.tools.profilers.memory.adapters.InstanceObject;
import com.android.tools.profilers.memory.adapters.NativeAllocationSampleCaptureObject;
import com.android.tools.profilers.memory.adapters.classifiers.HeapSet;
import com.android.tools.profilers.memory.adapters.instancefilters.ActivityFragmentLeakInstanceFilter;
import com.android.tools.profilers.memory.chart.MemoryVisualizationView;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.ToLongFunction;
import java.util.stream.Stream;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J.\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020\u00192\f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'H\u0002J\u0010\u0010)\u001a\u00020\u00012\u0006\u0010*\u001a\u00020\u0001H\u0002J\u0018\u0010+\u001a\u00020\u00012\u0006\u0010,\u001a\u00020\u00012\u0006\u0010-\u001a\u00020.H\u0002J\b\u0010/\u001a\u00020\u0001H\u0002J\b\u00100\u001a\u00020#H\u0002J\u0010\u00101\u001a\u00020\u00012\u0006\u0010,\u001a\u00020\u0001H\u0002J\b\u00102\u001a\u00020!H\u0002J\u000e\u00103\u001a\b\u0012\u0004\u0012\u00020(0\u0018H\u0002J\u000e\u00104\u001a\b\u0012\u0004\u0012\u00020(0\u0018H\u0002R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001d0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/android/tools/profilers/memory/CapturePanelUi;", "Ljavax/swing/JPanel;", "selection", "Lcom/android/tools/profilers/memory/MemoryCaptureSelection;", "heapView", "Lcom/android/tools/profilers/memory/MemoryHeapView;", "classGrouping", "Lcom/android/tools/profilers/memory/MemoryClassGrouping;", "classifierView", "Lcom/android/tools/profilers/memory/MemoryClassifierView;", "filterComponent", "Lcom/android/tools/adtui/FilterComponent;", "captureInfoMessage", "Ljavax/swing/JLabel;", "profilersView", "Lcom/android/tools/profilers/StudioProfilersView;", "(Lcom/android/tools/profilers/memory/MemoryCaptureSelection;Lcom/android/tools/profilers/memory/MemoryHeapView;Lcom/android/tools/profilers/memory/MemoryClassGrouping;Lcom/android/tools/profilers/memory/MemoryClassifierView;Lcom/android/tools/adtui/FilterComponent;Ljavax/swing/JLabel;Lcom/android/tools/profilers/StudioProfilersView;)V", "activeTabIndex", "", "instanceFilterMenu", "Lcom/android/tools/profilers/memory/MemoryInstanceFilterMenu;", "observer", "Lcom/android/tools/adtui/model/AspectObserver;", "tabListeners", "", "Lcom/android/tools/profilers/memory/CapturePanelTabContainer;", "toolbarTabPanels", "", "", "Lcom/android/tools/profilers/memory/ToolbarComponents;", "visualizationView", "Lcom/android/tools/profilers/memory/chart/MemoryVisualizationView;", "addTab", "", "tabPane", "Lcom/intellij/ui/components/JBTabbedPane;", "name", "tabContainer", "toolbarComponents", "", "Ljava/awt/Component;", "buildDetailsPanel", "headingPanel", "buildNonTabPanel", "toolbar", "component", "Ljavax/swing/JComponent;", "buildSummaryPanel", "buildTabPanel", "buildToolbarPanel", "showLeaks", "toolbarCore", "toolbarDefaults", "intellij.android.profilers.ui"})
@SourceDebugExtension(value={"SMAP\nCapturePanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CapturePanel.kt\ncom/android/tools/profilers/memory/CapturePanelUi\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,258:1\n1851#2,2:259\n1851#2,2:261\n*S KotlinDebug\n*F\n+ 1 CapturePanel.kt\ncom/android/tools/profilers/memory/CapturePanelUi\n*L\n132#1:259,2\n159#1:261,2\n*E\n"})
final class CapturePanelUi
extends JPanel {
    @NotNull
    private final MemoryCaptureSelection selection;
    @NotNull
    private final MemoryHeapView heapView;
    @NotNull
    private final MemoryClassGrouping classGrouping;
    @NotNull
    private final MemoryClassifierView classifierView;
    @NotNull
    private final FilterComponent filterComponent;
    @NotNull
    private final JLabel captureInfoMessage;
    @NotNull
    private final StudioProfilersView profilersView;
    @NotNull
    private final AspectObserver observer;
    @NotNull
    private final MemoryInstanceFilterMenu instanceFilterMenu;
    @NotNull
    private final Map<String, ToolbarComponents> toolbarTabPanels;
    @NotNull
    private final List<CapturePanelTabContainer> tabListeners;
    @NotNull
    private final MemoryVisualizationView visualizationView;
    private int activeTabIndex;

    public CapturePanelUi(@NotNull MemoryCaptureSelection selection2, @NotNull MemoryHeapView heapView, @NotNull MemoryClassGrouping classGrouping, @NotNull MemoryClassifierView classifierView, @NotNull FilterComponent filterComponent, @NotNull JLabel captureInfoMessage2, @NotNull StudioProfilersView profilersView) {
        JPanel jPanel;
        Intrinsics.checkNotNullParameter((Object)selection2, (String)"selection");
        Intrinsics.checkNotNullParameter((Object)((Object)heapView), (String)"heapView");
        Intrinsics.checkNotNullParameter((Object)((Object)classGrouping), (String)"classGrouping");
        Intrinsics.checkNotNullParameter((Object)classifierView, (String)"classifierView");
        Intrinsics.checkNotNullParameter((Object)filterComponent, (String)"filterComponent");
        Intrinsics.checkNotNullParameter((Object)captureInfoMessage2, (String)"captureInfoMessage");
        Intrinsics.checkNotNullParameter((Object)((Object)profilersView), (String)"profilersView");
        super(new BorderLayout());
        this.selection = selection2;
        this.heapView = heapView;
        this.classGrouping = classGrouping;
        this.classifierView = classifierView;
        this.filterComponent = filterComponent;
        this.captureInfoMessage = captureInfoMessage2;
        this.profilersView = profilersView;
        this.observer = new AspectObserver();
        this.instanceFilterMenu = new MemoryInstanceFilterMenu(this.selection);
        this.toolbarTabPanels = new LinkedHashMap();
        this.tabListeners = new ArrayList();
        this.visualizationView = new MemoryVisualizationView(this.selection, this.profilersView);
        JPanel $this$_init__u24lambda_u240 = jPanel = new JPanel();
        boolean bl = false;
        $this$_init__u24lambda_u240.setLayout(new BoxLayout($this$_init__u24lambda_u240, 1));
        $this$_init__u24lambda_u240.add(this.buildSummaryPanel());
        JPanel headingPanel2 = jPanel;
        this.add((Component)headingPanel2, "First");
        this.add((Component)this.buildDetailsPanel(headingPanel2), "Center");
    }

    private final JPanel buildDetailsPanel(JPanel headingPanel2) {
        JPanel jPanel;
        JPanel $this$buildDetailsPanel_u24lambda_u242 = jPanel = new JPanel(new BorderLayout());
        boolean bl = false;
        this.selection.getAspect().addDependency(this.observer).onChange((Enum)CaptureSelectionAspect.CURRENT_LOADED_CAPTURE, new Runnable($this$buildDetailsPanel_u24lambda_u242, this, headingPanel2){
            final /* synthetic */ JPanel $this_apply;
            final /* synthetic */ CapturePanelUi this$0;
            final /* synthetic */ JPanel $headingPanel;
            {
                this.$this_apply = $receiver;
                this.this$0 = $receiver2;
                this.$headingPanel = $headingPanel;
            }

            public final void run() {
                CapturePanelUi.access$buildDetailsPanel$lambda$2$refreshPanel(this.$this_apply, this.this$0, this.$headingPanel);
            }
        });
        CapturePanelUi.buildDetailsPanel$lambda$2$refreshPanel($this$buildDetailsPanel_u24lambda_u242, this, headingPanel2);
        return jPanel;
    }

    private final JPanel buildNonTabPanel(JPanel toolbar, JComponent component) {
        JPanel jPanel;
        JPanel $this$buildNonTabPanel_u24lambda_u243 = jPanel = new JPanel(new BorderLayout());
        boolean bl = false;
        $this$buildNonTabPanel_u24lambda_u243.add((Component)this.buildToolbarPanel(toolbar), "First");
        $this$buildNonTabPanel_u24lambda_u243.add((Component)component, "Center");
        return jPanel;
    }

    private final JBTabbedPane buildTabPanel() {
        JBTabbedPane jBTabbedPane;
        JBTabbedPane $this$buildTabPanel_u24lambda_u245 = jBTabbedPane = new JBTabbedPane();
        boolean bl = false;
        this.addTab($this$buildTabPanel_u24lambda_u245, "Table", this.classifierView, this.toolbarDefaults());
        Object[] objectArray = new List[]{this.visualizationView.getToolbarComponents(), this.toolbarCore()};
        this.addTab($this$buildTabPanel_u24lambda_u245, "Visualization", this.visualizationView, CollectionsKt.flatten((Iterable)CollectionsKt.mutableListOf((Object[])objectArray)));
        $this$buildTabPanel_u24lambda_u245.addChangeListener(new ChangeListener(this, $this$buildTabPanel_u24lambda_u245){
            final /* synthetic */ CapturePanelUi this$0;
            final /* synthetic */ JBTabbedPane $this_apply;
            {
                this.this$0 = $receiver;
                this.$this_apply = $receiver2;
            }

            public final void stateChanged(ChangeEvent it) {
                CapturePanelUi.access$buildTabPanel$lambda$5$updateTabs(this.this$0, this.$this_apply);
            }
        });
        CapturePanelUi.buildTabPanel$lambda$5$updateTabs(this, $this$buildTabPanel_u24lambda_u245);
        return jBTabbedPane;
    }

    private final void addTab(JBTabbedPane tabPane, String name, CapturePanelTabContainer tabContainer, List<? extends Component> toolbarComponents) {
        this.toolbarTabPanels.put(name, new ToolbarComponents(new JPanel(ProfilerLayout.createToolbarLayout()), toolbarComponents));
        this.tabListeners.add(tabContainer);
        ToolbarComponents toolbarComponents2 = this.toolbarTabPanels.get(name);
        Intrinsics.checkNotNull((Object)toolbarComponents2);
        JPanel body = this.buildNonTabPanel(toolbarComponents2.getToolbarPanel(), tabContainer.getComponent());
        tabPane.add(name, (Component)body);
        body.setBorder((Border)JBUI.Borders.empty());
    }

    private final List<Component> toolbarDefaults() {
        List list;
        List $this$toolbarDefaults_u24lambda_u246 = list = (List)new ArrayList();
        boolean bl = false;
        if (!(this.selection.getSelectedCapture() instanceof NativeAllocationSampleCaptureObject)) {
            JComponent jComponent = this.heapView.getComponent();
            Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"heapView.component");
            $this$toolbarDefaults_u24lambda_u246.add(jComponent);
        }
        JComboBox<ClassGrouping> jComboBox = this.classGrouping.getComponent();
        Intrinsics.checkNotNullExpressionValue(jComboBox, (String)"classGrouping.component");
        $this$toolbarDefaults_u24lambda_u246.add(jComboBox);
        $this$toolbarDefaults_u24lambda_u246.addAll((Collection)this.toolbarCore());
        return list;
    }

    private final List<Component> toolbarCore() {
        List list;
        List $this$toolbarCore_u24lambda_u247 = list = (List)new ArrayList();
        boolean bl = false;
        $this$toolbarCore_u24lambda_u247.add(this.instanceFilterMenu.getComponent());
        $this$toolbarCore_u24lambda_u247.add(this.filterComponent);
        $this$toolbarCore_u24lambda_u247.add(this.captureInfoMessage);
        return list;
    }

    private final JPanel buildToolbarPanel(JPanel toolbar) {
        JPanel jPanel;
        JPanel $this$buildToolbarPanel_u24lambda_u248 = jPanel = new JPanel(new BorderLayout());
        boolean bl = false;
        $this$buildToolbarPanel_u24lambda_u248.add((Component)toolbar, "Before");
        $this$buildToolbarPanel_u24lambda_u248.setAlignmentX(0.0f);
        $this$buildToolbarPanel_u24lambda_u248.setMinimumSize(new Dimension(0, $this$buildToolbarPanel_u24lambda_u248.getMinimumSize().height));
        return jPanel;
    }

    private final JPanel buildSummaryPanel() {
        JPanel jPanel;
        JPanel $this$buildSummaryPanel_u24lambda_u2412 = jPanel = new JPanel(new FlowLayout(0));
        boolean bl = false;
        StatLabel totalClassLabel = CapturePanelUi.buildSummaryPanel$lambda$12$mkLabel$default("Classes", null, 2, null);
        StatLabel totalLeakLabel2 = CapturePanelUi.buildSummaryPanel$lambda$12$mkLabel("Leaks", new Runnable(this){
            final /* synthetic */ CapturePanelUi $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final void run() {
                CapturePanelUi.access$showLeaks(this.$tmp0);
            }
        });
        StatLabel totalCountLabel = CapturePanelUi.buildSummaryPanel$lambda$12$mkLabel$default("Count", null, 2, null);
        StatLabel totalNativeSizeLabel = CapturePanelUi.buildSummaryPanel$lambda$12$mkLabel$default("Native Size", null, 2, null);
        StatLabel totalShallowSizeLabel = CapturePanelUi.buildSummaryPanel$lambda$12$mkLabel$default("Shallow Size", null, 2, null);
        StatLabel totalRetainedSizeLabel = CapturePanelUi.buildSummaryPanel$lambda$12$mkLabel$default("Retained Size", null, 2, null);
        this.selection.getAspect().addDependency(this.observer).onChange((Enum)CaptureSelectionAspect.CURRENT_HEAP_CONTENTS, new Runnable(this, totalCountLabel, totalNativeSizeLabel, totalShallowSizeLabel, totalRetainedSizeLabel, totalClassLabel, $this$buildSummaryPanel_u24lambda_u2412, totalLeakLabel2){
            final /* synthetic */ CapturePanelUi this$0;
            final /* synthetic */ StatLabel $totalCountLabel;
            final /* synthetic */ StatLabel $totalNativeSizeLabel;
            final /* synthetic */ StatLabel $totalShallowSizeLabel;
            final /* synthetic */ StatLabel $totalRetainedSizeLabel;
            final /* synthetic */ StatLabel $totalClassLabel;
            final /* synthetic */ JPanel $this_apply;
            final /* synthetic */ StatLabel $totalLeakLabel;
            {
                this.this$0 = $receiver;
                this.$totalCountLabel = $totalCountLabel;
                this.$totalNativeSizeLabel = $totalNativeSizeLabel;
                this.$totalShallowSizeLabel = $totalShallowSizeLabel;
                this.$totalRetainedSizeLabel = $totalRetainedSizeLabel;
                this.$totalClassLabel = $totalClassLabel;
                this.$this_apply = $receiver2;
                this.$totalLeakLabel = $totalLeakLabel;
            }

            public final void run() {
                CapturePanelUi.access$buildSummaryPanel$lambda$12$refreshSummaries(this.this$0, this.$totalCountLabel, this.$totalNativeSizeLabel, this.$totalShallowSizeLabel, this.$totalRetainedSizeLabel, this.$totalClassLabel, this.$this_apply, this.$totalLeakLabel);
            }
        }).onChange((Enum)CaptureSelectionAspect.CURRENT_FILTER, new Runnable(this, totalCountLabel, totalNativeSizeLabel, totalShallowSizeLabel, totalRetainedSizeLabel, totalClassLabel, $this$buildSummaryPanel_u24lambda_u2412, totalLeakLabel2){
            final /* synthetic */ CapturePanelUi this$0;
            final /* synthetic */ StatLabel $totalCountLabel;
            final /* synthetic */ StatLabel $totalNativeSizeLabel;
            final /* synthetic */ StatLabel $totalShallowSizeLabel;
            final /* synthetic */ StatLabel $totalRetainedSizeLabel;
            final /* synthetic */ StatLabel $totalClassLabel;
            final /* synthetic */ JPanel $this_apply;
            final /* synthetic */ StatLabel $totalLeakLabel;
            {
                this.this$0 = $receiver;
                this.$totalCountLabel = $totalCountLabel;
                this.$totalNativeSizeLabel = $totalNativeSizeLabel;
                this.$totalShallowSizeLabel = $totalShallowSizeLabel;
                this.$totalRetainedSizeLabel = $totalRetainedSizeLabel;
                this.$totalClassLabel = $totalClassLabel;
                this.$this_apply = $receiver2;
                this.$totalLeakLabel = $totalLeakLabel;
            }

            public final void run() {
                CapturePanelUi.access$buildSummaryPanel$lambda$12$refreshSummaries(this.this$0, this.$totalCountLabel, this.$totalNativeSizeLabel, this.$totalShallowSizeLabel, this.$totalRetainedSizeLabel, this.$totalClassLabel, this.$this_apply, this.$totalLeakLabel);
            }
        });
        $this$buildSummaryPanel_u24lambda_u2412.add((Component)totalClassLabel);
        $this$buildSummaryPanel_u24lambda_u2412.add((Component)totalLeakLabel2);
        $this$buildSummaryPanel_u24lambda_u2412.add((Component)new FlatSeparator(6, 36));
        $this$buildSummaryPanel_u24lambda_u2412.add((Component)totalCountLabel);
        $this$buildSummaryPanel_u24lambda_u2412.add((Component)totalNativeSizeLabel);
        $this$buildSummaryPanel_u24lambda_u2412.add((Component)totalShallowSizeLabel);
        $this$buildSummaryPanel_u24lambda_u2412.add((Component)totalRetainedSizeLabel);
        $this$buildSummaryPanel_u24lambda_u2412.setAlignmentX(0.0f);
        return jPanel;
    }

    private final void showLeaks() {
        block0: {
            Object object = this.selection.getSelectedCapture();
            if (object == null || (object = object.getActivityFragmentLeakFilter()) == null) break block0;
            Object it = object;
            boolean bl = false;
            this.instanceFilterMenu.getComponent().setSelectedItem(it);
        }
    }

    private static final void buildDetailsPanel$lambda$2$refreshPanel(JPanel $this_apply, CapturePanelUi this$0, JPanel $headingPanel) {
        $this_apply.removeAll();
        if (this$0.selection.getSelectedCapture() instanceof HeapDumpCaptureObject) {
            JPanel toolbarPanel = new JPanel(ProfilerLayout.createToolbarLayout());
            Iterable $this$forEach$iv = this$0.toolbarDefaults();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Component it = (Component)element$iv;
                boolean bl = false;
                toolbarPanel.add(it);
            }
            $headingPanel.add((Component)this$0.buildToolbarPanel(toolbarPanel), 0);
            $this_apply.add(this$0.classifierView.getComponent());
        } else {
            $this_apply.add((Component)this$0.buildTabPanel(), "Center");
        }
    }

    private static final void buildTabPanel$lambda$5$updateTabs(CapturePanelUi this$0, JBTabbedPane $this_apply) {
        this$0.tabListeners.get(this$0.activeTabIndex).onSelectionChanged(false);
        String title = $this_apply.getTitleAt($this_apply.getSelectedIndex());
        ToolbarComponents toolbarComponents = this$0.toolbarTabPanels.get(title);
        Intrinsics.checkNotNull((Object)toolbarComponents);
        JPanel panel = toolbarComponents.getToolbarPanel();
        panel.removeAll();
        ToolbarComponents toolbarComponents2 = this$0.toolbarTabPanels.get(title);
        Intrinsics.checkNotNull((Object)toolbarComponents2);
        Iterable $this$forEach$iv = toolbarComponents2.getComponents();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Component it = (Component)element$iv;
            boolean bl = false;
            panel.add(it);
        }
        this$0.tabListeners.get($this_apply.getSelectedIndex()).onSelectionChanged(true);
        this$0.activeTabIndex = $this_apply.getSelectedIndex();
    }

    private static final StatLabel buildSummaryPanel$lambda$12$mkLabel(String desc, Runnable action) {
        Font font = ProfilerFonts.H2_FONT;
        Intrinsics.checkNotNullExpressionValue((Object)font, (String)"H2_FONT");
        JBFont jBFont = AdtUiUtils.DEFAULT_FONT.biggerOn(1.0f);
        Intrinsics.checkNotNullExpressionValue((Object)jBFont, (String)"DEFAULT_FONT.biggerOn(1f)");
        return new StatLabel(0L, desc, font, (Font)jBFont, null, action, 16, null);
    }

    static /* synthetic */ StatLabel buildSummaryPanel$lambda$12$mkLabel$default(String string, Runnable runnable, int n, Object object) {
        if ((n & 2) != 0) {
            runnable = null;
        }
        return CapturePanelUi.buildSummaryPanel$lambda$12$mkLabel(string, runnable);
    }

    private static final void buildSummaryPanel$lambda$12$refreshTotalClassesAsync(CapturePanelUi this$0, StatLabel totalClassLabel, HeapSet heap) {
        this$0.profilersView.getStudioProfilers().getIdeServices().getPoolExecutor().execute(new Runnable(this$0, heap, totalClassLabel){
            final /* synthetic */ CapturePanelUi this$0;
            final /* synthetic */ HeapSet $heap;
            final /* synthetic */ StatLabel $totalClassLabel;
            {
                this.this$0 = $receiver;
                this.$heap = $heap;
                this.$totalClassLabel = $totalClassLabel;
            }

            public final void run() {
                Stream<InstanceObject> filterMatches2 = CapturePanelUi.access$getSelection$p(this.this$0).getFilterHandler().getFilter().isEmpty() ? this.$heap.getInstancesStream() : this.$heap.getFilterMatches();
                long count2 = filterMatches2.mapToLong((ToLongFunction<InstanceObject>)buildSummaryPanel.1.refreshTotalClassesAsync.count.1.INSTANCE).distinct().count();
                CapturePanelUi.access$getProfilersView$p(this.this$0).getStudioProfilers().getIdeServices().getMainExecutor().execute(new Runnable(this.$totalClassLabel, count2){
                    final /* synthetic */ StatLabel $totalClassLabel;
                    final /* synthetic */ long $count;
                    {
                        this.$totalClassLabel = $totalClassLabel;
                        this.$count = $count;
                    }

                    public final void run() {
                        this.$totalClassLabel.setNumValue(this.$count);
                    }
                });
            }
        });
    }

    private static final void buildSummaryPanel$lambda$12$refreshSummaries(CapturePanelUi this$0, StatLabel totalCountLabel, StatLabel totalNativeSizeLabel, StatLabel totalShallowSizeLabel, StatLabel totalRetainedSizeLabel, StatLabel totalClassLabel, JPanel $this_apply, StatLabel totalLeakLabel2) {
        block3: {
            HeapSet heapSet = this$0.selection.getSelectedHeapSet();
            if (heapSet == null) break block3;
            HeapSet heap = heapSet;
            boolean bl = false;
            CapturePanelUi.buildSummaryPanel$lambda$12$refreshTotalClassesAsync(this$0, totalClassLabel, heap);
            totalCountLabel.setNumValue((long)heap.getTotalObjectCount());
            totalNativeSizeLabel.setNumValue(heap.getTotalNativeSize());
            totalShallowSizeLabel.setNumValue(heap.getTotalShallowSize());
            totalRetainedSizeLabel.setNumValue(heap.getTotalRetainedSize());
            CaptureObject captureObject = this$0.selection.getSelectedCapture();
            if (captureObject != null) {
                CaptureObject capture = captureObject;
                boolean bl2 = false;
                $this_apply.setVisible(capture instanceof HeapDumpCaptureObject);
                ActivityFragmentLeakInstanceFilter filter = capture.getActivityFragmentLeakFilter();
                if (filter == null) {
                    totalLeakLabel2.setVisible(false);
                } else {
                    StatLabel statLabel;
                    StatLabel $this$buildSummaryPanel_u24lambda_u2412_u24refreshSummaries_u24lambda_u2411_u24lambda_u2410_u24lambda_u249 = statLabel = totalLeakLabel2;
                    boolean bl3 = false;
                    long leakCount = heap.getInstanceFilterMatchCount(filter);
                    $this$buildSummaryPanel_u24lambda_u2412_u24refreshSummaries_u24lambda_u2411_u24lambda_u2410_u24lambda_u249.setVisible(true);
                    $this$buildSummaryPanel_u24lambda_u2412_u24refreshSummaries_u24lambda_u2411_u24lambda_u2410_u24lambda_u249.setNumValue(leakCount);
                    $this$buildSummaryPanel_u24lambda_u2412_u24refreshSummaries_u24lambda_u2411_u24lambda_u2410_u24lambda_u249.setIcon(leakCount > 0L ? StudioIcons.Common.WARNING : null);
                }
            }
        }
    }

    public static final /* synthetic */ void access$buildDetailsPanel$lambda$2$refreshPanel(JPanel $this_apply, CapturePanelUi this$0, JPanel $headingPanel) {
        CapturePanelUi.buildDetailsPanel$lambda$2$refreshPanel($this_apply, this$0, $headingPanel);
    }

    public static final /* synthetic */ void access$buildTabPanel$lambda$5$updateTabs(CapturePanelUi this$0, JBTabbedPane $this_apply) {
        CapturePanelUi.buildTabPanel$lambda$5$updateTabs(this$0, $this_apply);
    }

    public static final /* synthetic */ MemoryCaptureSelection access$getSelection$p(CapturePanelUi $this) {
        return $this.selection;
    }

    public static final /* synthetic */ StudioProfilersView access$getProfilersView$p(CapturePanelUi $this) {
        return $this.profilersView;
    }

    public static final /* synthetic */ void access$showLeaks(CapturePanelUi $this) {
        $this.showLeaks();
    }

    public static final /* synthetic */ void access$buildSummaryPanel$lambda$12$refreshSummaries(CapturePanelUi this$0, StatLabel totalCountLabel, StatLabel totalNativeSizeLabel, StatLabel totalShallowSizeLabel, StatLabel totalRetainedSizeLabel, StatLabel totalClassLabel, JPanel $this_apply, StatLabel totalLeakLabel2) {
        CapturePanelUi.buildSummaryPanel$lambda$12$refreshSummaries(this$0, totalCountLabel, totalNativeSizeLabel, totalShallowSizeLabel, totalRetainedSizeLabel, totalClassLabel, $this_apply, totalLeakLabel2);
    }
}

