/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.energy;

import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.LineChartModel;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedContinuousSeries;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Energy;
import com.android.tools.profiler.proto.TransportServiceGrpc;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.UnifiedEventDataSeries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

public class EnergyUsage
extends LineChartModel {
    @NotNull
    private final RangedContinuousSeries myTotalUsageDataSeries;
    @NotNull
    private final Range myUsageRange = new Range(0.0, 400.0);

    public EnergyUsage(@NotNull StudioProfilers profilers) {
        super(profilers.getIdeServices().getPoolExecutor());
        DataSeries<Long> dataSeries = EnergyUsage.buildDataSeries(profilers.getClient().getTransportClient(), profilers.getSession());
        this.myTotalUsageDataSeries = new RangedContinuousSeries(EnergyUsage.getSeriesLabel(), profilers.getTimeline().getViewRange(), this.myUsageRange, dataSeries, profilers.getTimeline().getDataRange());
        this.add(this.myTotalUsageDataSeries);
    }

    @NotNull
    public RangedContinuousSeries getTotalUsageDataSeries() {
        return this.myTotalUsageDataSeries;
    }

    @NotNull
    public Range getUsageRange() {
        return this.myUsageRange;
    }

    @NotNull
    private static String getSeriesLabel() {
        return "";
    }

    private static long getTotalUsage(@NotNull Energy.EnergyUsageData usage) {
        return usage.getCpuUsage() + usage.getNetworkUsage() + usage.getLocationUsage();
    }

    @VisibleForTesting
    public static DataSeries<Long> buildDataSeries(@NotNull TransportServiceGrpc.TransportServiceBlockingStub client, @NotNull Common.Session session) {
        return new UnifiedEventDataSeries<Long>(client, session.getStreamId(), session.getPid(), Common.Event.Kind.ENERGY_USAGE, 0, UnifiedEventDataSeries.fromFieldToDataExtractor(event -> EnergyUsage.getTotalUsage(event.getEnergyUsage())));
    }
}

