/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.energy;

import com.android.tools.adtui.LegendComponent;
import com.android.tools.adtui.LegendConfig;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.TooltipView;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.model.legend.Legend;
import com.android.tools.adtui.model.legend.LegendComponentModel;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerFonts;
import com.android.tools.profilers.Stage;
import com.android.tools.profilers.StageView;
import com.android.tools.profilers.energy.EnergyProfilerStage;
import com.android.tools.profilers.energy.EnergyStageTooltip;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

class EnergyStageTooltipView
extends TooltipView {
    @NotNull
    private final StageView myStageView;
    @NotNull
    private final EnergyStageTooltip myTooltip;

    public EnergyStageTooltipView(@NotNull StageView stageView, @NotNull EnergyStageTooltip tooltip2) {
        super(((Stage)((Object)stageView.getStage())).getTimeline());
        this.myStageView = stageView;
        this.myTooltip = tooltip2;
    }

    @NotNull
    protected JComponent createTooltip() {
        EnergyProfilerStage.EnergyUsageLegends usageLegends = this.myTooltip.getUsageLegends();
        LegendComponent usageLegendComponent = new LegendComponent.Builder((LegendComponentModel)usageLegends).setVerticalPadding(0).setOrientation(LegendComponent.Orientation.VERTICAL).build();
        usageLegendComponent.configure(usageLegends.getCpuLegend(), new LegendConfig(LegendConfig.IconType.BOX, ProfilerColors.ENERGY_CPU));
        usageLegendComponent.configure(usageLegends.getNetworkLegend(), new LegendConfig(LegendConfig.IconType.BOX, ProfilerColors.ENERGY_NETWORK));
        usageLegendComponent.configure((Legend)usageLegends.getLocationLegend(), new LegendConfig(LegendConfig.IconType.BOX, ProfilerColors.ENERGY_LOCATION));
        JPanel legendPanel2 = new JPanel((LayoutManager)new TabularLayout("*", "Fit,8px,Fit,8px,Fit,Fit,Fit"));
        legendPanel2.setOpaque(false);
        legendPanel2.add((Component)usageLegendComponent, new TabularLayout.Constraint(0, 0));
        JLabel eventLabel = new JLabel("System Events");
        eventLabel.setForeground(ProfilerColors.TOOLTIP_TEXT);
        eventLabel.setFont(ProfilerFonts.STANDARD_FONT);
        Color color = eventLabel.getForeground();
        eventLabel.setForeground(new Color(color.getRed(), color.getGreen(), color.getBlue(), 153));
        JPanel labelWithSeparator = new JPanel((LayoutManager)new TabularLayout("Fit,8px,*", "Fit"));
        labelWithSeparator.add((Component)eventLabel, new TabularLayout.Constraint(0, 0));
        labelWithSeparator.add((Component)AdtUiUtils.createHorizontalSeparator(), new TabularLayout.Constraint(0, 2));
        labelWithSeparator.setOpaque(false);
        legendPanel2.add((Component)AdtUiUtils.createHorizontalSeparator(), new TabularLayout.Constraint(1, 0));
        return legendPanel2;
    }
}

