/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.energy;

import com.android.tools.adtui.AxisComponent;
import com.android.tools.adtui.LegendComponent;
import com.android.tools.adtui.LegendConfig;
import com.android.tools.adtui.RangeTooltipComponent;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.TooltipComponent;
import com.android.tools.adtui.TooltipView;
import com.android.tools.adtui.chart.linechart.LineChart;
import com.android.tools.adtui.chart.linechart.LineConfig;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.model.LineChartModel;
import com.android.tools.adtui.model.StreamingTimeline;
import com.android.tools.adtui.model.Timeline;
import com.android.tools.adtui.model.legend.Legend;
import com.android.tools.adtui.model.legend.LegendComponentModel;
import com.android.tools.adtui.stdui.StreamingScrollbar;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerFonts;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.ProfilerTooltipMouseAdapter;
import com.android.tools.profilers.Stage;
import com.android.tools.profilers.StageView;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.StudioProfilersView;
import com.android.tools.profilers.energy.DetailedEnergyUsage;
import com.android.tools.profilers.energy.EnergyDetailsView;
import com.android.tools.profilers.energy.EnergyEventMinibar;
import com.android.tools.profilers.energy.EnergyMonitorView;
import com.android.tools.profilers.energy.EnergyProfilerStage;
import com.android.tools.profilers.energy.EnergyStageTooltip;
import com.android.tools.profilers.energy.EnergyStageTooltipView;
import com.android.tools.profilers.event.EventMonitorView;
import com.android.tools.profilers.event.LifecycleTooltip;
import com.android.tools.profilers.event.LifecycleTooltipView;
import com.android.tools.profilers.event.UserEventTooltip;
import com.android.tools.profilers.event.UserEventTooltipView;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class EnergyProfilerStageView
extends StageView<EnergyProfilerStage> {
    @NotNull
    private final EnergyDetailsView myDetailsView;

    public EnergyProfilerStageView(@NotNull StudioProfilersView profilersView, @NotNull EnergyProfilerStage energyProfilerStage) {
        super(profilersView, energyProfilerStage);
        this.getTooltipBinder().bind(EnergyStageTooltip.class, EnergyStageTooltipView::new);
        this.getTooltipBinder().bind(LifecycleTooltip.class, (stageView, tooltip2) -> new LifecycleTooltipView(stageView.getComponent(), (LifecycleTooltip)tooltip2));
        this.getTooltipBinder().bind(UserEventTooltip.class, (stageView, tooltip2) -> new UserEventTooltipView(stageView.getComponent(), (UserEventTooltip)tooltip2));
        this.myDetailsView = new EnergyDetailsView(this);
        this.myDetailsView.setMinimumSize(new Dimension(JBUI.scale((int)450), (int)this.myDetailsView.getMinimumSize().getHeight()));
        this.myDetailsView.setVisible(false);
        JBSplitter splitter = new JBSplitter(false, 0.6f);
        splitter.setFirstComponent((JComponent)this.buildMonitorUi());
        splitter.setSecondComponent((JComponent)this.myDetailsView);
        splitter.setHonorComponentsMinimumSize(true);
        splitter.getDivider().setBorder(AdtUiUtils.DEFAULT_VERTICAL_BORDERS);
        this.getComponent().add((Component)splitter, "Center");
    }

    @NotNull
    private JPanel buildMonitorUi() {
        StudioProfilers profilers = ((EnergyProfilerStage)((Object)this.getStage())).getStudioProfilers();
        StreamingTimeline timeline = ((EnergyProfilerStage)((Object)this.getStage())).getTimeline();
        RangeTooltipComponent tooltip2 = new RangeTooltipComponent((Timeline)((EnergyProfilerStage)((Object)this.getStage())).getTimeline(), (JComponent)this.getTooltipPanel(), this.getProfilersView().getComponent(), () -> true);
        TabularLayout layout = new TabularLayout("*");
        JBPanel panel = new JBPanel((LayoutManager)layout);
        panel.setBackground(ProfilerColors.DEFAULT_STAGE_BACKGROUND);
        panel.add((Component)tooltip2, new TabularLayout.Constraint(0, 0, 2, 1));
        StreamingScrollbar scrollbar = new StreamingScrollbar(timeline, (JComponent)panel);
        panel.add((Component)scrollbar, new TabularLayout.Constraint(4, 0));
        JComponent timeAxis = this.buildTimeAxis(profilers);
        panel.add((Component)timeAxis, new TabularLayout.Constraint(3, 0));
        EventMonitorView eventsView = new EventMonitorView(this.getProfilersView(), ((EnergyProfilerStage)((Object)this.getStage())).getEventMonitor());
        JComponent eventsComponent = eventsView.getComponent();
        panel.add((Component)eventsComponent, new TabularLayout.Constraint(0, 0));
        JBPanel monitorPanel = new JBPanel((LayoutManager)new TabularLayout("*", "*"));
        monitorPanel.setOpaque(false);
        monitorPanel.setBorder(ProfilerLayout.MONITOR_BORDER);
        JLabel label = new JLabel(((EnergyProfilerStage)((Object)this.getStage())).getName());
        label.setBorder(ProfilerLayout.MONITOR_LABEL_PADDING);
        label.setVerticalAlignment(1);
        JBPanel lineChartPanel = new JBPanel((LayoutManager)new BorderLayout());
        lineChartPanel.setOpaque(false);
        lineChartPanel.setBorder(BorderFactory.createEmptyBorder(ProfilerLayout.Y_AXIS_TOP_MARGIN, 0, 0, 0));
        DetailedEnergyUsage usage = ((EnergyProfilerStage)((Object)this.getStage())).getDetailedUsage();
        LineChart lineChart = new LineChart((LineChartModel)usage);
        LineConfig cpuConfig = new LineConfig(ProfilerColors.ENERGY_CPU).setFilled(true).setStacked(true).setLegendIconType(LegendConfig.IconType.BOX).setDataBucketInterval(EnergyMonitorView.CHART_INTERVAL_US);
        lineChart.configure(usage.getCpuUsageSeries(), cpuConfig);
        LineConfig networkConfig = new LineConfig(ProfilerColors.ENERGY_NETWORK).setFilled(true).setStacked(true).setLegendIconType(LegendConfig.IconType.BOX).setDataBucketInterval(EnergyMonitorView.CHART_INTERVAL_US);
        lineChart.configure(usage.getNetworkUsageSeries(), networkConfig);
        LineConfig locationConfig = new LineConfig(ProfilerColors.ENERGY_LOCATION).setFilled(true).setStacked(true).setLegendIconType(LegendConfig.IconType.BOX).setDataBucketInterval(EnergyMonitorView.CHART_INTERVAL_US);
        lineChart.configure(usage.getLocationUsageSeries(), locationConfig);
        lineChart.configure(usage.getTotalUsageDataSeries(), new LineConfig(UIUtil.TRANSPARENT_COLOR));
        lineChart.setRenderOffset(0, (int)LineConfig.DEFAULT_DASH_STROKE.getLineWidth() / 2);
        lineChartPanel.add((Component)lineChart, "Center");
        JBPanel axisPanel = new JBPanel((LayoutManager)new BorderLayout());
        axisPanel.setOpaque(false);
        AxisComponent leftAxis = new AxisComponent(((EnergyProfilerStage)((Object)this.getStage())).getAxis(), AxisComponent.AxisOrientation.RIGHT, true);
        leftAxis.setShowAxisLine(false);
        leftAxis.setOnlyShowUnitAtMax(true);
        leftAxis.setHideTickAtMin(true);
        leftAxis.setMarkerLengths(ProfilerLayout.MARKER_LENGTH, ProfilerLayout.MARKER_LENGTH);
        leftAxis.setMargins(0, ProfilerLayout.Y_AXIS_TOP_MARGIN);
        axisPanel.add((Component)leftAxis, "West");
        EnergyProfilerStage.EnergyUsageLegends legends = ((EnergyProfilerStage)((Object)this.getStage())).getLegends();
        LegendComponent legend = new LegendComponent.Builder((LegendComponentModel)legends).setRightPadding(ProfilerLayout.PROFILER_LEGEND_RIGHT_PADDING).build();
        legend.configure(legends.getCpuLegend(), new LegendConfig(lineChart.getLineConfig(usage.getCpuUsageSeries())));
        legend.configure(legends.getNetworkLegend(), new LegendConfig(lineChart.getLineConfig(usage.getNetworkUsageSeries())));
        legend.configure((Legend)legends.getLocationLegend(), new LegendConfig(lineChart.getLineConfig(usage.getLocationUsageSeries())));
        JBPanel legendPanel2 = new JBPanel((LayoutManager)new BorderLayout());
        legendPanel2.setOpaque(false);
        legendPanel2.add((Component)label, "West");
        legendPanel2.add((Component)legend, "East");
        JComponent minibar = new EnergyEventMinibar(this).getComponent();
        eventsView.registerTooltip(tooltip2, (Stage)((Object)this.getStage()));
        monitorPanel.add((Component)axisPanel, new TabularLayout.Constraint(0, 0));
        monitorPanel.add((Component)legendPanel2, new TabularLayout.Constraint(0, 0));
        monitorPanel.add((Component)lineChartPanel, new TabularLayout.Constraint(0, 0));
        JPanel stagePanel = new JPanel((LayoutManager)new TabularLayout("*", "*,Fit"));
        stagePanel.add((Component)monitorPanel, new TabularLayout.Constraint(0, 0));
        stagePanel.add((Component)minibar, new TabularLayout.Constraint(1, 0));
        layout.setRowSizing(1, "*");
        stagePanel.setBackground(null);
        this.installListeners(stagePanel, tooltip2);
        panel.add((Component)stagePanel, new TabularLayout.Constraint(1, 0));
        return panel;
    }

    private void installListeners(@NotNull JComponent component, @NotNull RangeTooltipComponent tooltip2) {
        this.getProfilersView().installCommonMenuItems(component);
        tooltip2.registerListenersOn(component);
        component.addMouseListener(new ProfilerTooltipMouseAdapter((Stage)((Object)this.getStage()), () -> new EnergyStageTooltip((EnergyProfilerStage)((Object)((Object)this.getStage())))));
    }

    @Override
    public JComponent getToolbar() {
        JPanel toolBar = new JPanel(ProfilerLayout.createToolbarLayout());
        JLabel textLabel = new JLabel();
        textLabel.setText("Modeled");
        textLabel.setFont(ProfilerFonts.H4_FONT);
        textLabel.setBorder((Border)new JBEmptyBorder(4, 8, 4, 7));
        toolBar.add(textLabel);
        JLabel iconLabel = new JLabel();
        iconLabel.setIcon(StudioIcons.Common.HELP);
        toolBar.add(iconLabel);
        JTextPane textPane = new JTextPane();
        textPane.setEditable(false);
        textPane.setBorder(ProfilerLayout.TOOLTIP_BORDER);
        textPane.setBackground(ProfilerColors.TOOLTIP_BACKGROUND);
        textPane.setForeground(ProfilerColors.TOOLTIP_TEXT);
        textPane.setFont(TooltipView.TOOLTIP_BODY_FONT);
        textPane.setText("The Energy Profiler models your app's estimated energy usage of CPU, Network, and GPS resources of your device. It also highlights background events that may contribute to battery drain, such as wake locks, alarms, jobs, and location requests.");
        textPane.setPreferredSize(new Dimension(350, 0));
        TooltipComponent tooltip2 = new TooltipComponent.Builder((JComponent)textPane, (JComponent)iconLabel, this.getProfilersView().getComponent()).build();
        tooltip2.registerListenersOn((Component)iconLabel);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)toolBar, "West");
        return panel;
    }
}

