/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.energy;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.EaseOutModel;
import com.android.tools.adtui.model.Interpolatable;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangeSelectionListener;
import com.android.tools.adtui.model.RangeSelectionModel;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.adtui.model.StateChartModel;
import com.android.tools.adtui.model.axis.AxisComponentModel;
import com.android.tools.adtui.model.axis.ResizingAxisComponentModel;
import com.android.tools.adtui.model.formatter.BaseAxisFormatter;
import com.android.tools.adtui.model.formatter.EnergyAxisFormatter;
import com.android.tools.adtui.model.legend.Legend;
import com.android.tools.adtui.model.legend.LegendComponentModel;
import com.android.tools.adtui.model.legend.SeriesLegend;
import com.android.tools.adtui.model.updater.Updatable;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profiler.proto.TransportServiceGrpc;
import com.android.tools.profilers.ProfilerAspect;
import com.android.tools.profilers.StreamingStage;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.analytics.energy.EnergyEventMetadata;
import com.android.tools.profilers.analytics.energy.EnergyRangeMetadata;
import com.android.tools.profilers.energy.DetailedEnergyUsage;
import com.android.tools.profilers.energy.EnergyDuration;
import com.android.tools.profilers.energy.EnergyEventOrigin;
import com.android.tools.profilers.energy.EnergyMonitor;
import com.android.tools.profilers.energy.EnergyProfilerAspect;
import com.android.tools.profilers.energy.MergedEnergyEventsDataSeries;
import com.android.tools.profilers.event.EventMonitor;
import com.google.common.collect.ImmutableList;
import com.google.wireless.android.sdk.stats.AndroidProfilerEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnergyProfilerStage
extends StreamingStage {
    private static final String HAS_USED_ENERGY_SELECTION = "energy.used.selection";
    private static final String ENERGY_EVENT_ORIGIN_INDEX = "energy.event.origin";
    @NotNull
    private final DetailedEnergyUsage myDetailedUsage;
    @NotNull
    private final ResizingAxisComponentModel myAxis;
    @NotNull
    private final EventMonitor myEventMonitor;
    @NotNull
    private final EnergyUsageLegends myLegends;
    @NotNull
    private final EnergyUsageLegends myUsageTooltipLegends;
    @NotNull
    private final RangeSelectionModel myRangeSelectionModel;
    @NotNull
    private final StateChartModel<Common.Event> myEventModel;
    @NotNull
    private final EaseOutModel myInstructionsEaseOutModel;
    @NotNull
    private final Updatable myUpdatable;
    private AspectObserver myAspectObserver = new AspectObserver();
    private AspectModel<EnergyProfilerAspect> myAspect = new AspectModel();
    @Nullable
    private EnergyDuration mySelectedDuration;

    public EnergyProfilerStage(final @NotNull StudioProfilers profilers) {
        super(profilers);
        this.myDetailedUsage = new DetailedEnergyUsage(profilers);
        this.myAxis = (ResizingAxisComponentModel)new ResizingAxisComponentModel.Builder(this.myDetailedUsage.getUsageRange(), (BaseAxisFormatter)EnergyAxisFormatter.DEFAULT).setMarkerRange(EnergyMonitor.AXIS_MARKER_RANGE).build();
        this.myEventMonitor = new EventMonitor(profilers);
        this.myLegends = new EnergyUsageLegends(this.myDetailedUsage, this.getTimeline().getDataRange());
        this.myUsageTooltipLegends = new EnergyUsageLegends(this.myDetailedUsage, this.getTimeline().getTooltipRange());
        this.myRangeSelectionModel = new RangeSelectionModel(this.getTimeline().getSelectionRange(), this.getTimeline().getViewRange());
        this.myRangeSelectionModel.setSelectionEnabled(profilers.isAgentAttached());
        profilers.addDependency(this.myAspectObserver).onChange((Enum)ProfilerAspect.AGENT, () -> this.myRangeSelectionModel.setSelectionEnabled(profilers.isAgentAttached()));
        this.myRangeSelectionModel.addListener(new RangeSelectionListener(){

            public void selectionCreated() {
                EnergyProfilerStage.trackRangeSelection(profilers, EnergyProfilerStage.this.myRangeSelectionModel.getSelectionRange());
                profilers.getIdeServices().getTemporaryProfilerPreferences().setBoolean(EnergyProfilerStage.HAS_USED_ENERGY_SELECTION, true);
                EnergyProfilerStage.this.myInstructionsEaseOutModel.setCurrentPercentage(1.0f);
            }
        });
        this.myEventModel = this.createEventChartModel(profilers);
        this.myInstructionsEaseOutModel = new EaseOutModel(profilers.getUpdater(), PROFILING_INSTRUCTIONS_EASE_OUT_NS);
        this.myUpdatable = elapsedNs -> this.getTimeline().getTooltipRange().changed((Enum)Range.Aspect.RANGE);
    }

    @Override
    public void enter() {
        this.logEnterStage();
        this.myEventMonitor.enter();
        this.getStudioProfilers().getUpdater().register((Updatable)this.myDetailedUsage);
        this.getStudioProfilers().getUpdater().register(this.myUpdatable);
        this.getStudioProfilers().getIdeServices().getFeatureTracker().trackEnterStage(this.getStageType());
    }

    @Override
    public void exit() {
        this.myEventMonitor.exit();
        this.getStudioProfilers().getUpdater().unregister((Updatable)this.myDetailedUsage);
        this.getStudioProfilers().getUpdater().unregister(this.myUpdatable);
    }

    @Override
    public AndroidProfilerEvent.Stage getStageType() {
        return AndroidProfilerEvent.Stage.ENERGY_STAGE;
    }

    @NotNull
    public RangeSelectionModel getRangeSelectionModel() {
        return this.myRangeSelectionModel;
    }

    @NotNull
    public DetailedEnergyUsage getDetailedUsage() {
        return this.myDetailedUsage;
    }

    @NotNull
    StateChartModel<Common.Event> getEventModel() {
        return this.myEventModel;
    }

    @NotNull
    public AxisComponentModel getAxis() {
        return this.myAxis;
    }

    @NotNull
    public EventMonitor getEventMonitor() {
        return this.myEventMonitor;
    }

    @NotNull
    public EnergyUsageLegends getLegends() {
        return this.myLegends;
    }

    @NotNull
    public EnergyUsageLegends getUsageTooltipLegends() {
        return this.myUsageTooltipLegends;
    }

    @NotNull
    public String getName() {
        return "ENERGY";
    }

    @NotNull
    public AspectModel<EnergyProfilerAspect> getAspect() {
        return this.myAspect;
    }

    @Nullable
    public EnergyDuration getSelectedDuration() {
        return this.mySelectedDuration;
    }

    public void setSelectedDuration(@Nullable EnergyDuration duration) {
        if (Objects.equals(this.mySelectedDuration, duration) || !this.canSelectDuration(duration)) {
            return;
        }
        this.mySelectedDuration = duration;
        this.myAspect.changed((Enum)EnergyProfilerAspect.SELECTED_EVENT_DURATION);
        if (this.mySelectedDuration != null) {
            this.getStudioProfilers().getIdeServices().getFeatureTracker().trackSelectEnergyEvent(new EnergyEventMetadata((Collection<Common.Event>)this.mySelectedDuration.getEventList()));
        }
    }

    @NotNull
    public EaseOutModel getInstructionsEaseOutModel() {
        return this.myInstructionsEaseOutModel;
    }

    public boolean hasUserUsedEnergySelection() {
        return this.getStudioProfilers().getIdeServices().getTemporaryProfilerPreferences().getBoolean(HAS_USED_ENERGY_SELECTION, false);
    }

    @NotNull
    public EnergyEventOrigin getEventOrigin() {
        int savedOriginOrdinal = this.getStudioProfilers().getIdeServices().getTemporaryProfilerPreferences().getInt(ENERGY_EVENT_ORIGIN_INDEX, EnergyEventOrigin.ALL.ordinal());
        return EnergyEventOrigin.values()[savedOriginOrdinal];
    }

    public void setEventOrigin(@NotNull EnergyEventOrigin origin) {
        if (this.getEventOrigin() != origin) {
            this.getStudioProfilers().getIdeServices().getTemporaryProfilerPreferences().setInt(ENERGY_EVENT_ORIGIN_INDEX, origin.ordinal());
            if (!this.canSelectDuration(this.getSelectedDuration())) {
                this.setSelectedDuration(null);
            }
            this.myAspect.changed((Enum)EnergyProfilerAspect.SELECTED_ORIGIN_FILTER);
        }
    }

    private boolean canSelectDuration(@Nullable EnergyDuration duration) {
        return duration == null || !this.filterByOrigin((List<EnergyDuration>)ImmutableList.of((Object)duration)).isEmpty();
    }

    @NotNull
    public List<EnergyDuration> filterByOrigin(@NotNull List<EnergyDuration> list) {
        String appName = this.getStudioProfilers().getSelectedAppName();
        return list.stream().filter(duration -> this.getEventOrigin().isValid(appName, duration.getCalledBy())).collect(Collectors.toList());
    }

    private static void trackRangeSelection(@NotNull StudioProfilers profilers, Range selectionRange) {
        profilers.getIdeServices().getFeatureTracker().trackSelectRange();
        long minNs = TimeUnit.MICROSECONDS.toNanos((long)selectionRange.getMin());
        long maxNs = TimeUnit.MICROSECONDS.toNanos((long)selectionRange.getMax());
        ArrayList<EnergyDuration> energyDurations = new ArrayList<EnergyDuration>();
        Transport.GetEventGroupsRequest request = Transport.GetEventGroupsRequest.newBuilder().setStreamId(profilers.getSession().getStreamId()).setPid(profilers.getSession().getPid()).setKind(Common.Event.Kind.ENERGY_EVENT).setFromTimestamp(minNs).setToTimestamp(maxNs).build();
        Transport.GetEventGroupsResponse response = profilers.getClient().getTransportClient().getEventGroups(request);
        for (Transport.EventGroup group : response.getGroupsList()) {
            energyDurations.add(new EnergyDuration(group.getEventsList()));
        }
        if (!energyDurations.isEmpty()) {
            profilers.getIdeServices().getFeatureTracker().trackSelectEnergyRange(new EnergyRangeMetadata(energyDurations));
        }
    }

    private StateChartModel<Common.Event> createEventChartModel(StudioProfilers profilers) {
        StateChartModel stateChartModel = new StateChartModel();
        Range range = this.getTimeline().getViewRange();
        TransportServiceGrpc.TransportServiceBlockingStub transportClient = profilers.getClient().getTransportClient();
        long streamId = profilers.getSession().getStreamId();
        int pid = profilers.getSession().getPid();
        stateChartModel.addSeries(new RangedSeries(range, (DataSeries)new MergedEnergyEventsDataSeries(transportClient, streamId, pid, kind -> kind == EnergyDuration.Kind.ALARM || kind == EnergyDuration.Kind.JOB)));
        stateChartModel.addSeries(new RangedSeries(range, (DataSeries)new MergedEnergyEventsDataSeries(transportClient, streamId, pid, kind -> kind == EnergyDuration.Kind.WAKE_LOCK)));
        stateChartModel.addSeries(new RangedSeries(range, (DataSeries)new MergedEnergyEventsDataSeries(transportClient, streamId, pid, kind -> kind == EnergyDuration.Kind.LOCATION)));
        return stateChartModel;
    }

    public static class EnergyUsageLegends
    extends LegendComponentModel {
        @NotNull
        private final SeriesLegend myCpuLegend;
        @NotNull
        private final SeriesLegend myNetworkLegend;
        @NotNull
        private final SeriesLegend myLocationLegend;

        EnergyUsageLegends(DetailedEnergyUsage detailedUsage, Range range) {
            super(range);
            this.myCpuLegend = new SeriesLegend(detailedUsage.getCpuUsageSeries(), (BaseAxisFormatter)EnergyAxisFormatter.LEGEND_FORMATTER, range, "CPU", Interpolatable.SegmentInterpolator);
            this.myNetworkLegend = new SeriesLegend(detailedUsage.getNetworkUsageSeries(), (BaseAxisFormatter)EnergyAxisFormatter.LEGEND_FORMATTER, range, "Network", Interpolatable.SegmentInterpolator);
            this.myLocationLegend = new SeriesLegend(detailedUsage.getLocationUsageSeries(), (BaseAxisFormatter)EnergyAxisFormatter.LEGEND_FORMATTER, range, "Location", Interpolatable.SegmentInterpolator);
            this.add((Legend)this.myCpuLegend);
            this.add((Legend)this.myNetworkLegend);
            this.add((Legend)this.myLocationLegend);
        }

        @NotNull
        public Legend getCpuLegend() {
            return this.myCpuLegend;
        }

        @NotNull
        public Legend getNetworkLegend() {
            return this.myNetworkLegend;
        }

        @NotNull
        public SeriesLegend getLocationLegend() {
            return this.myLocationLegend;
        }
    }
}

