/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.customevent;

import com.android.tools.adtui.AxisComponent;
import com.android.tools.adtui.LegendConfig;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.chart.linechart.LineChart;
import com.android.tools.adtui.chart.linechart.LineConfig;
import com.android.tools.adtui.model.LineChartModel;
import com.android.tools.adtui.model.RangedContinuousSeries;
import com.android.tools.adtui.model.legend.Legend;
import com.android.tools.adtui.model.trackgroup.TrackModel;
import com.android.tools.adtui.trackgroup.TrackRenderer;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.customevent.CustomEventTrackLegendComponent;
import com.android.tools.profilers.customevent.CustomEventTrackModel;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.ui.JBDimension;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class CustomEventTrackRenderer
implements TrackRenderer<CustomEventTrackModel> {
    @NotNull
    public JComponent render(@NotNull TrackModel<CustomEventTrackModel, ?> trackModel) {
        JPanel container = new JPanel();
        container.setLayout((LayoutManager)new TabularLayout("150px,*", "*"));
        container.setFocusable(true);
        LineChartModel lineChartModel = ((CustomEventTrackModel)trackModel.getDataModel()).getLineChartModel();
        List rangedContinuousSeriesList = lineChartModel.getSeries();
        assert (rangedContinuousSeriesList.size() == 1);
        RangedContinuousSeries rangedContinuousSeries = (RangedContinuousSeries)rangedContinuousSeriesList.get(0);
        JPanel lineChartPanel = new JPanel(new BorderLayout());
        lineChartPanel.setOpaque(false);
        LineChart lineChart = new LineChart(lineChartModel);
        LineConfig config = new LineConfig(ProfilerColors.USER_COUNTER_EVENT_USAGE).setLegendIconType(LegendConfig.IconType.LINE).setFilled(true);
        lineChart.configure(rangedContinuousSeries, config);
        lineChart.setRenderOffset(0, (int)LineConfig.DEFAULT_DASH_STROKE.getLineWidth() / 2);
        lineChart.setFillEndGap(true);
        lineChartPanel.add((Component)lineChart, "Center");
        lineChartPanel.setPreferredSize((Dimension)JBDimension.create((Dimension)lineChartPanel.getPreferredSize()).withHeight(100));
        JBPanel axisPanel = new JBPanel((LayoutManager)new BorderLayout());
        axisPanel.setOpaque(false);
        AxisComponent leftAxis = new AxisComponent(((CustomEventTrackModel)trackModel.getDataModel()).getAxisComponentModel(), AxisComponent.AxisOrientation.RIGHT, true);
        leftAxis.setShowAxisLine(false);
        leftAxis.setOnlyShowUnitAtMax(true);
        leftAxis.setHideTickAtMin(true);
        leftAxis.setMarkerLengths(ProfilerLayout.MARKER_LENGTH, ProfilerLayout.MARKER_LENGTH);
        leftAxis.setMargins(0, ProfilerLayout.Y_AXIS_TOP_MARGIN);
        axisPanel.add((Component)leftAxis, "West");
        JLabel titleLabel = new JLabel(" " + ((CustomEventTrackModel)trackModel.getDataModel()).getName());
        CustomEventTrackModel.Legends legends = ((CustomEventTrackModel)trackModel.getDataModel()).getLegends();
        CustomEventTrackLegendComponent legend = new CustomEventTrackLegendComponent(legends);
        legend.configure((Legend)legends.getTrackLegend(), new LegendConfig(LegendConfig.IconType.NONE, ProfilerColors.USER_COUNTER_EVENT_NONE));
        JBPanel legendPanel2 = new JBPanel((LayoutManager)new TabularLayout("*,*", "*,*"));
        legendPanel2.setOpaque(false);
        legendPanel2.add((Component)titleLabel, new TabularLayout.Constraint(0, 0, 1, 2));
        legendPanel2.add((Component)((Object)legend), new TabularLayout.Constraint(1, 0));
        container.add((Component)legendPanel2, new TabularLayout.Constraint(0, 0));
        container.add((Component)leftAxis, new TabularLayout.Constraint(0, 1));
        container.add((Component)lineChartPanel, new TabularLayout.Constraint(0, 1));
        container.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, ProfilerColors.COMBOBOX_BORDER));
        container.setBackground(ProfilerColors.DEFAULT_BACKGROUND);
        return container;
    }
}

