/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.systemtrace;

import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.LineChartModel;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedContinuousSeries;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.adtui.model.axis.AxisComponentModel;
import com.android.tools.adtui.model.axis.ResizingAxisComponentModel;
import com.android.tools.adtui.model.formatter.BaseAxisFormatter;
import com.android.tools.adtui.model.formatter.MemoryAxisFormatter;
import com.android.tools.profilers.cpu.LazyDataSeries;
import com.android.tools.profilers.cpu.systemtrace.RssMemoryTrackModel;
import java.util.List;
import java.util.SortedMap;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B!\u0012\u0012\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/profilers/cpu/systemtrace/RssMemoryTrackModel;", "Lcom/android/tools/adtui/model/LineChartModel;", "dataSeries", "", "Lcom/android/tools/adtui/model/SeriesData;", "", "viewRange", "Lcom/android/tools/adtui/model/Range;", "(Ljava/util/List;Lcom/android/tools/adtui/model/Range;)V", "axisComponentModel", "Lcom/android/tools/adtui/model/axis/AxisComponentModel;", "getAxisComponentModel", "()Lcom/android/tools/adtui/model/axis/AxisComponentModel;", "memoryCounterSeries", "Lcom/android/tools/adtui/model/RangedContinuousSeries;", "getMemoryCounterSeries", "()Lcom/android/tools/adtui/model/RangedContinuousSeries;", "Companion", "intellij.android.profilers"})
public final class RssMemoryTrackModel
extends LineChartModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RangedContinuousSeries memoryCounterSeries;
    @NotNull
    private final AxisComponentModel axisComponentModel;
    @NotNull
    private static final MemoryAxisFormatter axisFormatter = new MemoryAxisFormatter(1, 2, 5);
    @NotNull
    private static final SortedMap<String, String> includedCountersNameMap;

    public RssMemoryTrackModel(final @NotNull List<SeriesData<Long>> dataSeries, @NotNull Range viewRange) {
        Intrinsics.checkNotNullParameter(dataSeries, (String)"dataSeries");
        Intrinsics.checkNotNullParameter((Object)viewRange, (String)"viewRange");
        Long l = (Long)SequencesKt.maxOrNull((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)dataSeries), (Function1)maxValue.1.INSTANCE));
        long maxValue2 = l != null ? l : 0L;
        Range yRange = new Range(0.0, (double)maxValue2);
        ResizingAxisComponentModel resizingAxisComponentModel = new ResizingAxisComponentModel.Builder(yRange, (BaseAxisFormatter)axisFormatter).build();
        Intrinsics.checkNotNullExpressionValue((Object)resizingAxisComponentModel, (String)"Builder(yRange, axisFormatter).build()");
        this.axisComponentModel = (AxisComponentModel)resizingAxisComponentModel;
        this.memoryCounterSeries = new RangedContinuousSeries("RSS", viewRange, yRange, (DataSeries)new LazyDataSeries(new Supplier(){

            public final List<SeriesData<Long>> get() {
                return dataSeries;
            }
        }), null, 16, null);
        this.add(this.memoryCounterSeries);
    }

    @NotNull
    public final RangedContinuousSeries getMemoryCounterSeries() {
        return this.memoryCounterSeries;
    }

    @NotNull
    public final AxisComponentModel getAxisComponentModel() {
        return this.axisComponentModel;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"mem.rss", (Object)"Total"), TuplesKt.to((Object)"mem.rss.anon", (Object)"Allocated"), TuplesKt.to((Object)"mem.rss.file", (Object)"File Mappings"), TuplesKt.to((Object)"mem.rss.shmem", (Object)"Shared"), TuplesKt.to((Object)"mem.swap", (Object)"Swapped-Out")};
        includedCountersNameMap = MapsKt.sortedMapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/android/tools/profilers/cpu/systemtrace/RssMemoryTrackModel$Companion;", "", "()V", "axisFormatter", "Lcom/android/tools/adtui/model/formatter/MemoryAxisFormatter;", "includedCountersNameMap", "Ljava/util/SortedMap;", "", "getIncludedCountersNameMap", "()Ljava/util/SortedMap;", "intellij.android.profilers"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SortedMap<String, String> getIncludedCountersNameMap() {
            return includedCountersNameMap;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

