/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.systemtrace;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.adtui.model.Timeline;
import com.android.tools.adtui.model.TooltipModel;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u0001\u0017B#\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0015H\u0002R\u001e\u0010\r\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/profilers/cpu/systemtrace/RssMemoryTooltip;", "Lcom/android/tools/adtui/model/TooltipModel;", "Lcom/android/tools/adtui/model/AspectModel;", "Lcom/android/tools/profilers/cpu/systemtrace/RssMemoryTooltip$Aspect;", "timeline", "Lcom/android/tools/adtui/model/Timeline;", "counterName", "", "rssValues", "Lcom/android/tools/adtui/model/RangedSeries;", "", "(Lcom/android/tools/adtui/model/Timeline;Ljava/lang/String;Lcom/android/tools/adtui/model/RangedSeries;)V", "<set-?>", "activeValueBytes", "getActiveValueBytes", "()J", "getCounterName", "()Ljava/lang/String;", "getTimeline", "()Lcom/android/tools/adtui/model/Timeline;", "dispose", "", "updateValue", "Aspect", "intellij.android.profilers"})
public final class RssMemoryTooltip
extends AspectModel<Aspect>
implements TooltipModel {
    @NotNull
    private final Timeline timeline;
    @NotNull
    private final String counterName;
    @NotNull
    private final RangedSeries<Long> rssValues;
    private long activeValueBytes;

    public RssMemoryTooltip(@NotNull Timeline timeline, @NotNull String counterName, @NotNull RangedSeries<Long> rssValues) {
        Intrinsics.checkNotNullParameter((Object)timeline, (String)"timeline");
        Intrinsics.checkNotNullParameter((Object)counterName, (String)"counterName");
        Intrinsics.checkNotNullParameter(rssValues, (String)"rssValues");
        this.timeline = timeline;
        this.counterName = counterName;
        this.rssValues = rssValues;
        this.timeline.getTooltipRange().addDependency((AspectObserver)this).onChange((Enum)Range.Aspect.RANGE, new Runnable(){

            @Override
            public final void run() {
                this.updateValue();
            }
        });
    }

    @NotNull
    public final Timeline getTimeline() {
        return this.timeline;
    }

    @NotNull
    public final String getCounterName() {
        return this.counterName;
    }

    public final long getActiveValueBytes() {
        return this.activeValueBytes;
    }

    public void dispose() {
        this.timeline.getTooltipRange().removeDependencies((AspectObserver)this);
    }

    private final void updateValue() {
        long newValueKb;
        Range range = this.timeline.getTooltipRange();
        Intrinsics.checkNotNullExpressionValue((Object)range, (String)"timeline.tooltipRange");
        List series = this.rssValues.getSeriesForRange(range);
        long l = newValueKb = series.isEmpty() ? 0L : ((Number)((SeriesData)series.get((int)0)).value).longValue();
        if (newValueKb != this.activeValueBytes) {
            this.activeValueBytes = newValueKb;
            this.changed(Aspect.VALUE_CHANGED);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0003\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003\u00a8\u0006\u0004"}, d2={"Lcom/android/tools/profilers/cpu/systemtrace/RssMemoryTooltip$Aspect;", "", "(Ljava/lang/String;I)V", "VALUE_CHANGED", "intellij.android.profilers"})
    public static final class Aspect
    extends Enum<Aspect> {
        public static final /* enum */ Aspect VALUE_CHANGED = new Aspect();
        private static final /* synthetic */ Aspect[] $VALUES;

        public static Aspect[] values() {
            return (Aspect[])$VALUES.clone();
        }

        public static Aspect valueOf(String value) {
            return Enum.valueOf(Aspect.class, value);
        }

        static {
            $VALUES = aspectArray = new Aspect[]{Aspect.VALUE_CHANGED};
        }
    }
}

