/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.simpleperf;

import com.android.tools.adtui.model.Range;
import com.android.tools.perflib.vmtrace.ClockType;
import com.android.tools.profiler.proto.SimpleperfReport;
import com.android.tools.profilers.cpu.BaseCpuCapture;
import com.android.tools.profilers.cpu.CaptureNode;
import com.android.tools.profilers.cpu.CpuCapture;
import com.android.tools.profilers.cpu.CpuThreadInfo;
import com.android.tools.profilers.cpu.TraceParser;
import com.android.tools.profilers.cpu.config.ProfilingConfiguration;
import com.android.tools.profilers.cpu.nodemodel.CaptureNodeModel;
import com.android.tools.profilers.cpu.nodemodel.NoSymbolModel;
import com.android.tools.profilers.cpu.nodemodel.SingleNameModel;
import com.android.tools.profilers.cpu.simpleperf.NodeNameParser;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class SimpleperfTraceParser
implements TraceParser {
    private static final String MAGIC = "SIMPLEPERF";
    private static final int INVALID_SYMBOL_ID = -1;
    private static final String DATA_APP_DIR = "/data/app";
    private static final String CPU_CLOCK_EVENT = "cpu-clock";
    private static final String DUAL_CLOCK_DISABLED_MESSAGE = "This imported trace supports Wall Clock Time only.<p>To view Thread Time, take a new recording using the latest version of Android Studio.";
    private int myTraceVersion;
    private final Map<Integer, SimpleperfReport.File> myFiles;
    private final Map<Integer, SimpleperfReport.Thread> myThreads;
    @VisibleForTesting
    final List<SimpleperfReport.Sample> mySamples;
    private final Map<CpuThreadInfo, CaptureNode> myCaptureTrees;
    private long mySampleCount;
    private long myLostSampleCount;
    private int myCpuClockEventTypeId = -1;
    @NotNull
    private final Range myCaptureRange = new Range();
    private List<String> myEventTypes;
    private String myAppPackageName;
    private String myAppDataFolderPrefix;
    private Set<String> myTags = new TreeSet<String>(TAG_COMPARATOR);
    @VisibleForTesting
    static Comparator<String> TAG_COMPARATOR = Comparator.comparing(SimpleperfTraceParser::tagClass).thenComparing(String::compareTo);

    public SimpleperfTraceParser() {
        this.myFiles = new HashMap<Integer, SimpleperfReport.File>();
        this.mySamples = new ArrayList<SimpleperfReport.Sample>();
        this.myCaptureTrees = new HashMap<CpuThreadInfo, CaptureNode>();
        this.myThreads = new HashMap<Integer, SimpleperfReport.Thread>();
    }

    private static String fileNameFromPath(String path) {
        String[] splitPath = path.split("/");
        return splitPath[splitPath.length - 1];
    }

    private static boolean equals(SimpleperfReport.Sample.CallChainEntry c1, SimpleperfReport.Sample.CallChainEntry c2) {
        boolean isSameFileAndSymbolId;
        boolean bl = isSameFileAndSymbolId = c1.getFileId() == c2.getFileId() && c1.getSymbolId() == c2.getSymbolId();
        if (!isSameFileAndSymbolId) {
            return false;
        }
        if (c1.getSymbolId() == -1) {
            return c1.getVaddrInFile() == c2.getVaddrInFile();
        }
        return true;
    }

    private static Logger getLog() {
        return Logger.getInstance(SimpleperfTraceParser.class);
    }

    private static ByteBuffer byteBufferFromFile(File f, ByteOrder byteOrder) throws IOException {
        try (FileInputStream dataFile = new FileInputStream(f);){
            MappedByteBuffer buffer = dataFile.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, f.length());
            buffer.order(byteOrder);
            MappedByteBuffer mappedByteBuffer = buffer;
            return mappedByteBuffer;
        }
    }

    @Override
    public CpuCapture parse(@NotNull File trace, long traceId) throws IOException {
        this.parseTraceFile(trace);
        this.parseSampleData();
        return new BaseCpuCapture(traceId, ProfilingConfiguration.TraceType.SIMPLEPERF, this.isThreadTimeSupported(), this.isThreadTimeSupported() ? null : DUAL_CLOCK_DISABLED_MESSAGE, this.myCaptureRange, this.getCaptureTrees(), this.myTags);
    }

    public Map<CpuThreadInfo, CaptureNode> getCaptureTrees() {
        return this.myCaptureTrees;
    }

    public long getLostSampleCount() {
        return this.myLostSampleCount;
    }

    public long getSampleCount() {
        return this.mySampleCount;
    }

    private boolean isThreadTimeSupported() {
        return this.myCpuClockEventTypeId >= 0;
    }

    @NotNull
    private static CaptureNode createCaptureNode(CaptureNodeModel model, long startGlobalNs, long startThreadNs) {
        CaptureNode node = new CaptureNode(model, ClockType.GLOBAL);
        SimpleperfTraceParser.setNodeStartTime(node, startGlobalNs, startThreadNs);
        node.setDepth(0);
        return node;
    }

    @VisibleForTesting
    void parseTraceFile(File trace) throws IOException {
        ByteBuffer buffer = SimpleperfTraceParser.byteBufferFromFile(trace, ByteOrder.LITTLE_ENDIAN);
        SimpleperfTraceParser.verifyMagicNumber(buffer);
        this.parseVersionNumber(buffer);
        int recordSize = buffer.getInt();
        while (recordSize != 0) {
            byte[] recordBytes = new byte[recordSize];
            buffer.get(recordBytes);
            SimpleperfReport.Record record = SimpleperfReport.Record.parseFrom((byte[])recordBytes);
            switch (record.getRecordDataCase()) {
                case FILE: {
                    SimpleperfReport.File file = record.getFile();
                    this.myFiles.put(file.getId(), file);
                    break;
                }
                case LOST: {
                    SimpleperfReport.LostSituation situation = record.getLost();
                    this.mySampleCount = situation.getSampleCount();
                    this.myLostSampleCount = situation.getLostCount();
                    break;
                }
                case SAMPLE: {
                    SimpleperfReport.Sample sample = record.getSample();
                    this.mySamples.add(sample);
                    break;
                }
                case THREAD: {
                    SimpleperfReport.Thread thread2 = record.getThread();
                    this.myThreads.put(thread2.getThreadId(), thread2);
                    break;
                }
                case META_INFO: {
                    SimpleperfReport.MetaInfo info = record.getMetaInfo();
                    this.myEventTypes = info.getEventTypeList();
                    this.myAppPackageName = info.getAppPackageName();
                    this.myAppDataFolderPrefix = String.format("%s/%s", DATA_APP_DIR, this.myAppPackageName);
                    break;
                }
                default: {
                    SimpleperfTraceParser.getLog().warn("Unexpected record data type " + record.getRecordDataCase());
                }
            }
            recordSize = buffer.getInt();
        }
        if ((long)this.mySamples.size() != this.mySampleCount) {
            throw new IllegalStateException("Samples count doesn't match the number of samples read.");
        }
        this.myCpuClockEventTypeId = this.myEventTypes.indexOf(CPU_CLOCK_EVENT);
    }

    private void parseVersionNumber(ByteBuffer buffer) {
        this.myTraceVersion = buffer.getShort();
    }

    private static void verifyMagicNumber(ByteBuffer buffer) {
        byte[] magic = new byte[MAGIC.length()];
        buffer.get(magic);
        if (!new String(magic).equals(MAGIC)) {
            throw new IllegalStateException("Simpleperf trace could not be parsed due to magic number mismatch.");
        }
    }

    private void parseSampleData() {
        if (this.mySamples.isEmpty()) {
            this.myCaptureRange.clear();
            return;
        }
        long startTimestamp = this.mySamples.get(0).getTime();
        long endTimestamp = this.mySamples.get(this.mySamples.size() - 1).getTime();
        this.myCaptureRange.set((double)TimeUnit.NANOSECONDS.toMicros(startTimestamp), (double)TimeUnit.NANOSECONDS.toMicros(endTimestamp));
        Map<Integer, List<SimpleperfReport.Sample>> threadSamples = this.splitSamplesPerThread();
        for (Map.Entry<Integer, List<SimpleperfReport.Sample>> threadSamplesEntry : threadSamples.entrySet()) {
            this.parseThreadSamples(threadSamplesEntry.getKey(), threadSamplesEntry.getValue());
        }
    }

    private Map<Integer, List<SimpleperfReport.Sample>> splitSamplesPerThread() {
        HashMap<Integer, List<SimpleperfReport.Sample>> threadSamples = new HashMap<Integer, List<SimpleperfReport.Sample>>();
        for (SimpleperfReport.Sample sample : this.mySamples) {
            int threadId = sample.getThreadId();
            if (!threadSamples.containsKey(threadId)) {
                threadSamples.put(threadId, new ArrayList());
            }
            ((List)threadSamples.get(threadId)).add(sample);
        }
        return threadSamples;
    }

    private static void setNodeStartTime(CaptureNode node, long startGlobalNs, long startThreadNs) {
        node.setStartGlobal(TimeUnit.NANOSECONDS.toMicros(startGlobalNs));
        node.setStartThread(TimeUnit.NANOSECONDS.toMicros(startThreadNs));
    }

    private static void setNodeEndTime(CaptureNode node, long endGlobalNs, long endThreadNs) {
        node.setEndGlobal(TimeUnit.NANOSECONDS.toMicros(endGlobalNs));
        node.setEndThread(TimeUnit.NANOSECONDS.toMicros(endThreadNs));
    }

    private void parseThreadSamples(int threadId, List<SimpleperfReport.Sample> threadSamples) {
        long firstTimestamp;
        if (threadSamples.isEmpty()) {
            SimpleperfTraceParser.getLog().warn(String.format("Warning: No samples read for thread %s (%d)", this.myThreads.get(threadId), threadId));
            return;
        }
        if (!this.myThreads.containsKey(threadId)) {
            throw new IllegalStateException("Malformed trace file: thread with id " + threadId + " not found.");
        }
        long threadTimeNs = firstTimestamp = threadSamples.get(0).getTime();
        SimpleperfReport.Thread thread2 = this.myThreads.get(threadId);
        CaptureNode root = SimpleperfTraceParser.createCaptureNode(new SingleNameModel(thread2.getThreadName()), firstTimestamp, threadTimeNs);
        root.setDepth(0);
        this.myCaptureTrees.put(new CpuThreadInfo(threadId, thread2.getThreadName(), threadId == thread2.getProcessId()), root);
        List previousCallChain = Lists.reverse((List)threadSamples.get(0).getCallchainList());
        CaptureNode lastVisitedNode = this.parseCallChain(previousCallChain, Collections.emptyList(), firstTimestamp, threadTimeNs, root);
        for (int i = 1; i < threadSamples.size(); ++i) {
            SimpleperfReport.Sample sample = threadSamples.get(i);
            List callChain = Lists.reverse((List)sample.getCallchainList());
            if (this.isThreadTimeSupported() && sample.getEventTypeId() == this.myCpuClockEventTypeId) {
                threadTimeNs += sample.getEventCount();
            }
            lastVisitedNode = this.parseCallChain(callChain, previousCallChain, sample.getTime(), threadTimeNs, lastVisitedNode);
            previousCallChain = callChain;
        }
        long lastTimestamp = this.mySamples.get(this.mySamples.size() - 1).getTime();
        SimpleperfTraceParser.updateAncestorsEndTime(lastTimestamp, threadTimeNs, lastVisitedNode);
        SimpleperfTraceParser.setNodeEndTime(root, lastTimestamp, threadTimeNs);
    }

    private static void updateAncestorsEndTime(long globalTimeNs, long threadTimeNs, CaptureNode lastVisited) {
        CaptureNode node = lastVisited;
        while (node.getParent() != null && node.getEnd() == 0L) {
            SimpleperfTraceParser.setNodeEndTime(node, globalTimeNs, threadTimeNs);
            node = node.getParent();
            assert (node != null);
        }
    }

    private CaptureNode parseCallChain(List<SimpleperfReport.Sample.CallChainEntry> callChain, List<SimpleperfReport.Sample.CallChainEntry> previousCallChain, long globalTimeNs, long threadTimeNs, CaptureNode lastVisitedNode) {
        int divergenceIndex;
        CaptureNode traversalNode = lastVisitedNode;
        for (divergenceIndex = 0; divergenceIndex < callChain.size() && divergenceIndex < previousCallChain.size() && SimpleperfTraceParser.equals(previousCallChain.get(divergenceIndex), callChain.get(divergenceIndex)); ++divergenceIndex) {
        }
        if (divergenceIndex < previousCallChain.size()) {
            int divergenceCount = previousCallChain.size() - divergenceIndex;
            traversalNode = SimpleperfTraceParser.findDivergenceAndUpdateEndTime(divergenceCount, globalTimeNs, threadTimeNs, traversalNode);
        }
        if (divergenceIndex < callChain.size()) {
            traversalNode = this.addNewNodes(callChain, traversalNode, divergenceIndex, globalTimeNs, threadTimeNs);
        }
        return traversalNode;
    }

    private static CaptureNode findDivergenceAndUpdateEndTime(int divergenceCount, long endGlobalNs, long endThreadNs, CaptureNode node) {
        for (int i = 0; i < divergenceCount; ++i) {
            assert (node != null);
            SimpleperfTraceParser.setNodeEndTime(node, endGlobalNs, endThreadNs);
            node = node.getParent();
        }
        return node;
    }

    private CaptureNode addNewNodes(List<SimpleperfReport.Sample.CallChainEntry> callChain, CaptureNode node, int startIndex, long startGlobalNs, long startThreadNs) {
        assert (node != null);
        for (int i = startIndex; i < callChain.size(); ++i) {
            long parentVAddress = i > 0 ? callChain.get(i - 1).getVaddrInFile() : -1L;
            CaptureNode child = SimpleperfTraceParser.createCaptureNode(this.methodModelFromCallchainEntry(callChain.get(i), parentVAddress), startGlobalNs, startThreadNs);
            node.addChild(child);
            child.setDepth(node.getDepth() + 1);
            node = child;
        }
        return node;
    }

    private CaptureNodeModel methodModelFromCallchainEntry(SimpleperfReport.Sample.CallChainEntry callChainEntry, long parentVAddress) {
        int symbolId = callChainEntry.getSymbolId();
        SimpleperfReport.File symbolFile = this.myFiles.get(callChainEntry.getFileId());
        if (symbolFile == null) {
            throw new IllegalStateException("Symbol file with id \"" + callChainEntry.getFileId() + "\" not found.");
        }
        if (symbolId == -1) {
            String hexAddress = "0x" + Long.toHexString(callChainEntry.getVaddrInFile());
            String methodName = SimpleperfTraceParser.fileNameFromPath(symbolFile.getPath()) + "+" + hexAddress;
            return this.nodeWithTagAdded(new NoSymbolModel(symbolFile.getPath(), methodName));
        }
        boolean isUserWritten = symbolFile.getPath().startsWith(this.myAppDataFolderPrefix);
        return this.nodeWithTagAdded(NodeNameParser.parseNodeName(symbolFile.getSymbol(symbolId), isUserWritten, symbolFile.getPath(), parentVAddress));
    }

    private CaptureNodeModel nodeWithTagAdded(CaptureNodeModel node) {
        if (node.getTag() != null) {
            this.myTags.add(node.getTag());
        }
        return node;
    }

    private static TagClass tagClass(String tag) {
        return tag.contains("*") ? TagClass.PREFIXED_PATH : (tag.contains("[") ? TagClass.DESCRIPTION : TagClass.EXACT_PATH);
    }

    private static enum TagClass {
        EXACT_PATH,
        DESCRIPTION,
        PREFIXED_PATH;

    }
}

