/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.simpleperf;

import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.protobuf.ByteString;
import com.android.tools.idea.util.StudioPathManager;
import com.android.tools.profilers.cpu.TracePreProcessor;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.AndroidProfilerEvent;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.CpuCaptureMetadata;
import com.google.wireless.android.sdk.stats.CpuProfilingConfig;
import com.google.wireless.android.sdk.stats.DeviceInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.system.CpuArch;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class SimpleperfSampleReporter
implements TracePreProcessor {
    @NotNull
    private final DeviceInfo myDeviceInfo;

    public SimpleperfSampleReporter(@NotNull DeviceInfo deviceInfo) {
        this.myDeviceInfo = deviceInfo;
    }

    private static Logger getLogger() {
        return Logger.getInstance(SimpleperfSampleReporter.class);
    }

    @Override
    @NotNull
    public ByteString preProcessTrace(@NotNull ByteString trace, @NotNull List<String> symbolDirs) {
        try {
            boolean reportSampleSuccess;
            if (trace.isEmpty()) {
                SimpleperfSampleReporter.getLogger().error("Simpleperf preprocessing exited unsuccessfully. Input trace is empty.");
                this.logPreprocessError(CpuCaptureMetadata.CaptureStatus.PREPROCESS_FAILED_SIMPLEPERF_EMPTY_FILE);
                return FAILURE;
            }
            File processedTraceFile = FileUtil.createTempFile((String)String.format("%s%ctrace-%d", FileUtil.getTempDirectory(), Character.valueOf(File.separatorChar), System.currentTimeMillis()), (String)".trace", (boolean)true);
            List<String> command = this.getReportSampleCommand(trace, processedTraceFile, symbolDirs);
            SimpleperfSampleReporter.getLogger().info("Running simpleperf command: " + command);
            Process reportSample = new ProcessBuilder(command).start();
            reportSample.waitFor();
            boolean bl = reportSampleSuccess = reportSample.exitValue() == 0;
            if (!reportSampleSuccess) {
                String error = new BufferedReader(new InputStreamReader(reportSample.getErrorStream())).readLine();
                SimpleperfSampleReporter.getLogger().warn("simpleperf report-sample exited unsuccessfully. " + error);
                this.logPreprocessError(CpuCaptureMetadata.CaptureStatus.PREPROCESS_FAILED_SIMPLEPERF_ERRORS_AT_EXIT);
                return FAILURE;
            }
            ByteString processedTrace = ByteString.copyFrom((byte[])Files.readAllBytes(processedTraceFile.toPath()));
            processedTraceFile.delete();
            return processedTrace;
        }
        catch (IOException e) {
            SimpleperfSampleReporter.getLogger().warn(String.format("I/O error when trying to execute simpleperf report-sample:\n%s", e.getMessage()));
            this.logPreprocessError(CpuCaptureMetadata.CaptureStatus.PREPROCESS_FAILED_SIMPLEPERF_IO_ERROR);
            return FAILURE;
        }
        catch (InterruptedException e) {
            SimpleperfSampleReporter.getLogger().warn(String.format("Failed to wait for simpleperf report-sample command to run:\n%s", e.getMessage()));
            this.logPreprocessError(CpuCaptureMetadata.CaptureStatus.PREPROCESS_FAILED_SIMPLEPERF_FAILED_TO_WAIT);
            return FAILURE;
        }
    }

    @VisibleForTesting
    List<String> getReportSampleCommand(@NotNull ByteString trace, @NotNull File processedTrace, @NotNull List<String> symbolDirs) throws IOException {
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.getSimpleperfBinaryPath());
        command.add("report-sample");
        command.add("--protobuf");
        command.add("--show-callchain");
        command.add("-i");
        command.add(SimpleperfSampleReporter.tempFileFromByteString(trace).getAbsolutePath());
        command.add("-o");
        command.add(processedTrace.getAbsolutePath());
        for (String path : symbolDirs) {
            command.add("--symdir");
            command.add(path);
        }
        return command;
    }

    @VisibleForTesting
    String getSimpleperfBinaryPath() {
        String subDir = SimpleperfSampleReporter.getSimpleperfBinarySubdirectory();
        String binaryName = SimpleperfSampleReporter.getSimpleperfBinaryName();
        if (StudioPathManager.isRunningFromSources()) {
            return StudioPathManager.resolvePathFromSourcesRoot((String)("prebuilts/tools/" + subDir + "/simpleperf/" + binaryName)).toString();
        }
        return Paths.get(PathManager.getHomePath(), "plugins", "android", "resources", "simpleperf", subDir, binaryName).toString();
    }

    private static File tempFileFromByteString(@NotNull ByteString bytes) throws IOException {
        File file = FileUtil.createTempFile((String)String.format("cpu_trace_%d", System.currentTimeMillis()), (String)".trace", (boolean)true);
        try (FileOutputStream out = new FileOutputStream(file);){
            out.write(bytes.toByteArray());
        }
        return file;
    }

    private void logPreprocessError(CpuCaptureMetadata.CaptureStatus captureStatus) {
        AndroidStudioEvent.Builder event = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.ANDROID_PROFILER).setDeviceInfo(this.myDeviceInfo).setAndroidProfilerEvent(AndroidProfilerEvent.newBuilder().setType(AndroidProfilerEvent.Type.CAPTURE_TRACE).setCpuCaptureMetadata(CpuCaptureMetadata.newBuilder().setProfilingConfig(CpuProfilingConfig.newBuilder().setType(CpuProfilingConfig.Type.SIMPLE_PERF).setMode(CpuProfilingConfig.Mode.SAMPLED)).setCaptureStatus(captureStatus)));
        UsageTracker.log((AndroidStudioEvent.Builder)event);
    }

    private static String getSimpleperfBinarySubdirectory() {
        if (SystemInfo.isLinux && CpuArch.isIntel32()) {
            return "linux-x86";
        }
        if (SystemInfo.isLinux && CpuArch.isIntel64()) {
            return "linux-x86_64";
        }
        if (SystemInfo.isMac && CpuArch.isIntel64()) {
            return "darwin-x86_64";
        }
        if (SystemInfo.isMac && CpuArch.isArm64()) {
            return "darwin-x86_64";
        }
        if (SystemInfo.isWindows && CpuArch.isIntel32()) {
            return "windows";
        }
        if (SystemInfo.isWindows && CpuArch.isIntel64()) {
            return "windows-x86_64";
        }
        throw new IllegalStateException("Unknown operating system/CPU architecture");
    }

    private static String getSimpleperfBinaryName() {
        return SystemInfo.isWindows ? "simpleperf.exe" : "simpleperf";
    }
}

