/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.capturedetails;

import com.android.tools.adtui.AxisComponent;
import com.android.tools.adtui.RangeTimeScrollBar;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.chart.hchart.HRenderer;
import com.android.tools.adtui.chart.hchart.HTreeChart;
import com.android.tools.adtui.chart.hchart.HTreeChartVerticalScrollBar;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.HNode;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.axis.AxisComponentModel;
import com.android.tools.adtui.model.axis.ResizingAxisComponentModel;
import com.android.tools.adtui.model.formatter.BaseAxisFormatter;
import com.android.tools.adtui.model.formatter.TimeAxisFormatter;
import com.android.tools.idea.codenavigation.CodeLocation;
import com.android.tools.idea.codenavigation.CodeNavigator;
import com.android.tools.profilers.FeatureConfig;
import com.android.tools.profilers.IdeProfilerServices;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.StudioProfilersView;
import com.android.tools.profilers.cpu.CaptureNode;
import com.android.tools.profilers.cpu.capturedetails.CaptureDetails;
import com.android.tools.profilers.cpu.capturedetails.CaptureDetailsView;
import com.android.tools.profilers.cpu.capturedetails.CaptureNodeHRenderer;
import com.android.tools.profilers.cpu.capturedetails.CodeNavigationHandler;
import com.android.tools.profilers.cpu.capturedetails.CpuChartTooltipView;
import com.android.tools.profilers.cpu.capturedetails.CpuTraceEventTooltipView;
import com.android.tools.profilers.cpu.nodemodel.CaptureNodeModel;
import com.android.tools.profilers.cpu.nodemodel.CppFunctionModel;
import com.android.tools.profilers.cpu.nodemodel.JavaMethodModel;
import com.android.tools.profilers.cpu.nodemodel.SystemTraceNodeModel;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ChartDetailsView
extends CaptureDetailsView {
    private static final Pattern COMPOSABLE_TRACE_EVENT_PATTERN = Pattern.compile("^(.*) \\((.*\\.(kt|java)):(-?\\d+)\\)$");
    @NotNull
    protected final JPanel myPanel;
    @NotNull
    protected final AspectObserver myObserver = new AspectObserver();

    private ChartDetailsView(@NotNull StudioProfilersView profilersView, @NotNull CaptureDetails.ChartDetails chartDetails) {
        super(profilersView);
        if (chartDetails.getNode() == null) {
            this.myPanel = ChartDetailsView.getNoDataForThread();
            return;
        }
        this.myPanel = new JPanel(new CardLayout());
        this.myPanel.add((Component)ChartDetailsView.getNoDataForRange(), "Empty content");
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        return this.myPanel;
    }

    @NotNull
    protected HTreeChart<CaptureNode> createChart(@NotNull CaptureDetails.ChartDetails chartDetails, @NotNull Range globalRange, @NotNull Range range) {
        CaptureDetails.Type type = chartDetails.getType();
        CaptureNode node = chartDetails.getNode();
        HTreeChart.Orientation orientation = type == CaptureDetails.Type.CALL_CHART ? HTreeChart.Orientation.TOP_DOWN : HTreeChart.Orientation.BOTTOM_UP;
        HTreeChart chart2 = new HTreeChart.Builder((HNode)node, range, (HRenderer)new CaptureNodeHRenderer(type)).setGlobalXRange(globalRange).setOrientation(orientation).setRootVisible(false).build();
        if (node != null) {
            if (node.getData().getId().isEmpty() && node.getChildCount() > 0) {
                node = (CaptureNode)node.getFirstChild();
            }
            if (node.getData() instanceof SystemTraceNodeModel) {
                if (type == CaptureDetails.Type.CALL_CHART) {
                    chart2.addMouseMotionListener((MouseMotionListener)new CpuTraceEventTooltipView((HTreeChart<CaptureNode>)chart2, this.myProfilersView.getComponent(), ProfilerColors.CPU_USAGE_CAPTURED, ProfilerColors.CPU_TRACE_IDLE));
                } else {
                    chart2.addMouseMotionListener((MouseMotionListener)new CpuTraceEventTooltipView((HTreeChart<CaptureNode>)chart2, this.myProfilersView.getComponent(), ProfilerColors.CPU_FLAMECHART_APP, ProfilerColors.CPU_FLAMECHART_APP_IDLE));
                }
            } else {
                chart2.addMouseMotionListener((MouseMotionListener)new CpuChartTooltipView((HTreeChart<CaptureNode>)chart2, this.myProfilersView.getStudioProfilers().getTimeline().getDataRange(), this.myProfilersView.getComponent()));
            }
        }
        if (chartDetails.getCapture().getSystemTraceData() == null) {
            IdeProfilerServices ideServices = this.myProfilersView.getStudioProfilers().getStage().getStudioProfilers().getIdeServices();
            CodeNavigator navigator = ideServices.getCodeNavigator();
            FeatureConfig featureConfig = ideServices.getFeatureConfig();
            CodeNavigationHandler handler2 = new CodeNavigationHandler((HTreeChart<CaptureNode>)chart2, navigator, featureConfig);
            chart2.addMouseListener((MouseListener)handler2);
            this.myProfilersView.getIdeProfilerComponents().createContextMenuInstaller().installNavigationContextMenu((JComponent)chart2, navigator, handler2::getCodeLocation);
        }
        return chart2;
    }

    @Nullable
    protected static CodeLocation modelToCodeLocation(CaptureNodeModel model, FeatureConfig featureConfig) {
        if (model instanceof CppFunctionModel) {
            CppFunctionModel nativeFunction = (CppFunctionModel)model;
            return new CodeLocation.Builder(nativeFunction.getClassOrNamespace()).setMethodName(nativeFunction.getName()).setMethodParameters(nativeFunction.getParameters()).setNativeCode(true).setFileName(nativeFunction.getFileName()).setNativeVAddress(nativeFunction.getVAddress()).build();
        }
        if (model instanceof JavaMethodModel) {
            JavaMethodModel javaMethod = (JavaMethodModel)model;
            return new CodeLocation.Builder(javaMethod.getClassName()).setMethodName(javaMethod.getName()).setMethodSignature(javaMethod.getSignature()).setNativeCode(false).build();
        }
        if (model instanceof SystemTraceNodeModel && featureConfig.isComposeTracingNavigateToSourceEnabled()) {
            SystemTraceNodeModel systemTraceNodeModel = (SystemTraceNodeModel)model;
            Matcher matcher = COMPOSABLE_TRACE_EVENT_PATTERN.matcher(systemTraceNodeModel.getName());
            if (!matcher.find()) {
                return null;
            }
            return new CodeLocation.Builder((String)null).setFullComposableName(matcher.group(1)).setFileName(matcher.group(2)).setLineNumber(Integer.parseInt(matcher.group(4))).build();
        }
        return null;
    }

    public static final class FlameChartDetailsView
    extends ChartDetailsView {
        @NotNull
        private final HTreeChart<CaptureNode> myChart;
        @NotNull
        private final CaptureDetails.FlameChart myFlameChart;
        @NotNull
        private final Range myMasterRange;

        public FlameChartDetailsView(@NotNull StudioProfilersView profilersView, @NotNull CaptureDetails.FlameChart flameChart) {
            super(profilersView, flameChart);
            this.myFlameChart = flameChart;
            this.myMasterRange = new Range(this.myFlameChart.getRange());
            this.myChart = this.createChart(this.myFlameChart, this.myFlameChart.getRange(), this.myMasterRange);
            if (this.myFlameChart.getNode() == null) {
                return;
            }
            this.myPanel.add((Component)this.createChartPanel(), "Content");
            this.myFlameChart.getAspect().addDependency(this.myObserver).onChange((Enum)CaptureDetails.FlameChart.Aspect.NODE, this::nodeChanged);
            this.nodeChanged();
        }

        @Override
        public void onRemoved() {
            this.myFlameChart.onRemoved();
        }

        @Override
        public void onReattached() {
            this.myFlameChart.onReattached();
        }

        @NotNull
        private JPanel createChartPanel() {
            RangeTimeScrollBar horizontalScrollBar = new RangeTimeScrollBar(this.myFlameChart.getRange(), this.myMasterRange, TimeUnit.MICROSECONDS);
            horizontalScrollBar.setPreferredSize(new Dimension(horizontalScrollBar.getPreferredSize().width, 10));
            JPanel panel = new JPanel((LayoutManager)new TabularLayout("*,Fit", "*,Fit"));
            panel.setBorder(AdtUiUtils.DEFAULT_TOP_BORDER);
            panel.setBackground((Color)StudioColorsKt.getPrimaryContentBackground());
            panel.add((Component)this.myChart, new TabularLayout.Constraint(0, 0));
            panel.add((Component)new HTreeChartVerticalScrollBar(this.myChart), new TabularLayout.Constraint(0, 1));
            panel.add((Component)horizontalScrollBar, new TabularLayout.Constraint(1, 0, 1, 2));
            return panel;
        }

        private void nodeChanged() {
            FlameChartDetailsView.switchCardLayout(this.myPanel, this.myFlameChart.getNode() == null);
            this.myChart.setHTree((HNode)this.myFlameChart.getNode());
            this.myMasterRange.set(this.myFlameChart.getRange());
        }
    }

    public static final class CallChartDetailsView
    extends ChartDetailsView {
        @NotNull
        private final HTreeChart<CaptureNode> myChart;
        @NotNull
        private final CaptureDetails.CallChart myCallChart;

        public CallChartDetailsView(@NotNull StudioProfilersView profilersView, @NotNull CaptureDetails.CallChart callChart) {
            super(profilersView, callChart);
            this.myCallChart = callChart;
            this.myChart = this.createChart(this.myCallChart, callChart.getCapture().getRange(), profilersView.getStudioProfilers().getTimeline().getSelectionRange());
            if (this.myCallChart.getNode() == null) {
                return;
            }
            this.myPanel.add((Component)this.createChartPanel(), "Content");
            this.myCallChart.getRange().addDependency(this.myObserver).onChange((Enum)Range.Aspect.RANGE, this::callChartRangeChanged);
            this.callChartRangeChanged();
        }

        @Override
        public void onRemoved() {
        }

        @Override
        public void onReattached() {
        }

        @NotNull
        private JPanel createChartPanel() {
            Range selectionRange = this.myProfilersView.getStudioProfilers().getTimeline().getSelectionRange();
            Range captureRange = this.myCallChart.getCapture().getRange();
            RangeTimeScrollBar horizontalScrollBar = new RangeTimeScrollBar(captureRange, selectionRange, TimeUnit.MICROSECONDS);
            horizontalScrollBar.setPreferredSize(new Dimension(horizontalScrollBar.getPreferredSize().width, 10));
            AxisComponent axis = CallChartDetailsView.createAxis(selectionRange, this.myProfilersView.getStudioProfilers().getTimeline().getDataRange());
            JPanel panel = new JPanel((LayoutManager)new TabularLayout("*,Fit", "*,Fit"));
            panel.add((Component)axis, new TabularLayout.Constraint(0, 0));
            panel.add((Component)this.myChart, new TabularLayout.Constraint(0, 0));
            panel.add((Component)new HTreeChartVerticalScrollBar(this.myChart), new TabularLayout.Constraint(0, 1));
            panel.add((Component)horizontalScrollBar, new TabularLayout.Constraint(1, 0, 1, 2));
            return panel;
        }

        private void callChartRangeChanged() {
            CaptureNode node = this.myCallChart.getNode();
            assert (node != null);
            CallChartDetailsView.switchCardLayout(this.myPanel, this.myCallChart.getRange().getIntersectionLength((double)node.getStart(), (double)node.getEnd()) == 0.0);
        }

        private static AxisComponent createAxis(@NotNull Range range, @NotNull Range globalRange) {
            ResizingAxisComponentModel axisModel = new ResizingAxisComponentModel.Builder(range, (BaseAxisFormatter)new TimeAxisFormatter(1, 10, 1)).setGlobalRange(globalRange).build();
            final AxisComponent axis = new AxisComponent((AxisComponentModel)axisModel, AxisComponent.AxisOrientation.BOTTOM, true);
            axis.setShowAxisLine(false);
            axis.setMarkerColor(ProfilerColors.CPU_AXIS_GUIDE_COLOR);
            axis.addComponentListener((ComponentListener)new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    axis.setMarkerLengths(axis.getHeight(), 0);
                    axis.repaint();
                }
            });
            return axis;
        }
    }
}

