/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.analysis;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.adtui.model.formatter.TimeFormatter;
import com.android.tools.adtui.ui.HideablePanel;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.StudioProfilersView;
import com.android.tools.profilers.cpu.JankyFrameTrackRendererKt;
import com.android.tools.profilers.cpu.LazyDataSeries;
import com.android.tools.profilers.cpu.ThreadState;
import com.android.tools.profilers.cpu.analysis.CpuAnalysisSummaryTabModel;
import com.android.tools.profilers.cpu.analysis.CpuThreadStateTable;
import com.android.tools.profilers.cpu.analysis.EventTable;
import com.android.tools.profilers.cpu.analysis.FilledLabel;
import com.android.tools.profilers.cpu.analysis.JankAnalysisModel;
import com.android.tools.profilers.cpu.analysis.JankSummaryDetailsViewKt;
import com.android.tools.profilers.cpu.analysis.SummaryDetailsViewBase;
import com.android.tools.profilers.cpu.systemtrace.AndroidFrameTimelineEvent;
import com.android.tools.profilers.cpu.systemtrace.AndroidFrameTimelineModelKt;
import com.android.tools.profilers.cpu.systemtrace.SystemTraceCpuCapture;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/profilers/cpu/analysis/JankSummaryDetailsView;", "Lcom/android/tools/profilers/cpu/analysis/SummaryDetailsViewBase;", "Lcom/android/tools/profilers/cpu/analysis/JankAnalysisModel$Summary;", "profilersView", "Lcom/android/tools/profilers/StudioProfilersView;", "model", "(Lcom/android/tools/profilers/StudioProfilersView;Lcom/android/tools/profilers/cpu/analysis/JankAnalysisModel$Summary;)V", "intellij.android.profilers.ui"})
@StabilityInferred(parameters=0)
public final class JankSummaryDetailsView
extends SummaryDetailsViewBase<JankAnalysisModel.Summary> {
    public static final int $stable;

    /*
     * WARNING - void declaration
     */
    public JankSummaryDetailsView(@NotNull StudioProfilersView profilersView, final @NotNull JankAnalysisModel.Summary model) {
        void $this$_init__u24lambda_u241;
        JBLabel jBLabel;
        Intrinsics.checkNotNullParameter((Object)((Object)profilersView), (String)"profilersView");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        super(profilersView, (CpuAnalysisSummaryTabModel)model);
        SystemTraceCpuCapture capture = model.getCapture();
        AndroidFrameTimelineEvent event = model.getEvent();
        JBLabel jBLabel2 = jBLabel = new JBLabel(AndroidFrameTimelineModelKt.getTitle(event.getAppJankType()));
        String string = "Jank type";
        JankSummaryDetailsView jankSummaryDetailsView = this;
        boolean bl = false;
        $this$_init__u24lambda_u241.setForeground((Color)JankyFrameTrackRendererKt.getActiveColor(event));
        Unit unit = Unit.INSTANCE;
        jankSummaryDetailsView.addRowToCommonSection(string, (JComponent)jBLabel);
        this.addRowToCommonSection("Layer name:", (JComponent)JankSummaryDetailsViewKt.access$abbreviatedLabel(event.getLayerName()));
        this.addRowToCommonSection("Display timing", (JComponent)new JBLabel(AndroidFrameTimelineModelKt.getTitle(event.getPresentType())));
        jBLabel = event.getExpectedDurationUs() < event.getActualDurationUs() ? TuplesKt.to((Object)((int)(event.getExpectedDurationUs() * (long)100 / event.getActualDurationUs())), (Object)100) : (event.getExpectedDurationUs() > 0L ? TuplesKt.to((Object)100, (Object)((int)(event.getActualDurationUs() * (long)100 / event.getExpectedDurationUs()))) : TuplesKt.to((Object)100, (Object)100));
        int expectedPercent = ((Number)jBLabel.component1()).intValue();
        int actualPercent = ((Number)jBLabel.component2()).intValue();
        int maxDurationBarWidth = 100;
        String string2 = TimeFormatter.getSingleUnitDurationString((long)event.getExpectedDurationUs());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getSingleUnitDurationStr\u2026event.expectedDurationUs)");
        Color color = ProfilerColors.CAPTURE_SPARKLINE;
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"CAPTURE_SPARKLINE");
        this.addRowToCommonSection("Expected duration", (JComponent)((Object)new FilledLabel(string2, color, expectedPercent, maxDurationBarWidth)));
        String string3 = TimeFormatter.getSingleUnitDurationString((long)event.getActualDurationUs());
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getSingleUnitDurationStr\u2026g(event.actualDurationUs)");
        this.addRowToCommonSection("Actual duration", (JComponent)((Object)new FilledLabel(string3, (Color)JankyFrameTrackRendererKt.getActiveColor(event), actualPercent, maxDurationBarWidth)));
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)JankSummaryDetailsViewKt.access$descendants(model.getSequence().getRenderEvent()), (Object)"Render"), TuplesKt.to((Object)JankSummaryDetailsViewKt.access$descendants(model.getSequence().getGpuEvent()), (Object)"GPU"), TuplesKt.to((Object)JankSummaryDetailsViewKt.access$descendants(model.getSequence().getMainEvent()), (Object)"Main")};
        this.addSection((JComponent)JankSummaryDetailsView._init_$hideablePanel("Events associated with frame", EventTable.INSTANCE.of(capture, pairArray)));
        StudioProfilers studioProfilers = profilersView.getStudioProfilers();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)studioProfilers), (String)"profilersView.studioProfilers");
        this.addSection(new CpuThreadStateTable(studioProfilers, CollectionsKt.listOf(new LazyDataSeries(new Supplier(){

            public final List<SeriesData<ThreadState>> get() {
                return model.getThreadState(model.getCapture().getMainThreadId());
            }
        })), JankSummaryDetailsViewKt.access$range(model.getSequence().getMainEvent()), "Main thread states").getComponent());
        StudioProfilers studioProfilers2 = profilersView.getStudioProfilers();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)studioProfilers2), (String)"profilersView.studioProfilers");
        this.addSection(new CpuThreadStateTable(studioProfilers2, CollectionsKt.listOf(new LazyDataSeries(new Supplier(){

            public final List<SeriesData<ThreadState>> get() {
                return model.getThreadState(model.getCapture().getRenderThreadId());
            }
        })), JankSummaryDetailsViewKt.access$range(model.getSequence().getRenderEvent()), "RenderThread states").getComponent());
    }

    private static final HideablePanel _init_$hideablePanel(String title, JComponent content) {
        HideablePanel hideablePanel;
        HideablePanel $this$hideablePanel_u24lambda_u240 = hideablePanel = new HideablePanel.Builder(title, content).setPanelBorder((Border)JBUI.Borders.empty()).setContentBorder(JBUI.Borders.merge((Border)JBUI.Borders.customLine((Color)((Color)StudioColorsKt.getBorder()), (int)1), (Border)((Border)JBUI.Borders.empty((int)8, (int)0, (int)0, (int)0)), (boolean)true)).build();
        boolean bl = false;
        $this$hideablePanel_u24lambda_u240.setBackground((Color)StudioColorsKt.getPrimaryContentBackground());
        HideablePanel hideablePanel2 = hideablePanel;
        Intrinsics.checkNotNullExpressionValue((Object)hideablePanel2, (String)"Builder(title, content)\n\u2026ntentBackground\n        }");
        return hideablePanel2;
    }
}

