/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.analysis;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.adtui.ui.HideablePanel;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.cpu.ThreadState;
import com.android.tools.profilers.cpu.analysis.CpuThreadStateTableKt;
import com.android.tools.profilers.cpu.analysis.CustomBorderTableCellRenderer;
import com.android.tools.profilers.cpu.analysis.DurationRenderer;
import com.android.tools.profilers.cpu.analysis.IntegerAsStringTableCellRender;
import com.android.tools.profilers.cpu.analysis.PercentRenderer;
import com.android.tools.profilers.cpu.analysis.ThreadStateRow;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\b\u0007\u0018\u00002\u00020\u0001:\u0002\u001d\u001eB3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\u00020\u00168\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u001aR\u001d\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001f"}, d2={"Lcom/android/tools/profilers/cpu/analysis/CpuThreadStateTable;", "", "profilers", "Lcom/android/tools/profilers/StudioProfilers;", "threadStateSeriesList", "", "Lcom/android/tools/adtui/model/DataSeries;", "Lcom/android/tools/profilers/cpu/ThreadState;", "range", "Lcom/android/tools/adtui/model/Range;", "title", "", "(Lcom/android/tools/profilers/StudioProfilers;Ljava/util/List;Lcom/android/tools/adtui/model/Range;Ljava/lang/String;)V", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "getProfilers", "()Lcom/android/tools/profilers/StudioProfilers;", "getRange", "()Lcom/android/tools/adtui/model/Range;", "table", "Ljavax/swing/JTable;", "getTable$annotations", "()V", "getTable", "()Ljavax/swing/JTable;", "getThreadStateSeriesList", "()Ljava/util/List;", "Column", "ThreadStateTableModel", "intellij.android.profilers.ui"})
@StabilityInferred(parameters=0)
public final class CpuThreadStateTable {
    @NotNull
    private final StudioProfilers profilers;
    @NotNull
    private final List<DataSeries<ThreadState>> threadStateSeriesList;
    @NotNull
    private final Range range;
    @NotNull
    private final JComponent component;
    @NotNull
    private final JTable table;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public CpuThreadStateTable(@NotNull StudioProfilers profilers, @NotNull List<? extends DataSeries<ThreadState>> threadStateSeriesList, @NotNull Range range, @NotNull String title) {
        void $this$_init__u24lambda_u242;
        HideablePanel hideablePanel;
        JPanel $this$_init__u24lambda_u240;
        JBTable jBTable;
        Intrinsics.checkNotNullParameter((Object)((Object)profilers), (String)"profilers");
        Intrinsics.checkNotNullParameter(threadStateSeriesList, (String)"threadStateSeriesList");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        this.profilers = profilers;
        this.threadStateSeriesList = threadStateSeriesList;
        this.range = range;
        JBTable jBTable2 = jBTable = new JBTable((TableModel)new ThreadStateTableModel());
        CpuThreadStateTable cpuThreadStateTable = this;
        boolean bl = false;
        $this$_init__u24lambda_u240.setAutoCreateRowSorter(true);
        $this$_init__u24lambda_u240.setShowVerticalLines(true);
        $this$_init__u24lambda_u240.setShowHorizontalLines(false);
        $this$_init__u24lambda_u240.getColumnModel().getColumn(Column.THREAD_STATE.ordinal()).setCellRenderer(new CustomBorderTableCellRenderer(null, 1, null));
        $this$_init__u24lambda_u240.getColumnModel().getColumn(Column.TIME.ordinal()).setCellRenderer(new DurationRenderer(null, 1, null));
        $this$_init__u24lambda_u240.getColumnModel().getColumn(Column.PERCENT.ordinal()).setCellRenderer(new PercentRenderer(null, 1, null));
        $this$_init__u24lambda_u240.getColumnModel().getColumn(Column.OCCURRENCES.ordinal()).setCellRenderer(new IntegerAsStringTableCellRender(null, 1, null));
        cpuThreadStateTable.table = (JTable)jBTable;
        JPanel $this$_init__u24lambda_u241 = $this$_init__u24lambda_u240 = new JPanel((LayoutManager)new TabularLayout("*", "Fit,Fit"));
        boolean bl2 = false;
        $this$_init__u24lambda_u241.setBorder(JBUI.Borders.customLine((Color)((Color)StudioColorsKt.getBorder()), (int)2));
        $this$_init__u24lambda_u241.setOpaque(false);
        $this$_init__u24lambda_u241.add((Component)((JBTable)this.table).getTableHeader(), new TabularLayout.Constraint(0, 0, 0, 4, null));
        $this$_init__u24lambda_u241.add((Component)this.table, new TabularLayout.Constraint(1, 0, 0, 4, null));
        JPanel tableContainer = $this$_init__u24lambda_u240;
        Border border = JBUI.Borders.merge((Border)JBUI.Borders.customLine((Color)((Color)StudioColorsKt.getBorder()), (int)1), (Border)((Border)JBUI.Borders.empty((int)8, (int)0, (int)0, (int)0)), (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)border, (String)"merge(JBUI.Borders.custo\u2026.empty(8, 0, 0, 0), true)");
        Border contentBorder = border;
        HideablePanel hideablePanel2 = hideablePanel = new HideablePanel.Builder(title, (JComponent)tableContainer).setPanelBorder((Border)JBUI.Borders.empty()).setContentBorder(contentBorder).build();
        cpuThreadStateTable = this;
        boolean bl3 = false;
        $this$_init__u24lambda_u242.setBackground((Color)StudioColorsKt.getPrimaryContentBackground());
        HideablePanel hideablePanel3 = hideablePanel;
        Intrinsics.checkNotNullExpressionValue((Object)hideablePanel3, (String)"Builder(title, tableCont\u2026ContentBackground\n      }");
        cpuThreadStateTable.component = (JComponent)hideablePanel3;
    }

    public /* synthetic */ CpuThreadStateTable(StudioProfilers studioProfilers, List list, Range range, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            string = "States";
        }
        this(studioProfilers, list, range, string);
    }

    @NotNull
    public final StudioProfilers getProfilers() {
        return this.profilers;
    }

    @NotNull
    public final List<DataSeries<ThreadState>> getThreadStateSeriesList() {
        return this.threadStateSeriesList;
    }

    @NotNull
    public final Range getRange() {
        return this.range;
    }

    @NotNull
    public final JComponent getComponent() {
        return this.component;
    }

    @NotNull
    public final JTable getTable() {
        return this.table;
    }

    @VisibleForTesting
    public static /* synthetic */ void getTable$annotations() {
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u001b\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0015\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nj\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/profilers/cpu/analysis/CpuThreadStateTable$Column;", "", "displayName", "", "type", "Ljava/lang/Class;", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/Class;)V", "getDisplayName", "()Ljava/lang/String;", "getType", "()Ljava/lang/Class;", "getValueFrom", "", "data", "Lcom/android/tools/profilers/cpu/analysis/ThreadStateRow;", "THREAD_STATE", "TIME", "PERCENT", "OCCURRENCES", "intellij.android.profilers.ui"})
    private static final abstract class Column
    extends Enum<Column> {
        @NotNull
        private final String displayName;
        @NotNull
        private final Class<?> type;
        public static final /* enum */ Column THREAD_STATE = new THREAD_STATE("THREAD_STATE", 0);
        public static final /* enum */ Column TIME = new TIME("TIME", 1);
        public static final /* enum */ Column PERCENT = new PERCENT("PERCENT", 2);
        public static final /* enum */ Column OCCURRENCES = new OCCURRENCES("OCCURRENCES", 3);
        private static final /* synthetic */ Column[] $VALUES;

        private Column(String displayName, Class<?> type) {
            this.displayName = displayName;
            this.type = type;
        }

        @NotNull
        public final String getDisplayName() {
            return this.displayName;
        }

        @NotNull
        public final Class<?> getType() {
            return this.type;
        }

        @NotNull
        public abstract Object getValueFrom(@NotNull ThreadStateRow var1);

        public static Column[] values() {
            return (Column[])$VALUES.clone();
        }

        public static Column valueOf(String value) {
            return Enum.valueOf(Column.class, value);
        }

        public /* synthetic */ Column(String $enum$name, int $enum$ordinal, String displayName, Class type, DefaultConstructorMarker $constructor_marker) {
            this(displayName, type);
        }

        static {
            $VALUES = columnArray = new Column[]{Column.THREAD_STATE, Column.TIME, Column.PERCENT, Column.OCCURRENCES};
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/profilers/cpu/analysis/CpuThreadStateTable$Column$OCCURRENCES;", "Lcom/android/tools/profilers/cpu/analysis/CpuThreadStateTable$Column;", "getValueFrom", "", "data", "Lcom/android/tools/profilers/cpu/analysis/ThreadStateRow;", "intellij.android.profilers.ui"})
        static final class OCCURRENCES
        extends Column {
            /*
             * WARNING - void declaration
             */
            OCCURRENCES() {
                void var1_1;
            }

            @Override
            @NotNull
            public Object getValueFrom(@NotNull ThreadStateRow data) {
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                return data.getOccurrences();
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/profilers/cpu/analysis/CpuThreadStateTable$Column$PERCENT;", "Lcom/android/tools/profilers/cpu/analysis/CpuThreadStateTable$Column;", "getValueFrom", "", "data", "Lcom/android/tools/profilers/cpu/analysis/ThreadStateRow;", "intellij.android.profilers.ui"})
        static final class PERCENT
        extends Column {
            /*
             * WARNING - void declaration
             */
            PERCENT() {
                void var1_1;
            }

            @Override
            @NotNull
            public Object getValueFrom(@NotNull ThreadStateRow data) {
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                return data.getPercentage();
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/profilers/cpu/analysis/CpuThreadStateTable$Column$THREAD_STATE;", "Lcom/android/tools/profilers/cpu/analysis/CpuThreadStateTable$Column;", "getValueFrom", "", "data", "Lcom/android/tools/profilers/cpu/analysis/ThreadStateRow;", "intellij.android.profilers.ui"})
        static final class THREAD_STATE
        extends Column {
            /*
             * WARNING - void declaration
             */
            THREAD_STATE() {
                void var1_1;
            }

            @Override
            @NotNull
            public Object getValueFrom(@NotNull ThreadStateRow data) {
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                return data.getThreadState().getDisplayName();
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/profilers/cpu/analysis/CpuThreadStateTable$Column$TIME;", "Lcom/android/tools/profilers/cpu/analysis/CpuThreadStateTable$Column;", "getValueFrom", "", "data", "Lcom/android/tools/profilers/cpu/analysis/ThreadStateRow;", "intellij.android.profilers.ui"})
        static final class TIME
        extends Column {
            /*
             * WARNING - void declaration
             */
            TIME() {
                void var1_1;
            }

            @Override
            @NotNull
            public Object getValueFrom(@NotNull ThreadStateRow data) {
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                return data.getDuration();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\b\u001a\u00020\tH\u0002J\u0014\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\rH\u0016J\b\u0010\u0012\u001a\u00020\rH\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/profilers/cpu/analysis/CpuThreadStateTable$ThreadStateTableModel;", "Ljavax/swing/table/AbstractTableModel;", "(Lcom/android/tools/profilers/cpu/analysis/CpuThreadStateTable;)V", "dataRows", "", "Lcom/android/tools/profilers/cpu/analysis/ThreadStateRow;", "observer", "Lcom/android/tools/adtui/model/AspectObserver;", "computeDistribution", "", "getColumnClass", "Ljava/lang/Class;", "columnIndex", "", "getColumnCount", "getColumnName", "", "column", "getRowCount", "getValueAt", "", "rowIndex", "intellij.android.profilers.ui"})
    @SourceDebugExtension(value={"SMAP\nCpuThreadStateTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CpuThreadStateTable.kt\ncom/android/tools/profilers/cpu/analysis/CpuThreadStateTable$ThreadStateTableModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,202:1\n1851#2:203\n1852#2:213\n1054#2:214\n1291#3:204\n1292#3:212\n359#4,7:205\n*S KotlinDebug\n*F\n+ 1 CpuThreadStateTable.kt\ncom/android/tools/profilers/cpu/analysis/CpuThreadStateTable$ThreadStateTableModel\n*L\n124#1:203\n124#1:213\n151#1:214\n132#1:204\n132#1:212\n135#1:205,7\n*E\n"})
    private final class ThreadStateTableModel
    extends AbstractTableModel {
        @NotNull
        private final AspectObserver observer = new AspectObserver();
        @NotNull
        private List<ThreadStateRow> dataRows = CollectionsKt.emptyList();

        public ThreadStateTableModel() {
            CpuThreadStateTable.this.getRange().addDependency(this.observer).onChange((Enum)Range.Aspect.RANGE, new Runnable(){

                @Override
                public final void run() {
                    this.computeDistribution();
                }
            });
            this.computeDistribution();
        }

        @Override
        public int getRowCount() {
            return this.dataRows.size();
        }

        @Override
        public int getColumnCount() {
            return Column.values().length;
        }

        @Override
        @NotNull
        public Object getValueAt(int rowIndex, int columnIndex) {
            return Column.values()[columnIndex].getValueFrom(this.dataRows.get(rowIndex));
        }

        @Override
        @NotNull
        public Class<?> getColumnClass(int columnIndex) {
            return Column.values()[columnIndex].getType();
        }

        @Override
        @NotNull
        public String getColumnName(int column) {
            return Column.values()[column].getDisplayName();
        }

        /*
         * WARNING - void declaration
         */
        private final void computeDistribution() {
            void $this$forEach$iv;
            EnumMap threadStateToRow = new EnumMap(ThreadState.class);
            double totalDuration = CpuThreadStateTable.this.getRange().getLength() * (double)CpuThreadStateTable.this.getThreadStateSeriesList().size();
            Iterable iterable = CpuThreadStateTable.this.getThreadStateSeriesList();
            CpuThreadStateTable cpuThreadStateTable = CpuThreadStateTable.this;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$forEach$iv2;
                DataSeries threadStateSeries = (DataSeries)element$iv;
                boolean bl = false;
                long nextTimestamp = 0L;
                nextTimestamp = (long)cpuThreadStateTable.getRange().getMax();
                Sequence sequence = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)CollectionsKt.asReversed((List)threadStateSeries.getDataForRange(cpuThreadStateTable.getRange()))), (Function1)((Function1)new Function1<SeriesData<ThreadState>, Boolean>(cpuThreadStateTable){
                    final /* synthetic */ CpuThreadStateTable this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull SeriesData<ThreadState> it) {
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        return it.x < (long)this.this$0.getRange().getMax();
                    }
                }));
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    Object object;
                    void $this$getOrPut$iv;
                    SeriesData threadStateDataPoint = (SeriesData)element$iv2;
                    boolean bl2 = false;
                    Map map = threadStateToRow;
                    Object key$iv = threadStateDataPoint.value;
                    boolean $i$f$getOrPut = false;
                    Object value$iv = $this$getOrPut$iv.get(key$iv);
                    if (value$iv == null) {
                        boolean bl3 = false;
                        ThreadStateRow answer$iv = new ThreadStateRow((ThreadState)((Object)threadStateDataPoint.value), totalDuration, 0L, 0L, 12, null);
                        $this$getOrPut$iv.put(key$iv, answer$iv);
                        object = answer$iv;
                    } else {
                        object = value$iv;
                    }
                    map = object;
                    ThreadStateRow $this$computeDistribution_u24lambda_u243_u24lambda_u242_u24lambda_u241 = (ThreadStateRow)((Object)map);
                    boolean bl4 = false;
                    long duration = nextTimestamp - Math.max((long)cpuThreadStateTable.getRange().getMin(), threadStateDataPoint.x);
                    if (duration >= 0L) {
                        $this$computeDistribution_u24lambda_u243_u24lambda_u242_u24lambda_u241.setDuration($this$computeDistribution_u24lambda_u243_u24lambda_u242_u24lambda_u241.getDuration() + duration);
                        $this$computeDistribution_u24lambda_u243_u24lambda_u242_u24lambda_u241.setOccurrences($this$computeDistribution_u24lambda_u243_u24lambda_u242_u24lambda_u241.getOccurrences() + 1L);
                        nextTimestamp = threadStateDataPoint.x;
                        continue;
                    }
                    CpuThreadStateTableKt.access$getLogger().warn("Negative duration in thread state table: " + duration + ".");
                }
            }
            Collection collection = threadStateToRow.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"threadStateToRow.values");
            Iterable $this$sortedByDescending$iv = CollectionsKt.toList((Iterable)collection);
            boolean $i$f$sortedByDescending = false;
            this.dataRows = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    ThreadStateRow it = (ThreadStateRow)b;
                    boolean bl = false;
                    Comparable comparable = Long.valueOf(it.getDuration());
                    it = (ThreadStateRow)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getDuration()));
                }
            });
            this.fireTableDataChanged();
        }
    }
}

