/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.analysis;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.adtui.StatLabel;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.ui.HideablePanel;
import com.android.tools.profilers.ProfilerFonts;
import com.android.tools.profilers.StudioProfilersView;
import com.android.tools.profilers.cpu.CaptureNode;
import com.android.tools.profilers.cpu.analysis.CaptureNodeAnalysisModel;
import com.android.tools.profilers.cpu.analysis.CaptureNodeAnalysisStats;
import com.android.tools.profilers.cpu.analysis.CaptureNodeAnalysisSummaryTabModel;
import com.android.tools.profilers.cpu.analysis.CaptureNodeDetailTable;
import com.android.tools.profilers.cpu.analysis.CaptureNodeSummaryDetailsView;
import com.android.tools.profilers.cpu.analysis.CpuAnalysisSummaryTabModel;
import com.android.tools.profilers.cpu.analysis.SummaryDetailsViewBase;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0002R\u0013\u0010\u0007\u001a\u00020\b8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u000b\u001a\u00020\b8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/profilers/cpu/analysis/CaptureNodeSummaryDetailsView;", "Lcom/android/tools/profilers/cpu/analysis/SummaryDetailsViewBase;", "Lcom/android/tools/profilers/cpu/analysis/CaptureNodeAnalysisSummaryTabModel;", "profilersView", "Lcom/android/tools/profilers/StudioProfilersView;", "tabModel", "(Lcom/android/tools/profilers/StudioProfilersView;Lcom/android/tools/profilers/cpu/analysis/CaptureNodeAnalysisSummaryTabModel;)V", "dataTypeLabel", "Ljavax/swing/JLabel;", "getDataTypeLabel", "()Ljavax/swing/JLabel;", "timeRangeLabel", "getTimeRangeLabel", "buildAllOccurrencesSection", "Ljavax/swing/JComponent;", "model", "Lcom/android/tools/profilers/cpu/analysis/CaptureNodeAnalysisModel;", "buildSelectedNodeTable", "Ljavax/swing/JPanel;", "intellij.android.profilers.ui"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nCaptureNodeSummaryDetailsView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CaptureNodeSummaryDetailsView.kt\ncom/android/tools/profilers/cpu/analysis/CaptureNodeSummaryDetailsView\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,113:1\n1549#2:114\n1620#2,3:115\n*S KotlinDebug\n*F\n+ 1 CaptureNodeSummaryDetailsView.kt\ncom/android/tools/profilers/cpu/analysis/CaptureNodeSummaryDetailsView\n*L\n58#1:114\n58#1:115,3\n*E\n"})
public final class CaptureNodeSummaryDetailsView
extends SummaryDetailsViewBase<CaptureNodeAnalysisSummaryTabModel> {
    @NotNull
    private final JLabel timeRangeLabel;
    @NotNull
    private final JLabel dataTypeLabel;
    public static final int $stable = 8;

    public CaptureNodeSummaryDetailsView(@NotNull StudioProfilersView profilersView, @NotNull CaptureNodeAnalysisSummaryTabModel tabModel) {
        Intrinsics.checkNotNullParameter((Object)((Object)profilersView), (String)"profilersView");
        Intrinsics.checkNotNullParameter((Object)tabModel, (String)"tabModel");
        super(profilersView, (CpuAnalysisSummaryTabModel)tabModel);
        this.timeRangeLabel = new JLabel();
        this.dataTypeLabel = new JLabel();
        Range range = tabModel.getSelectionRange();
        this.timeRangeLabel.setText(this.formatTimeRangeAsString(range));
        this.dataTypeLabel.setText(tabModel.getLabel());
        this.addRowToCommonSection("Time Range", this.timeRangeLabel);
        this.addRowToCommonSection("Data Type", this.dataTypeLabel);
        this.addSection(this.buildSelectedNodeTable());
        if (tabModel.getDataSeries().size() == 1) {
            Object t = tabModel.getDataSeries().get(0);
            Intrinsics.checkNotNullExpressionValue(t, (String)"tabModel.dataSeries[0]");
            this.addSection(this.buildAllOccurrencesSection((CaptureNodeAnalysisModel)t));
        }
    }

    @VisibleForTesting
    @NotNull
    public final JLabel getTimeRangeLabel() {
        return this.timeRangeLabel;
    }

    @VisibleForTesting
    @NotNull
    public final JLabel getDataTypeLabel() {
        return this.dataTypeLabel;
    }

    /*
     * WARNING - void declaration
     */
    private final JPanel buildSelectedNodeTable() {
        String string;
        Object object;
        void $this$mapTo$iv$iv;
        JPanel jPanel;
        JPanel $this$buildSelectedNodeTable_u24lambda_u242 = jPanel = new JPanel((LayoutManager)new TabularLayout("*").setVGap(8));
        boolean bl = false;
        List list = ((CaptureNodeAnalysisSummaryTabModel)this.getTabModel()).getDataSeries();
        Intrinsics.checkNotNullExpressionValue(list, (String)"tabModel.dataSeries");
        Iterable $this$map$iv = list;
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CaptureNodeAnalysisModel captureNodeAnalysisModel = (CaptureNodeAnalysisModel)item$iv$iv;
            object = destination$iv$iv;
            boolean bl2 = false;
            object.add(it.getNode());
        }
        List selectedNodes = (List)destination$iv$iv;
        String $i$f$map22 = string = "Selected event";
        object = $this$buildSelectedNodeTable_u24lambda_u242;
        boolean bl3 = false;
        $this$buildSelectedNodeTable_u24lambda_u242.setFont(ProfilerFonts.H3_FONT);
        $this$buildSelectedNodeTable_u24lambda_u242.setOpaque(false);
        String string2 = string;
        ((Container)object).add((Component)new JLabel(string2), new TabularLayout.Constraint(0, 0, 0, 4, null));
        Range range = ((CaptureNodeAnalysisSummaryTabModel)this.getTabModel()).getCaptureRange();
        Intrinsics.checkNotNullExpressionValue((Object)range, (String)"tabModel.captureRange");
        $this$buildSelectedNodeTable_u24lambda_u242.add((Component)new CaptureNodeDetailTable(selectedNodes, range, null, 0, 12, null).getComponent(), new TabularLayout.Constraint(1, 0, 0, 4, null));
        return jPanel;
    }

    /*
     * WARNING - void declaration
     */
    private final JComponent buildAllOccurrencesSection(CaptureNodeAnalysisModel model) {
        JPanel jPanel;
        void $this$buildAllOccurrencesSection_u24lambda_u246_u24lambda_u244_u24lambda_u243;
        StatLabel statLabel;
        void $this$buildAllOccurrencesSection_u24lambda_u246_u24lambda_u244;
        JPanel jPanel2;
        CaptureNodeAnalysisStats nodeStats = model.getAllOccurrenceStats();
        JPanel jPanel3 = new JPanel(new FlowLayout(0));
        JComponent $this$buildAllOccurrencesSection_u24lambda_u246 = jPanel3;
        boolean bl = false;
        $this$buildAllOccurrencesSection_u24lambda_u246.setOpaque(false);
        JPanel jPanel4 = jPanel2 = new JPanel(new BorderLayout());
        JPanel jPanel5 = $this$buildAllOccurrencesSection_u24lambda_u246;
        boolean bl2 = false;
        $this$buildAllOccurrencesSection_u24lambda_u246_u24lambda_u244.setOpaque(false);
        $this$buildAllOccurrencesSection_u24lambda_u246_u24lambda_u244.setBorder(JBUI.Borders.customLine((Color)((Color)StudioColorsKt.getBorder()), (int)0, (int)0, (int)0, (int)1));
        long l = nodeStats.getCount();
        Font font = ProfilerFonts.H2_FONT;
        Intrinsics.checkNotNullExpressionValue((Object)font, (String)"H2_FONT");
        Font font2 = ProfilerFonts.H4_FONT;
        Intrinsics.checkNotNullExpressionValue((Object)font2, (String)"H4_FONT");
        StatLabel statLabel2 = statLabel = new StatLabel(l, "Count", font, font2, null, null, 48, null);
        void var13_17 = $this$buildAllOccurrencesSection_u24lambda_u246_u24lambda_u244;
        boolean bl3 = false;
        $this$buildAllOccurrencesSection_u24lambda_u246_u24lambda_u244_u24lambda_u243.setOpaque(false);
        var13_17.add((Component)statLabel);
        jPanel5.add(jPanel2);
        $this$buildAllOccurrencesSection_u24lambda_u246.add((Component)CaptureNodeSummaryDetailsView.buildAllOccurrencesSection$lambda$6$buildDurationLabel((long)nodeStats.getAverage(), "Average"));
        $this$buildAllOccurrencesSection_u24lambda_u246.add((Component)CaptureNodeSummaryDetailsView.buildAllOccurrencesSection$lambda$6$buildDurationLabel(nodeStats.getMax(), "Max"));
        $this$buildAllOccurrencesSection_u24lambda_u246.add((Component)CaptureNodeSummaryDetailsView.buildAllOccurrencesSection$lambda$6$buildDurationLabel(nodeStats.getMin(), "Min"));
        $this$buildAllOccurrencesSection_u24lambda_u246.add((Component)CaptureNodeSummaryDetailsView.buildAllOccurrencesSection$lambda$6$buildDurationLabel((long)nodeStats.getStandardDeviation(), "Std Dev"));
        JPanel statsPanel2 = jPanel3;
        JComponent $this$buildAllOccurrencesSection_u24lambda_u247 = $this$buildAllOccurrencesSection_u24lambda_u246 = new JLabel("Longest running occurrences (select row to navigate)");
        boolean bl4 = false;
        $this$buildAllOccurrencesSection_u24lambda_u247.setOpaque(false);
        $this$buildAllOccurrencesSection_u24lambda_u247.setFont(ProfilerFonts.H3_FONT);
        JComponent topOccurrencesLabel = $this$buildAllOccurrencesSection_u24lambda_u246;
        List<CaptureNode> list = model.getLongestRunningOccurrences(10);
        Range range = ((CaptureNodeAnalysisSummaryTabModel)this.getTabModel()).getCaptureRange();
        Intrinsics.checkNotNullExpressionValue((Object)range, (String)"tabModel.captureRange");
        CaptureNodeDetailTable topOccurrencesTable = new CaptureNodeDetailTable(list, range, this.getProfilersView().getStudioProfilers().getStage().getTimeline().getViewRange(), 0, 8, null);
        JPanel $this$buildAllOccurrencesSection_u24lambda_u248 = jPanel = new JPanel((LayoutManager)new TabularLayout("*", "Fit,Fit,Fit").setVGap(8));
        boolean bl5 = false;
        $this$buildAllOccurrencesSection_u24lambda_u248.setOpaque(false);
        $this$buildAllOccurrencesSection_u24lambda_u248.add((Component)statsPanel2, new TabularLayout.Constraint(0, 0, 0, 4, null));
        $this$buildAllOccurrencesSection_u24lambda_u248.add((Component)topOccurrencesLabel, new TabularLayout.Constraint(1, 0, 0, 4, null));
        $this$buildAllOccurrencesSection_u24lambda_u248.add((Component)topOccurrencesTable.getComponent(), new TabularLayout.Constraint(2, 0, 0, 4, null));
        JPanel panel = jPanel;
        JPanel $this$buildAllOccurrencesSection_u24lambda_u249 = jPanel4 = new HideablePanel.Builder("All Occurrences (" + nodeStats.getCount() + ")", (JComponent)panel).setPanelBorder((Border)JBUI.Borders.empty()).setContentBorder((Border)JBUI.Borders.empty((int)8, (int)0, (int)0, (int)0)).build();
        boolean bl6 = false;
        $this$buildAllOccurrencesSection_u24lambda_u249.setBackground((Color)StudioColorsKt.getPrimaryContentBackground());
        JPanel jPanel6 = jPanel4;
        Intrinsics.checkNotNullExpressionValue((Object)jPanel6, (String)"Builder(\"All Occurrences\u2026ryContentBackground\n    }");
        return jPanel6;
    }

    private static final StatLabel buildAllOccurrencesSection$lambda$6$buildDurationLabel(long num, String desc) {
        StatLabel statLabel;
        Font font = ProfilerFonts.H2_FONT;
        Intrinsics.checkNotNullExpressionValue((Object)font, (String)"H2_FONT");
        Font font2 = ProfilerFonts.H4_FONT;
        Intrinsics.checkNotNullExpressionValue((Object)font2, (String)"H4_FONT");
        StatLabel $this$buildAllOccurrencesSection_u24lambda_u246_u24buildDurationLabel_u24lambda_u245 = statLabel = new StatLabel(num, desc, font, font2, (Function1)buildAllOccurrencesSection.statsPanel.1.buildDurationLabel.1.INSTANCE, null, 32, null);
        boolean bl = false;
        $this$buildAllOccurrencesSection_u24lambda_u246_u24buildDurationLabel_u24lambda_u245.setOpaque(false);
        return statLabel;
    }
}

