/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.AxisComponent;
import com.android.tools.adtui.DragAndDropList;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.event.DelegateMouseEventHandler;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.DragAndDropListModel;
import com.android.tools.adtui.model.Timeline;
import com.android.tools.adtui.ui.HideablePanel;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerTooltipMouseAdapter;
import com.android.tools.profilers.cpu.CpuListScrollPane;
import com.android.tools.profilers.cpu.CpuProfilerAspect;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.CpuThreadsModel;
import com.android.tools.profilers.cpu.CpuThreadsTooltip;
import com.android.tools.profilers.cpu.ThreadCellRenderer;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.jetbrains.annotations.NotNull;

final class CpuThreadsView {
    @NotNull
    private final HideablePanel myPanel;
    @NotNull
    private final CpuProfilerStage myStage;
    @NotNull
    private final DragAndDropList<CpuThreadsModel.RangedCpuThread> myThreads;
    @NotNull
    private final AspectObserver myObserver;
    private int myLastHoveredRow = -1;

    public CpuThreadsView(@NotNull CpuProfilerStage stage) {
        this.myStage = stage;
        this.myThreads = new DragAndDropList((DragAndDropListModel)stage.getThreadStates());
        this.myPanel = this.createHideablePanel();
        this.setupListeners();
        this.myThreads.setBorder(null);
        this.myThreads.setCellRenderer((ListCellRenderer)new ThreadCellRenderer((JList<CpuThreadsModel.RangedCpuThread>)this.myThreads, this.myStage.getUpdatableManager()));
        this.myThreads.setBackground(ProfilerColors.DEFAULT_STAGE_BACKGROUND);
        this.myThreads.getSelectionModel().setSelectionMode(0);
        DelegateMouseEventHandler.delegateTo((Component)this.myPanel).installListenerOn(this.myThreads).installMotionListenerOn(this.myThreads);
        this.myPanel.addStateChangedListener(actionEvent -> this.myStage.getStudioProfilers().getIdeServices().getFeatureTracker().trackToggleCpuThreadsHideablePanel());
        this.myObserver = new AspectObserver();
        stage.getAspect().addDependency(this.myObserver).onChange((Enum)CpuProfilerAspect.SELECTED_THREADS, this::updateThreadSelection);
    }

    @NotNull
    public JComponent getComponent() {
        return this.myPanel;
    }

    @NotNull
    private HideablePanel createHideablePanel() {
        final AxisComponent axisComponent = new AxisComponent(this.myStage.getTimeAxisGuide(), AxisComponent.AxisOrientation.BOTTOM, true);
        axisComponent.setShowAxisLine(false);
        axisComponent.setShowLabels(false);
        axisComponent.setHideTickAtMin(true);
        axisComponent.setMarkerColor(ProfilerColors.CPU_AXIS_GUIDE_COLOR);
        JPanel threads = new JPanel((LayoutManager)new TabularLayout("*", "*"));
        final HideablePanel threadsPanel = new HideablePanel.Builder("THREADS", (JComponent)threads).setShowSeparator(false).setClickableComponent(HideablePanel.ClickableComponent.TITLE).setIconTextGap(6).setTitleLeftPadding(7).build();
        final CpuListScrollPane scrollingThreads = new CpuListScrollPane((JList)this.myThreads, (JComponent)threadsPanel);
        scrollingThreads.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                axisComponent.setMarkerLengths(scrollingThreads.getHeight(), 0);
            }
        });
        threads.add((Component)axisComponent, new TabularLayout.Constraint(0, 0));
        threads.add((Component)((Object)scrollingThreads), new TabularLayout.Constraint(0, 0));
        threadsPanel.setBorder(JBUI.Borders.customLine((Color)ProfilerColors.CPU_AXIS_GUIDE_COLOR, (int)2, (int)0, (int)0, (int)0));
        threadsPanel.setBackground(ProfilerColors.DEFAULT_STAGE_BACKGROUND);
        this.myThreads.getModel().addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                threadsPanel.setTitle(String.format("THREADS (%d)", CpuThreadsView.this.myThreads.getModel().getSize()));
            }
        });
        threads.setBorder((Border)JBUI.Borders.empty());
        return threadsPanel;
    }

    private void setupListeners() {
        CpuThreadsModel model = this.myStage.getThreadStates();
        this.myThreads.addListSelectionListener(e -> {
            int selectedIndex = this.myThreads.getSelectedIndex();
            if (selectedIndex >= 0) {
                CpuThreadsModel.RangedCpuThread thread2 = (CpuThreadsModel.RangedCpuThread)model.getElementAt(selectedIndex);
                if (this.myStage.getSelectedThread() != thread2.getThreadId()) {
                    this.myStage.setSelectedThread(thread2.getThreadId());
                    this.myStage.getStudioProfilers().getIdeServices().getFeatureTracker().trackSelectThread();
                }
            } else {
                this.myStage.setSelectedThread(-1);
            }
        });
        this.myThreads.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (CpuThreadsView.this.myThreads.getSelectedIndex() < 0 && CpuThreadsView.this.myThreads.getModel().getSize() > 0) {
                    CpuThreadsView.this.myThreads.setSelectedIndex(0);
                }
            }
        });
        ProfilerTooltipMouseAdapter adapter = new ProfilerTooltipMouseAdapter(this.myStage, () -> new CpuThreadsTooltip((Timeline)this.myStage.getTimeline())){

            @Override
            public void mouseMoved(MouseEvent e) {
                super.mouseMoved(e);
                this.handleMoved(e);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                super.mouseEntered(e);
                CpuThreadsView.this.myLastHoveredRow = -1;
                this.handleMoved(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                this.repaintLastHoveredRow();
                CpuThreadsView.this.myLastHoveredRow = -1;
                super.mouseExited(e);
            }

            private void handleMoved(MouseEvent e) {
                this.repaintLastHoveredRow();
                CpuThreadsView.this.myLastHoveredRow = CpuThreadsView.this.myThreads.locationToIndex(e.getPoint());
                if (CpuThreadsView.this.myLastHoveredRow != -1) {
                    this.repaintLastHoveredRow();
                    CpuThreadsModel.RangedCpuThread model = (CpuThreadsModel.RangedCpuThread)CpuThreadsView.this.myThreads.getModel().getElementAt(CpuThreadsView.this.myLastHoveredRow);
                    if (CpuThreadsView.this.myStage.getTooltip() instanceof CpuThreadsTooltip) {
                        CpuThreadsTooltip tooltip2 = (CpuThreadsTooltip)CpuThreadsView.this.myStage.getTooltip();
                        tooltip2.setThread(model.getName(), model.getStateSeries());
                    }
                }
            }

            private void repaintLastHoveredRow() {
                Rectangle cellBounds = CpuThreadsView.this.myThreads.getCellBounds(CpuThreadsView.this.myLastHoveredRow, CpuThreadsView.this.myLastHoveredRow);
                if (cellBounds != null) {
                    CpuThreadsView.this.myPanel.repaint(SwingUtilities.convertRectangle(CpuThreadsView.this.myThreads, cellBounds, (Component)CpuThreadsView.this.myPanel));
                }
            }
        };
        this.myThreads.addMouseListener((MouseListener)adapter);
        this.myThreads.addMouseMotionListener((MouseMotionListener)adapter);
    }

    private void updateThreadSelection() {
        if (this.myStage.getSelectedThread() == -1) {
            this.myThreads.clearSelection();
            return;
        }
        for (int i = 0; i < this.myThreads.getModel().getSize(); ++i) {
            CpuThreadsModel.RangedCpuThread thread2 = (CpuThreadsModel.RangedCpuThread)this.myThreads.getModel().getElementAt(i);
            if (this.myStage.getSelectedThread() != thread2.getThreadId()) continue;
            this.myThreads.setSelectedIndex(i);
            break;
        }
    }
}

