/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.DragAndDropListModel;
import com.android.tools.adtui.model.DragAndDropModelListElement;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.adtui.model.StateChartModel;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Cpu;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.cpu.CpuCapture;
import com.android.tools.profilers.cpu.CpuThreadComparator;
import com.android.tools.profilers.cpu.CpuThreadInfo;
import com.android.tools.profilers.cpu.CpuThreadStateDataSeries;
import com.android.tools.profilers.cpu.LazyDataSeries;
import com.android.tools.profilers.cpu.MergeCaptureDataSeries;
import com.android.tools.profilers.cpu.ThreadState;
import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CpuThreadsModel
extends DragAndDropListModel<RangedCpuThread> {
    public static final int NO_THREAD = -1;
    private int myThread = -1;
    @NotNull
    private final StudioProfilers myProfilers;
    @NotNull
    private final Common.Session mySession;
    @NotNull
    private final Range myRange;
    @NotNull
    private final AspectObserver myAspectObserver;

    public CpuThreadsModel(@NotNull Range range, @NotNull StudioProfilers profilers, @NotNull Common.Session session) {
        this.myRange = range;
        this.myProfilers = profilers;
        this.mySession = session;
        this.myAspectObserver = new AspectObserver();
        this.myRange.addDependency(this.myAspectObserver).onChange((Enum)Range.Aspect.RANGE, this::nonImportRangeChanged);
        this.nonImportRangeChanged();
        this.sortElements();
    }

    public void setThread(int thread2) {
        if (this.myThread == thread2) {
            return;
        }
        this.myThread = thread2;
    }

    public int getThread() {
        return this.myThread;
    }

    private void nonImportRangeChanged() {
        long minNs = TimeUnit.MICROSECONDS.toNanos((long)this.myRange.getMin());
        long maxNs = TimeUnit.MICROSECONDS.toNanos((long)this.myRange.getMax());
        HashMap<Integer, RangedCpuThread> requestedThreadsRangedCpuThreads = new HashMap<Integer, RangedCpuThread>();
        Transport.GetEventGroupsResponse response = this.myProfilers.getClient().getTransportClient().getEventGroups(Transport.GetEventGroupsRequest.newBuilder().setStreamId(this.mySession.getStreamId()).setPid(this.mySession.getPid()).setKind(Common.Event.Kind.CPU_THREAD).setFromTimestamp(minNs).setToTimestamp(maxNs).build());
        for (Transport.EventGroup eventGroup : response.getGroupsList()) {
            if (eventGroup.getEventsCount() <= 0) continue;
            Cpu.CpuThreadData threadData = eventGroup.getEvents(0).getCpuThread();
            requestedThreadsRangedCpuThreads.put(threadData.getTid(), new RangedCpuThread(this.myRange, threadData.getTid(), threadData.getName()));
        }
        for (int i = 0; i < this.getSize(); ++i) {
            RangedCpuThread element = (RangedCpuThread)this.getElementAt(i);
            if (requestedThreadsRangedCpuThreads.containsKey(element.getThreadId())) {
                requestedThreadsRangedCpuThreads.remove(element.getThreadId());
                continue;
            }
            this.removeOrderedElement(element);
            --i;
        }
        for (RangedCpuThread element : requestedThreadsRangedCpuThreads.values()) {
            this.insertOrderedElement(element);
        }
        this.contentsChanged();
    }

    private void sortElements() {
        Object[] elements = new RangedCpuThread[this.getSize()];
        for (int i = 0; i < this.getSize(); ++i) {
            elements[i] = (RangedCpuThread)this.get(i);
        }
        this.clearOrderedElements();
        Arrays.sort(elements);
        for (Object element : elements) {
            this.insertOrderedElement((DragAndDropModelListElement)element);
        }
    }

    private void contentsChanged() {
        this.fireContentsChanged((Object)this, 0, this.size());
    }

    protected static ThreadState getState(Cpu.CpuThreadData.State state, boolean captured) {
        switch (state) {
            case RUNNING: {
                return captured ? ThreadState.RUNNING_CAPTURED : ThreadState.RUNNING;
            }
            case DEAD: {
                return captured ? ThreadState.DEAD_CAPTURED : ThreadState.DEAD;
            }
            case SLEEPING: {
                return captured ? ThreadState.SLEEPING_CAPTURED : ThreadState.SLEEPING;
            }
            case WAITING: {
                return captured ? ThreadState.WAITING_CAPTURED : ThreadState.WAITING;
            }
        }
        return ThreadState.UNKNOWN;
    }

    public class RangedCpuThread
    implements DragAndDropModelListElement,
    Comparable<RangedCpuThread> {
        @NotNull
        private final CpuThreadInfo myThreadInfo;
        private final Range myRange;
        private final StateChartModel<ThreadState> myModel;
        private DataSeries<ThreadState> mySeries;

        public RangedCpuThread(Range range, int threadId, String name) {
            this(range, threadId, name, null);
        }

        public RangedCpuThread(Range range, int threadId, @Nullable String name, CpuCapture capture) {
            this.myRange = range;
            this.myModel = new StateChartModel();
            boolean isMainThread = this.applyCapture(threadId, capture);
            this.myThreadInfo = new CpuThreadInfo(threadId, name, isMainThread);
        }

        private boolean applyCapture(int threadId, @Nullable CpuCapture capture) {
            this.mySeries = new CpuThreadStateDataSeries(CpuThreadsModel.this.myProfilers.getClient().getTransportClient(), CpuThreadsModel.this.mySession.getStreamId(), CpuThreadsModel.this.mySession.getPid(), threadId, capture);
            if (capture != null && capture.getSystemTraceData() != null) {
                this.mySeries = new MergeCaptureDataSeries<ThreadState>(capture, this.mySeries, new LazyDataSeries(() -> capture.getSystemTraceData().getThreadStatesForThread(threadId)));
            }
            boolean isMainThread = threadId == CpuThreadsModel.this.mySession.getPid();
            this.myModel.addSeries(new RangedSeries(this.myRange, this.mySeries));
            return isMainThread;
        }

        public int getThreadId() {
            return this.myThreadInfo.getId();
        }

        @NotNull
        public String getName() {
            return this.myThreadInfo.getName();
        }

        public StateChartModel<ThreadState> getModel() {
            return this.myModel;
        }

        public DataSeries<ThreadState> getStateSeries() {
            return this.mySeries;
        }

        public int getId() {
            return this.getThreadId();
        }

        @Override
        public int compareTo(@NotNull RangedCpuThread o) {
            return CpuThreadComparator.BASE.compare(this.myThreadInfo, o.myThreadInfo);
        }
    }
}

