/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.RangeTooltipComponent;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.instructions.InstructionsPanel;
import com.android.tools.adtui.instructions.RenderInstruction;
import com.android.tools.adtui.instructions.TextInstruction;
import com.android.tools.adtui.model.Timeline;
import com.android.tools.adtui.stdui.StreamingScrollbar;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profilers.DismissibleMessage;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerFonts;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.ProfilerTooltipMouseAdapter;
import com.android.tools.profilers.RecordingOption;
import com.android.tools.profilers.RecordingOptionsView;
import com.android.tools.profilers.Stage;
import com.android.tools.profilers.StageView;
import com.android.tools.profilers.StudioProfilersView;
import com.android.tools.profilers.SupportLevel;
import com.android.tools.profilers.cpu.CpuProfilerContextMenuInstaller;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.CpuProfilerStageCpuUsageTooltip;
import com.android.tools.profilers.cpu.CpuProfilerStageCpuUsageTooltipView;
import com.android.tools.profilers.cpu.CpuThreadsTooltip;
import com.android.tools.profilers.cpu.CpuThreadsTooltipView;
import com.android.tools.profilers.cpu.CpuThreadsView;
import com.android.tools.profilers.cpu.CpuUsageView;
import com.android.tools.profilers.cpu.config.ProfilingConfiguration;
import com.android.tools.profilers.event.EventMonitorView;
import com.android.tools.profilers.event.LifecycleTooltip;
import com.android.tools.profilers.event.LifecycleTooltipView;
import com.android.tools.profilers.event.UserEventTooltip;
import com.android.tools.profilers.event.UserEventTooltipView;
import com.android.tools.profilers.sessions.SessionAspect;
import com.android.tools.profilers.sessions.SessionsManager;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.ui.UIUtilities;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.LayoutManager;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.MutableComboBoxModel;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;

public class CpuProfilerStageView
extends StageView<CpuProfilerStage> {
    private static final float SPLITTER_DEFAULT_RATIO = 0.2f;
    private static final String SHOW_PROFILEABLE_MESSAGE = "profileable.cpu.message";
    private final CpuProfilerStage myStage;
    @NotNull
    private final CpuThreadsView myThreads;
    @NotNull
    private final RecordingOptionsView myRecordingOptionsView;
    @NotNull
    private final RangeTooltipComponent myTooltipComponent;

    public CpuProfilerStageView(@NotNull StudioProfilersView profilersView, @NotNull CpuProfilerStage stage) {
        super(profilersView, stage);
        this.myStage = stage;
        this.myThreads = new CpuThreadsView(this.myStage);
        this.myTooltipComponent = new RangeTooltipComponent((Timeline)((CpuProfilerStage)((Object)this.getStage())).getTimeline(), (JComponent)this.getTooltipPanel(), this.getProfilersView().getComponent(), this::shouldShowTooltipSeekComponent);
        this.getTooltipBinder().bind(CpuProfilerStageCpuUsageTooltip.class, CpuProfilerStageCpuUsageTooltipView::new);
        this.getTooltipBinder().bind(CpuThreadsTooltip.class, (stageView, tooltip2) -> new CpuThreadsTooltipView(stageView.getComponent(), (CpuThreadsTooltip)((Object)tooltip2)));
        this.getTooltipBinder().bind(LifecycleTooltip.class, (stageView, tooltip2) -> new LifecycleTooltipView(stageView.getComponent(), (LifecycleTooltip)tooltip2));
        this.getTooltipBinder().bind(UserEventTooltip.class, (stageView, tooltip2) -> new UserEventTooltipView(stageView.getComponent(), (UserEventTooltip)tooltip2));
        this.getTooltipPanel().setLayout(new FlowLayout(0, 0, 0));
        CpuUsageView usageView = new CpuUsageView(this.myStage);
        this.myTooltipComponent.registerListenersOn((JComponent)((Object)usageView));
        ProfilerTooltipMouseAdapter listener2 = new ProfilerTooltipMouseAdapter(this.myStage, () -> new CpuProfilerStageCpuUsageTooltip(this.myStage));
        usageView.addMouseListener(listener2);
        JPanel details = new JPanel((LayoutManager)new TabularLayout("*", "Fit-,*"));
        details.setBackground(ProfilerColors.DEFAULT_STAGE_BACKGROUND);
        details.add((Component)this.myTooltipComponent, new TabularLayout.Constraint(0, 0, 3, 1));
        if (stage.getStudioProfilers().getSelectedSessionSupportLevel() == SupportLevel.DEBUGGABLE) {
            EventMonitorView eventsView = new EventMonitorView(profilersView, stage.getEventMonitor());
            eventsView.registerTooltip(this.myTooltipComponent, (Stage)((Object)this.getStage()));
            details.add((Component)eventsView.getComponent(), new TabularLayout.Constraint(0, 0));
        }
        TabularLayout mainLayout = new TabularLayout("*");
        mainLayout.setRowSizing(PanelSizing.MONITOR.getRow(), PanelSizing.MONITOR.getRowRule());
        mainLayout.setRowSizing(PanelSizing.DETAILS.getRow(), PanelSizing.DETAILS.getRowRule());
        JBPanel mainPanel = new JBPanel((LayoutManager)mainLayout);
        mainPanel.setBackground(ProfilerColors.DEFAULT_STAGE_BACKGROUND);
        mainPanel.add((Component)((Object)usageView), new TabularLayout.Constraint(PanelSizing.MONITOR.getRow(), 0));
        mainPanel.add((Component)this.createCpuStatePanel(), new TabularLayout.Constraint(PanelSizing.DETAILS.getRow(), 0));
        details.add((Component)mainPanel, new TabularLayout.Constraint(1, 0));
        details.add((Component)this.buildTimeAxis(this.myStage.getStudioProfilers()), new TabularLayout.Constraint(3, 0));
        details.add((Component)new StreamingScrollbar(this.myStage.getTimeline(), (JComponent)details), new TabularLayout.Constraint(4, 0));
        this.myRecordingOptionsView = new RecordingOptionsView(((CpuProfilerStage)((Object)this.getStage())).getRecordingModel(), (Function1<? super MutableComboBoxModel<RecordingOption>, Unit>)((Function1)this::editConfigurations));
        JBSplitter splitter = new JBSplitter(false);
        splitter.setFirstComponent((JComponent)((Object)this.myRecordingOptionsView));
        splitter.setSecondComponent((JComponent)details);
        splitter.getDivider().setBorder(AdtUiUtils.DEFAULT_VERTICAL_BORDERS);
        splitter.setProportion(0.2f);
        this.getComponent().add((Component)splitter, "Center");
        CpuProfilerContextMenuInstaller.install(this.myStage, this.getIdeComponents(), (JComponent)((Object)usageView), this.getComponent());
        this.getProfilersView().installCommonMenuItems((JComponent)((Object)usageView));
        SessionsManager sessions = ((CpuProfilerStage)((Object)this.getStage())).getStudioProfilers().getSessionsManager();
        sessions.addDependency(this).onChange((Enum)SessionAspect.SELECTED_SESSION, this::sessionChanged);
        sessions.addDependency(this).onChange((Enum)SessionAspect.PROFILING_SESSION, this::sessionChanged);
        if (!((CpuProfilerStage)((Object)this.getStage())).hasUserUsedCpuCapture()) {
            this.installProfilingInstructions((JPanel)((Object)usageView));
        }
        this.sessionChanged();
    }

    @Override
    public JPanel getToolbar() {
        return ((CpuProfilerStage)((Object)this.getStage())).getStudioProfilers().getSelectedSessionSupportLevel() == SupportLevel.PROFILEABLE ? DismissibleMessage.of(((CpuProfilerStage)((Object)this.getStage())).getStudioProfilers(), SHOW_PROFILEABLE_MESSAGE, "Some features are disabled for profileable processes.", "https://d.android.com/r/studio-ui/profiler/profileable") : new JPanel();
    }

    private void sessionChanged() {
        boolean sessionAlive = SessionsManager.isSessionAlive(((CpuProfilerStage)((Object)this.getStage())).getStudioProfilers().getSessionsManager().getSelectedSession());
        this.myRecordingOptionsView.setEnabled(sessionAlive);
    }

    private Unit editConfigurations(MutableComboBoxModel<RecordingOption> model) {
        Consumer<ProfilingConfiguration> dialogCallback = configuration -> {
            this.myStage.getProfilerConfigModel().updateProfilingConfigurations();
            this.myStage.refreshRecordingConfigurations();
        };
        Common.Device selectedDevice = this.myStage.getStudioProfilers().getDevice();
        int deviceFeatureLevel = selectedDevice != null ? selectedDevice.getFeatureLevel() : 0;
        this.getIdeComponents().openCpuProfilingConfigurationsDialog(this.myStage.getProfilerConfigModel(), deviceFeatureLevel, dialogCallback);
        this.myStage.getStudioProfilers().getIdeServices().getFeatureTracker().trackOpenProfilingConfigDialog();
        return Unit.INSTANCE;
    }

    @NotNull
    private JPanel createCpuStatePanel() {
        TabularLayout cpuStateLayout = new TabularLayout("*");
        JBPanel cpuStatePanel = new JBPanel((LayoutManager)cpuStateLayout);
        cpuStatePanel.setBackground(ProfilerColors.DEFAULT_STAGE_BACKGROUND);
        cpuStateLayout.setRowSizing(PanelSizing.THREADS.getRow(), PanelSizing.THREADS.getRowRule());
        this.myTooltipComponent.registerListenersOn(this.myThreads.getComponent());
        cpuStatePanel.add((Component)this.myThreads.getComponent(), new TabularLayout.Constraint(PanelSizing.THREADS.getRow(), 0));
        return cpuStatePanel;
    }

    private void installProfilingInstructions(@NotNull JPanel parent) {
        assert (parent.getLayout().getClass() == TabularLayout.class);
        FontMetrics metrics = UIUtilities.getFontMetrics((JComponent)parent, (Font)ProfilerFonts.H2_FONT);
        InstructionsPanel panel = new InstructionsPanel.Builder(new RenderInstruction[]{new TextInstruction(metrics, "Click Record to start capturing CPU activity")}).setEaseOut(this.myStage.getInstructionsEaseOutModel(), parent::remove).setBackgroundCornerRadius(ProfilerLayout.PROFILING_INSTRUCTIONS_BACKGROUND_ARC_DIAMETER, ProfilerLayout.PROFILING_INSTRUCTIONS_BACKGROUND_ARC_DIAMETER).build();
        parent.add((Component)panel, new TabularLayout.Constraint(0, 0), 0);
    }

    @VisibleForTesting
    boolean shouldShowTooltipSeekComponent() {
        return this.myStage.getTooltip() instanceof CpuProfilerStageCpuUsageTooltip;
    }

    private static enum PanelSizing {
        MONITOR("140px", 0),
        DETAILS("*", 1),
        THREADS("*", 0);

        @NotNull
        private final String myRowRule;
        private final int myRow;

        private PanelSizing(String rowRule, int row) {
            this.myRowRule = rowRule;
            this.myRow = row;
        }

        @NotNull
        public String getRowRule() {
            return this.myRowRule;
        }

        public int getRow() {
            return this.myRow;
        }
    }
}

