/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.updater.Updatable;
import com.android.tools.profilers.IdeProfilerServices;
import com.android.tools.profilers.cpu.CpuCapture;
import com.android.tools.profilers.cpu.CpuCaptureMetadata;
import com.android.tools.profilers.cpu.CpuCaptureParser;
import com.android.tools.profilers.cpu.StatusPanelModel;
import com.android.tools.profilers.cpu.config.ProfilingConfiguration;
import java.io.File;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CpuCaptureHandler
implements Updatable,
StatusPanelModel {
    @NotNull
    private final CpuCaptureParser myCaptureParser;
    @NotNull
    private final Range myParseRange = new Range();
    @NotNull
    private final IdeProfilerServices myServices;
    @NotNull
    private final ProfilingConfiguration myConfiguration;
    @NotNull
    private final File myCaptureFile;
    private final long myTraceId;
    private final int myCaptureProcessIdHint;
    @Nullable
    private final String myCaptureProcessNameHint;
    private boolean myIsParsing = false;

    public CpuCaptureHandler(@NotNull IdeProfilerServices services, @NotNull File captureFile, long traceId, @NotNull ProfilingConfiguration configuration, @Nullable String captureProcessNameHint, int captureProcessIdHint) {
        this.myCaptureParser = new CpuCaptureParser(services);
        this.myCaptureFile = captureFile;
        this.myTraceId = traceId;
        this.myServices = services;
        this.myConfiguration = configuration;
        this.myCaptureProcessIdHint = captureProcessIdHint;
        this.myCaptureProcessNameHint = captureProcessNameHint;
        this.myCaptureParser.trackCaptureMetadata(traceId, new CpuCaptureMetadata(configuration));
    }

    @Override
    @NotNull
    public Range getRange() {
        return this.myParseRange;
    }

    @Override
    @NotNull
    public String getConfigurationText() {
        return this.myConfiguration.getName();
    }

    @Override
    public void abort() {
        this.myCaptureParser.abortParsing();
    }

    public void update(long elapsedNs) {
        if (this.myIsParsing) {
            this.myParseRange.setMax(this.myParseRange.getMax() + (double)elapsedNs);
        }
    }

    public void parse(Consumer<CpuCapture> captureCompleted) {
        this.myIsParsing = true;
        this.myParseRange.set(0.0, 0.0);
        CompletableFuture<CpuCapture> capture = this.myCaptureParser.parse(this.myCaptureFile, this.myTraceId, this.myConfiguration.getTraceType(), this.myCaptureProcessIdHint, this.myCaptureProcessNameHint);
        capture.handleAsync((parsedCapture, exception) -> {
            this.myIsParsing = false;
            captureCompleted.accept((CpuCapture)parsedCapture);
            return parsedCapture;
        }, this.myServices.getMainExecutor());
    }
}

