/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.TooltipView;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.formatter.NumberFormatter;
import com.android.tools.profilers.cpu.BatteryDrainTooltip;
import com.google.common.annotations.VisibleForTesting;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0014\u001a\u00020\u0003H\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002J\u0010\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0012\u0010\f\u001a\u0004\b\u0013\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/profilers/cpu/BatteryDrainTooltipView;", "Lcom/android/tools/adtui/TooltipView;", "parent", "Ljavax/swing/JComponent;", "tooltip", "Lcom/android/tools/profilers/cpu/BatteryDrainTooltip;", "(Ljavax/swing/JComponent;Lcom/android/tools/profilers/cpu/BatteryDrainTooltip;)V", "content", "Ljavax/swing/JPanel;", "descriptionLabel", "Ljavax/swing/JLabel;", "getDescriptionLabel$annotations", "()V", "getDescriptionLabel", "()Ljavax/swing/JLabel;", "getTooltip", "()Lcom/android/tools/profilers/cpu/BatteryDrainTooltip;", "valueLabel", "getValueLabel$annotations", "getValueLabel", "createTooltip", "getDescriptionText", "", "counterName", "getTitle", "updateView", "", "intellij.android.profilers.ui"})
@StabilityInferred(parameters=0)
public final class BatteryDrainTooltipView
extends TooltipView {
    @NotNull
    private final BatteryDrainTooltip tooltip;
    @NotNull
    private final JPanel content;
    @NotNull
    private final JLabel descriptionLabel;
    @NotNull
    private final JLabel valueLabel;
    public static final int $stable = 8;

    public BatteryDrainTooltipView(@NotNull JComponent parent, @NotNull BatteryDrainTooltip tooltip2) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)((Object)tooltip2), (String)"tooltip");
        super(tooltip2.getTimeline());
        this.tooltip = tooltip2;
        this.content = new JPanel((LayoutManager)new TabularLayout("*").setVGap(12));
        JLabel jLabel = TooltipView.createTooltipLabel();
        Intrinsics.checkNotNullExpressionValue((Object)jLabel, (String)"createTooltipLabel()");
        this.descriptionLabel = jLabel;
        JLabel jLabel2 = TooltipView.createTooltipLabel();
        Intrinsics.checkNotNullExpressionValue((Object)jLabel2, (String)"createTooltipLabel()");
        this.valueLabel = jLabel2;
        this.content.add((Component)this.valueLabel, new TabularLayout.Constraint(0, 0, 0, 4, null));
        this.content.add((Component)this.descriptionLabel, new TabularLayout.Constraint(1, 0, 0, 4, null));
        this.tooltip.addDependency((AspectObserver)this).onChange((Enum)BatteryDrainTooltip.Aspect.VALUE_CHANGED, new Runnable(){

            @Override
            public final void run() {
                this.updateView();
            }
        });
        this.updateView();
    }

    @NotNull
    public final BatteryDrainTooltip getTooltip() {
        return this.tooltip;
    }

    @NotNull
    public final JLabel getDescriptionLabel() {
        return this.descriptionLabel;
    }

    @VisibleForTesting
    public static /* synthetic */ void getDescriptionLabel$annotations() {
    }

    @NotNull
    public final JLabel getValueLabel() {
        return this.valueLabel;
    }

    @VisibleForTesting
    public static /* synthetic */ void getValueLabel$annotations() {
    }

    @NotNull
    protected JComponent createTooltip() {
        return this.content;
    }

    private final void updateView() {
        this.descriptionLabel.setText("<html>" + this.getDescriptionText(this.tooltip.getCounterName()) + "</html>");
        String string = NumberFormatter.formatInteger((Number)this.tooltip.getActiveValue());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatInteger(tooltip.activeValue)");
        String batteryDrainValueText = string;
        this.valueLabel.setText(this.getTitle(this.tooltip.getCounterName()) + ": " + batteryDrainValueText);
    }

    private final String getTitle(String counterName) {
        return counterName;
    }

    private final String getDescriptionText(String counterName) {
        return "[PLACEHOLDER BATTERY DESCRIPTION]";
    }
}

