/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.profilers.RecordingOption;
import com.android.tools.profilers.RecordingOptionsModelKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.MutableComboBoxModel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.assertj.core.util.VisibleForTesting;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u0000 ;2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003:;<B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001f\u0010\u001e\u001a\u00020\u001f2\u0012\u0010 \u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060!\"\u00020\u0006\u00a2\u0006\u0002\u0010\"J\u001f\u0010#\u001a\u00020\u001f2\u0012\u0010 \u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060!\"\u00020\u0006\u00a2\u0006\u0002\u0010\"J\u0006\u0010$\u001a\u00020\u0010J\u0006\u0010%\u001a\u00020\u0010J\u0006\u0010&\u001a\u00020\u001fJ\u0010\u0010'\u001a\u0004\u0018\u00010\u00172\u0006\u0010(\u001a\u00020\u0006J\u000e\u0010)\u001a\u00020\u00102\u0006\u0010(\u001a\u00020\u0006J\u000e\u0010*\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020\u0006J\u0006\u0010+\u001a\u00020\u001fJ)\u0010,\u001a\u00020\u001f2!\u0010-\u001a\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b/\u0012\b\b0\u0012\u0004\b\b(1\u0012\u0004\u0012\u00020\u00100.J\u0006\u00102\u001a\u00020\u001fJ\u0016\u00103\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020\u00062\u0006\u00104\u001a\u00020\u0017J\u000e\u00105\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020\u0006J\u0006\u00106\u001a\u00020\u001fJ\u0006\u00107\u001a\u00020\u001fJ\u0006\u00108\u001a\u00020\u001fJ\u000e\u00109\u001a\u00020\u0010*\u0004\u0018\u00010\u0006H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\u0014\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0019\u001a\u0004\u0018\u00010\u00062\b\u0010\u0018\u001a\u0004\u0018\u00010\u0006@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001d\u00a8\u0006="}, d2={"Lcom/android/tools/profilers/RecordingOptionsModel;", "Lcom/android/tools/adtui/model/AspectModel;", "Lcom/android/tools/profilers/RecordingOptionsModel$Aspect;", "()V", "builtInOptionList", "", "Lcom/android/tools/profilers/RecordingOption;", "builtInOptions", "", "getBuiltInOptions", "()Ljava/util/List;", "customConfigurationModel", "Ljavax/swing/MutableComboBoxModel;", "getCustomConfigurationModel", "()Ljavax/swing/MutableComboBoxModel;", "<set-?>", "", "isRecording", "()Z", "isSelectedOptionBuiltIn", "isSelectedOptionCustom", "notReadyOptions", "", "", "newOption", "selectedOption", "getSelectedOption", "()Lcom/android/tools/profilers/RecordingOption;", "setSelectedOption", "(Lcom/android/tools/profilers/RecordingOption;)V", "addBuiltInOptions", "", "options", "", "([Lcom/android/tools/profilers/RecordingOption;)V", "addConfigurations", "canStart", "canStop", "clearConfigurations", "getOptionNotReadyMessage", "opt", "isOptionReady", "selectBuiltInOption", "selectCurrentCustomConfiguration", "selectOptionBy", "criteria", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "recordingOption", "setFinished", "setOptionNotReady", "message", "setOptionReady", "setRecording", "start", "stop", "isValid", "Aspect", "Companion", "ConfigModel", "intellij.android.profilers"})
@SourceDebugExtension(value={"SMAP\nRecordingOptionsModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecordingOptionsModel.kt\ncom/android/tools/profilers/RecordingOptionsModel\n+ 2 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,203:1\n26#2:204\n288#3,2:205\n1#4:207\n*S KotlinDebug\n*F\n+ 1 RecordingOptionsModel.kt\ncom/android/tools/profilers/RecordingOptionsModel\n*L\n40#1:204\n64#1:205,2\n*E\n"})
public final class RecordingOptionsModel
extends AspectModel<Aspect> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean isRecording;
    @Nullable
    private RecordingOption selectedOption;
    @NotNull
    private final List<RecordingOption> builtInOptionList = new ArrayList();
    @NotNull
    private final MutableComboBoxModel<RecordingOption> customConfigurationModel;
    @NotNull
    private final Map<RecordingOption, String> notReadyOptions;

    public RecordingOptionsModel() {
        boolean $i$f$emptyArray = false;
        this.customConfigurationModel = new ConfigModel(new RecordingOption[0]);
        this.notReadyOptions = new LinkedHashMap();
    }

    public final boolean isRecording() {
        return this.isRecording;
    }

    @Nullable
    public final RecordingOption getSelectedOption() {
        return this.selectedOption;
    }

    @VisibleForTesting
    public final void setSelectedOption(@Nullable RecordingOption newOption) {
        if (!Intrinsics.areEqual((Object)newOption, (Object)this.selectedOption)) {
            if (!(!this.isRecording && this.isValid(newOption))) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            this.selectedOption = newOption;
            this.changed(Aspect.SELECTION_CHANGED);
        }
    }

    @NotNull
    public final List<RecordingOption> getBuiltInOptions() {
        List<RecordingOption> list = Collections.unmodifiableList(this.builtInOptionList);
        Intrinsics.checkNotNullExpressionValue(list, (String)"unmodifiableList(builtInOptionList)");
        return list;
    }

    @NotNull
    public final MutableComboBoxModel<RecordingOption> getCustomConfigurationModel() {
        return this.customConfigurationModel;
    }

    public final boolean isSelectedOptionBuiltIn() {
        return CollectionsKt.contains((Iterable)this.builtInOptionList, (Object)this.selectedOption);
    }

    public final boolean isSelectedOptionCustom() {
        return RecordingOptionsModelKt.access$contains(this.customConfigurationModel, this.selectedOption);
    }

    public final void selectBuiltInOption(@NotNull RecordingOption opt) {
        Intrinsics.checkNotNullParameter((Object)opt, (String)"opt");
        if (!this.builtInOptionList.contains(opt)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.setSelectedOption(opt);
    }

    public final void selectCurrentCustomConfiguration() {
        Object object = this.customConfigurationModel.getSelectedItem();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.android.tools.profilers.RecordingOption");
        this.setSelectedOption((RecordingOption)object);
    }

    public final void selectOptionBy(@NotNull Function1<? super RecordingOption, Boolean> criteria) {
        Object v0;
        block4: {
            Intrinsics.checkNotNullParameter(criteria, (String)"criteria");
            Iterable $this$firstOrNull$iv = this.builtInOptionList;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                if (!((Boolean)criteria.invoke(element$iv)).booleanValue()) continue;
                v0 = element$iv;
                break block4;
            }
            v0 = null;
        }
        RecordingOption builtInOption = v0;
        if (builtInOption != null) {
            this.selectBuiltInOption(builtInOption);
        } else {
            int n = this.customConfigurationModel.getSize();
            for (int i = 0; i < n; ++i) {
                RecordingOption customOption = (RecordingOption)this.customConfigurationModel.getElementAt(i);
                Intrinsics.checkNotNullExpressionValue((Object)customOption, (String)"customOption");
                if (!((Boolean)criteria.invoke((Object)customOption)).booleanValue()) continue;
                this.customConfigurationModel.setSelectedItem(customOption);
                this.selectCurrentCustomConfiguration();
                return;
            }
            this.selectBuiltInOption(this.builtInOptionList.get(0));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean canStop() {
        if (!this.isRecording) return false;
        RecordingOption recordingOption = this.selectedOption;
        if (recordingOption == null) return false;
        Runnable runnable = recordingOption.getStopAction();
        if (runnable == null) return false;
        return true;
    }

    public final boolean canStart() {
        return !this.isRecording && this.selectedOption != null && !this.notReadyOptions.containsKey(this.selectedOption);
    }

    public final void start() {
        if (!this.canStart()) {
            boolean bl = false;
            String string = "Cannot record while another session is on-going";
            throw new IllegalArgumentException(string.toString());
        }
        RecordingOption recordingOption = this.selectedOption;
        Intrinsics.checkNotNull((Object)recordingOption);
        recordingOption.getStartAction().run();
        this.setRecording();
    }

    public final void stop() {
        block0: {
            Object object;
            if (!this.canStop() || (object = this.selectedOption) == null || (object = ((RecordingOption)object).getStopAction()) == null) break block0;
            object.run();
        }
    }

    public final void setRecording() {
        if (!this.isRecording) {
            this.isRecording = true;
            this.changed(Aspect.RECORDING_CHANGED);
        }
    }

    public final void setFinished() {
        if (this.isRecording) {
            this.isRecording = false;
            this.changed(Aspect.RECORDING_CHANGED);
        }
    }

    public final void addBuiltInOptions(RecordingOption ... options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        CollectionsKt.addAll((Collection)this.builtInOptionList, (Object[])options);
        this.changed(Aspect.BUILT_IN_OPTIONS_CHANGED);
    }

    public final void addConfigurations(RecordingOption ... options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        MutableComboBoxModel<RecordingOption> mutableComboBoxModel = this.customConfigurationModel;
        Intrinsics.checkNotNull(mutableComboBoxModel, (String)"null cannot be cast to non-null type com.android.tools.profilers.RecordingOptionsModel.ConfigModel");
        ((ConfigModel)mutableComboBoxModel).addAll(ArraysKt.toMutableList((Object[])options));
        if (((ConfigModel)this.customConfigurationModel).getSize() > 0 && ((ConfigModel)this.customConfigurationModel).getSelectedItem() == null) {
            ((ConfigModel)this.customConfigurationModel).setSelectedItem(this.customConfigurationModel.getElementAt(0));
        }
    }

    public final void clearConfigurations() {
        MutableComboBoxModel<RecordingOption> mutableComboBoxModel = this.customConfigurationModel;
        Intrinsics.checkNotNull(mutableComboBoxModel, (String)"null cannot be cast to non-null type com.android.tools.profilers.RecordingOptionsModel.ConfigModel");
        ((ConfigModel)mutableComboBoxModel).removeAllElements();
    }

    public final void setOptionNotReady(@NotNull RecordingOption opt, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)opt, (String)"opt");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (!this.getBuiltInOptions().contains(opt)) {
            boolean bl = false;
            String string = "Marking options not ready is only supported for builtin options for now";
            throw new IllegalArgumentException(string.toString());
        }
        this.notReadyOptions.put(opt, message);
        this.changed(Aspect.READY_OPTIONS_CHANGED);
    }

    public final void setOptionReady(@NotNull RecordingOption opt) {
        Intrinsics.checkNotNullParameter((Object)opt, (String)"opt");
        if (this.notReadyOptions.containsKey(opt)) {
            this.notReadyOptions.remove(opt);
            this.changed(Aspect.READY_OPTIONS_CHANGED);
        }
    }

    @Nullable
    public final String getOptionNotReadyMessage(@NotNull RecordingOption opt) {
        Intrinsics.checkNotNullParameter((Object)opt, (String)"opt");
        return this.notReadyOptions.get(opt);
    }

    public final boolean isOptionReady(@NotNull RecordingOption opt) {
        Intrinsics.checkNotNullParameter((Object)opt, (String)"opt");
        return this.getOptionNotReadyMessage(opt) == null;
    }

    private final boolean isValid(RecordingOption $this$isValid) {
        return $this$isValid == null || this.builtInOptionList.contains($this$isValid) || RecordingOptionsModelKt.access$contains(this.customConfigurationModel, $this$isValid);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/android/tools/profilers/RecordingOptionsModel$Aspect;", "", "(Ljava/lang/String;I)V", "RECORDING_CHANGED", "SELECTION_CHANGED", "BUILT_IN_OPTIONS_CHANGED", "READY_OPTIONS_CHANGED", "CONFIGURATIONS_EMPTINESS_CHANGED", "intellij.android.profilers"})
    public static final class Aspect
    extends Enum<Aspect> {
        public static final /* enum */ Aspect RECORDING_CHANGED = new Aspect();
        public static final /* enum */ Aspect SELECTION_CHANGED = new Aspect();
        public static final /* enum */ Aspect BUILT_IN_OPTIONS_CHANGED = new Aspect();
        public static final /* enum */ Aspect READY_OPTIONS_CHANGED = new Aspect();
        public static final /* enum */ Aspect CONFIGURATIONS_EMPTINESS_CHANGED = new Aspect();
        private static final /* synthetic */ Aspect[] $VALUES;

        public static Aspect[] values() {
            return (Aspect[])$VALUES.clone();
        }

        public static Aspect valueOf(String value) {
            return Enum.valueOf(Aspect.class, value);
        }

        static {
            $VALUES = aspectArray = new Aspect[]{Aspect.RECORDING_CHANGED, Aspect.SELECTION_CHANGED, Aspect.BUILT_IN_OPTIONS_CHANGED, Aspect.READY_OPTIONS_CHANGED, Aspect.CONFIGURATIONS_EMPTINESS_CHANGED};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0086\u0002\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lcom/android/tools/profilers/RecordingOptionsModel$Companion;", "", "()V", "invoke", "Lcom/android/tools/profilers/RecordingOptionsModel;", "builtInRecordings", "", "Lcom/android/tools/profilers/RecordingOption;", "configs", "([Lcom/android/tools/profilers/RecordingOption;[Lcom/android/tools/profilers/RecordingOption;)Lcom/android/tools/profilers/RecordingOptionsModel;", "intellij.android.profilers"})
    @SourceDebugExtension(value={"SMAP\nRecordingOptionsModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecordingOptionsModel.kt\ncom/android/tools/profilers/RecordingOptionsModel$Companion\n+ 2 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n*L\n1#1,203:1\n26#2:204\n*S KotlinDebug\n*F\n+ 1 RecordingOptionsModel.kt\ncom/android/tools/profilers/RecordingOptionsModel$Companion\n*L\n186#1:204\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RecordingOptionsModel invoke(@NotNull RecordingOption[] builtInRecordings, @NotNull RecordingOption[] configs) {
            RecordingOptionsModel recordingOptionsModel;
            Intrinsics.checkNotNullParameter((Object)builtInRecordings, (String)"builtInRecordings");
            Intrinsics.checkNotNullParameter((Object)configs, (String)"configs");
            RecordingOptionsModel $this$invoke_u24lambda_u240 = recordingOptionsModel = new RecordingOptionsModel();
            boolean bl = false;
            $this$invoke_u24lambda_u240.addBuiltInOptions(Arrays.copyOf(builtInRecordings, builtInRecordings.length));
            $this$invoke_u24lambda_u240.addConfigurations(Arrays.copyOf(configs, configs.length));
            return recordingOptionsModel;
        }

        public static /* synthetic */ RecordingOptionsModel invoke$default(Companion companion, RecordingOption[] recordingOptionArray, RecordingOption[] recordingOptionArray2, int n, Object object) {
            if ((n & 2) != 0) {
                boolean $i$f$emptyArray = false;
                recordingOptionArray2 = new RecordingOption[]{};
            }
            return companion.invoke(recordingOptionArray, recordingOptionArray2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u001f\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\"\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0010\u0010\n\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0002\u0018\u00010\u000bH\u0016J\u001a\u0010\u0006\u001a\u00020\u00072\u0010\u0010\n\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0002\u0018\u00010\u000bH\u0016J\u0012\u0010\f\u001a\u00020\u00072\b\u0010\r\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010\u000e\u001a\u00020\u00072\b\u0010\r\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\u000f\u001a\u00020\u0007H\u0016J\u0012\u0010\u0010\u001a\u00020\u00072\b\u0010\r\u001a\u0004\u0018\u00010\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\u0013\u001a\u00020\u00072\b\u0010\r\u001a\u0004\u0018\u00010\u0011H\u0016J\u0016\u0010\u0014\u001a\u00020\u00072\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\u0016H\u0002\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/profilers/RecordingOptionsModel$ConfigModel;", "Ljavax/swing/DefaultComboBoxModel;", "Lcom/android/tools/profilers/RecordingOption;", "configs", "", "(Lcom/android/tools/profilers/RecordingOptionsModel;[Lcom/android/tools/profilers/RecordingOption;)V", "addAll", "", "index", "", "c", "", "addElement", "anObject", "insertElementAt", "removeAllElements", "removeElement", "", "removeElementAt", "setSelectedItem", "trackEmptinessChanged", "run", "Lkotlin/Function0;", "intellij.android.profilers"})
    private final class ConfigModel
    extends DefaultComboBoxModel<RecordingOption> {
        public ConfigModel(RecordingOption[] configs) {
            Intrinsics.checkNotNullParameter((Object)configs, (String)"configs");
            super(configs);
        }

        @Override
        public void setSelectedItem(@Nullable Object anObject) {
            super.setSelectedItem(anObject);
            if (RecordingOptionsModel.this.isSelectedOptionCustom()) {
                RecordingOptionsModel.this.selectCurrentCustomConfiguration();
            }
        }

        @Override
        public void addAll(@Nullable Collection<? extends RecordingOption> c) {
            this.trackEmptinessChanged((Function0<? extends Object>)((Function0)new Function0<Unit>(this, c){
                final /* synthetic */ ConfigModel this$0;
                final /* synthetic */ Collection<? extends RecordingOption> $c;
                {
                    this.this$0 = $receiver;
                    this.$c = $c;
                    super(0);
                }

                public final void invoke() {
                    ConfigModel.access$addAll$s1694505771(this.this$0, this.$c);
                }
            }));
        }

        @Override
        public void addAll(int index, @Nullable Collection<? extends RecordingOption> c) {
            this.trackEmptinessChanged((Function0<? extends Object>)((Function0)new Function0<Unit>(this, index, c){
                final /* synthetic */ ConfigModel this$0;
                final /* synthetic */ int $index;
                final /* synthetic */ Collection<? extends RecordingOption> $c;
                {
                    this.this$0 = $receiver;
                    this.$index = $index;
                    this.$c = $c;
                    super(0);
                }

                public final void invoke() {
                    ConfigModel.access$addAll$s1694505771(this.this$0, this.$index, this.$c);
                }
            }));
        }

        @Override
        public void addElement(@Nullable RecordingOption anObject) {
            this.trackEmptinessChanged((Function0<? extends Object>)((Function0)new Function0<Unit>(this, anObject){
                final /* synthetic */ ConfigModel this$0;
                final /* synthetic */ RecordingOption $anObject;
                {
                    this.this$0 = $receiver;
                    this.$anObject = $anObject;
                    super(0);
                }

                public final void invoke() {
                    ConfigModel.access$addElement$s1694505771(this.this$0, this.$anObject);
                }
            }));
        }

        @Override
        public void insertElementAt(@Nullable RecordingOption anObject, int index) {
            this.trackEmptinessChanged((Function0<? extends Object>)((Function0)new Function0<Unit>(this, anObject, index){
                final /* synthetic */ ConfigModel this$0;
                final /* synthetic */ RecordingOption $anObject;
                final /* synthetic */ int $index;
                {
                    this.this$0 = $receiver;
                    this.$anObject = $anObject;
                    this.$index = $index;
                    super(0);
                }

                public final void invoke() {
                    ConfigModel.access$insertElementAt$s1694505771(this.this$0, this.$anObject, this.$index);
                }
            }));
        }

        @Override
        public void removeAllElements() {
            this.trackEmptinessChanged((Function0<? extends Object>)((Function0)new Function0<Unit>(this){
                final /* synthetic */ ConfigModel this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    ConfigModel.access$removeAllElements$s1694505771(this.this$0);
                }
            }));
        }

        @Override
        public void removeElement(@Nullable Object anObject) {
            this.trackEmptinessChanged((Function0<? extends Object>)((Function0)new Function0<Unit>(this, anObject){
                final /* synthetic */ ConfigModel this$0;
                final /* synthetic */ Object $anObject;
                {
                    this.this$0 = $receiver;
                    this.$anObject = $anObject;
                    super(0);
                }

                public final void invoke() {
                    ConfigModel.access$removeElement$s1694505771(this.this$0, this.$anObject);
                }
            }));
        }

        @Override
        public void removeElementAt(int index) {
            this.trackEmptinessChanged((Function0<? extends Object>)((Function0)new Function0<Unit>(this, index){
                final /* synthetic */ ConfigModel this$0;
                final /* synthetic */ int $index;
                {
                    this.this$0 = $receiver;
                    this.$index = $index;
                    super(0);
                }

                public final void invoke() {
                    ConfigModel.access$removeElementAt$s1694505771(this.this$0, this.$index);
                }
            }));
        }

        private final void trackEmptinessChanged(Function0<? extends Object> run2) {
            boolean bl = this.getSize() > 0;
            RecordingOptionsModel recordingOptionsModel = RecordingOptionsModel.this;
            boolean it = bl;
            boolean bl2 = false;
            run2.invoke();
            if (this.getSize() > 0 != it) {
                recordingOptionsModel.changed(Aspect.CONFIGURATIONS_EMPTINESS_CHANGED);
            }
        }

        public static final /* synthetic */ void access$addAll$s1694505771(ConfigModel $this, Collection p0) {
            super.addAll(p0);
        }

        public static final /* synthetic */ void access$addAll$s1694505771(ConfigModel $this, int p0, Collection p1) {
            super.addAll(p0, p1);
        }

        public static final /* synthetic */ void access$addElement$s1694505771(ConfigModel $this, Object p0) {
            super.addElement(p0);
        }

        public static final /* synthetic */ void access$insertElementAt$s1694505771(ConfigModel $this, Object p0, int p1) {
            super.insertElementAt(p0, p1);
        }

        public static final /* synthetic */ void access$removeAllElements$s1694505771(ConfigModel $this) {
            super.removeAllElements();
        }

        public static final /* synthetic */ void access$removeElement$s1694505771(ConfigModel $this, Object p0) {
            super.removeElement(p0);
        }

        public static final /* synthetic */ void access$removeElementAt$s1694505771(ConfigModel $this, int p0) {
            super.removeElementAt(p0);
        }
    }
}

