/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore.poller;

import com.android.tools.datastore.database.NetworkTable;
import com.android.tools.datastore.poller.PollRunner;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.NetworkProfiler;
import com.android.tools.profiler.proto.NetworkServiceGrpc;
import org.jetbrains.annotations.NotNull;

public class NetworkDataPoller
extends PollRunner {
    private long myDataRequestStartTimestampNs = Long.MIN_VALUE;
    private long myHttpRangeRequestStartTimeNs = Long.MIN_VALUE;
    private Common.Session mySession;
    private NetworkTable myNetworkTable;
    NetworkServiceGrpc.NetworkServiceBlockingStub myPollingService;

    public NetworkDataPoller(@NotNull Common.Session session, @NotNull NetworkTable table2, @NotNull NetworkServiceGrpc.NetworkServiceBlockingStub pollingService) {
        super(POLLING_DELAY_NS);
        this.mySession = session;
        this.myNetworkTable = table2;
        this.myPollingService = pollingService;
    }

    @Override
    public void poll() {
        NetworkProfiler.NetworkDataRequest.Builder dataRequestBuilder = NetworkProfiler.NetworkDataRequest.newBuilder().setSession(this.mySession).setStartTimestamp(this.myDataRequestStartTimestampNs).setEndTimestamp(Long.MAX_VALUE).setType(NetworkProfiler.NetworkDataRequest.Type.ALL);
        NetworkProfiler.NetworkDataResponse response = this.myPollingService.getData(dataRequestBuilder.build());
        for (NetworkProfiler.NetworkProfilerData data : response.getDataList()) {
            this.myDataRequestStartTimestampNs = Math.max(this.myDataRequestStartTimestampNs, data.getEndTimestamp());
            this.myNetworkTable.insert(this.mySession, data);
        }
        this.pollHttpRange();
    }

    private void pollHttpRange() {
        NetworkProfiler.HttpRangeRequest.Builder requestBuilder = NetworkProfiler.HttpRangeRequest.newBuilder().setSession(this.mySession).setStartTimestamp(this.myHttpRangeRequestStartTimeNs).setEndTimestamp(Long.MAX_VALUE);
        NetworkProfiler.HttpRangeResponse httpRange = this.myPollingService.getHttpRange(requestBuilder.build());
        for (NetworkProfiler.HttpConnectionData connection : httpRange.getDataList()) {
            NetworkProfiler.HttpDetailsResponse initialData;
            this.myHttpRangeRequestStartTimeNs = Math.max(this.myHttpRangeRequestStartTimeNs, connection.getStartTimestamp() + 1L);
            this.myHttpRangeRequestStartTimeNs = Math.max(this.myHttpRangeRequestStartTimeNs, connection.getEndTimestamp() + 1L);
            NetworkProfiler.HttpDetailsResponse request = initialData = this.myNetworkTable.getHttpDetailsResponseById(connection.getConnId(), this.mySession, NetworkProfiler.HttpDetailsRequest.Type.REQUEST);
            NetworkProfiler.HttpDetailsResponse requestBody = this.myNetworkTable.getHttpDetailsResponseById(connection.getConnId(), this.mySession, NetworkProfiler.HttpDetailsRequest.Type.REQUEST_BODY);
            NetworkProfiler.HttpDetailsResponse response = null;
            NetworkProfiler.HttpDetailsResponse responseBody = null;
            if (initialData == null) {
                request = this.pollHttpDetails(connection.getConnId(), NetworkProfiler.HttpDetailsRequest.Type.REQUEST);
            }
            if (connection.getUploadedTimestamp() != 0L) {
                requestBody = this.pollHttpDetails(connection.getConnId(), NetworkProfiler.HttpDetailsRequest.Type.REQUEST_BODY);
            }
            if (connection.getEndTimestamp() != 0L) {
                response = this.pollHttpDetails(connection.getConnId(), NetworkProfiler.HttpDetailsRequest.Type.RESPONSE);
                responseBody = this.pollHttpDetails(connection.getConnId(), NetworkProfiler.HttpDetailsRequest.Type.RESPONSE_BODY);
            }
            NetworkProfiler.HttpDetailsResponse threads = this.pollHttpDetails(connection.getConnId(), NetworkProfiler.HttpDetailsRequest.Type.ACCESSING_THREADS);
            this.myNetworkTable.insertOrReplace(this.mySession, request, response, requestBody, responseBody, threads, connection);
        }
    }

    private NetworkProfiler.HttpDetailsResponse pollHttpDetails(long id, NetworkProfiler.HttpDetailsRequest.Type type) {
        NetworkProfiler.HttpDetailsRequest request = NetworkProfiler.HttpDetailsRequest.newBuilder().setConnId(id).setType(type).build();
        return this.myPollingService.getHttpDetails(request);
    }
}

