/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore.energy;

import com.android.tools.datastore.energy.PowerProfile;
import com.android.tools.profiler.proto.Energy;
import com.android.tools.profiler.proto.EnergyProfiler;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BatteryModel {
    private static final long DEFAULT_SAMPLE_INTERVAL_NS = TimeUnit.MILLISECONDS.toNanos(200L);
    private static final long GPS_LOCK_DURATION_NS = TimeUnit.SECONDS.toNanos(7L);
    private static final long NETWORK_SCAN_DURATION_NS = TimeUnit.MILLISECONDS.toNanos(500L);
    private static final int LOCATION_SMOOTHING_SAMPLES = 4;
    @NotNull
    private final List<EnergyProfiler.EnergySample> mySparseSamples = new ArrayList<EnergyProfiler.EnergySample>();
    @NotNull
    private final PowerProfile myPowerProfile;
    private final long mySampleIntervalNs;
    private PowerProfile.CpuCoreUsage[] myLastCpuCoresUsage;
    @NotNull
    private PowerProfile.NetworkType myNetworkType = PowerProfile.NetworkType.NONE;
    private long myReceivingBps;
    private long mySendingBps;
    private Map<Long, Long> myGpsLockonMap = new HashMap<Long, Long>();
    private Map<Long, EnergyProfiler.EnergySample> myLocationSmoothingMap = new HashMap<Long, EnergyProfiler.EnergySample>();
    private long myLastNetworkLocationOffTime = 0L;
    private final long mySmoothingEndDeltaTime;
    private long myLastGpsOffTime = 0L;

    public BatteryModel() {
        this(new PowerProfile.DefaultPowerProfile(), DEFAULT_SAMPLE_INTERVAL_NS);
    }

    @VisibleForTesting
    public BatteryModel(@NotNull PowerProfile powerProfile, long sampleIntervalNs) {
        this.myPowerProfile = powerProfile;
        this.mySampleIntervalNs = sampleIntervalNs;
        this.mySmoothingEndDeltaTime = 4L * this.mySampleIntervalNs;
        this.mySparseSamples.add(0, EnergyProfiler.EnergySample.newBuilder().setEnergyUsage(Energy.EnergyUsageData.getDefaultInstance()).build());
    }

    @VisibleForTesting
    static long align(long originalValue, long alignment) {
        long valueMod = originalValue % alignment;
        originalValue = valueMod <= alignment / 2L ? (originalValue -= valueMod) : (originalValue += alignment - valueMod);
        return originalValue;
    }

    public void handleEvent(long timestampNs, @NotNull Event energyEvent, Object eventArg) {
        switch (energyEvent) {
            case CPU_USAGE: {
                Object[] cpuCoresUsage = (PowerProfile.CpuCoreUsage[])eventArg;
                if (Arrays.equals(this.myLastCpuCoresUsage, cpuCoresUsage)) break;
                this.myLastCpuCoresUsage = cpuCoresUsage;
                this.addNewCpuSample(timestampNs);
                break;
            }
            case NETWORK_USAGE: {
                PowerProfile.NetworkStats networkStats = (PowerProfile.NetworkStats)eventArg;
                if (this.myNetworkType == networkStats.myNetworkType && this.myReceivingBps == networkStats.myReceivingBps && this.mySendingBps == networkStats.mySendingBps) break;
                this.myNetworkType = networkStats.myNetworkType;
                this.myReceivingBps = networkStats.myReceivingBps;
                this.mySendingBps = networkStats.mySendingBps;
                this.addNewNetworkSample(timestampNs, new PowerProfile.NetworkStats(this.myNetworkType, this.myReceivingBps, this.mySendingBps));
                break;
            }
            case LOCATION_REGISTER: {
                PowerProfile.LocationEvent locationEvent = (PowerProfile.LocationEvent)eventArg;
                if (locationEvent.myLocationType != PowerProfile.LocationType.GPS) break;
                this.myGpsLockonMap.put(locationEvent.myEventId, timestampNs);
                this.addNewLocationSample(timestampNs + this.mySampleIntervalNs, new PowerProfile.LocationStats(PowerProfile.LocationType.GPS_ACQUIRE, 0L, this.mySampleIntervalNs));
                break;
            }
            case LOCATION_UNREGISTER: {
                PowerProfile.LocationEvent locationEvent = (PowerProfile.LocationEvent)eventArg;
                Long timestamp = this.myGpsLockonMap.remove(locationEvent.myEventId);
                if (timestamp == null) break;
                this.addNewLocationSample(timestampNs + this.mySampleIntervalNs, new PowerProfile.LocationStats(PowerProfile.LocationType.NONE, 0L, this.mySampleIntervalNs));
                break;
            }
            case LOCATION_UPDATE: {
                this.handleLocationUpdateEvent(timestampNs, (PowerProfile.LocationEvent)eventArg);
            }
        }
    }

    @NotNull
    public List<EnergyProfiler.EnergySample> getSamplesBetween(long startInclusiveNs, long endExclusiveNs) {
        int currIndex = this.getSampleIndexFor(startInclusiveNs);
        ArrayList<EnergyProfiler.EnergySample> samples = new ArrayList<EnergyProfiler.EnergySample>();
        for (long timestampNs = this.alignToSampleInterval(startInclusiveNs); timestampNs < endExclusiveNs; timestampNs += this.mySampleIntervalNs) {
            EnergyProfiler.EnergySample nextSample;
            EnergyProfiler.EnergySample nearestSample = this.mySparseSamples.get(currIndex);
            int nextIndex = currIndex + 1;
            if (nextIndex < this.mySparseSamples.size() && (nextSample = this.mySparseSamples.get(nextIndex)).getTimestamp() <= timestampNs) {
                ++currIndex;
                nearestSample = nextSample;
            }
            samples.add(nearestSample.toBuilder().setTimestamp(timestampNs).build());
        }
        return samples;
    }

    private int getSampleIndexFor(long timestampNs) {
        for (int i = this.mySparseSamples.size() - 1; i >= 0; --i) {
            EnergyProfiler.EnergySample sample = this.mySparseSamples.get(i);
            if (sample.getTimestamp() > timestampNs) continue;
            return i;
        }
        return 0;
    }

    private void addNewCpuSample(long timestampNs) {
        this.addNewSample(timestampNs, usage -> usage.setCpuUsage(this.myPowerProfile.getCpuUsage(this.myLastCpuCoresUsage)));
    }

    private void addNewNetworkSample(long timestampNs, @NotNull PowerProfile.NetworkStats networkStats) {
        this.addNewSample(timestampNs, usage -> usage.setNetworkUsage(this.myPowerProfile.getNetworkUsage(networkStats)));
    }

    @NotNull
    private EnergyProfiler.EnergySample addNewLocationSample(long timestampNs, @NotNull PowerProfile.LocationStats locationStats) {
        return this.addNewSample(timestampNs, usage -> usage.setLocationUsage(this.myPowerProfile.getLocationUsage(locationStats)));
    }

    private void removeLocationSample(long timestampNs) {
        this.removeDataFromSample(timestampNs, sample -> sample.setLocationUsage(0));
    }

    @NotNull
    private EnergyProfiler.EnergySample addNewSample(long timestampNs, @NotNull Function<Energy.EnergyUsageData.Builder, Energy.EnergyUsageData.Builder> produceNewUsage) {
        EnergyProfiler.EnergySample newSampleNoTime;
        int prevSampleIndex;
        EnergyProfiler.EnergySample prevSample;
        if ((timestampNs = this.alignToSampleInterval(timestampNs)) < (prevSample = this.mySparseSamples.get(prevSampleIndex = this.getSampleIndexFor(timestampNs))).getTimestamp()) {
            throw new IllegalArgumentException("Received energy events out of order");
        }
        EnergyProfiler.EnergySample newSample = EnergyProfiler.EnergySample.newBuilder().setTimestamp(timestampNs).setEnergyUsage(produceNewUsage.apply(prevSample.getEnergyUsage().toBuilder())).build();
        EnergyProfiler.EnergySample prevSampleNoTime = prevSample.toBuilder().setTimestamp(0L).build();
        if (!prevSampleNoTime.equals((Object)(newSampleNoTime = newSample.toBuilder().setTimestamp(0L).build()))) {
            if (prevSample.getTimestamp() == newSample.getTimestamp()) {
                this.mySparseSamples.set(prevSampleIndex, newSample);
            } else {
                this.mySparseSamples.add(prevSampleIndex + 1, newSample);
            }
        }
        return newSample;
    }

    private void removeDataFromSample(long timestampNs, @NotNull Function<Energy.EnergyUsageData.Builder, Energy.EnergyUsageData.Builder> resetSample) {
        int sampleIndex;
        EnergyProfiler.EnergySample originalSample;
        if ((timestampNs = this.alignToSampleInterval(timestampNs)) != (originalSample = this.mySparseSamples.get(sampleIndex = this.getSampleIndexFor(timestampNs))).getTimestamp()) {
            return;
        }
        EnergyProfiler.EnergySample updatedSample = EnergyProfiler.EnergySample.newBuilder().setTimestamp(timestampNs).setEnergyUsage(resetSample.apply(originalSample.getEnergyUsage().toBuilder())).build();
        EnergyProfiler.EnergySample updatedSampleNoTime = updatedSample.toBuilder().setTimestamp(0L).build();
        if (updatedSampleNoTime.equals((Object)EnergyProfiler.EnergySample.getDefaultInstance())) {
            this.mySparseSamples.remove(sampleIndex);
        } else {
            this.mySparseSamples.set(sampleIndex, updatedSample);
        }
    }

    private void handleLocationUpdateEvent(long timestampNs, @NotNull PowerProfile.LocationEvent locationEvent) {
        switch (locationEvent.myLocationType) {
            case GPS: {
                if (this.myGpsLockonMap.containsKey(locationEvent.myEventId)) {
                    this.myGpsLockonMap.remove(locationEvent.myEventId);
                    this.addNewLocationSample(timestampNs, new PowerProfile.LocationStats(PowerProfile.LocationType.NONE, 0L, this.mySampleIntervalNs));
                } else {
                    EnergyProfiler.EnergySample previousSample = this.myLocationSmoothingMap.get(locationEvent.myEventId);
                    long residualTime = this.calculateResidualSmoothingTime(previousSample, timestampNs);
                    if (residualTime > 0L) {
                        this.removeLocationSample(previousSample.getTimestamp() + this.mySmoothingEndDeltaTime);
                    }
                    EnergyProfiler.EnergySample eventSample = this.addNewLocationSample(timestampNs, new PowerProfile.LocationStats(PowerProfile.LocationType.GPS, Math.min(GPS_LOCK_DURATION_NS, timestampNs - this.myLastGpsOffTime) + residualTime, this.mySampleIntervalNs * 4L));
                    this.myLocationSmoothingMap.put(locationEvent.myEventId, eventSample);
                    this.addNewLocationSample(timestampNs + this.mySmoothingEndDeltaTime, new PowerProfile.LocationStats(PowerProfile.LocationType.NONE, 0L, this.mySampleIntervalNs));
                }
                this.myLastGpsOffTime = timestampNs;
                break;
            }
            case NETWORK: {
                this.addNewLocationSample(timestampNs, new PowerProfile.LocationStats(PowerProfile.LocationType.NETWORK, Math.min(NETWORK_SCAN_DURATION_NS, timestampNs - this.myLastNetworkLocationOffTime), this.mySampleIntervalNs * 4L));
                this.addNewLocationSample(timestampNs + 4L * this.mySampleIntervalNs, new PowerProfile.LocationStats(PowerProfile.LocationType.NONE, 0L, this.mySampleIntervalNs));
                this.myLastNetworkLocationOffTime = timestampNs;
                break;
            }
            default: {
                this.addNewLocationSample(timestampNs, new PowerProfile.LocationStats(locationEvent.myLocationType, 0L, this.mySampleIntervalNs));
            }
        }
    }

    private long alignToSampleInterval(long timestampNs) {
        return BatteryModel.align(timestampNs, this.mySampleIntervalNs);
    }

    private long calculateResidualSmoothingTime(@Nullable EnergyProfiler.EnergySample previousSample, long currentTime) {
        if (previousSample == null) {
            return 0L;
        }
        return Math.max(0L, this.alignToSampleInterval(previousSample.getTimestamp() + this.mySmoothingEndDeltaTime) - this.alignToSampleInterval(currentTime));
    }

    public static enum Event {
        CPU_USAGE,
        NETWORK_USAGE,
        LOCATION_REGISTER,
        LOCATION_UNREGISTER,
        LOCATION_UPDATE;

    }
}

