/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore;

import com.android.tools.datastore.LogService;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class DataStoreDatabase {
    @NotNull
    private final LogService myLogService;
    private final Connection myConnection;

    @NotNull
    private LogService.Logger getLogger() {
        return this.myLogService.getLogger(DataStoreDatabase.class);
    }

    public DataStoreDatabase(@NotNull String dbPath, @NotNull Characteristic characteristic, @NotNull LogService logService) {
        this(dbPath, characteristic, logService, t -> {});
    }

    public DataStoreDatabase(@NotNull String dbPath, @NotNull Characteristic characteristic, @NotNull LogService logService, @NotNull Consumer<Throwable> noPiiExceptionHandler) {
        this.myLogService = logService;
        Connection connection = null;
        try {
            Class.forName("org.sqlite.JDBC");
            switch (characteristic) {
                case PERFORMANT: {
                    connection = DriverManager.getConnection("jdbc:sqlite::memory:");
                    break;
                }
                case DURABLE: {
                    File parent;
                    File dbFile = new File(dbPath);
                    if (dbFile.exists()) {
                        dbFile.delete();
                    }
                    if ((parent = dbFile.getParentFile()) != null && !parent.mkdirs() && !parent.exists()) {
                        this.getLogger().error("Unable to create parent directory");
                    }
                    connection = DriverManager.getConnection(String.format("jdbc:sqlite:%s", dbFile.getPath()));
                    break;
                }
                default: {
                    throw new RuntimeException("Characteristic not handled!");
                }
            }
            connection.setAutoCommit(false);
        }
        catch (ClassNotFoundException e) {
            this.getLogger().error(e);
        }
        catch (SQLException e) {
            noPiiExceptionHandler.accept(e);
        }
        this.myConnection = connection;
    }

    public void disconnect() {
        try {
            this.myConnection.commit();
        }
        catch (SQLException e) {
            this.getLogger().error(e);
        }
        finally {
            try {
                if (!this.myConnection.isClosed()) {
                    this.myConnection.close();
                }
            }
            catch (SQLException e) {
                this.getLogger().error(e);
            }
        }
    }

    public Connection getConnection() {
        return this.myConnection;
    }

    public static enum Characteristic {
        DURABLE,
        PERFORMANT;

    }
}

