/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.util;

import git4idea.remote.hosting.HostedGitRepositoryMapping;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.ui.branch.GitRepositoryMappingData;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GHRepositoryCoordinates;
import org.jetbrains.plugins.github.api.GHRepositoryPath;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.util.GitRemoteUrlCoordinates;
import org.jetbrains.plugins.github.util.GithubUrlUtil;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 (2\u00020\u00012\u00020\u0002:\u0001(B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$H\u0096\u0002J\b\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020\u001eH\u0016R\u001c\u0010\b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u00020\u00128\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0013\u0010\n\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\fR\u0014\u0010\u001d\u001a\u00020\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u0006)"}, d2={"Lorg/jetbrains/plugins/github/util/GHGitRepositoryMapping;", "Lgit4idea/ui/branch/GitRepositoryMappingData;", "Lgit4idea/remote/hosting/HostedGitRepositoryMapping;", "repository", "Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;", "remote", "Lgit4idea/remote/GitRemoteUrlCoordinates;", "(Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;Lgit4idea/remote/GitRemoteUrlCoordinates;)V", "ghRepositoryCoordinates", "getGhRepositoryCoordinates$annotations", "()V", "getGhRepositoryCoordinates", "()Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;", "gitRemote", "Lgit4idea/repo/GitRemote;", "getGitRemote", "()Lgit4idea/repo/GitRemote;", "gitRemoteUrlCoordinates", "Lorg/jetbrains/plugins/github/util/GitRemoteUrlCoordinates;", "getGitRemoteUrlCoordinates$annotations", "getGitRemoteUrlCoordinates", "()Lorg/jetbrains/plugins/github/util/GitRemoteUrlCoordinates;", "gitRepository", "Lgit4idea/repo/GitRepository;", "getGitRepository", "()Lgit4idea/repo/GitRepository;", "getRemote", "()Lgit4idea/remote/GitRemoteUrlCoordinates;", "getRepository", "repositoryPath", "", "getRepositoryPath", "()Ljava/lang/String;", "equals", "", "other", "", "hashCode", "", "toString", "Companion", "intellij.vcs.github"})
public final class GHGitRepositoryMapping
implements GitRepositoryMappingData,
HostedGitRepositoryMapping {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GHRepositoryCoordinates repository;
    @NotNull
    private final git4idea.remote.GitRemoteUrlCoordinates remote;
    @NotNull
    private final GHRepositoryCoordinates ghRepositoryCoordinates;
    @NotNull
    private final GitRemoteUrlCoordinates gitRemoteUrlCoordinates;

    public GHGitRepositoryMapping(@NotNull GHRepositoryCoordinates repository, @NotNull git4idea.remote.GitRemoteUrlCoordinates remote) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)remote, (String)"remote");
        this.repository = repository;
        this.remote = remote;
        this.ghRepositoryCoordinates = this.getRepository();
        this.gitRemoteUrlCoordinates = new GitRemoteUrlCoordinates(this.getRemote());
    }

    @NotNull
    public GHRepositoryCoordinates getRepository() {
        return this.repository;
    }

    @NotNull
    public git4idea.remote.GitRemoteUrlCoordinates getRemote() {
        return this.remote;
    }

    @NotNull
    public GitRemote getGitRemote() {
        return this.getRemote().getRemote();
    }

    @NotNull
    public GitRepository getGitRepository() {
        return this.getRemote().getRepository();
    }

    @NotNull
    public String getRepositoryPath() {
        return this.getRepository().getRepositoryPath().getRepository();
    }

    @NotNull
    public final GHRepositoryCoordinates getGhRepositoryCoordinates() {
        return this.ghRepositoryCoordinates;
    }

    @Deprecated(message="use repository property", replaceWith=@ReplaceWith(expression="repository", imports={}))
    public static /* synthetic */ void getGhRepositoryCoordinates$annotations() {
    }

    @NotNull
    public final GitRemoteUrlCoordinates getGitRemoteUrlCoordinates() {
        return this.gitRemoteUrlCoordinates;
    }

    @Deprecated(message="use remote property", replaceWith=@ReplaceWith(expression="remote", imports={}))
    public static /* synthetic */ void getGitRemoteUrlCoordinates$annotations() {
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GHGitRepositoryMapping)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getRepository(), (Object)((GHGitRepositoryMapping)other).getRepository());
    }

    public int hashCode() {
        return this.getRepository().hashCode();
    }

    @NotNull
    public String toString() {
        return "(repository=" + this.getRepository() + ", remote=" + this.getRepository() + ")";
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\tH\u0007\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/github/util/GHGitRepositoryMapping$Companion;", "", "()V", "create", "Lorg/jetbrains/plugins/github/util/GHGitRepositoryMapping;", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "remote", "Lgit4idea/remote/GitRemoteUrlCoordinates;", "Lorg/jetbrains/plugins/github/util/GitRemoteUrlCoordinates;", "intellij.vcs.github"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final GHGitRepositoryMapping create(@NotNull GithubServerPath server, @NotNull git4idea.remote.GitRemoteUrlCoordinates remote) {
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            Intrinsics.checkNotNullParameter((Object)remote, (String)"remote");
            GHRepositoryPath gHRepositoryPath = GithubUrlUtil.getUserAndRepositoryFromRemoteUrl(remote.getUrl());
            if (gHRepositoryPath == null) {
                return null;
            }
            GHRepositoryPath repositoryPath = gHRepositoryPath;
            GHRepositoryCoordinates repository = new GHRepositoryCoordinates(server, repositoryPath);
            return new GHGitRepositoryMapping(repository, remote);
        }

        @Deprecated(message="remote extracted to collab")
        @Nullable
        public final GHGitRepositoryMapping create(@NotNull GithubServerPath server, @NotNull GitRemoteUrlCoordinates remote) {
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            Intrinsics.checkNotNullParameter((Object)remote, (String)"remote");
            GHRepositoryPath gHRepositoryPath = GithubUrlUtil.getUserAndRepositoryFromRemoteUrl(remote.getUrl());
            if (gHRepositoryPath == null) {
                return null;
            }
            GHRepositoryPath repositoryPath = gHRepositoryPath;
            GHRepositoryCoordinates repository = new GHRepositoryCoordinates(server, repositoryPath);
            return new GHGitRepositoryMapping(repository, remote.toExtracted());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

