/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.util;

import com.intellij.collaboration.async.CompletableFutureUtil;
import com.intellij.collaboration.util.ProgressIndicatorsProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Disposer;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubApiRequest;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.api.data.GHEnterpriseServerMeta;

@Service
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\f\u001a\u00020\rH\u0016J\u001d\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u0011J\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0013\u001a\u00020\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/plugins/github/util/GHEnterpriseServerMetadataLoader;", "Lcom/intellij/openapi/Disposable;", "()V", "apiRequestExecutor", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;", "indicatorProvider", "Lcom/intellij/collaboration/util/ProgressIndicatorsProvider;", "serverMetadataRequests", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "Ljava/util/concurrent/CompletableFuture;", "Lorg/jetbrains/plugins/github/api/data/GHEnterpriseServerMeta;", "dispose", "", "findRequestByEndpointUrl", "url", "", "findRequestByEndpointUrl$intellij_vcs_github", "loadMetadata", "server", "intellij.vcs.github"})
public final class GHEnterpriseServerMetadataLoader
implements Disposable {
    @NotNull
    private final GithubApiRequestExecutor apiRequestExecutor = GithubApiRequestExecutor.Factory.Companion.getInstance().create();
    @NotNull
    private final ConcurrentHashMap<GithubServerPath, CompletableFuture<GHEnterpriseServerMeta>> serverMetadataRequests = new ConcurrentHashMap();
    @NotNull
    private final ProgressIndicatorsProvider indicatorProvider;

    /*
     * WARNING - void declaration
     */
    public GHEnterpriseServerMetadataLoader() {
        void it;
        ProgressIndicatorsProvider progressIndicatorsProvider;
        ProgressIndicatorsProvider progressIndicatorsProvider2 = progressIndicatorsProvider = new ProgressIndicatorsProvider();
        GHEnterpriseServerMetadataLoader gHEnterpriseServerMetadataLoader = this;
        boolean bl = false;
        Disposer.register((Disposable)this, (Disposable)((Disposable)it));
        gHEnterpriseServerMetadataLoader.indicatorProvider = progressIndicatorsProvider;
    }

    @NotNull
    public final CompletableFuture<GHEnterpriseServerMeta> loadMetadata(@NotNull GithubServerPath server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        if (!(!server.isGithubDotCom())) {
            boolean $i$a$-require-GHEnterpriseServerMetadataLoader$loadMetadata$22 = false;
            String $i$a$-require-GHEnterpriseServerMetadataLoader$loadMetadata$22 = "Cannot retrieve server metadata from github.com";
            throw new IllegalArgumentException($i$a$-require-GHEnterpriseServerMetadataLoader$loadMetadata$22.toString());
        }
        ConcurrentMap $this$getOrPut$iv = this.serverMetadataRequests;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(server);
        if (object == null) {
            boolean bl = false;
            ProgressManager progressManager = ProgressManager.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)progressManager, (String)"getInstance()");
            CompletableFuture default$iv = CompletableFutureUtil.INSTANCE.submitIOTask(progressManager, this.indicatorProvider, (Function1)new Function1<ProgressIndicator, GHEnterpriseServerMeta>(server, this){
                final /* synthetic */ GithubServerPath $server;
                final /* synthetic */ GHEnterpriseServerMetadataLoader this$0;
                {
                    this.$server = $server;
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final GHEnterpriseServerMeta invoke(@NotNull ProgressIndicator it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    String metaUrl = this.$server.toApiUrl() + "/meta";
                    GithubApiRequest.Get.Companion $this$iv = GithubApiRequest.Get.Companion;
                    String acceptMimeType$iv = null;
                    boolean $i$f$json = false;
                    return (GHEnterpriseServerMeta)GHEnterpriseServerMetadataLoader.access$getApiRequestExecutor$p(this.this$0).execute(it, (GithubApiRequest)new GithubApiRequest.Get.Json<GHEnterpriseServerMeta>(metaUrl, GHEnterpriseServerMeta.class, acceptMimeType$iv));
                }
            });
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(server, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        Intrinsics.checkNotNullExpressionValue(object, (String)"serverMetadataRequests.g\u2026>(metaUrl))\n      }\n    }");
        return (CompletableFuture)object;
    }

    @Nullable
    public final CompletableFuture<GHEnterpriseServerMeta> findRequestByEndpointUrl$intellij_vcs_github(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        for (Map.Entry entry : ((Map)this.serverMetadataRequests).entrySet()) {
            String serverUrl;
            GithubServerPath server = (GithubServerPath)entry.getKey();
            CompletableFuture request = (CompletableFuture)entry.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)server.toUrl(), (String)"server.toUrl()");
            if (!StringsKt.startsWith$default((String)url, (String)serverUrl, (boolean)false, (int)2, null)) continue;
            return request;
        }
        return null;
    }

    public void dispose() {
    }

    public static final /* synthetic */ GithubApiRequestExecutor access$getApiRequestExecutor$p(GHEnterpriseServerMetadataLoader $this) {
        return $this.apiRequestExecutor;
    }
}

