/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.ui.util;

import com.intellij.collaboration.ui.codereview.BaseHtmlEditorPane;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.Graphics2DDelegate;
import com.intellij.util.ui.ExtendableHTMLViewFactory;
import com.intellij.util.ui.HTMLEditorKitBuilder;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.ImageObserver;
import javax.swing.Icon;
import javax.swing.text.Element;
import javax.swing.text.FlowView;
import javax.swing.text.View;
import javax.swing.text.html.HTML;
import javax.swing.text.html.ImageView;
import javax.swing.text.html.InlineView;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0000\u0018\u0000 \u00062\u00020\u0001:\u0003\u0006\u0007\bB\u0011\b\u0016\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0005\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/github/ui/util/HtmlEditorPane;", "Lcom/intellij/collaboration/ui/codereview/BaseHtmlEditorPane;", "body", "", "(Ljava/lang/String;)V", "()V", "Companion", "GHExtensions", "MyScalingImageView", "intellij.vcs.github"})
public final class HtmlEditorPane
extends BaseHtmlEditorPane {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String ICON_INLINE_ELEMENT_NAME = "icon-inline";

    public HtmlEditorPane() {
        Function2[] function2Array = new Function2[]{(Function2)ExtendableHTMLViewFactory.Extensions.WORD_WRAP, (Function2)new GHExtensions()};
        this.setEditorKit(new HTMLEditorKitBuilder().withViewFactoryExtensions(function2Array).build());
    }

    public HtmlEditorPane(@NlsSafe @NotNull String body2) {
        Intrinsics.checkNotNullParameter((Object)body2, (String)"body");
        this();
        this.setBody(body2);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0096\u0002\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/github/ui/util/HtmlEditorPane$GHExtensions;", "Lcom/intellij/util/ui/ExtendableHTMLViewFactory$Extension;", "()V", "invoke", "Ljavax/swing/text/View;", "elem", "Ljavax/swing/text/Element;", "view", "intellij.vcs.github"})
    private static final class GHExtensions
    implements ExtendableHTMLViewFactory.Extension {
        @NotNull
        public View invoke(@NotNull Element elem, @NotNull View view) {
            Intrinsics.checkNotNullParameter((Object)elem, (String)"elem");
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            if (view instanceof ImageView) {
                return new MyScalingImageView(elem);
            }
            if (Intrinsics.areEqual((Object)HtmlEditorPane.ICON_INLINE_ELEMENT_NAME, (Object)elem.getName())) {
                Icon icon;
                Object object = elem.getAttributes().getAttribute(HTML.Attribute.SRC);
                if (object != null) {
                    Object it = object;
                    boolean bl = false;
                    String path = (String)it;
                    v1 = IconLoader.findIcon((String)path, ExtendableHTMLViewFactory.class, (boolean)true, (boolean)false);
                } else {
                    v1 = icon = null;
                }
                if (icon != null) {
                    return new InlineView(elem, icon){
                        final /* synthetic */ Icon $icon;
                        {
                            this.$icon = $icon;
                            super($elem);
                        }

                        public float getPreferredSpan(int axis) {
                            if (axis == 0) {
                                return (float)this.$icon.getIconWidth() + super.getPreferredSpan(axis);
                            }
                            return super.getPreferredSpan(axis);
                        }

                        public void paint(@NotNull Graphics g, @NotNull Shape allocation) {
                            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                            Intrinsics.checkNotNullParameter((Object)allocation, (String)"allocation");
                            super.paint(g, allocation);
                            this.$icon.paintIcon(null, g, allocation.getBounds().x, allocation.getBounds().y);
                        }
                    };
                }
            }
            return view;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\u0006H\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006H\u0016J\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006H\u0016J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006H\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/plugins/github/ui/util/HtmlEditorPane$MyScalingImageView;", "Ljavax/swing/text/html/ImageView;", "element", "Ljavax/swing/text/Element;", "(Ljavax/swing/text/Element;)V", "myAvailableWidth", "", "getAvailableWidth", "getMaximumSpan", "", "axis", "getPreferredSpan", "getResizeWeight", "paint", "", "g", "Ljava/awt/Graphics;", "a", "Ljava/awt/Shape;", "intellij.vcs.github"})
    private static final class MyScalingImageView
    extends ImageView {
        private int myAvailableWidth;

        public MyScalingImageView(@NotNull Element element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            super(element);
        }

        @Override
        public int getResizeWeight(int axis) {
            return 1;
        }

        @Override
        public float getMaximumSpan(int axis) {
            return this.getPreferredSpan(axis);
        }

        @Override
        public float getPreferredSpan(int axis) {
            float baseSpan = super.getPreferredSpan(axis);
            if (axis == 0) {
                return baseSpan;
            }
            int availableWidth = this.getAvailableWidth();
            if (availableWidth <= 0) {
                return baseSpan;
            }
            float baseXSpan = super.getPreferredSpan(0);
            if (baseXSpan <= 0.0f) {
                return baseSpan;
            }
            if ((float)availableWidth > baseXSpan) {
                availableWidth = (int)baseXSpan;
            }
            if (this.myAvailableWidth > 0 && availableWidth != this.myAvailableWidth) {
                this.preferenceChanged(null, false, true);
            }
            this.myAvailableWidth = availableWidth;
            return baseSpan * (float)availableWidth / baseXSpan;
        }

        private final int getAvailableWidth() {
            View v = this;
            while (v != null) {
                View parent = v.getParent();
                if (parent instanceof FlowView) {
                    int childCount = parent.getViewCount();
                    for (int i = 0; i < childCount; ++i) {
                        if (parent.getView(i) != v) continue;
                        return ((FlowView)parent).getFlowSpan(i);
                    }
                }
                v = parent;
            }
            return 0;
        }

        @Override
        public void paint(@NotNull Graphics g, @NotNull Shape a) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Rectangle targetRect = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
            Graphics2DDelegate scalingGraphics2 = new Graphics2DDelegate(g, targetRect){
                final /* synthetic */ Rectangle $targetRect;
                {
                    this.$targetRect = $targetRect;
                    Intrinsics.checkNotNull((Object)$g, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
                    super((Graphics2D)$g);
                }

                public boolean drawImage(@NotNull Image img, int x, int y, int width, int height, @NotNull ImageObserver observer) {
                    Intrinsics.checkNotNullParameter((Object)img, (String)"img");
                    Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
                    int newWidth = width;
                    int newHeight = height;
                    int maxWidth = RangesKt.coerceAtLeast((int)0, (int)(this.$targetRect.width - 2 * (x - this.$targetRect.x)));
                    int maxHeight = RangesKt.coerceAtLeast((int)0, (int)(this.$targetRect.height - 2 * (y - this.$targetRect.y)));
                    if (width > maxWidth) {
                        newHeight = height * maxWidth / width;
                        newWidth = maxWidth;
                    }
                    if (height > maxHeight) {
                        newWidth = width * maxHeight / height;
                        newHeight = maxHeight;
                    }
                    return super.drawImage(img, x, y, newWidth, newHeight, observer);
                }
            };
            super.paint((Graphics)scalingGraphics2, a);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/plugins/github/ui/util/HtmlEditorPane$Companion;", "", "()V", "ICON_INLINE_ELEMENT_NAME", "", "intellij.vcs.github"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

