/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.ui.util;

import com.intellij.UtilBundle;
import com.intellij.collaboration.async.CompletableFutureUtil;
import com.intellij.collaboration.ui.CollaborationToolsUIUtil;
import com.intellij.collaboration.ui.icon.IconsProvider;
import com.intellij.collaboration.util.CollectionDelta;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.editor.impl.view.FontLayoutService;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.ListUtil;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.UIBundle;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.ColorIcon;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.LafIconLookup;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import icons.CollaborationToolsIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.GithubIcons;
import org.jetbrains.plugins.github.api.GHRepositoryCoordinates;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.api.data.GHLabel;
import org.jetbrains.plugins.github.api.data.GHUser;
import org.jetbrains.plugins.github.api.data.GithubIssueState;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestRequestedReviewer;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestState;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.ui.util.GHUIUtil;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u000245B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019J\u0006\u0010\u001b\u001a\u00020\u0004J\u0016\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0018\u0010 \u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0007J(\u0010!\u001a\u00020\n2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\u0006\u0010%\u001a\u00020$2\b\b\u0002\u0010&\u001a\u00020\u001fH\u0007J\u0016\u0010'\u001a\u00020\u001f2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020$0#H\u0002J\u0016\u0010)\u001a\u00020\u001f2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020$0#H\u0002JZ\u0010*\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H-0,0+\"\u0004\b\u0000\u0010-2\b\b\u0001\u0010.\u001a\u00020\n2\u0006\u0010/\u001a\u00020\u00102\f\u00100\u001a\b\u0012\u0004\u0012\u0002H-012\f\u00102\u001a\b\u0012\u0004\u0012\u0002H-0#2\u0012\u00103\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H-0#0+R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lorg/jetbrains/plugins/github/ui/util/GHUIUtil;", "", "()V", "AVATAR_SIZE", "", "createIssueLabelLabel", "Lcom/intellij/ui/components/JBLabel;", "label", "Lorg/jetbrains/plugins/github/api/data/GHLabel;", "formatActionDate", "", "date", "Ljava/util/Date;", "getFontEM", "", "component", "Ljavax/swing/JComponent;", "getIssueStateIcon", "Ljavax/swing/Icon;", "state", "Lorg/jetbrains/plugins/github/api/data/GithubIssueState;", "getIssueStateText", "getLabelBackground", "Lcom/intellij/ui/JBColor;", "getLabelForeground", "Ljava/awt/Color;", "bg", "getPRTimelineWidth", "getPullRequestStateIcon", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestState;", "isDraft", "", "getPullRequestStateText", "getRepositoryDisplayName", "allRepositories", "", "Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;", "repository", "alwaysShowOwner", "needToShowRepositoryOwner", "repos", "needToShowRepositoryServer", "showChooserPopup", "Ljava/util/concurrent/CompletableFuture;", "Lcom/intellij/collaboration/util/CollectionDelta;", "T", "popupTitle", "parentComponent", "cellRenderer", "Lorg/jetbrains/plugins/github/ui/util/GHUIUtil$SelectionListCellRenderer;", "currentList", "availableListFuture", "SelectableWrapper", "SelectionListCellRenderer", "intellij.vcs.github"})
public final class GHUIUtil {
    @NotNull
    public static final GHUIUtil INSTANCE = new GHUIUtil();
    public static final int AVATAR_SIZE = 20;

    private GHUIUtil() {
    }

    @NotNull
    public final Icon getPullRequestStateIcon(@NotNull GHPullRequestState state2, boolean isDraft) {
        Icon icon;
        Intrinsics.checkNotNullParameter((Object)((Object)state2), (String)"state");
        if (isDraft) {
            Icon icon2 = GithubIcons.PullRequestDraft;
            icon = icon2;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"PullRequestDraft");
        } else {
            Icon icon3 = switch (WhenMappings.$EnumSwitchMapping$0[state2.ordinal()]) {
                case 1 -> CollaborationToolsIcons.PullRequestClosed;
                case 2 -> GithubIcons.PullRequestMerged;
                case 3 -> CollaborationToolsIcons.PullRequestOpen;
                default -> throw new NoWhenBranchMatchedException();
            };
            icon = icon3;
            Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"when (state) {\n      GHP\u2026ons.PullRequestOpen\n    }");
        }
        return icon;
    }

    @NlsSafe
    @NotNull
    public final String getPullRequestStateText(@NotNull GHPullRequestState state2, boolean isDraft) {
        String string;
        Intrinsics.checkNotNullParameter((Object)((Object)state2), (String)"state");
        if (isDraft) {
            String string2 = GithubBundle.message("pull.request.state.draft", new Object[0]);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"pull.request.state.draft\")");
        } else {
            String string3 = switch (WhenMappings.$EnumSwitchMapping$0[state2.ordinal()]) {
                case 1 -> GithubBundle.message("pull.request.state.closed", new Object[0]);
                case 2 -> GithubBundle.message("pull.request.state.merged", new Object[0]);
                case 3 -> GithubBundle.message("pull.request.state.open", new Object[0]);
                default -> throw new NoWhenBranchMatchedException();
            };
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"when (state) {\n      GHP\u2026equest.state.open\")\n    }");
        }
        return string;
    }

    @NotNull
    public final Icon getIssueStateIcon(@NotNull GithubIssueState state2) {
        Icon icon;
        Intrinsics.checkNotNullParameter((Object)((Object)state2), (String)"state");
        switch (WhenMappings.$EnumSwitchMapping$1[state2.ordinal()]) {
            case 1: {
                Icon icon2 = GithubIcons.IssueOpened;
                icon = icon2;
                Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"IssueOpened");
                break;
            }
            case 2: {
                Icon icon3 = GithubIcons.IssueClosed;
                icon = icon3;
                Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"IssueClosed");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return icon;
    }

    @NlsSafe
    @NotNull
    public final String getIssueStateText(@NotNull GithubIssueState state2) {
        String string;
        Intrinsics.checkNotNullParameter((Object)((Object)state2), (String)"state");
        switch (WhenMappings.$EnumSwitchMapping$1[state2.ordinal()]) {
            case 1: {
                String string2 = GithubBundle.message("issue.state.open", new Object[0]);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"issue.state.open\")");
                break;
            }
            case 2: {
                String string3 = GithubBundle.message("issue.state.closed", new Object[0]);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(\"issue.state.closed\")");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @NotNull
    public final JBLabel createIssueLabelLabel(@NotNull GHLabel label2) {
        JBLabel jBLabel;
        Intrinsics.checkNotNullParameter((Object)label2, (String)"label");
        JBLabel $this$createIssueLabelLabel_u24lambda_u240 = jBLabel = new JBLabel(" " + label2.getName() + " ", UIUtil.ComponentStyle.SMALL);
        boolean bl = false;
        $this$createIssueLabelLabel_u24lambda_u240.setBackground((Color)INSTANCE.getLabelBackground(label2));
        Color color2 = $this$createIssueLabelLabel_u24lambda_u240.getBackground();
        Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"background");
        $this$createIssueLabelLabel_u24lambda_u240.setForeground(INSTANCE.getLabelForeground(color2));
        JBLabel jBLabel2 = jBLabel.andOpaque();
        Intrinsics.checkNotNullExpressionValue((Object)jBLabel2, (String)"JBLabel(\" ${label.name} \u2026ckground)\n  }.andOpaque()");
        return jBLabel2;
    }

    @NotNull
    public final JBColor getLabelBackground(@NotNull GHLabel label2) {
        Intrinsics.checkNotNullParameter((Object)label2, (String)"label");
        Color color2 = ColorUtil.fromHex((String)label2.getColor());
        Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"fromHex(label.color)");
        Color apiColor = color2;
        return new JBColor(apiColor, ColorUtil.darker((Color)apiColor, (int)3));
    }

    @NotNull
    public final Color getLabelForeground(@NotNull Color bg) {
        Color color2;
        Intrinsics.checkNotNullParameter((Object)bg, (String)"bg");
        if (ColorUtil.isDark((Color)bg)) {
            Color color3 = Color.white;
            color2 = color3;
            Intrinsics.checkNotNullExpressionValue((Object)color3, (String)"white");
        } else {
            Color color4 = Color.black;
            color2 = color4;
            Intrinsics.checkNotNullExpressionValue((Object)color4, (String)"black");
        }
        return color2;
    }

    private final float getFontEM(JComponent component2) {
        FontMetrics metrics = component2.getFontMetrics(component2.getFont());
        return FontLayoutService.getInstance().charWidth2D(metrics, 8212);
    }

    @NotNull
    public final String formatActionDate(@NotNull Date date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        String string = DateFormatUtil.formatPrettyDate((Date)date);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatPrettyDate(date)");
        String string2 = string.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase()");
        String prettyDate = string2;
        String datePrefix = StringsKt.equals((String)prettyDate, (String)UtilBundle.message((String)"date.format.today", (Object[])new Object[0]), (boolean)true) || StringsKt.equals((String)prettyDate, (String)UtilBundle.message((String)"date.format.yesterday", (Object[])new Object[0]), (boolean)true) ? "" : "on ";
        return datePrefix + prettyDate;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <T> CompletableFuture<CollectionDelta<T>> showChooserPopup(@NlsContexts.PopupTitle @NotNull String popupTitle, @NotNull JComponent parentComponent, @NotNull SelectionListCellRenderer<T> cellRenderer, @NotNull List<? extends T> currentList, @NotNull CompletableFuture<List<T>> availableListFuture) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        JBList jBList;
        Intrinsics.checkNotNullParameter((Object)popupTitle, (String)"popupTitle");
        Intrinsics.checkNotNullParameter((Object)parentComponent, (String)"parentComponent");
        Intrinsics.checkNotNullParameter(cellRenderer, (String)"cellRenderer");
        Intrinsics.checkNotNullParameter(currentList, (String)"currentList");
        Intrinsics.checkNotNullParameter(availableListFuture, (String)"availableListFuture");
        CollectionListModel listModel = new CollectionListModel((Object[])new SelectableWrapper[0]);
        JBList $this$showChooserPopup_u24lambda_u241 = jBList = new JBList((ListModel)listModel);
        boolean bl = false;
        $this$showChooserPopup_u24lambda_u241.setVisibleRowCount(7);
        $this$showChooserPopup_u24lambda_u241.setFocusable(false);
        $this$showChooserPopup_u24lambda_u241.setSelectionMode(0);
        JBList list = jBList;
        list.setCellRenderer((ListCellRenderer)cellRenderer);
        JScrollPane $this$showChooserPopup_u24lambda_u242 = bl = ScrollPaneFactory.createScrollPane((Component)((Component)list), (boolean)true);
        boolean bl2 = false;
        $this$showChooserPopup_u24lambda_u242.getViewport().setCursor(Cursor.getPredefinedCursor(12));
        $this$showChooserPopup_u24lambda_u242.setFocusable(false);
        JScrollPane jScrollPane = bl;
        Intrinsics.checkNotNullExpressionValue((Object)jScrollPane, (String)"createScrollPane(list, t\u2026isFocusable = false\n    }");
        JScrollPane scrollPane2 = jScrollPane;
        JScrollPane $this$showChooserPopup_u24lambda_u243 = bl = new SearchTextField(false);
        boolean $i$a$-apply-GHUIUtil$showChooserPopup$searchField$22 = false;
        $this$showChooserPopup_u24lambda_u243.setBorder(IdeBorderFactory.createBorder((int)8));
        UIUtil.setBackgroundRecursively((Component)$this$showChooserPopup_u24lambda_u243, (Color)UIUtil.getListBackground());
        $this$showChooserPopup_u24lambda_u243.getTextEditor().setBorder((Border)JBUI.Borders.empty());
        JScrollPane searchField = bl;
        CollaborationToolsUIUtil.INSTANCE.attachSearch((JList)list, (SearchTextField)searchField, new Function1<SelectableWrapper<T>, String>(cellRenderer){
            final /* synthetic */ SelectionListCellRenderer<T> $cellRenderer;
            {
                this.$cellRenderer = $cellRenderer;
                super(1);
            }

            @NotNull
            public final String invoke(SelectableWrapper<T> it) {
                return this.$cellRenderer.getText(it.getValue());
            }
        });
        BorderLayoutPanel borderLayoutPanel = JBUI.Panels.simplePanel((Component)scrollPane2).addToTop((Component)searchField.getTextEditor());
        Intrinsics.checkNotNullExpressionValue((Object)borderLayoutPanel, (String)"simplePanel(scrollPane).\u2026p(searchField.textEditor)");
        BorderLayoutPanel panel = borderLayoutPanel;
        ListUtil.installAutoSelectOnMouseMove((JList)((JList)list));
        list.addMouseListener((MouseListener)new MouseAdapter(list){
            final /* synthetic */ JBList<SelectableWrapper<T>> $list;
            {
                this.$list = $list;
            }

            public void mouseReleased(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (UIUtil.isActionClick((MouseEvent)e, (int)502) && !UIUtil.isSelectionButtonDown((MouseEvent)e) && !e.isConsumed()) {
                    GHUIUtil.access$showChooserPopup$toggleSelection(this.$list);
                }
            }
        });
        Set originalSelection = CollectionsKt.toHashSet((Iterable)currentList);
        Iterable $i$a$-apply-GHUIUtil$showChooserPopup$searchField$22 = currentList;
        CollectionListModel collectionListModel = listModel;
        boolean $i$f$map = false;
        void var14_17 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            collection.add(new SelectableWrapper<void>(it, true));
        }
        collectionListModel.add((List)destination$iv$iv);
        CompletableFuture result = new CompletableFuture();
        JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)panel, (JComponent)searchField).setRequestFocus(true).setCancelOnClickOutside(true).setTitle(popupTitle).setResizable(true).setMovable(true).setKeyboardActions(CollectionsKt.listOf((Object)Pair.create(arg_0 -> GHUIUtil.showChooserPopup$lambda$5(list, arg_0), (Object)KeyStroke.getKeyStroke(10, 0)))).addListener(new JBPopupListener(list, availableListFuture, originalSelection, cellRenderer, listModel, result){
            final /* synthetic */ JBList<SelectableWrapper<T>> $list;
            final /* synthetic */ CompletableFuture<List<T>> $availableListFuture;
            final /* synthetic */ Set<T> $originalSelection;
            final /* synthetic */ SelectionListCellRenderer<T> $cellRenderer;
            final /* synthetic */ CollectionListModel<SelectableWrapper<T>> $listModel;
            final /* synthetic */ CompletableFuture<CollectionDelta<T>> $result;
            {
                this.$list = $list;
                this.$availableListFuture = $availableListFuture;
                this.$originalSelection = $originalSelection;
                this.$cellRenderer = $cellRenderer;
                this.$listModel = $listModel;
                this.$result = $result;
            }

            public void beforeShown(@NotNull LightweightWindowEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.$list.setPaintBusy(true);
                this.$list.getEmptyText().setText(ApplicationBundle.message((String)"label.loading.page.please.wait", (Object[])new Object[0]));
                CompletionStage completionStage = this.$availableListFuture.thenApplyAsync(arg_0 -> showChooserPopup.5.beforeShown$lambda$0((Function1)new Function1<List<? extends T>, List<? extends SelectableWrapper<T>>>(this.$originalSelection, this.$cellRenderer){
                    final /* synthetic */ Set<T> $originalSelection;
                    final /* synthetic */ SelectionListCellRenderer<T> $cellRenderer;
                    {
                        this.$originalSelection = $originalSelection;
                        this.$cellRenderer = $cellRenderer;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final List<SelectableWrapper<T>> invoke(List<? extends T> available) {
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        Intrinsics.checkNotNullExpressionValue(available, (String)"available");
                        Iterable iterable = available;
                        Set<T> set = this.$originalSelection;
                        boolean $i$f$map = false;
                        void var5_5 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        Iterator<T> iterator = $this$mapTo$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            void it;
                            T item$iv$iv;
                            T t = item$iv$iv = iterator.next();
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            collection.add(new SelectableWrapper<void>(it, set.contains(it)));
                        }
                        Iterable iterable2 = (List)destination$iv$iv;
                        Comparator<Object> comparator = Comparator.comparing(arg_0 -> showChooserPopup.beforeShown.1.invoke$lambda$1(showChooserPopup.beforeShown.2.INSTANCE, arg_0)).thenComparing(arg_0 -> showChooserPopup.beforeShown.1.invoke$lambda$2((Function1)new Function1<SelectableWrapper<T>, String>(this.$cellRenderer){
                            final /* synthetic */ SelectionListCellRenderer<T> $cellRenderer;
                            {
                                this.$cellRenderer = $cellRenderer;
                                super(1);
                            }

                            public final String invoke(SelectableWrapper<T> it) {
                                return this.$cellRenderer.getText(it.getValue());
                            }
                        }, arg_0), (arg_0, arg_1) -> showChooserPopup.beforeShown.1.invoke$lambda$3(showChooserPopup.beforeShown.4.INSTANCE, arg_0, arg_1));
                        Intrinsics.checkNotNullExpressionValue(comparator, (String)"cellRenderer: SelectionL\u2026til.compare(a, b, true) }");
                        return CollectionsKt.sortedWith((Iterable)iterable2, comparator);
                    }

                    private static final Boolean invoke$lambda$1(Function1 $tmp0, Object p0) {
                        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                        return (Boolean)$tmp0.invoke(p0);
                    }

                    private static final String invoke$lambda$2(Function1 $tmp0, Object p0) {
                        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                        return (String)$tmp0.invoke(p0);
                    }

                    private static final int invoke$lambda$3(Function2 $tmp0, Object p0, Object p1) {
                        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                        return ((Number)$tmp0.invoke(p0, p1)).intValue();
                    }
                }, arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"T> showChooserPopup(@Nls\u2026b, true) })\n            }");
                CompletableFutureUtil.successOnEdt$default((CompletableFutureUtil)CompletableFutureUtil.INSTANCE, (CompletableFuture)completionStage, null, (Function1)((Function1)new Function1<List<? extends SelectableWrapper<T>>, Unit>(this.$listModel, this.$list, event){
                    final /* synthetic */ CollectionListModel<SelectableWrapper<T>> $listModel;
                    final /* synthetic */ JBList<SelectableWrapper<T>> $list;
                    final /* synthetic */ LightweightWindowEvent $event;
                    {
                        this.$listModel = $listModel;
                        this.$list = $list;
                        this.$event = $event;
                        super(1);
                    }

                    public final void invoke(List<SelectableWrapper<T>> it) {
                        this.$listModel.replaceAll(it);
                        this.$list.setPaintBusy(false);
                        this.$list.getEmptyText().setText(UIBundle.message((String)"message.noMatchesFound", (Object[])new Object[0]));
                        this.$event.asPopup().pack(true, true);
                        if (this.$list.getSelectedIndex() == -1) {
                            this.$list.setSelectedIndex(0);
                        }
                    }
                }), (int)1, null);
            }

            /*
             * WARNING - void declaration
             */
            public void onClosed(@NotNull LightweightWindowEvent event) {
                void $this$mapTo$iv$iv;
                SelectableWrapper it;
                Iterable $this$filterTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                List list = this.$listModel.getItems();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"listModel.items");
                Iterable $this$filter$iv = list;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (SelectableWrapper)element$iv$iv;
                    boolean bl = false;
                    if (!it.getSelected()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    it = (SelectableWrapper)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getValue());
                }
                List selected = (List)destination$iv$iv;
                this.$result.complete(new CollectionDelta((Collection)this.$originalSelection, (Collection)selected));
            }

            private static final List beforeShown$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (List)$tmp0.invoke(p0);
            }
        }).createPopup().showUnderneathOf((Component)parentComponent);
        return result;
    }

    public final int getPRTimelineWidth() {
        return (int)(this.getFontEM(new JLabel()) * (float)42);
    }

    @NlsSafe
    @NotNull
    public final String getRepositoryDisplayName(@NotNull List<GHRepositoryCoordinates> allRepositories, @NotNull GHRepositoryCoordinates repository, boolean alwaysShowOwner) {
        Intrinsics.checkNotNullParameter(allRepositories, (String)"allRepositories");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        boolean showServer = this.needToShowRepositoryServer(allRepositories);
        boolean showOwner = showServer || alwaysShowOwner ? true : this.needToShowRepositoryOwner(allRepositories);
        StringBuilder builder = new StringBuilder();
        if (showServer) {
            builder.append(repository.getServerPath().toUrl(false)).append("/");
        }
        if (showOwner) {
            builder.append(repository.getRepositoryPath().getOwner()).append("/");
        }
        builder.append(repository.getRepositoryPath().getRepository());
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
        return string;
    }

    public static /* synthetic */ String getRepositoryDisplayName$default(GHUIUtil gHUIUtil, List list, GHRepositoryCoordinates gHRepositoryCoordinates, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return gHUIUtil.getRepositoryDisplayName(list, gHRepositoryCoordinates, bl);
    }

    private final boolean needToShowRepositoryOwner(List<GHRepositoryCoordinates> repos) {
        boolean bl;
        block4: {
            if (repos.size() <= 1) {
                return false;
            }
            String firstOwner = ((GHRepositoryCoordinates)CollectionsKt.first(repos)).getRepositoryPath().getOwner();
            Iterable $this$any$iv = repos;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    GHRepositoryCoordinates it = (GHRepositoryCoordinates)element$iv;
                    boolean bl2 = false;
                    if (!(!Intrinsics.areEqual((Object)it.getRepositoryPath().getOwner(), (Object)firstOwner))) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean needToShowRepositoryServer(List<GHRepositoryCoordinates> repos) {
        boolean bl;
        block4: {
            if (repos.size() <= 1) {
                return false;
            }
            GithubServerPath firstServer = ((GHRepositoryCoordinates)CollectionsKt.first(repos)).getServerPath();
            Iterable $this$any$iv = repos;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    GHRepositoryCoordinates it = (GHRepositoryCoordinates)element$iv;
                    boolean bl2 = false;
                    if (!(!Intrinsics.areEqual((Object)it.getServerPath(), (Object)firstServer))) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final <T> void showChooserPopup$toggleSelection(JBList<SelectableWrapper<T>> list) {
        Iterator iterator = list.getSelectedValuesList().iterator();
        while (iterator.hasNext()) {
            SelectableWrapper item;
            item.setSelected(!(item = (SelectableWrapper)iterator.next()).getSelected());
        }
        list.repaint();
    }

    private static final void showChooserPopup$lambda$5(JBList $list, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)$list, (String)"$list");
        GHUIUtil.showChooserPopup$toggleSelection($list);
    }

    public static final /* synthetic */ void access$showChooserPopup$toggleSelection(JBList list) {
        GHUIUtil.showChooserPopup$toggleSelection(list);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000e\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\fJ\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J(\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00028\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0011J\u0013\u0010\u0012\u001a\u00020\u00052\b\u0010\u0013\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0013\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/plugins/github/ui/util/GHUIUtil$SelectableWrapper;", "T", "", "value", "selected", "", "(Ljava/lang/Object;Z)V", "getSelected", "()Z", "setSelected", "(Z)V", "getValue", "()Ljava/lang/Object;", "Ljava/lang/Object;", "component1", "component2", "copy", "(Ljava/lang/Object;Z)Lorg/jetbrains/plugins/github/ui/util/GHUIUtil$SelectableWrapper;", "equals", "other", "hashCode", "", "toString", "", "intellij.vcs.github"})
    public static final class SelectableWrapper<T> {
        private final T value;
        private boolean selected;

        public SelectableWrapper(T value, boolean selected) {
            this.value = value;
            this.selected = selected;
        }

        public /* synthetic */ SelectableWrapper(Object object, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                bl = false;
            }
            this(object, bl);
        }

        public final T getValue() {
            return this.value;
        }

        public final boolean getSelected() {
            return this.selected;
        }

        public final void setSelected(boolean bl) {
            this.selected = bl;
        }

        public final T component1() {
            return this.value;
        }

        public final boolean component2() {
            return this.selected;
        }

        @NotNull
        public final SelectableWrapper<T> copy(T value, boolean selected) {
            return new SelectableWrapper<T>(value, selected);
        }

        public static /* synthetic */ SelectableWrapper copy$default(SelectableWrapper selectableWrapper, Object object, boolean bl, int n, Object object2) {
            if ((n & 1) != 0) {
                object = selectableWrapper.value;
            }
            if ((n & 2) != 0) {
                bl = selectableWrapper.selected;
            }
            return selectableWrapper.copy(object, bl);
        }

        @NotNull
        public String toString() {
            return "SelectableWrapper(value=" + this.value + ", selected=" + this.selected + ")";
        }

        public int hashCode() {
            int result = this.value == null ? 0 : this.value.hashCode();
            int n = this.selected ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result = result * 31 + n;
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SelectableWrapper)) {
                return false;
            }
            SelectableWrapper selectableWrapper = (SelectableWrapper)other;
            if (!Intrinsics.areEqual(this.value, selectableWrapper.value)) {
                return false;
            }
            return this.selected == selectableWrapper.selected;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000*\u0004\b\u0000\u0010\u00012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00030\u00022\u00020\u0004:\u0003\u0019\u001a\u001bB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0005J\u0015\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\fJD\u0010\r\u001a\u00020\u000e2\u0014\u0010\u000f\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00028\u00000\u00030\u00102\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0016J\u0015\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00028\u0000H'\u00a2\u0006\u0002\u0010\u0018R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0001\u0003\u001c\u001d\u001e\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/plugins/github/ui/util/GHUIUtil$SelectionListCellRenderer;", "T", "Ljavax/swing/ListCellRenderer;", "Lorg/jetbrains/plugins/github/ui/util/GHUIUtil$SelectableWrapper;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "()V", "checkIconLabel", "Ljavax/swing/JLabel;", "mainLabel", "getIcon", "Ljavax/swing/Icon;", "value", "(Ljava/lang/Object;)Ljavax/swing/Icon;", "getListCellRendererComponent", "Ljava/awt/Component;", "list", "Ljavax/swing/JList;", "index", "", "isSelected", "", "cellHasFocus", "getText", "", "(Ljava/lang/Object;)Ljava/lang/String;", "Labels", "PRReviewers", "Users", "Lorg/jetbrains/plugins/github/ui/util/GHUIUtil$SelectionListCellRenderer$Labels;", "Lorg/jetbrains/plugins/github/ui/util/GHUIUtil$SelectionListCellRenderer$PRReviewers;", "Lorg/jetbrains/plugins/github/ui/util/GHUIUtil$SelectionListCellRenderer$Users;", "intellij.vcs.github"})
    public static abstract class SelectionListCellRenderer<T>
    extends BorderLayoutPanel
    implements ListCellRenderer<SelectableWrapper<T>> {
        @NotNull
        private final JLabel mainLabel = new JLabel();
        @NotNull
        private final JLabel checkIconLabel = new JLabel();

        private SelectionListCellRenderer() {
            this.checkIconLabel.setIconTextGap(JBUI.scale((int)4));
            this.checkIconLabel.setBorder((Border)JBUI.Borders.empty((int)0, (int)4));
            this.addToLeft(this.checkIconLabel);
            this.addToCenter(this.mainLabel);
            this.setBorder((Border)JBUI.Borders.empty((int)4, (int)0));
        }

        @Override
        @NotNull
        public Component getListCellRendererComponent(@NotNull JList<? extends SelectableWrapper<T>> list, @NotNull SelectableWrapper<T> value, int index, boolean isSelected, boolean cellHasFocus) {
            Intrinsics.checkNotNullParameter(list, (String)"list");
            Intrinsics.checkNotNullParameter(value, (String)"value");
            this.setForeground(UIUtil.getListForeground((boolean)isSelected, (boolean)true));
            this.setBackground(UIUtil.getListBackground((boolean)isSelected, (boolean)true));
            this.mainLabel.setForeground(this.getForeground());
            this.mainLabel.setFont(this.getFont());
            this.mainLabel.setText(this.getText(value.getValue()));
            this.mainLabel.setIcon(this.getIcon(value.getValue()));
            Icon icon = LafIconLookup.getIcon$default((String)"checkmark", (boolean)isSelected, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (int)56, null);
            this.checkIconLabel.setIcon(value.getSelected() ? icon : (Icon)EmptyIcon.create((Icon)icon));
            return (Component)((Object)this);
        }

        @NlsContexts.Label
        @NotNull
        public abstract String getText(T var1);

        @NotNull
        public abstract Icon getIcon(T var1);

        public /* synthetic */ SelectionListCellRenderer(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0010\u0010\u0003\u001a\f\u0012\u0004\u0012\u00020\u00050\u0004j\u0002`\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0002H\u0016R\u0018\u0010\u0003\u001a\f\u0012\u0004\u0012\u00020\u00050\u0004j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/github/ui/util/GHUIUtil$SelectionListCellRenderer$PRReviewers;", "Lorg/jetbrains/plugins/github/ui/util/GHUIUtil$SelectionListCellRenderer;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestRequestedReviewer;", "iconsProvider", "Lcom/intellij/collaboration/ui/icon/IconsProvider;", "", "Lorg/jetbrains/plugins/github/ui/avatars/GHAvatarIconsProvider;", "(Lcom/intellij/collaboration/ui/icon/IconsProvider;)V", "getIcon", "Ljavax/swing/Icon;", "value", "getText", "intellij.vcs.github"})
        public static final class PRReviewers
        extends SelectionListCellRenderer<GHPullRequestRequestedReviewer> {
            @NotNull
            private final IconsProvider<String> iconsProvider;

            public PRReviewers(@NotNull IconsProvider<String> iconsProvider) {
                Intrinsics.checkNotNullParameter(iconsProvider, (String)"iconsProvider");
                super(null);
                this.iconsProvider = iconsProvider;
            }

            @Override
            @NotNull
            public String getText(@NotNull GHPullRequestRequestedReviewer value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return value.getShortName();
            }

            @Override
            @NotNull
            public Icon getIcon(@NotNull GHPullRequestRequestedReviewer value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return this.iconsProvider.getIcon((Object)value.getAvatarUrl(), 20);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0010\u0010\u0003\u001a\f\u0012\u0004\u0012\u00020\u00050\u0004j\u0002`\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0002H\u0016R\u0018\u0010\u0003\u001a\f\u0012\u0004\u0012\u00020\u00050\u0004j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/github/ui/util/GHUIUtil$SelectionListCellRenderer$Users;", "Lorg/jetbrains/plugins/github/ui/util/GHUIUtil$SelectionListCellRenderer;", "Lorg/jetbrains/plugins/github/api/data/GHUser;", "iconsProvider", "Lcom/intellij/collaboration/ui/icon/IconsProvider;", "", "Lorg/jetbrains/plugins/github/ui/avatars/GHAvatarIconsProvider;", "(Lcom/intellij/collaboration/ui/icon/IconsProvider;)V", "getIcon", "Ljavax/swing/Icon;", "value", "getText", "intellij.vcs.github"})
        public static final class Users
        extends SelectionListCellRenderer<GHUser> {
            @NotNull
            private final IconsProvider<String> iconsProvider;

            public Users(@NotNull IconsProvider<String> iconsProvider) {
                Intrinsics.checkNotNullParameter(iconsProvider, (String)"iconsProvider");
                super(null);
                this.iconsProvider = iconsProvider;
            }

            @Override
            @NotNull
            public String getText(@NotNull GHUser value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return value.getLogin();
            }

            @Override
            @NotNull
            public Icon getIcon(@NotNull GHUser value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return this.iconsProvider.getIcon((Object)value.getAvatarUrl(), 20);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/github/ui/util/GHUIUtil$SelectionListCellRenderer$Labels;", "Lorg/jetbrains/plugins/github/ui/util/GHUIUtil$SelectionListCellRenderer;", "Lorg/jetbrains/plugins/github/api/data/GHLabel;", "()V", "getIcon", "Lcom/intellij/util/ui/ColorIcon;", "value", "getText", "", "intellij.vcs.github"})
        public static final class Labels
        extends SelectionListCellRenderer<GHLabel> {
            public Labels() {
                super(null);
            }

            @Override
            @NotNull
            public String getText(@NotNull GHLabel value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return value.getName();
            }

            @NotNull
            public ColorIcon getIcon(@NotNull GHLabel value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return new ColorIcon(16, ColorUtil.fromHex((String)value.getColor()));
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[GHPullRequestState.values().length];
            try {
                nArray[GHPullRequestState.CLOSED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GHPullRequestState.MERGED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GHPullRequestState.OPEN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[GithubIssueState.values().length];
            try {
                nArray[GithubIssueState.open.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GithubIssueState.closed.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

