/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.ui.util;

import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.NlsContexts;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JTextField;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.ui.util.DialogValidationUtils;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JC\u0010\u0003\u001a\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004j\u0002`\u00062*\u0010\u0007\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004j\u0002`\u00060\b\"\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004j\u0002`\u0006\u00a2\u0006\u0002\u0010\tJ\u001a\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\u000e\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/github/ui/util/DialogValidationUtils;", "", "()V", "chain", "Lkotlin/Function0;", "Lcom/intellij/openapi/ui/ValidationInfo;", "Lorg/jetbrains/plugins/github/ui/util/Validator;", "validators", "", "([Lkotlin/jvm/functions/Function0;)Lkotlin/jvm/functions/Function0;", "notBlank", "textField", "Ljavax/swing/JTextField;", "message", "", "RecordUniqueValidator", "intellij.vcs.github"})
public final class DialogValidationUtils {
    @NotNull
    public static final DialogValidationUtils INSTANCE = new DialogValidationUtils();

    private DialogValidationUtils() {
    }

    @Nullable
    public final ValidationInfo notBlank(@NotNull JTextField textField, @NlsContexts.DialogMessage @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)textField, (String)"textField");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        CharSequence charSequence = textField.getText();
        return charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? new ValidationInfo(message, (JComponent)textField) : null;
    }

    @NotNull
    public final Function0<ValidationInfo> chain(Function0<ValidationInfo> ... validators) {
        Intrinsics.checkNotNullParameter(validators, (String)"validators");
        return (Function0)new Function0<ValidationInfo>(validators){
            final /* synthetic */ Function0<ValidationInfo>[] $validators;
            {
                this.$validators = $validators;
                super(0);
            }

            @Nullable
            public final ValidationInfo invoke() {
                return (ValidationInfo)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)ArraysKt.asSequence((Object[])this.$validators), (Function1)chain.1.INSTANCE));
            }
        };
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0006\u0018\u00002\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001j\u0002`\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000b\u0010\u000f\u001a\u0004\u0018\u00010\u0002H\u0096\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/github/ui/util/DialogValidationUtils$RecordUniqueValidator;", "Lkotlin/Function0;", "Lcom/intellij/openapi/ui/ValidationInfo;", "Lorg/jetbrains/plugins/github/ui/util/Validator;", "textField", "Ljavax/swing/JTextField;", "message", "", "(Ljavax/swing/JTextField;Ljava/lang/String;)V", "records", "", "getRecords", "()Ljava/util/Set;", "setRecords", "(Ljava/util/Set;)V", "invoke", "intellij.vcs.github"})
    public static final class RecordUniqueValidator
    implements Function0<ValidationInfo> {
        @NotNull
        private final JTextField textField;
        @NotNull
        private final String message;
        @NotNull
        private Set<String> records;

        public RecordUniqueValidator(@NotNull JTextField textField, @NlsContexts.DialogMessage @NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)textField, (String)"textField");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            this.textField = textField;
            this.message = message;
            this.records = SetsKt.emptySet();
        }

        @NotNull
        public final Set<String> getRecords() {
            return this.records;
        }

        public final void setRecords(@NotNull Set<String> set) {
            Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
            this.records = set;
        }

        @Nullable
        public ValidationInfo invoke() {
            return this.records.contains(this.textField.getText()) ? new ValidationInfo(this.message, (JComponent)this.textField) : null;
        }
    }
}

