/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.ui.timeline;

import com.intellij.collaboration.async.CompletableFutureUtil;
import com.intellij.collaboration.ui.SingleValueModel;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.InlineIconButton;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.concurrent.CompletableFuture;
import javax.swing.JComponent;
import javax.swing.JLabel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequest;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestShort;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRDetailsDataProvider;
import org.jetbrains.plugins.github.pullrequest.ui.GHEditableHtmlPaneHandle;
import org.jetbrains.plugins.github.pullrequest.ui.GHTextActions;
import org.jetbrains.plugins.github.pullrequest.ui.details.GHPRDetailsModel;
import org.jetbrains.plugins.github.ui.util.GHUIUtil;
import org.jetbrains.plugins.github.ui.util.HtmlEditorPane;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rJ\u001c\u0010\u000e\u001a\u00020\u000f2\b\b\u0001\u0010\u0010\u001a\u00020\u000f2\b\b\u0001\u0010\u0011\u001a\u00020\u000fH\u0003J$\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u00042\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0004H\u0002\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTitleComponent;", "", "()V", "create", "Ljavax/swing/JComponent;", "project", "Lcom/intellij/openapi/project/Project;", "model", "Lcom/intellij/collaboration/ui/SingleValueModel;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestShort;", "detailsDataProvider", "Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRDetailsDataProvider;", "detailsModel", "Lorg/jetbrains/plugins/github/pullrequest/ui/details/GHPRDetailsModel;", "getTitleBody", "", "title", "number", "layout", "icon", "Ljavax/swing/JLabel;", "editButton", "intellij.vcs.github"})
public final class GHPRTitleComponent {
    @NotNull
    public static final GHPRTitleComponent INSTANCE = new GHPRTitleComponent();

    private GHPRTitleComponent() {
    }

    @NotNull
    public final JComponent create(@NotNull Project project, @NotNull SingleValueModel<GHPullRequestShort> model2, @NotNull GHPRDetailsDataProvider detailsDataProvider) {
        HtmlEditorPane htmlEditorPane;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)detailsDataProvider, (String)"detailsDataProvider");
        JLabel icon = new JLabel();
        HtmlEditorPane $this$create_u24lambda_u240 = htmlEditorPane = new HtmlEditorPane();
        boolean bl = false;
        $this$create_u24lambda_u240.setFont($this$create_u24lambda_u240.getFont().deriveFont((float)((double)$this$create_u24lambda_u240.getFont().getSize() * 1.5)));
        HtmlEditorPane titlePane = htmlEditorPane;
        InlineIconButton editButton = GHTextActions.INSTANCE.createEditButton();
        model2.addAndInvokeListener((Function1)new Function1<GHPullRequestShort, Unit>(icon, model2, titlePane){
            final /* synthetic */ JLabel $icon;
            final /* synthetic */ SingleValueModel<GHPullRequestShort> $model;
            final /* synthetic */ HtmlEditorPane $titlePane;
            {
                this.$icon = $icon;
                this.$model = $model;
                this.$titlePane = $titlePane;
                super(1);
            }

            public final void invoke(@NotNull GHPullRequestShort it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$icon.setIcon(GHUIUtil.INSTANCE.getPullRequestStateIcon(((GHPullRequestShort)this.$model.getValue()).getState(), ((GHPullRequestShort)this.$model.getValue()).isDraft()));
                this.$titlePane.setBody(GHPRTitleComponent.access$getTitleBody(GHPRTitleComponent.INSTANCE, ((GHPullRequestShort)this.$model.getValue()).getTitle(), String.valueOf(((GHPullRequestShort)this.$model.getValue()).getNumber())));
            }
        });
        JComponent fieldPanel = this.layout(icon, (JComponent)((Object)titlePane), (JComponent)editButton);
        GHEditableHtmlPaneHandle paneHandle2 = new GHEditableHtmlPaneHandle(project, fieldPanel, (Function0<String>)((Function0)new Function0<String>(model2){
            final /* synthetic */ SingleValueModel<GHPullRequestShort> $model;
            {
                this.$model = $model;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return ((GHPullRequestShort)this.$model.getValue()).getTitle();
            }
        }), (Function1<? super String, ? extends CompletableFuture<? extends Object>>)((Function1)new Function1<String, CompletableFuture<? extends Object>>(detailsDataProvider, titlePane, model2){
            final /* synthetic */ GHPRDetailsDataProvider $detailsDataProvider;
            final /* synthetic */ HtmlEditorPane $titlePane;
            final /* synthetic */ SingleValueModel<GHPullRequestShort> $model;
            {
                this.$detailsDataProvider = $detailsDataProvider;
                this.$titlePane = $titlePane;
                this.$model = $model;
                super(1);
            }

            @NotNull
            public final CompletableFuture<? extends Object> invoke(@NotNull String newText) {
                Intrinsics.checkNotNullParameter((Object)newText, (String)"newText");
                return CompletableFutureUtil.successOnEdt$default((CompletableFutureUtil)CompletableFutureUtil.INSTANCE, (CompletableFuture)GHPRDetailsDataProvider.updateDetails$default(this.$detailsDataProvider, (ProgressIndicator)new EmptyProgressIndicator(), newText, null, 4, null), null, (Function1)((Function1)new Function1<GHPullRequest, Unit>(this.$titlePane, newText, this.$model){
                    final /* synthetic */ HtmlEditorPane $titlePane;
                    final /* synthetic */ String $newText;
                    final /* synthetic */ SingleValueModel<GHPullRequestShort> $model;
                    {
                        this.$titlePane = $titlePane;
                        this.$newText = $newText;
                        this.$model = $model;
                        super(1);
                    }

                    public final void invoke(@NotNull GHPullRequest it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        this.$titlePane.setBody(GHPRTitleComponent.access$getTitleBody(GHPRTitleComponent.INSTANCE, this.$newText, String.valueOf(((GHPullRequestShort)this.$model.getValue()).getNumber())));
                    }
                }), (int)1, null);
            }
        }));
        editButton.setActionListener(arg_0 -> GHPRTitleComponent.create$lambda$1(paneHandle2, arg_0));
        editButton.setVisible(((GHPullRequestShort)model2.getValue()).getViewerCanUpdate());
        return paneHandle2.getPanel();
    }

    @NotNull
    public final JComponent create(@NotNull GHPRDetailsModel detailsModel) {
        HtmlEditorPane htmlEditorPane;
        Intrinsics.checkNotNullParameter((Object)detailsModel, (String)"detailsModel");
        JLabel icon = new JLabel();
        HtmlEditorPane $this$create_u24lambda_u242 = htmlEditorPane = new HtmlEditorPane();
        boolean bl = false;
        $this$create_u24lambda_u242.setFont($this$create_u24lambda_u242.getFont().deriveFont((float)((double)$this$create_u24lambda_u242.getFont().getSize() * 1.2)));
        HtmlEditorPane title = htmlEditorPane;
        detailsModel.addAndInvokeDetailsChangedListener((Function0<Unit>)((Function0)new Function0<Unit>(icon, detailsModel, title){
            final /* synthetic */ JLabel $icon;
            final /* synthetic */ GHPRDetailsModel $detailsModel;
            final /* synthetic */ HtmlEditorPane $title;
            {
                this.$icon = $icon;
                this.$detailsModel = $detailsModel;
                this.$title = $title;
                super(0);
            }

            public final void invoke() {
                this.$icon.setIcon(GHUIUtil.INSTANCE.getPullRequestStateIcon(this.$detailsModel.getState(), this.$detailsModel.isDraft()));
                this.$title.setBody(GHPRTitleComponent.access$getTitleBody(GHPRTitleComponent.INSTANCE, this.$detailsModel.getTitle(), this.$detailsModel.getNumber()));
            }
        }));
        return GHPRTitleComponent.layout$default(this, icon, (JComponent)((Object)title), null, 4, null);
    }

    @NlsSafe
    private final String getTitleBody(@NlsSafe String title, @NlsSafe String number) {
        String string = ColorUtil.toHtmlColor((Color)UIUtil.getContextHelpForeground());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toHtmlColor(UIUtil.getContextHelpForeground())");
        String contextHelpColorText = string;
        String string2 = new HtmlBuilder().append(title).nbsp().append((HtmlChunk)HtmlChunk.span((String)("color: " + contextHelpColorText)).addText("#" + number)).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"HtmlBuilder()\n      .app\u2026ber}\"))\n      .toString()");
        return string2;
    }

    private final JComponent layout(JLabel icon, JComponent title, JComponent editButton) {
        NonOpaquePanel nonOpaquePanel;
        NonOpaquePanel $this$layout_u24lambda_u243 = nonOpaquePanel = new NonOpaquePanel((LayoutManager)new MigLayout(new LC().insets("0").gridGap("0", "0").noGrid()));
        boolean bl = false;
        $this$layout_u24lambda_u243.add((Component)icon, (Object)new CC().gapRight(String.valueOf(JBUIScale.scale((int)4))));
        $this$layout_u24lambda_u243.add((Component)title, (Object)new CC());
        if (editButton != null) {
            $this$layout_u24lambda_u243.add((Component)editButton, (Object)new CC().gapLeft(String.valueOf(JBUIScale.scale((int)12))).hideMode(3));
        }
        return (JComponent)nonOpaquePanel;
    }

    static /* synthetic */ JComponent layout$default(GHPRTitleComponent gHPRTitleComponent, JLabel jLabel, JComponent jComponent, JComponent jComponent2, int n, Object object) {
        if ((n & 4) != 0) {
            jComponent2 = null;
        }
        return gHPRTitleComponent.layout(jLabel, jComponent, jComponent2);
    }

    private static final void create$lambda$1(GHEditableHtmlPaneHandle $paneHandle, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)$paneHandle, (String)"$paneHandle");
        $paneHandle.showAndFocusEditor();
    }

    public static final /* synthetic */ String access$getTitleBody(GHPRTitleComponent $this, String title, String number) {
        return $this.getTitleBody(title, number);
    }
}

