/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.ui.timeline;

import com.intellij.collaboration.async.CompletableFutureUtil;
import com.intellij.collaboration.ui.codereview.timeline.TimelineItemComponentFactory;
import com.intellij.collaboration.ui.icon.IconsProvider;
import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.plugins.newui.HorizontalLayout;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.panels.HorizontalBox;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.concurrent.CompletableFuture;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0Impl;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.GithubIcons;
import org.jetbrains.plugins.github.api.data.GHActor;
import org.jetbrains.plugins.github.api.data.GHCommitShort;
import org.jetbrains.plugins.github.api.data.GHGitActor;
import org.jetbrains.plugins.github.api.data.GHIssueComment;
import org.jetbrains.plugins.github.api.data.GHUser;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequest;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestCommitShort;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestReview;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestReviewState;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestShort;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRTimelineEvent;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRTimelineItem;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.pullrequest.comment.GHMarkdownToHtmlConverterKt;
import org.jetbrains.plugins.github.pullrequest.comment.ui.GHPRReviewThreadComponent;
import org.jetbrains.plugins.github.pullrequest.comment.ui.GHPRReviewThreadModel;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRCommentsDataProvider;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRDetailsDataProvider;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRReviewDataProvider;
import org.jetbrains.plugins.github.pullrequest.ui.GHEditableHtmlPaneHandle;
import org.jetbrains.plugins.github.pullrequest.ui.GHTextActions;
import org.jetbrains.plugins.github.pullrequest.ui.changes.GHPRSuggestedChangeHelper;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRReviewThreadDiffComponentFactory;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRReviewThreadsModel;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRReviewThreadsPanel;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRReviewsThreadsModelsProvider;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRSelectInToolWindowHelper;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRTimelineEventComponentFactory;
import org.jetbrains.plugins.github.ui.util.GHUIUtil;
import org.jetbrains.plugins.github.ui.util.HtmlEditorPane;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 -2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002-.Bm\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0010\u0010\u000b\u001a\f\u0012\u0004\u0012\u00020\r0\fj\u0002`\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u0012\u0006\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\u0002\u0010\u001cJ\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020$H\u0002J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020&J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020\u0002H\u0016J\u0012\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010+H\u0002J\u0012\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010,H\u0002R\u0018\u0010\u000b\u001a\f\u0012\u0004\u0012\u00020\r0\fj\u0002`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineItemComponentFactory;", "Lcom/intellij/collaboration/ui/codereview/timeline/TimelineItemComponentFactory;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/timeline/GHPRTimelineItem;", "project", "Lcom/intellij/openapi/project/Project;", "detailsDataProvider", "Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRDetailsDataProvider;", "commentsDataProvider", "Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRCommentsDataProvider;", "reviewDataProvider", "Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRReviewDataProvider;", "avatarIconsProvider", "Lcom/intellij/collaboration/ui/icon/IconsProvider;", "", "Lorg/jetbrains/plugins/github/ui/avatars/GHAvatarIconsProvider;", "reviewsThreadsModelsProvider", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRReviewsThreadsModelsProvider;", "reviewDiffComponentFactory", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRReviewThreadDiffComponentFactory;", "eventComponentFactory", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactory;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/timeline/GHPRTimelineEvent;", "selectInToolWindowHelper", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRSelectInToolWindowHelper;", "suggestedChangeHelper", "Lorg/jetbrains/plugins/github/pullrequest/ui/changes/GHPRSuggestedChangeHelper;", "currentUser", "Lorg/jetbrains/plugins/github/api/data/GHUser;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRDetailsDataProvider;Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRCommentsDataProvider;Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRReviewDataProvider;Lcom/intellij/collaboration/ui/icon/IconsProvider;Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRReviewsThreadsModelsProvider;Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRReviewThreadDiffComponentFactory;Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactory;Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRSelectInToolWindowHelper;Lorg/jetbrains/plugins/github/pullrequest/ui/changes/GHPRSuggestedChangeHelper;Lorg/jetbrains/plugins/github/api/data/GHUser;)V", "createComponent", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineItemComponentFactory$Item;", "comment", "Lorg/jetbrains/plugins/github/api/data/GHIssueComment;", "commit", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestCommitShort;", "review", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestReview;", "details", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestShort;", "item", "userAvatar", "Ljavax/swing/JLabel;", "user", "Lorg/jetbrains/plugins/github/api/data/GHActor;", "Lorg/jetbrains/plugins/github/api/data/GHGitActor;", "Companion", "Item", "intellij.vcs.github"})
public final class GHPRTimelineItemComponentFactory
implements TimelineItemComponentFactory<GHPRTimelineItem> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final GHPRDetailsDataProvider detailsDataProvider;
    @NotNull
    private final GHPRCommentsDataProvider commentsDataProvider;
    @NotNull
    private final GHPRReviewDataProvider reviewDataProvider;
    @NotNull
    private final IconsProvider<String> avatarIconsProvider;
    @NotNull
    private final GHPRReviewsThreadsModelsProvider reviewsThreadsModelsProvider;
    @NotNull
    private final GHPRReviewThreadDiffComponentFactory reviewDiffComponentFactory;
    @NotNull
    private final GHPRTimelineEventComponentFactory<GHPRTimelineEvent> eventComponentFactory;
    @NotNull
    private final GHPRSelectInToolWindowHelper selectInToolWindowHelper;
    @NotNull
    private final GHPRSuggestedChangeHelper suggestedChangeHelper;
    @NotNull
    private final GHUser currentUser;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Dimension NOT_DEFINED_SIZE;

    public GHPRTimelineItemComponentFactory(@NotNull Project project, @NotNull GHPRDetailsDataProvider detailsDataProvider, @NotNull GHPRCommentsDataProvider commentsDataProvider, @NotNull GHPRReviewDataProvider reviewDataProvider, @NotNull IconsProvider<String> avatarIconsProvider, @NotNull GHPRReviewsThreadsModelsProvider reviewsThreadsModelsProvider, @NotNull GHPRReviewThreadDiffComponentFactory reviewDiffComponentFactory, @NotNull GHPRTimelineEventComponentFactory<GHPRTimelineEvent> eventComponentFactory, @NotNull GHPRSelectInToolWindowHelper selectInToolWindowHelper, @NotNull GHPRSuggestedChangeHelper suggestedChangeHelper, @NotNull GHUser currentUser) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)detailsDataProvider, (String)"detailsDataProvider");
        Intrinsics.checkNotNullParameter((Object)commentsDataProvider, (String)"commentsDataProvider");
        Intrinsics.checkNotNullParameter((Object)reviewDataProvider, (String)"reviewDataProvider");
        Intrinsics.checkNotNullParameter(avatarIconsProvider, (String)"avatarIconsProvider");
        Intrinsics.checkNotNullParameter((Object)reviewsThreadsModelsProvider, (String)"reviewsThreadsModelsProvider");
        Intrinsics.checkNotNullParameter((Object)reviewDiffComponentFactory, (String)"reviewDiffComponentFactory");
        Intrinsics.checkNotNullParameter(eventComponentFactory, (String)"eventComponentFactory");
        Intrinsics.checkNotNullParameter((Object)selectInToolWindowHelper, (String)"selectInToolWindowHelper");
        Intrinsics.checkNotNullParameter((Object)suggestedChangeHelper, (String)"suggestedChangeHelper");
        Intrinsics.checkNotNullParameter((Object)currentUser, (String)"currentUser");
        this.project = project;
        this.detailsDataProvider = detailsDataProvider;
        this.commentsDataProvider = commentsDataProvider;
        this.reviewDataProvider = reviewDataProvider;
        this.avatarIconsProvider = avatarIconsProvider;
        this.reviewsThreadsModelsProvider = reviewsThreadsModelsProvider;
        this.reviewDiffComponentFactory = reviewDiffComponentFactory;
        this.eventComponentFactory = eventComponentFactory;
        this.selectInToolWindowHelper = selectInToolWindowHelper;
        this.suggestedChangeHelper = suggestedChangeHelper;
        this.currentUser = currentUser;
    }

    @NotNull
    public Item createComponent(@NotNull GHPRTimelineItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        try {
            Item item2;
            GHPRTimelineItem gHPRTimelineItem = item;
            if (gHPRTimelineItem instanceof GHPullRequestCommitShort) {
                item2 = this.createComponent((GHPullRequestCommitShort)item);
            } else if (gHPRTimelineItem instanceof GHIssueComment) {
                item2 = this.createComponent((GHIssueComment)item);
            } else if (gHPRTimelineItem instanceof GHPullRequestReview) {
                item2 = this.createComponent((GHPullRequestReview)item);
            } else if (gHPRTimelineItem instanceof GHPRTimelineEvent) {
                item2 = this.eventComponentFactory.createComponent((GHPRTimelineEvent)item);
            } else {
                if (gHPRTimelineItem instanceof GHPRTimelineItem.Unknown) {
                    throw new IllegalStateException("Unknown item type: " + ((GHPRTimelineItem.Unknown)item).get__typename());
                }
                throw new IllegalStateException("Undefined item type".toString());
            }
            return item2;
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            Icon icon = AllIcons.General.Warning;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Warning");
            Object[] objectArray = new Object[1];
            String string = e.getMessage();
            if (string == null) {
                string = "";
            }
            objectArray[0] = string;
            String string2 = GithubBundle.message("cannot.display.item", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"cannot.display.item\", e.message ?: \"\")");
            return new Item(icon, (JComponent)((Object)new HtmlEditorPane(string2)), null, null, 12, null);
        }
    }

    private final Item createComponent(GHPullRequestCommitShort commit) {
        NonOpaquePanel nonOpaquePanel;
        GHCommitShort gitCommit = commit.getCommit();
        NonOpaquePanel $this$createComponent_u24lambda_u240 = nonOpaquePanel = new NonOpaquePanel((LayoutManager)new HorizontalLayout(JBUIScale.scale((int)8)));
        boolean bl = false;
        $this$createComponent_u24lambda_u240.add((Component)this.userAvatar(gitCommit.getAuthor()));
        $this$createComponent_u24lambda_u240.add((Component)((Object)new HtmlEditorPane(gitCommit.getMessageHeadlineHTML())));
        $this$createComponent_u24lambda_u240.add((Component)new ActionLink(gitCommit.getAbbreviatedOid(), (Function1)new Function1<ActionEvent, Unit>(this, gitCommit){
            final /* synthetic */ GHPRTimelineItemComponentFactory this$0;
            final /* synthetic */ GHCommitShort $gitCommit;
            {
                this.this$0 = $receiver;
                this.$gitCommit = $gitCommit;
                super(1);
            }

            public final void invoke(@NotNull ActionEvent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                GHPRTimelineItemComponentFactory.access$getSelectInToolWindowHelper$p(this.this$0).selectCommit(this.$gitCommit.getAbbreviatedOid());
            }
        }));
        NonOpaquePanel titlePanel2 = nonOpaquePanel;
        Icon icon = AllIcons.Vcs.CommitNode;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"CommitNode");
        return new Item(icon, (JComponent)titlePanel2, null, null, 12, null);
    }

    @NotNull
    public final Item createComponent(@NotNull GHPullRequestShort details2) {
        NonOpaquePanel nonOpaquePanel;
        Intrinsics.checkNotNullParameter((Object)details2, (String)"details");
        JPanel contentPanel2 = null;
        Container actionsPanel2 = null;
        if (details2 instanceof GHPullRequest) {
            Container container;
            HtmlEditorPane textPane2 = new HtmlEditorPane(GHMarkdownToHtmlConverterKt.convertToHtml(((GHPullRequest)details2).getBody(), this.project));
            GHEditableHtmlPaneHandle panelHandle2 = new GHEditableHtmlPaneHandle(this.project, (JComponent)((Object)textPane2), (Function0<String>)((Function0)new PropertyReference0Impl(details2){

                @Nullable
                public Object get() {
                    return ((GHPullRequest)this.receiver).getBody();
                }
            }), (Function1<? super String, ? extends CompletableFuture<? extends Object>>)((Function1)new Function1<String, CompletableFuture<? extends Object>>(this, textPane2){
                final /* synthetic */ GHPRTimelineItemComponentFactory this$0;
                final /* synthetic */ HtmlEditorPane $textPane;
                {
                    this.this$0 = $receiver;
                    this.$textPane = $textPane;
                    super(1);
                }

                @NotNull
                public final CompletableFuture<? extends Object> invoke(@NotNull String newText) {
                    Intrinsics.checkNotNullParameter((Object)newText, (String)"newText");
                    return CompletableFutureUtil.successOnEdt$default((CompletableFutureUtil)CompletableFutureUtil.INSTANCE, (CompletableFuture)GHPRDetailsDataProvider.updateDetails$default(GHPRTimelineItemComponentFactory.access$getDetailsDataProvider$p(this.this$0), (ProgressIndicator)new EmptyProgressIndicator(), null, newText, 2, null), null, (Function1)((Function1)new Function1<GHPullRequest, Unit>(this.$textPane, this.this$0){
                        final /* synthetic */ HtmlEditorPane $textPane;
                        final /* synthetic */ GHPRTimelineItemComponentFactory this$0;
                        {
                            this.$textPane = $textPane;
                            this.this$0 = $receiver;
                            super(1);
                        }

                        public final void invoke(@NotNull GHPullRequest it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            this.$textPane.setBody(GHMarkdownToHtmlConverterKt.convertToHtml(it.getBody(), GHPRTimelineItemComponentFactory.access$getProject$p(this.this$0)));
                        }
                    }), (int)1, null);
                }
            }));
            contentPanel2 = panelHandle2.getPanel();
            if (details2.getViewerCanUpdate()) {
                NonOpaquePanel nonOpaquePanel2;
                NonOpaquePanel $this$createComponent_u24lambda_u241 = nonOpaquePanel2 = new NonOpaquePanel((LayoutManager)new HorizontalLayout(JBUIScale.scale((int)8)));
                boolean bl = false;
                $this$createComponent_u24lambda_u241.add((Component)GHTextActions.INSTANCE.createEditButton(panelHandle2));
                container = (JPanel)nonOpaquePanel2;
            } else {
                container = null;
            }
            actionsPanel2 = container;
        } else {
            contentPanel2 = null;
            actionsPanel2 = null;
        }
        NonOpaquePanel $this$createComponent_u24lambda_u242 = nonOpaquePanel = new NonOpaquePanel((LayoutManager)new HorizontalLayout(JBUIScale.scale((int)12)));
        boolean bl = false;
        GHActor gHActor = details2.getAuthor();
        String string = GithubBundle.message("pull.request.timeline.created", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"pull.request.timeline.created\")");
        $this$createComponent_u24lambda_u242.add((Component)Companion.actionTitle(gHActor, string, details2.getCreatedAt()));
        if (actionsPanel2 != null && actionsPanel2.getComponentCount() > 0) {
            $this$createComponent_u24lambda_u242.add((Component)actionsPanel2);
        }
        NonOpaquePanel titlePanel2 = nonOpaquePanel;
        return new Item(this.userAvatar(details2.getAuthor()), (JComponent)titlePanel2, (JComponent)contentPanel2, null, 8, null);
    }

    private final Item createComponent(GHIssueComment comment) {
        NonOpaquePanel nonOpaquePanel;
        NonOpaquePanel nonOpaquePanel2;
        HtmlEditorPane textPane2 = new HtmlEditorPane(GHMarkdownToHtmlConverterKt.convertToHtml(comment.getBody(), this.project));
        GHEditableHtmlPaneHandle panelHandle2 = new GHEditableHtmlPaneHandle(this.project, (JComponent)((Object)textPane2), (Function0<String>)((Function0)new PropertyReference0Impl(comment){

            @Nullable
            public Object get() {
                return ((GHIssueComment)this.receiver).getBody();
            }
        }), (Function1<? super String, ? extends CompletableFuture<? extends Object>>)((Function1)new Function1<String, CompletableFuture<? extends Object>>(this, comment, textPane2){
            final /* synthetic */ GHPRTimelineItemComponentFactory this$0;
            final /* synthetic */ GHIssueComment $comment;
            final /* synthetic */ HtmlEditorPane $textPane;
            {
                this.this$0 = $receiver;
                this.$comment = $comment;
                this.$textPane = $textPane;
                super(1);
            }

            @NotNull
            public final CompletableFuture<? extends Object> invoke(@NotNull String newText) {
                Intrinsics.checkNotNullParameter((Object)newText, (String)"newText");
                return CompletableFutureUtil.successOnEdt$default((CompletableFutureUtil)CompletableFutureUtil.INSTANCE, GHPRTimelineItemComponentFactory.access$getCommentsDataProvider$p(this.this$0).updateComment((ProgressIndicator)new EmptyProgressIndicator(), this.$comment.getId(), newText), null, (Function1)((Function1)new Function1<String, Unit>(this.$textPane, this.this$0){
                    final /* synthetic */ HtmlEditorPane $textPane;
                    final /* synthetic */ GHPRTimelineItemComponentFactory this$0;
                    {
                        this.$textPane = $textPane;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull String it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        this.$textPane.setBody(GHMarkdownToHtmlConverterKt.convertToHtml(it, GHPRTimelineItemComponentFactory.access$getProject$p(this.this$0)));
                    }
                }), (int)1, null);
            }
        }));
        NonOpaquePanel $this$createComponent_u24lambda_u243 = nonOpaquePanel2 = new NonOpaquePanel((LayoutManager)new HorizontalLayout(JBUIScale.scale((int)8)));
        boolean bl = false;
        if (comment.getViewerCanUpdate()) {
            $this$createComponent_u24lambda_u243.add((Component)GHTextActions.INSTANCE.createEditButton(panelHandle2));
        }
        if (comment.getViewerCanDelete()) {
            $this$createComponent_u24lambda_u243.add((Component)GHTextActions.INSTANCE.createDeleteButton((Function0<? extends CompletableFuture<? extends Object>>)((Function0)new Function0<CompletableFuture<? extends Object>>(this, comment){
                final /* synthetic */ GHPRTimelineItemComponentFactory this$0;
                final /* synthetic */ GHIssueComment $comment;
                {
                    this.this$0 = $receiver;
                    this.$comment = $comment;
                    super(0);
                }

                @NotNull
                public final CompletableFuture<? extends Object> invoke() {
                    return GHPRTimelineItemComponentFactory.access$getCommentsDataProvider$p(this.this$0).deleteComment((ProgressIndicator)new EmptyProgressIndicator(), this.$comment.getId());
                }
            })));
        }
        NonOpaquePanel actionsPanel2 = nonOpaquePanel2;
        NonOpaquePanel $this$createComponent_u24lambda_u244 = nonOpaquePanel = new NonOpaquePanel((LayoutManager)new HorizontalLayout(JBUIScale.scale((int)12)));
        boolean bl2 = false;
        GHActor gHActor = comment.getAuthor();
        String string = GithubBundle.message("pull.request.timeline.commented", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"pull.request.timeline.commented\")");
        $this$createComponent_u24lambda_u244.add((Component)Companion.actionTitle(gHActor, string, comment.getCreatedAt()));
        if (actionsPanel2.getComponentCount() > 0) {
            $this$createComponent_u24lambda_u244.add((Component)actionsPanel2);
        }
        NonOpaquePanel titlePanel2 = nonOpaquePanel;
        return new Item(this.userAvatar(comment.getAuthor()), (JComponent)titlePanel2, (JComponent)panelHandle2.getPanel(), null, 8, null);
    }

    private final Item createComponent(GHPullRequestReview review2) {
        NonOpaquePanel nonOpaquePanel;
        GHPRReviewThreadsModel reviewThreadsModel = this.reviewsThreadsModelsProvider.getReviewThreadsModel(review2.getId());
        GHEditableHtmlPaneHandle panelHandle2 = null;
        if (((CharSequence)review2.getBody()).length() > 0) {
            HtmlEditorPane textPane2 = new HtmlEditorPane(GHMarkdownToHtmlConverterKt.convertToHtml(review2.getBody(), this.project));
            panelHandle2 = new GHEditableHtmlPaneHandle(this.project, (JComponent)((Object)textPane2), (Function0<String>)((Function0)new PropertyReference0Impl(review2){

                @Nullable
                public Object get() {
                    return ((GHPullRequestReview)this.receiver).getBody();
                }
            }), (Function1<? super String, ? extends CompletableFuture<? extends Object>>)((Function1)new Function1<String, CompletableFuture<? extends Object>>(this, review2, textPane2){
                final /* synthetic */ GHPRTimelineItemComponentFactory this$0;
                final /* synthetic */ GHPullRequestReview $review;
                final /* synthetic */ HtmlEditorPane $textPane;
                {
                    this.this$0 = $receiver;
                    this.$review = $review;
                    this.$textPane = $textPane;
                    super(1);
                }

                @NotNull
                public final CompletableFuture<? extends Object> invoke(@NotNull String newText) {
                    Intrinsics.checkNotNullParameter((Object)newText, (String)"newText");
                    return CompletableFutureUtil.successOnEdt$default((CompletableFutureUtil)CompletableFutureUtil.INSTANCE, GHPRTimelineItemComponentFactory.access$getReviewDataProvider$p(this.this$0).updateReviewBody((ProgressIndicator)new EmptyProgressIndicator(), this.$review.getId(), newText), null, (Function1)((Function1)new Function1<String, Unit>(this.$textPane, this.this$0){
                        final /* synthetic */ HtmlEditorPane $textPane;
                        final /* synthetic */ GHPRTimelineItemComponentFactory this$0;
                        {
                            this.$textPane = $textPane;
                            this.this$0 = $receiver;
                            super(1);
                        }

                        public final void invoke(@NotNull String it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            this.$textPane.setBody(GHMarkdownToHtmlConverterKt.convertToHtml(it, GHPRTimelineItemComponentFactory.access$getProject$p(this.this$0)));
                        }
                    }), (int)1, null);
                }
            }));
        } else {
            panelHandle2 = null;
        }
        NonOpaquePanel $this$createComponent_u24lambda_u245 = nonOpaquePanel = new NonOpaquePanel((LayoutManager)new HorizontalLayout(JBUIScale.scale((int)8)));
        boolean bl = false;
        if (panelHandle2 != null && review2.getViewerCanUpdate()) {
            $this$createComponent_u24lambda_u245.add((Component)GHTextActions.INSTANCE.createEditButton(panelHandle2));
        }
        NonOpaquePanel actionsPanel2 = nonOpaquePanel;
        NonOpaquePanel $this$createComponent_u24lambda_u246 = $this$createComponent_u24lambda_u245 = new NonOpaquePanel((LayoutManager)new VerticalLayout(12));
        boolean bl2 = false;
        $this$createComponent_u24lambda_u246.setBorder((Border)JBUI.Borders.emptyTop((int)4));
        if (panelHandle2 != null) {
            $this$createComponent_u24lambda_u246.add((Component)panelHandle2.getPanel());
        }
        $this$createComponent_u24lambda_u246.add((Component)GHPRReviewThreadsPanel.INSTANCE.create(reviewThreadsModel, (Function1<? super GHPRReviewThreadModel, ? extends JComponent>)((Function1)new Function1<GHPRReviewThreadModel, JComponent>(this){
            final /* synthetic */ GHPRTimelineItemComponentFactory this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final JComponent invoke(@NotNull GHPRReviewThreadModel it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return GHPRReviewThreadComponent.INSTANCE.createWithDiff(GHPRTimelineItemComponentFactory.access$getProject$p(this.this$0), it, GHPRTimelineItemComponentFactory.access$getReviewDataProvider$p(this.this$0), (IconsProvider<String>)GHPRTimelineItemComponentFactory.access$getAvatarIconsProvider$p(this.this$0), GHPRTimelineItemComponentFactory.access$getReviewDiffComponentFactory$p(this.this$0), GHPRTimelineItemComponentFactory.access$getSelectInToolWindowHelper$p(this.this$0), GHPRTimelineItemComponentFactory.access$getSuggestedChangeHelper$p(this.this$0), GHPRTimelineItemComponentFactory.access$getCurrentUser$p(this.this$0));
            }
        })));
        NonOpaquePanel contentPanel2 = $this$createComponent_u24lambda_u245;
        String string = switch (WhenMappings.$EnumSwitchMapping$0[review2.getState().ordinal()]) {
            case 1 -> GithubBundle.message("pull.request.timeline.approved.changes", new Object[0]);
            case 2 -> GithubBundle.message("pull.request.timeline.requested.changes", new Object[0]);
            case 3 -> GithubBundle.message("pull.request.timeline.started.review", new Object[0]);
            case 4, 5 -> GithubBundle.message("pull.request.timeline.reviewed", new Object[0]);
            default -> throw new NoWhenBranchMatchedException();
        };
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"when (review.state) {\n  \u2026timeline.reviewed\")\n    }");
        String actionText = string;
        NonOpaquePanel $this$createComponent_u24lambda_u247 = bl2 = new NonOpaquePanel((LayoutManager)new HorizontalLayout(JBUIScale.scale((int)12)));
        boolean bl3 = false;
        $this$createComponent_u24lambda_u247.add((Component)Companion.actionTitle(this.avatarIconsProvider, review2.getAuthor(), actionText, review2.getCreatedAt()));
        if (actionsPanel2.getComponentCount() > 0) {
            $this$createComponent_u24lambda_u247.add((Component)actionsPanel2);
        }
        NonOpaquePanel titlePanel2 = bl2;
        Icon icon = switch (WhenMappings.$EnumSwitchMapping$0[review2.getState().ordinal()]) {
            case 1 -> GithubIcons.ReviewAccepted;
            case 2 -> GithubIcons.ReviewRejected;
            case 4 -> GithubIcons.Review;
            case 5 -> GithubIcons.Review;
            case 3 -> GithubIcons.Review;
            default -> throw new NoWhenBranchMatchedException();
        };
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"when (review.state) {\n  \u2026 GithubIcons.Review\n    }");
        Icon icon2 = icon;
        return new Item(icon2, (JComponent)titlePanel2, (JComponent)contentPanel2, NOT_DEFINED_SIZE);
    }

    private final JLabel userAvatar(GHActor user) {
        return Companion.userAvatar(this.avatarIconsProvider, user);
    }

    private final JLabel userAvatar(GHGitActor user) {
        GHGitActor gHGitActor = user;
        return (JLabel)new LinkLabel("", this.avatarIconsProvider.getIcon((Object)(gHGitActor != null ? gHGitActor.getAvatarUrl() : null), 20), (arg_0, arg_1) -> GHPRTimelineItemComponentFactory.userAvatar$lambda$9(user, arg_0, arg_1));
    }

    private static final void userAvatar$lambda$9(GHGitActor $user, LinkLabel linkLabel, Object object) {
        block0: {
            Object object2 = $user;
            if (object2 == null || (object2 = ((GHGitActor)object2).getUrl()) == null) break block0;
            Object it = object2;
            boolean bl = false;
            BrowserUtil.browse((String)it);
        }
    }

    public static final /* synthetic */ GHPRDetailsDataProvider access$getDetailsDataProvider$p(GHPRTimelineItemComponentFactory $this) {
        return $this.detailsDataProvider;
    }

    public static final /* synthetic */ Project access$getProject$p(GHPRTimelineItemComponentFactory $this) {
        return $this.project;
    }

    public static final /* synthetic */ GHPRCommentsDataProvider access$getCommentsDataProvider$p(GHPRTimelineItemComponentFactory $this) {
        return $this.commentsDataProvider;
    }

    public static final /* synthetic */ GHPRReviewDataProvider access$getReviewDataProvider$p(GHPRTimelineItemComponentFactory $this) {
        return $this.reviewDataProvider;
    }

    public static final /* synthetic */ GHPRSelectInToolWindowHelper access$getSelectInToolWindowHelper$p(GHPRTimelineItemComponentFactory $this) {
        return $this.selectInToolWindowHelper;
    }

    public static final /* synthetic */ IconsProvider access$getAvatarIconsProvider$p(GHPRTimelineItemComponentFactory $this) {
        return $this.avatarIconsProvider;
    }

    public static final /* synthetic */ GHPRReviewThreadDiffComponentFactory access$getReviewDiffComponentFactory$p(GHPRTimelineItemComponentFactory $this) {
        return $this.reviewDiffComponentFactory;
    }

    public static final /* synthetic */ GHPRSuggestedChangeHelper access$getSuggestedChangeHelper$p(GHPRTimelineItemComponentFactory $this) {
        return $this.suggestedChangeHelper;
    }

    public static final /* synthetic */ GHUser access$getCurrentUser$p(GHPRTimelineItemComponentFactory $this) {
        return $this.currentUser;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GHPRTimelineItemComponentFactory.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        LOG = logger;
        NOT_DEFINED_SIZE = new Dimension(-1, -1);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB-\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB+\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\fR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineItemComponentFactory$Item;", "Ljavax/swing/JPanel;", "markerIcon", "Ljavax/swing/Icon;", "title", "Ljavax/swing/JComponent;", "content", "size", "Ljava/awt/Dimension;", "(Ljavax/swing/Icon;Ljavax/swing/JComponent;Ljavax/swing/JComponent;Ljava/awt/Dimension;)V", "marker", "Ljavax/swing/JLabel;", "(Ljavax/swing/JLabel;Ljavax/swing/JComponent;Ljavax/swing/JComponent;Ljava/awt/Dimension;)V", "getMarker", "()Ljavax/swing/JLabel;", "Companion", "intellij.vcs.github"})
    public static final class Item
    extends JPanel {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final JLabel marker;

        /*
         * WARNING - void declaration
         */
        public Item(@NotNull JLabel marker, @NotNull JComponent title, @Nullable JComponent content2, @NotNull Dimension size) {
            void $this$_init__u24lambda_u240;
            MigLayout migLayout;
            Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)size, (String)"size");
            this.marker = marker;
            this.setOpaque(false);
            MigLayout migLayout2 = migLayout = new MigLayout(new LC().gridGap("0", "0").insets("0", "0", "0", "0").fill());
            Item item = this;
            boolean bl = false;
            $this$_init__u24lambda_u240.setColumnConstraints((Object)("[]" + JBUIScale.scale((int)8) + "[]"));
            item.setLayout((LayoutManager)migLayout);
            this.add((Component)this.marker, new CC().pushY());
            this.add((Component)title, new CC().pushX());
            if (content2 != null) {
                Component component2 = content2;
                CC cC = new CC().newline().skip().grow().push();
                Intrinsics.checkNotNullExpressionValue((Object)cC, (String)"CC().newline().skip().grow().push()");
                this.add(component2, Item.Companion.maxWidth(cC, size));
            }
        }

        public /* synthetic */ Item(JLabel jLabel, JComponent jComponent, JComponent jComponent2, Dimension dimension, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                jComponent2 = null;
            }
            if ((n & 8) != 0) {
                dimension = Companion.getDefaultSize();
            }
            this(jLabel, jComponent, jComponent2, dimension);
        }

        @NotNull
        public final JLabel getMarker() {
            return this.marker;
        }

        public Item(@NotNull Icon markerIcon, @NotNull JComponent title, @Nullable JComponent content2, @NotNull Dimension size) {
            Intrinsics.checkNotNullParameter((Object)markerIcon, (String)"markerIcon");
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)size, (String)"size");
            this(Item.Companion.createMarkerLabel(markerIcon), title, content2, size);
        }

        public /* synthetic */ Item(Icon icon, JComponent jComponent, JComponent jComponent2, Dimension dimension, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                jComponent2 = null;
            }
            if ((n & 8) != 0) {
                dimension = Companion.getDefaultSize();
            }
            this(icon, jComponent, jComponent2, dimension);
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001c\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\b*\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineItemComponentFactory$Item$Companion;", "", "()V", "createMarkerLabel", "Ljavax/swing/JLabel;", "markerIcon", "Ljavax/swing/Icon;", "maxWidth", "Lnet/miginfocom/layout/CC;", "kotlin.jvm.PlatformType", "dimension", "Ljava/awt/Dimension;", "intellij.vcs.github"})
        public static final class Companion {
            private Companion() {
            }

            private final CC maxWidth(CC $this$maxWidth, Dimension dimension) {
                return dimension.width > 0 ? $this$maxWidth.maxWidth(String.valueOf(dimension.width)) : $this$maxWidth;
            }

            private final JLabel createMarkerLabel(Icon markerIcon) {
                JLabel jLabel;
                JLabel $this$createMarkerLabel_u24lambda_u240 = jLabel = new JLabel(markerIcon);
                boolean bl = false;
                float verticalGap = markerIcon.getIconHeight() < 20 ? (20.0f - (float)markerIcon.getIconHeight()) / (float)2 : 0.0f;
                float horizontalGap = markerIcon.getIconWidth() < 20 ? (20.0f - (float)markerIcon.getIconWidth()) / (float)2 : 0.0f;
                $this$createMarkerLabel_u24lambda_u240.setBorder((Border)JBUI.Borders.empty((int)((int)Math.floor(verticalGap)), (int)((int)Math.floor(horizontalGap)), (int)((int)Math.ceil(verticalGap)), (int)((int)Math.ceil(horizontalGap))));
                return jLabel;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ4\u0010\b\u001a\u00020\t2\u0010\u0010\u0010\u001a\f\u0012\u0004\u0012\u00020\r0\u0011j\u0002`\u00122\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\b\u0001\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0013\u001a\u00020\u0007J\"\u0010\u0014\u001a\u00020\u00152\u0010\u0010\u0010\u001a\f\u0012\u0004\u0012\u00020\r0\u0011j\u0002`\u00122\b\u0010\u0016\u001a\u0004\u0018\u00010\u000bR\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineItemComponentFactory$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "NOT_DEFINED_SIZE", "Ljava/awt/Dimension;", "actionTitle", "Ljavax/swing/JComponent;", "actor", "Lorg/jetbrains/plugins/github/api/data/GHActor;", "actionHTML", "", "date", "Ljava/util/Date;", "avatarIconsProvider", "Lcom/intellij/collaboration/ui/icon/IconsProvider;", "Lorg/jetbrains/plugins/github/ui/avatars/GHAvatarIconsProvider;", "getDefaultSize", "userAvatar", "Ljavax/swing/JLabel;", "user", "intellij.vcs.github"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Dimension getDefaultSize() {
            return new Dimension(GHUIUtil.INSTANCE.getPRTimelineWidth(), -1);
        }

        @NotNull
        public final JLabel userAvatar(@NotNull IconsProvider<String> avatarIconsProvider, @Nullable GHActor user) {
            Intrinsics.checkNotNullParameter(avatarIconsProvider, (String)"avatarIconsProvider");
            GHActor gHActor = user;
            return (JLabel)new LinkLabel("", avatarIconsProvider.getIcon((Object)(gHActor != null ? gHActor.getAvatarUrl() : null), 20), (arg_0, arg_1) -> Companion.userAvatar$lambda$1(user, arg_0, arg_1));
        }

        @NotNull
        public final JComponent actionTitle(@NotNull IconsProvider<String> avatarIconsProvider, @Nullable GHActor actor, @Language(value="HTML") @NotNull String actionHTML, @NotNull Date date) {
            HorizontalBox horizontalBox;
            Intrinsics.checkNotNullParameter(avatarIconsProvider, (String)"avatarIconsProvider");
            Intrinsics.checkNotNullParameter((Object)actionHTML, (String)"actionHTML");
            Intrinsics.checkNotNullParameter((Object)date, (String)"date");
            HorizontalBox $this$actionTitle_u24lambda_u242 = horizontalBox = new HorizontalBox();
            boolean bl = false;
            $this$actionTitle_u24lambda_u242.add((Component)Companion.userAvatar(avatarIconsProvider, actor));
            $this$actionTitle_u24lambda_u242.add(Box.createRigidArea((Dimension)new JBDimension(8, 0)));
            $this$actionTitle_u24lambda_u242.add((Component)Companion.actionTitle(actor, actionHTML, date));
            return (JComponent)horizontalBox;
        }

        @NotNull
        public final JComponent actionTitle(@Nullable GHActor actor, @NotNull String actionHTML, @NotNull Date date) {
            HtmlEditorPane htmlEditorPane;
            Intrinsics.checkNotNullParameter((Object)actionHTML, (String)"actionHTML");
            Intrinsics.checkNotNullParameter((Object)date, (String)"date");
            GHActor gHActor = actor;
            String string = gHActor != null ? gHActor.getUrl() : null;
            Object object = actor;
            if (object == null || (object = object.getLogin()) == null) {
                object = "unknown";
            }
            String text = "<a href='" + string + "'>" + (String)object + "</a> " + actionHTML + " " + GHUIUtil.INSTANCE.formatActionDate(date);
            HtmlEditorPane $this$actionTitle_u24lambda_u243 = htmlEditorPane = new HtmlEditorPane(text);
            boolean bl = false;
            $this$actionTitle_u24lambda_u243.setForeground(UIUtil.getContextHelpForeground());
            return (JComponent)((Object)htmlEditorPane);
        }

        private static final void userAvatar$lambda$1(GHActor $user, LinkLabel linkLabel, Object object) {
            block0: {
                Object object2 = $user;
                if (object2 == null || (object2 = object2.getUrl()) == null) break block0;
                Object it = object2;
                boolean bl = false;
                BrowserUtil.browse((String)it);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[GHPullRequestReviewState.values().length];
            try {
                nArray[GHPullRequestReviewState.APPROVED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GHPullRequestReviewState.CHANGES_REQUESTED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GHPullRequestReviewState.PENDING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GHPullRequestReviewState.COMMENTED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GHPullRequestReviewState.DISMISSED.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

