/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.ui.timeline;

import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.util.ui.SingleComponentCenteringLayout;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.pullrequest.comment.ui.GHPRReviewThreadModel;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRReviewThreadsModel;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\nB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00040\b\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRReviewThreadsPanel;", "", "()V", "create", "Ljavax/swing/JComponent;", "model", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRReviewThreadsModel;", "threadComponentFactory", "Lkotlin/Function1;", "Lorg/jetbrains/plugins/github/pullrequest/comment/ui/GHPRReviewThreadModel;", "Controller", "intellij.vcs.github"})
public final class GHPRReviewThreadsPanel {
    @NotNull
    public static final GHPRReviewThreadsPanel INSTANCE = new GHPRReviewThreadsPanel();

    private GHPRReviewThreadsPanel() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final JComponent create(@NotNull GHPRReviewThreadsModel model2, @NotNull Function1<? super GHPRReviewThreadModel, ? extends JComponent> threadComponentFactory) {
        void $this$create_u24lambda_u242_u24lambda_u241;
        JLabel jLabel;
        JPanel jPanel;
        JPanel jPanel2;
        Intrinsics.checkNotNullParameter((Object)((Object)model2), (String)"model");
        Intrinsics.checkNotNullParameter(threadComponentFactory, (String)"threadComponentFactory");
        JPanel $this$create_u24lambda_u240 = jPanel2 = new JPanel((LayoutManager)new VerticalLayout(12));
        boolean bl = false;
        $this$create_u24lambda_u240.setOpaque(false);
        JPanel panel = jPanel2;
        JPanel $this$create_u24lambda_u242 = jPanel = new JPanel((LayoutManager)new SingleComponentCenteringLayout());
        boolean bl2 = false;
        $this$create_u24lambda_u242.setOpaque(false);
        JLabel jLabel2 = jLabel = new JLabel(ApplicationBundle.message((String)"label.loading.page.please.wait", (Object[])new Object[0]));
        JPanel jPanel3 = $this$create_u24lambda_u242;
        boolean bl3 = false;
        $this$create_u24lambda_u242_u24lambda_u241.setForeground(UIUtil.getContextHelpForeground());
        jPanel3.add(jLabel);
        JPanel loadingPanel = jPanel;
        new Controller(model2, panel, loadingPanel, threadComponentFactory);
        return panel;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRReviewThreadsPanel$Controller;", "", "model", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRReviewThreadsModel;", "panel", "Ljavax/swing/JPanel;", "loadingPanel", "threadComponentFactory", "Lkotlin/Function1;", "Lorg/jetbrains/plugins/github/pullrequest/comment/ui/GHPRReviewThreadModel;", "Ljavax/swing/JComponent;", "(Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRReviewThreadsModel;Ljavax/swing/JPanel;Ljavax/swing/JPanel;Lkotlin/jvm/functions/Function1;)V", "updateVisibility", "", "intellij.vcs.github"})
    private static final class Controller {
        @NotNull
        private final GHPRReviewThreadsModel model;
        @NotNull
        private final JPanel panel;
        @NotNull
        private final JPanel loadingPanel;
        @NotNull
        private final Function1<GHPRReviewThreadModel, JComponent> threadComponentFactory;

        public Controller(@NotNull GHPRReviewThreadsModel model2, @NotNull JPanel panel, @NotNull JPanel loadingPanel, @NotNull Function1<? super GHPRReviewThreadModel, ? extends JComponent> threadComponentFactory) {
            Intrinsics.checkNotNullParameter((Object)((Object)model2), (String)"model");
            Intrinsics.checkNotNullParameter((Object)panel, (String)"panel");
            Intrinsics.checkNotNullParameter((Object)loadingPanel, (String)"loadingPanel");
            Intrinsics.checkNotNullParameter(threadComponentFactory, (String)"threadComponentFactory");
            this.model = model2;
            this.panel = panel;
            this.loadingPanel = loadingPanel;
            this.threadComponentFactory = threadComponentFactory;
            this.model.addListDataListener(new ListDataListener(){

                @Override
                public void intervalRemoved(@NotNull ListDataEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    int i = e.getIndex1();
                    int n = e.getIndex0();
                    if (n <= i) {
                        while (true) {
                            panel.remove(i);
                            if (i == n) break;
                            --i;
                        }
                    }
                    this.updateVisibility();
                    panel.revalidate();
                    panel.repaint();
                }

                @Override
                public void intervalAdded(@NotNull ListDataEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    int i = e.getIndex0();
                    int n = e.getIndex1();
                    if (i <= n) {
                        while (true) {
                            JPanel jPanel = panel;
                            Function1 function1 = threadComponentFactory;
                            Object object = model.getElementAt(i);
                            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"model.getElementAt(i)");
                            jPanel.add((Component)function1.invoke(object), i);
                            if (i == n) break;
                            ++i;
                        }
                    }
                    this.updateVisibility();
                    panel.revalidate();
                    panel.repaint();
                }

                @Override
                public void contentsChanged(@NotNull ListDataEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    if (model.getLoaded()) {
                        panel.remove(loadingPanel);
                    }
                    this.updateVisibility();
                    panel.validate();
                    panel.repaint();
                }
            });
            if (!this.model.getLoaded()) {
                this.panel.add(this.loadingPanel);
            } else {
                int n = this.model.getSize();
                for (int i = 0; i < n; ++i) {
                    Object object = this.model.getElementAt(i);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"model.getElementAt(i)");
                    this.panel.add((Component)this.threadComponentFactory.invoke(object), i);
                }
            }
            this.updateVisibility();
        }

        private final void updateVisibility() {
            this.panel.setVisible(this.panel.getComponentCount() > 0);
        }
    }
}

