/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.ui.details;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.BrowserLink;
import com.intellij.util.ui.EmptyIcon;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.pullrequest.data.GHPRMergeabilityState;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rH\u0003\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/details/GHPRStatusChecksComponent;", "", "()V", "create", "Ljavax/swing/JComponent;", "mergeability", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRMergeabilityState;", "createLink", "Lcom/intellij/ui/components/BrowserLink;", "url", "", "getChecksResultsText", "failedChecks", "", "pendingChecks", "successfulChecks", "intellij.vcs.github"})
public final class GHPRStatusChecksComponent {
    @NotNull
    public static final GHPRStatusChecksComponent INSTANCE = new GHPRStatusChecksComponent();

    private GHPRStatusChecksComponent() {
    }

    @NotNull
    public final JComponent create(@NotNull GHPRMergeabilityState mergeability) {
        Intrinsics.checkNotNullParameter((Object)mergeability, (String)"mergeability");
        JPanel panel = new JPanel(new FlowLayout(3, 0, 0));
        GHPRMergeabilityState.ChecksState checksState = mergeability.getChecksState();
        if (checksState == GHPRMergeabilityState.ChecksState.NONE) {
            panel.setVisible(false);
        } else {
            JLabel jLabel;
            JLabel $this$create_u24lambda_u240 = jLabel = new JLabel();
            boolean bl = false;
            $this$create_u24lambda_u240.setIcon(switch (WhenMappings.$EnumSwitchMapping$0[checksState.ordinal()]) {
                case 1, 2 -> AllIcons.RunConfigurations.TestError;
                case 3 -> AllIcons.RunConfigurations.TestFailed;
                case 4 -> AllIcons.RunConfigurations.TestNotRan;
                case 5 -> AllIcons.RunConfigurations.TestPassed;
                default -> EmptyIcon.ICON_16;
            });
            $this$create_u24lambda_u240.setText(switch (WhenMappings.$EnumSwitchMapping$0[checksState.ordinal()]) {
                case 1 -> GithubBundle.message("pull.request.branch.out.of.sync", new Object[0]);
                case 2, 3, 4, 5 -> INSTANCE.getChecksResultsText(mergeability.getFailedChecks(), mergeability.getPendingChecks(), mergeability.getSuccessfulChecks());
                default -> "";
            });
            JLabel label2 = jLabel;
            JPanel $this$create_u24lambda_u241 = panel;
            boolean bl2 = false;
            $this$create_u24lambda_u241.add(label2);
            $this$create_u24lambda_u241.add((Component)INSTANCE.createLink(mergeability.getHtmlUrl()));
        }
        return panel;
    }

    @Nls
    private final String getChecksResultsText(int failedChecks, int pendingChecks, int successfulChecks) {
        Object[] objectArray;
        Object object;
        List results = new ArrayList();
        Object object2 = failedChecks;
        int it = ((Number)object2).intValue();
        boolean bl = false;
        Object object3 = object = it > 0 ? object2 : null;
        if (object != null) {
            int it2 = ((Number)object).intValue();
            boolean bl2 = false;
            objectArray = new Object[]{it2};
            object2 = GithubBundle.message("pull.request.checks.failing", objectArray);
            if (object2 != null) {
                Object[] it3 = it = object2;
                boolean bl3 = false;
                results.add(it3);
            }
        }
        object2 = pendingChecks;
        it = ((Number)object2).intValue();
        boolean bl4 = false;
        Object object4 = object = it > 0 ? object2 : null;
        if (object != null) {
            int it4 = ((Number)object).intValue();
            boolean bl5 = false;
            objectArray = new Object[]{it4};
            object2 = GithubBundle.message("pull.request.checks.pending", objectArray);
            if (object2 != null) {
                Object[] it5 = it = object2;
                boolean bl6 = false;
                results.add(it5);
            }
        }
        object2 = successfulChecks;
        it = ((Number)object2).intValue();
        boolean bl7 = false;
        Object object5 = object = it > 0 ? object2 : null;
        if (object != null) {
            int it6 = ((Number)object).intValue();
            boolean bl8 = false;
            objectArray = new Object[]{it6};
            object2 = GithubBundle.message("pull.request.checks.successful", objectArray);
            if (object2 != null) {
                Object[] objectArray2;
                Object[] it7 = objectArray2 = object2;
                boolean bl9 = false;
                results.add(it7);
            }
        }
        int checksCount = failedChecks + pendingChecks + successfulChecks;
        object2 = new Object[]{checksCount};
        return StringUtil.join((Collection)results, (String)", ") + " " + GithubBundle.message("pull.request.checks", object2);
    }

    private final BrowserLink createLink(String url) {
        String string = GithubBundle.message("open.in.browser.link", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"open.in.browser.link\")");
        return new BrowserLink(string, url);
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[GHPRMergeabilityState.ChecksState.values().length];
            try {
                nArray[GHPRMergeabilityState.ChecksState.BLOCKING_BEHIND.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GHPRMergeabilityState.ChecksState.BLOCKING_FAILING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GHPRMergeabilityState.ChecksState.FAILING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GHPRMergeabilityState.ChecksState.PENDING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GHPRMergeabilityState.ChecksState.SUCCESSFUL.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

