/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.ui.details;

import com.intellij.collaboration.async.CompletableFutureUtil;
import com.intellij.icons.AllIcons;
import com.intellij.ui.CardLayoutPanel;
import com.intellij.ui.components.JBOptionButton;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.NamedColorUtil;
import icons.CollaborationToolsIcons;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.GithubIcons;
import org.jetbrains.plugins.github.api.data.GHRepositoryPermissionLevel;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestState;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.pullrequest.data.GHPRMergeabilityState;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRSecurityService;
import org.jetbrains.plugins.github.pullrequest.ui.details.GHPRStateModel;
import org.jetbrains.plugins.github.pullrequest.ui.details.GHPRStatusChecksComponent;
import org.jetbrains.plugins.github.pullrequest.ui.details.action.GHPRCloseAction;
import org.jetbrains.plugins.github.pullrequest.ui.details.action.GHPRCommitMergeAction;
import org.jetbrains.plugins.github.pullrequest.ui.details.action.GHPRMarkReadyForReviewAction;
import org.jetbrains.plugins.github.pullrequest.ui.details.action.GHPRRebaseMergeAction;
import org.jetbrains.plugins.github.pullrequest.ui.details.action.GHPRReopenAction;
import org.jetbrains.plugins.github.pullrequest.ui.details.action.GHPRSquashMergeAction;
import org.jetbrains.plugins.github.ui.component.GHHtmlErrorPanel;
import org.jetbrains.plugins.github.ui.util.HtmlEditorPane;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u0001\u000eB\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0003H\u0014J\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0002H\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/details/GHPRStatePanel;", "Lcom/intellij/ui/CardLayoutPanel;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestState;", "Lorg/jetbrains/plugins/github/pullrequest/ui/details/GHPRStatePanel$StateUI;", "Ljavax/swing/JComponent;", "securityService", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRSecurityService;", "stateModel", "Lorg/jetbrains/plugins/github/pullrequest/ui/details/GHPRStateModel;", "(Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRSecurityService;Lorg/jetbrains/plugins/github/pullrequest/ui/details/GHPRStateModel;)V", "create", "ui", "prepare", "key", "StateUI", "intellij.vcs.github"})
public final class GHPRStatePanel
extends CardLayoutPanel<GHPullRequestState, StateUI, JComponent> {
    @NotNull
    private final GHPRSecurityService securityService;
    @NotNull
    private final GHPRStateModel stateModel;

    public GHPRStatePanel(@NotNull GHPRSecurityService securityService, @NotNull GHPRStateModel stateModel) {
        Intrinsics.checkNotNullParameter((Object)securityService, (String)"securityService");
        Intrinsics.checkNotNullParameter((Object)stateModel, (String)"stateModel");
        this.securityService = securityService;
        this.stateModel = stateModel;
    }

    @NotNull
    protected StateUI prepare(@NotNull GHPullRequestState key) {
        Intrinsics.checkNotNullParameter((Object)((Object)key), (String)"key");
        return switch (WhenMappings.$EnumSwitchMapping$0[key.ordinal()]) {
            case 1 -> new StateUI.Merged(this.stateModel);
            case 2 -> new StateUI.Closed(this.securityService, this.stateModel);
            case 3 -> new StateUI.Open(this.securityService, this.stateModel);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    protected JComponent create(@NotNull StateUI ui) {
        Intrinsics.checkNotNullParameter((Object)ui, (String)"ui");
        return ui.createComponent();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u0000 \r2\u00020\u0001:\u0004\f\r\u000e\u000fB\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH&J\u0006\u0010\n\u001a\u00020\tJ\b\u0010\u000b\u001a\u00020\tH&R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0003\u0010\u0011\u0012\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/details/GHPRStatePanel$StateUI;", "", "stateModel", "Lorg/jetbrains/plugins/github/pullrequest/ui/details/GHPRStateModel;", "(Lorg/jetbrains/plugins/github/pullrequest/ui/details/GHPRStateModel;)V", "getStateModel", "()Lorg/jetbrains/plugins/github/pullrequest/ui/details/GHPRStateModel;", "createButtons", "", "Ljavax/swing/JComponent;", "createComponent", "createStatusComponent", "Closed", "Companion", "Merged", "Open", "Lorg/jetbrains/plugins/github/pullrequest/ui/details/GHPRStatePanel$StateUI$Closed;", "Lorg/jetbrains/plugins/github/pullrequest/ui/details/GHPRStatePanel$StateUI$Merged;", "Lorg/jetbrains/plugins/github/pullrequest/ui/details/GHPRStatePanel$StateUI$Open;", "intellij.vcs.github"})
    public static abstract class StateUI {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final GHPRStateModel stateModel;
        protected static final int STATUSES_GAP = 4;

        private StateUI(GHPRStateModel stateModel) {
            this.stateModel = stateModel;
        }

        @NotNull
        protected final GHPRStateModel getStateModel() {
            return this.stateModel;
        }

        @NotNull
        public final JComponent createComponent() {
            JPanel jPanel;
            JPanel jPanel2;
            JComponent statusComponent = this.createStatusComponent();
            Object $this$createComponent_u24lambda_u240 = jPanel2 = new JPanel(new FlowLayout(0, 0, 0));
            boolean bl = false;
            $this$createComponent_u24lambda_u240.setOpaque(false);
            for (JComponent button : this.createButtons()) {
                $this$createComponent_u24lambda_u240.add(button);
            }
            JPanel buttonsPanel = jPanel2;
            Object $this$createComponent_u24lambda_u241 = $this$createComponent_u24lambda_u240 = new HtmlEditorPane();
            boolean bl2 = false;
            $this$createComponent_u24lambda_u241.setForeground(NamedColorUtil.getErrorForeground());
            Object errorComponent = $this$createComponent_u24lambda_u240;
            this.stateModel.addAndInvokeActionErrorChangedListener((Function0<Unit>)((Function0)new Function0<Unit>((HtmlEditorPane)((Object)errorComponent), this){
                final /* synthetic */ HtmlEditorPane $errorComponent;
                final /* synthetic */ StateUI this$0;
                {
                    this.$errorComponent = $errorComponent;
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    Throwable throwable = this.this$0.getStateModel().getActionError();
                    String string = throwable != null ? throwable.getMessage() : null;
                    if (string == null) {
                        string = "";
                    }
                    this.$errorComponent.setBody(string);
                }
            }));
            JPanel $this$createComponent_u24lambda_u242 = jPanel = new JPanel(null);
            boolean bl3 = false;
            $this$createComponent_u24lambda_u242.setOpaque(false);
            $this$createComponent_u24lambda_u242.setLayout((LayoutManager)new MigLayout(new LC().fill().flowY().gridGap(String.valueOf(JBUIScale.scale((int)5)), "0").insets("0")));
            $this$createComponent_u24lambda_u242.add(buttonsPanel);
            $this$createComponent_u24lambda_u242.add((Component)errorComponent, new CC().minWidth("0"));
            JPanel actionsPanel2 = jPanel;
            JPanel $this$createComponent_u24lambda_u243 = jPanel = new JPanel(null);
            boolean bl4 = false;
            $this$createComponent_u24lambda_u243.setOpaque(false);
            $this$createComponent_u24lambda_u243.setLayout((LayoutManager)new MigLayout(new LC().fill().flowY().gridGap(String.valueOf(JBUIScale.scale((int)4)), "0").insets("0")));
            $this$createComponent_u24lambda_u243.add(statusComponent);
            $this$createComponent_u24lambda_u243.add(actionsPanel2);
            return jPanel;
        }

        @NotNull
        public abstract JComponent createStatusComponent();

        @NotNull
        public abstract List<JComponent> createButtons();

        public /* synthetic */ StateUI(GHPRStateModel stateModel, DefaultConstructorMarker $constructor_marker) {
            this(stateModel);
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0084T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/details/GHPRStatePanel$StateUI$Companion;", "", "()V", "STATUSES_GAP", "", "intellij.vcs.github"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/details/GHPRStatePanel$StateUI$Merged;", "Lorg/jetbrains/plugins/github/pullrequest/ui/details/GHPRStatePanel$StateUI;", "stateModel", "Lorg/jetbrains/plugins/github/pullrequest/ui/details/GHPRStateModel;", "(Lorg/jetbrains/plugins/github/pullrequest/ui/details/GHPRStateModel;)V", "createButtons", "", "Ljavax/swing/JComponent;", "createStatusComponent", "Ljavax/swing/JLabel;", "intellij.vcs.github"})
        public static final class Merged
        extends StateUI {
            public Merged(@NotNull GHPRStateModel stateModel) {
                Intrinsics.checkNotNullParameter((Object)stateModel, (String)"stateModel");
                super(stateModel, null);
            }

            @Override
            @NotNull
            public JLabel createStatusComponent() {
                return new JLabel(GithubBundle.message("pull.request.state.merged.long", new Object[0]), GithubIcons.PullRequestMerged, 2);
            }

            @Override
            @NotNull
            public List<JComponent> createButtons() {
                return CollectionsKt.emptyList();
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/details/GHPRStatePanel$StateUI$Closed;", "Lorg/jetbrains/plugins/github/pullrequest/ui/details/GHPRStatePanel$StateUI;", "securityService", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRSecurityService;", "stateModel", "Lorg/jetbrains/plugins/github/pullrequest/ui/details/GHPRStateModel;", "(Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRSecurityService;Lorg/jetbrains/plugins/github/pullrequest/ui/details/GHPRStateModel;)V", "canReopen", "", "createButtons", "", "Ljavax/swing/JComponent;", "createStatusComponent", "intellij.vcs.github"})
        public static final class Closed
        extends StateUI {
            private final boolean canReopen;

            public Closed(@NotNull GHPRSecurityService securityService, @NotNull GHPRStateModel stateModel) {
                Intrinsics.checkNotNullParameter((Object)securityService, (String)"securityService");
                Intrinsics.checkNotNullParameter((Object)stateModel, (String)"stateModel");
                super(stateModel, null);
                this.canReopen = securityService.currentUserHasPermissionLevel(GHRepositoryPermissionLevel.TRIAGE) || stateModel.getViewerDidAuthor();
            }

            @Override
            @NotNull
            public JComponent createStatusComponent() {
                JComponent jComponent;
                JLabel stateLabel = new JLabel(GithubBundle.message("pull.request.state.closed.long", new Object[0]), CollaborationToolsIcons.PullRequestClosed, 2);
                if (this.canReopen) {
                    jComponent = stateLabel;
                } else {
                    JComponent jComponent2 = new JLabel();
                    JLabel $this$createStatusComponent_u24lambda_u240 = jComponent2;
                    boolean bl = false;
                    $this$createStatusComponent_u24lambda_u240.setIcon(AllIcons.RunConfigurations.TestError);
                    $this$createStatusComponent_u24lambda_u240.setText(GithubBundle.message("pull.request.repo.access.required", new Object[0]));
                    JLabel accessDeniedLabel = jComponent2;
                    JComponent $this$createStatusComponent_u24lambda_u241 = jComponent2 = new JPanel((LayoutManager)new VerticalLayout(4));
                    boolean bl2 = false;
                    $this$createStatusComponent_u24lambda_u241.setOpaque(false);
                    $this$createStatusComponent_u24lambda_u241.add(stateLabel);
                    $this$createStatusComponent_u24lambda_u241.add(accessDeniedLabel);
                    jComponent = jComponent2;
                }
                return jComponent;
            }

            @Override
            @NotNull
            public List<JComponent> createButtons() {
                List list;
                if (this.canReopen) {
                    GHPRReopenAction action2 = new GHPRReopenAction(this.getStateModel());
                    list = CollectionsKt.listOf((Object)new JButton(action2));
                } else {
                    list = CollectionsKt.emptyList();
                }
                return list;
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u001aB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\bH\u0002J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0010H\u0002J\u0018\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\bH\u0002J\u0010\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\bH\u0002J\b\u0010\u0019\u001a\u00020\u0010H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/details/GHPRStatePanel$StateUI$Open;", "Lorg/jetbrains/plugins/github/pullrequest/ui/details/GHPRStatePanel$StateUI;", "securityService", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRSecurityService;", "stateModel", "Lorg/jetbrains/plugins/github/pullrequest/ui/details/GHPRStateModel;", "(Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRSecurityService;Lorg/jetbrains/plugins/github/pullrequest/ui/details/GHPRStateModel;)V", "canClose", "", "canCommitMerge", "canMarkReadyForReview", "canMerge", "canRebaseMerge", "canSquashMerge", "mergeForbidden", "createAccessDeniedLabel", "Ljavax/swing/JComponent;", "isDraft", "createButtons", "", "createErrorComponent", "createLoadedComponent", "mergeability", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRMergeabilityState;", "createNotLoadedComponent", "createStatusComponent", "LoadingController", "intellij.vcs.github"})
        public static final class Open
        extends StateUI {
            private final boolean canClose;
            private final boolean canMerge;
            private final boolean mergeForbidden;
            private final boolean canMarkReadyForReview;
            private final boolean canCommitMerge;
            private final boolean canSquashMerge;
            private final boolean canRebaseMerge;

            public Open(@NotNull GHPRSecurityService securityService, @NotNull GHPRStateModel stateModel) {
                Intrinsics.checkNotNullParameter((Object)securityService, (String)"securityService");
                Intrinsics.checkNotNullParameter((Object)stateModel, (String)"stateModel");
                super(stateModel, null);
                this.canClose = securityService.currentUserHasPermissionLevel(GHRepositoryPermissionLevel.TRIAGE) || stateModel.getViewerDidAuthor();
                this.canMerge = securityService.currentUserHasPermissionLevel(GHRepositoryPermissionLevel.WRITE);
                this.mergeForbidden = securityService.isMergeForbiddenForProject();
                this.canMarkReadyForReview = securityService.currentUserHasPermissionLevel(GHRepositoryPermissionLevel.WRITE) || stateModel.getViewerDidAuthor();
                this.canCommitMerge = securityService.isMergeAllowed();
                this.canSquashMerge = securityService.isSquashMergeAllowed();
                this.canRebaseMerge = securityService.isRebaseMergeAllowed();
            }

            @Override
            @NotNull
            public JComponent createStatusComponent() {
                Wrapper panel = new Wrapper();
                new LoadingController(panel);
                return (JComponent)panel;
            }

            private final JComponent createNotLoadedComponent(boolean isDraft) {
                JPanel jPanel;
                JLabel stateLabel = new JLabel(GithubBundle.message("pull.request.loading.status", new Object[0]), AllIcons.RunConfigurations.TestNotRan, 2);
                JComponent accessDeniedLabel = this.createAccessDeniedLabel(isDraft);
                JPanel $this$createNotLoadedComponent_u24lambda_u240 = jPanel = new JPanel((LayoutManager)new VerticalLayout(4, 2));
                boolean bl = false;
                $this$createNotLoadedComponent_u24lambda_u240.setOpaque(false);
                $this$createNotLoadedComponent_u24lambda_u240.add(stateLabel);
                $this$createNotLoadedComponent_u24lambda_u240.add(accessDeniedLabel);
                return jPanel;
            }

            private final JComponent createErrorComponent() {
                String string = GithubBundle.message("pull.request.state.cannot.load", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"pull.request.state.cannot.load\")");
                Throwable throwable = this.getStateModel().getMergeabilityLoadingError();
                Intrinsics.checkNotNull((Object)throwable);
                String string2 = GithubBundle.message("retry.action", new Object[0]);
                return GHHtmlErrorPanel.INSTANCE.create(string, throwable, new AbstractAction(this, string2){
                    final /* synthetic */ Open this$0;
                    {
                        this.this$0 = $receiver;
                        super($super_call_param$1);
                    }

                    public void actionPerformed(@Nullable ActionEvent e) {
                        this.this$0.getStateModel().reloadMergeabilityState();
                    }
                }, 2);
            }

            private final JComponent createLoadedComponent(GHPRMergeabilityState mergeability, boolean isDraft) {
                JPanel jPanel;
                JLabel jLabel;
                JComponent statusChecks = GHPRStatusChecksComponent.INSTANCE.create(mergeability);
                JLabel $this$createLoadedComponent_u24lambda_u241 = jLabel = new JLabel();
                boolean bl = false;
                Boolean bl2 = mergeability.getHasConflicts();
                if (Intrinsics.areEqual((Object)bl2, (Object)false)) {
                    $this$createLoadedComponent_u24lambda_u241.setIcon(AllIcons.RunConfigurations.TestPassed);
                    $this$createLoadedComponent_u24lambda_u241.setText(GithubBundle.message("pull.request.conflicts.none", new Object[0]));
                } else if (Intrinsics.areEqual((Object)bl2, (Object)true)) {
                    $this$createLoadedComponent_u24lambda_u241.setIcon(AllIcons.RunConfigurations.TestError);
                    $this$createLoadedComponent_u24lambda_u241.setText(GithubBundle.message("pull.request.conflicts.must.be.resolved", new Object[0]));
                } else if (bl2 == null) {
                    $this$createLoadedComponent_u24lambda_u241.setIcon(AllIcons.RunConfigurations.TestNotRan);
                    $this$createLoadedComponent_u24lambda_u241.setText(GithubBundle.message("pull.request.conflicts.checking", new Object[0]));
                }
                JLabel conflictsLabel = jLabel;
                JLabel $this$createLoadedComponent_u24lambda_u242 = $this$createLoadedComponent_u24lambda_u241 = new JLabel();
                boolean bl3 = false;
                int requiredApprovingReviewsCount = mergeability.getRequiredApprovingReviewsCount();
                $this$createLoadedComponent_u24lambda_u242.setVisible(requiredApprovingReviewsCount > 0 && !isDraft);
                $this$createLoadedComponent_u24lambda_u242.setIcon(AllIcons.RunConfigurations.TestError);
                Object[] objectArray = new Object[]{requiredApprovingReviewsCount};
                $this$createLoadedComponent_u24lambda_u242.setText(GithubBundle.message("pull.request.reviewers.required", objectArray));
                JLabel requiredReviewsLabel = $this$createLoadedComponent_u24lambda_u241;
                JLabel $this$createLoadedComponent_u24lambda_u243 = $this$createLoadedComponent_u24lambda_u242 = new JLabel();
                boolean bl4 = false;
                $this$createLoadedComponent_u24lambda_u243.setVisible(mergeability.isRestricted() && !isDraft);
                $this$createLoadedComponent_u24lambda_u243.setIcon(AllIcons.RunConfigurations.TestError);
                $this$createLoadedComponent_u24lambda_u243.setText(GithubBundle.message("pull.request.not.authorized.to.merge", new Object[0]));
                JLabel restrictionsLabel = $this$createLoadedComponent_u24lambda_u242;
                JComponent accessDeniedLabel = this.createAccessDeniedLabel(isDraft);
                JPanel $this$createLoadedComponent_u24lambda_u244 = jPanel = new JPanel((LayoutManager)new VerticalLayout(4, 2));
                boolean bl5 = false;
                $this$createLoadedComponent_u24lambda_u244.setOpaque(false);
                $this$createLoadedComponent_u24lambda_u244.add(statusChecks);
                $this$createLoadedComponent_u24lambda_u244.add(requiredReviewsLabel);
                $this$createLoadedComponent_u24lambda_u244.add(conflictsLabel);
                $this$createLoadedComponent_u24lambda_u244.add(restrictionsLabel);
                $this$createLoadedComponent_u24lambda_u244.add(accessDeniedLabel);
                return jPanel;
            }

            private final JComponent createAccessDeniedLabel(boolean isDraft) {
                JLabel jLabel;
                JLabel $this$createAccessDeniedLabel_u24lambda_u249 = jLabel = new JLabel();
                boolean bl = false;
                if (!this.canClose) {
                    JLabel jLabel2;
                    JLabel $this$createAccessDeniedLabel_u24lambda_u249_u24lambda_u245 = jLabel2 = new JLabel();
                    boolean bl2 = false;
                    $this$createAccessDeniedLabel_u24lambda_u249_u24lambda_u245.setIcon(AllIcons.RunConfigurations.TestError);
                    $this$createAccessDeniedLabel_u24lambda_u249_u24lambda_u245.setText(GithubBundle.message("pull.request.repo.access.required", new Object[0]));
                } else if (!this.canMarkReadyForReview && isDraft) {
                    JLabel jLabel3;
                    JLabel $this$createAccessDeniedLabel_u24lambda_u249_u24lambda_u246 = jLabel3 = new JLabel();
                    boolean bl3 = false;
                    $this$createAccessDeniedLabel_u24lambda_u249_u24lambda_u246.setIcon(AllIcons.RunConfigurations.TestError);
                    $this$createAccessDeniedLabel_u24lambda_u249_u24lambda_u246.setText(GithubBundle.message("pull.request.repo.write.access.required", new Object[0]));
                } else if (!this.canMerge && !isDraft) {
                    JLabel jLabel4;
                    JLabel $this$createAccessDeniedLabel_u24lambda_u249_u24lambda_u247 = jLabel4 = new JLabel();
                    boolean bl4 = false;
                    $this$createAccessDeniedLabel_u24lambda_u249_u24lambda_u247.setIcon(AllIcons.RunConfigurations.TestError);
                    $this$createAccessDeniedLabel_u24lambda_u249_u24lambda_u247.setText(GithubBundle.message("pull.request.repo.write.access.required", new Object[0]));
                } else if (this.mergeForbidden && !isDraft) {
                    JLabel jLabel5;
                    JLabel $this$createAccessDeniedLabel_u24lambda_u249_u24lambda_u248 = jLabel5 = new JLabel();
                    boolean bl5 = false;
                    $this$createAccessDeniedLabel_u24lambda_u249_u24lambda_u248.setIcon(AllIcons.RunConfigurations.TestError);
                    $this$createAccessDeniedLabel_u24lambda_u249_u24lambda_u248.setText(GithubBundle.message("pull.request.merge.disabled", new Object[0]));
                } else {
                    $this$createAccessDeniedLabel_u24lambda_u249.setVisible(false);
                }
                return jLabel;
            }

            @Override
            @NotNull
            public List<JComponent> createButtons() {
                List list = new ArrayList();
                if (this.canMarkReadyForReview) {
                    JButton button = new JButton(new GHPRMarkReadyForReviewAction(this.getStateModel()));
                    list.add(button);
                    this.getStateModel().addAndInvokeDraftStateListener((Function0<Unit>)((Function0)new Function0<Unit>(button, this){
                        final /* synthetic */ JButton $button;
                        final /* synthetic */ Open this$0;
                        {
                            this.$button = $button;
                            this.this$0 = $receiver;
                            super(0);
                        }

                        public final void invoke() {
                            this.$button.setVisible(this.this$0.getStateModel().isDraft());
                        }
                    }));
                }
                if (this.canMerge && !this.mergeForbidden) {
                    Action[] actionArray;
                    List allowedActions = new ArrayList();
                    if (this.canCommitMerge) {
                        allowedActions.add(new GHPRCommitMergeAction(this.getStateModel()));
                    }
                    if (this.canRebaseMerge) {
                        allowedActions.add(new GHPRRebaseMergeAction(this.getStateModel()));
                    }
                    if (this.canSquashMerge) {
                        allowedActions.add(new GHPRSquashMergeAction(this.getStateModel()));
                    }
                    Action action2 = (Action)CollectionsKt.firstOrNull((List)allowedActions);
                    if (allowedActions.size() > 1) {
                        int n = 0;
                        int n2 = allowedActions.size() - 1;
                        Action[] actionArray2 = new Action[n2];
                        while (n < n2) {
                            int n3 = n++;
                            actionArray2[n3] = (Action)allowedActions.get(n3 + 1);
                        }
                        actionArray = actionArray2;
                    } else {
                        boolean $i$f$emptyArray = false;
                        actionArray = new Action[]{};
                    }
                    Action[] actions = actionArray;
                    JBOptionButton mergeButton = new JBOptionButton(action2, actions);
                    list.add(mergeButton);
                    this.getStateModel().addAndInvokeDraftStateListener((Function0<Unit>)((Function0)new Function0<Unit>(mergeButton, this){
                        final /* synthetic */ JBOptionButton $mergeButton;
                        final /* synthetic */ Open this$0;
                        {
                            this.$mergeButton = $mergeButton;
                            this.this$0 = $receiver;
                            super(0);
                        }

                        public final void invoke() {
                            this.$mergeButton.setVisible(!this.this$0.getStateModel().isDraft());
                        }
                    }));
                }
                if (this.canClose) {
                    list.add(new JButton(new GHPRCloseAction(this.getStateModel())));
                }
                return list;
            }

            @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/details/GHPRStatePanel$StateUI$Open$LoadingController;", "", "panel", "Lcom/intellij/ui/components/panels/Wrapper;", "(Lorg/jetbrains/plugins/github/pullrequest/ui/details/GHPRStatePanel$StateUI$Open;Lcom/intellij/ui/components/panels/Wrapper;)V", "update", "", "intellij.vcs.github"})
            private final class LoadingController {
                @NotNull
                private final Wrapper panel;

                public LoadingController(Wrapper panel) {
                    Intrinsics.checkNotNullParameter((Object)panel, (String)"panel");
                    this.panel = panel;
                    Open.this.getStateModel().addAndInvokeMergeabilityStateLoadingResultListener((Function0<Unit>)((Function0)new Function0<Unit>((Object)this){

                        public final void invoke() {
                            ((LoadingController)this.receiver).update();
                        }
                    }));
                    Open.this.getStateModel().addAndInvokeDraftStateListener((Function0<Unit>)((Function0)new Function0<Unit>((Object)this){

                        public final void invoke() {
                            ((LoadingController)this.receiver).update();
                        }
                    }));
                }

                private final void update() {
                    GHPRMergeabilityState mergeability = Open.this.getStateModel().getMergeabilityState();
                    if (mergeability == null) {
                        Throwable throwable;
                        Throwable throwable2 = Open.this.getStateModel().getMergeabilityLoadingError();
                        if (throwable2 != null) {
                            Throwable throwable3;
                            Throwable it = throwable3 = throwable2;
                            boolean bl = false;
                            throwable = !CompletableFutureUtil.INSTANCE.isCancellation(it) ? throwable3 : null;
                        } else {
                            throwable = null;
                        }
                        if (throwable == null) {
                            this.panel.setContent(Open.this.createNotLoadedComponent(Open.this.getStateModel().isDraft()));
                        } else {
                            this.panel.setContent(Open.this.createErrorComponent());
                        }
                    } else {
                        this.panel.setContent(Open.this.createLoadedComponent(mergeability, Open.this.getStateModel().isDraft()));
                        this.panel.revalidate();
                    }
                }
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[GHPullRequestState.values().length];
            try {
                nArray[GHPullRequestState.MERGED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GHPullRequestState.CLOSED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GHPullRequestState.OPEN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

