/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.ui.changes;

import com.intellij.collaboration.ui.SingleValueModel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import git4idea.branch.GitBranchUtil;
import git4idea.repo.GitRepository;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequest;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRDetailsDataProvider;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRReviewDataProvider;
import org.jetbrains.plugins.github.pullrequest.ui.changes.GHPRSuggestedChangeHelper;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u001b\u001a\u00020\u000fH\u0002J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\r\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0015\u001a\u00070\u0016\u00a2\u0006\u0002\b\u00178FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u0012\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006 "}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/changes/GHPRSuggestedChangeHelper;", "", "project", "Lcom/intellij/openapi/project/Project;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "repository", "Lgit4idea/repo/GitRepository;", "reviewDataProvider", "Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRReviewDataProvider;", "detailsDataProvider", "Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRDetailsDataProvider;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/Disposable;Lgit4idea/repo/GitRepository;Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRReviewDataProvider;Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRDetailsDataProvider;)V", "isCorrectBranch", "Lcom/intellij/collaboration/ui/SingleValueModel;", "", "()Lcom/intellij/collaboration/ui/SingleValueModel;", "isCorrectBranch$delegate", "Lkotlin/Lazy;", "getRepository", "()Lgit4idea/repo/GitRepository;", "suggestedChangeCommitMessageDocument", "Lcom/intellij/openapi/editor/Document;", "Lorg/jetbrains/annotations/NotNull;", "getSuggestedChangeCommitMessageDocument", "()Lcom/intellij/openapi/editor/Document;", "suggestedChangeCommitMessageDocument$delegate", "isCorrectBranchWithPullRequestSource", "resolveThread", "", "threadId", "", "intellij.vcs.github"})
public final class GHPRSuggestedChangeHelper {
    @NotNull
    private final GitRepository repository;
    @NotNull
    private final GHPRReviewDataProvider reviewDataProvider;
    @NotNull
    private final GHPRDetailsDataProvider detailsDataProvider;
    @NotNull
    private final Lazy suggestedChangeCommitMessageDocument$delegate;
    @NotNull
    private final Lazy isCorrectBranch$delegate;

    public GHPRSuggestedChangeHelper(@NotNull Project project, @NotNull Disposable parentDisposable, @NotNull GitRepository repository, @NotNull GHPRReviewDataProvider reviewDataProvider, @NotNull GHPRDetailsDataProvider detailsDataProvider) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)reviewDataProvider, (String)"reviewDataProvider");
        Intrinsics.checkNotNullParameter((Object)detailsDataProvider, (String)"detailsDataProvider");
        this.repository = repository;
        this.reviewDataProvider = reviewDataProvider;
        this.detailsDataProvider = detailsDataProvider;
        this.suggestedChangeCommitMessageDocument$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)suggestedChangeCommitMessageDocument.2.INSTANCE);
        this.isCorrectBranch$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<SingleValueModel<Boolean>>(this){
            final /* synthetic */ GHPRSuggestedChangeHelper this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final SingleValueModel<Boolean> invoke() {
                return new SingleValueModel((Object)GHPRSuggestedChangeHelper.access$isCorrectBranchWithPullRequestSource(this.this$0));
            }
        }));
        MessageBusConnection messageBusConnection = project.getMessageBus().connect(parentDisposable);
        Topic topic = GitRepository.GIT_REPO_CHANGE;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"GIT_REPO_CHANGE");
        messageBusConnection.subscribe(topic, arg_0 -> GHPRSuggestedChangeHelper._init_$lambda$0(this, arg_0));
    }

    @NotNull
    public final GitRepository getRepository() {
        return this.repository;
    }

    @NotNull
    public final Document getSuggestedChangeCommitMessageDocument() {
        Lazy lazy = this.suggestedChangeCommitMessageDocument$delegate;
        return (Document)lazy.getValue();
    }

    @NotNull
    public final SingleValueModel<Boolean> isCorrectBranch() {
        Lazy lazy = this.isCorrectBranch$delegate;
        return (SingleValueModel)lazy.getValue();
    }

    public final void resolveThread(@NotNull String threadId) {
        Intrinsics.checkNotNullParameter((Object)threadId, (String)"threadId");
        this.reviewDataProvider.resolveThread((ProgressIndicator)new EmptyProgressIndicator(), threadId);
    }

    private final boolean isCorrectBranchWithPullRequestSource() {
        String string = GitBranchUtil.getBranchNameOrRev((GitRepository)this.repository);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getBranchNameOrRev(repository)");
        String currentBranchName = string;
        Object object = this.detailsDataProvider.getLoadedDetails();
        if (object == null || (object = ((GHPullRequest)object).getHeadRefName()) == null) {
            return false;
        }
        Object pullRequestSourceBranchName = object;
        return Intrinsics.areEqual((Object)currentBranchName, (Object)pullRequestSourceBranchName);
    }

    private static final void _init_$lambda$0(GHPRSuggestedChangeHelper this$0, GitRepository it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object object = it.getCurrentBranch();
        if (object == null || (object = object.getName()) == null) {
            return;
        }
        Object currentBranchName = object;
        Object object2 = this$0.detailsDataProvider.getLoadedDetails();
        if (object2 == null || (object2 = ((GHPullRequest)object2).getHeadRefName()) == null) {
            return;
        }
        Object pullRequestSourceBranchName = object2;
        this$0.isCorrectBranch().setValue((Object)Intrinsics.areEqual((Object)currentBranchName, (Object)pullRequestSourceBranchName));
    }

    public static final /* synthetic */ boolean access$isCorrectBranchWithPullRequestSource(GHPRSuggestedChangeHelper $this) {
        return $this.isCorrectBranchWithPullRequestSource();
    }
}

